/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.trace;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.debug.CndDiagnosticProvider;
import org.netbeans.modules.cnd.modelimpl.content.file.ReferencesIndex;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmStandaloneFileProviderImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileSnapshot;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.trace.ASTFrameEx;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public final class CodeModelDiagnostic {

    public static final class ProjectReferencesTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Project References";
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            CsmProject project;
            CsmFile file;
            ArrayList<CsmProject> projects = new ArrayList<CsmProject>(context.lookupAll(CsmProject.class));
            if (projects.isEmpty() && (file = (CsmFile)context.lookup(CsmFile.class)) != null && (project = file.getProject()) != null) {
                projects.add(project);
            }
            printOut.println("References:");
            for (CsmProject prj : projects) {
                printOut.print(prj.getName() + " : ");
                int refsNumber = 0;
                for (CsmFile file2 : prj.getAllFiles()) {
                    refsNumber += ((FileImpl)file2).getReferences().size();
                }
                printOut.println(refsNumber);
            }
        }
    }

    public static final class ModelTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Project Code Model (Huge size)";
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            CsmProject project;
            CsmFile file;
            ArrayList<CsmProject> projects = new ArrayList<CsmProject>(context.lookupAll(CsmProject.class));
            if (projects.isEmpty() && (file = (CsmFile)context.lookup(CsmFile.class)) != null && (project = file.getProject()) != null) {
                projects.add(project);
            }
            for (CsmProject prj : projects) {
                new CsmTracer((Writer)printOut).dumpModel(prj);
            }
        }
    }

    public static final class ProjectDeclarationsTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Project Declaration Containers (Huge size)";
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            CsmProject project;
            CsmFile file;
            ArrayList<CsmProject> projects = new ArrayList<CsmProject>(context.lookupAll(CsmProject.class));
            if (projects.isEmpty() && (file = (CsmFile)context.lookup(CsmFile.class)) != null && (project = file.getProject()) instanceof ProjectBase) {
                projects.add(project);
            }
            PrintStream ps = CsmTracer.toPrintStream((Writer)printOut);
            for (CsmProject prj : projects) {
                if (!(prj instanceof ProjectBase)) continue;
                ProjectBase.dumpProjectContainers(ps, prj, false);
            }
        }
    }

    public static final class FileImplASTTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "File AST";
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            Collection allFiles = context.lookupAll(CsmFile.class);
            for (CsmFile csmFile : allFiles) {
                if (!(csmFile instanceof FileImpl)) continue;
                ASTFrameEx frame = new ASTFrameEx(((Object)csmFile.getName()).toString(), ((FileImpl)csmFile).debugParse());
                frame.setVisible(true);
            }
        }
    }

    public static final class FileImplModelTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "File Code Model";
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            Collection allFiles = context.lookupAll(CsmFile.class);
            for (CsmFile csmFile : allFiles) {
                new CsmTracer((Writer)printOut).dumpModel(csmFile);
            }
        }
    }

    public static final class ModelFileIndex
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "File References Index";
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====File Indices:\n", new Object[0]);
            Collection allFiles = context.lookupAll(CsmFile.class);
            for (CsmFile csmFile : allFiles) {
                if (csmFile instanceof FileImpl) {
                    ((FileImpl)csmFile).dumpIndex(printOut);
                    continue;
                }
                if (csmFile instanceof FileSnapshot) {
                    ((FileSnapshot)csmFile).dumpIndex(printOut);
                    continue;
                }
                printOut.printf("UNKNOWN FOR ME [%s] %s\n", csmFile.getClass().getName(), csmFile.toString());
            }
        }
    }

    public static final class ModelProjectsIndex
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Model Projects Index";
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====Model Projects Index:\n", new Object[0]);
            ReferencesIndex.dumpInfo(printOut);
        }
    }

    public static final class ModelProjectsContainers
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Model Projects File Containers";
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====ModelImpl:\n", new Object[0]);
            ModelImpl.instance().dumpInfo(printOut, true);
            printOut.printf("====Libraries:\n", new Object[0]);
            LibraryManager.dumpInfo(printOut, true);
        }
    }

    public static final class ModelProjectsTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Model Projects";
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====ModelImpl:\n", new Object[0]);
            ModelImpl.instance().dumpInfo(printOut, false);
            printOut.printf("====Libraries:\n", new Object[0]);
            LibraryManager.dumpInfo(printOut, false);
        }
    }

    public static final class IncludePPStatesTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Included Preprocessor States";
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====Files info:\nGlobal ParseCount=%d\n", FileImpl.getLongParseCount());
            Collection allFiles = context.lookupAll(CsmFile.class);
            for (CsmFile csmFile : allFiles) {
                if (csmFile instanceof FileImpl) {
                    ((FileImpl)csmFile).dumpIncludePPStates(printOut);
                    continue;
                }
                printOut.printf("UNKOWN FOR ME [%s] %s\n", csmFile.getClass().getName(), csmFile.toString());
            }
        }
    }

    public static final class PPStatesTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Preprocessor States";
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====Files info:\nGlobal ParseCount=%d\n", FileImpl.getLongParseCount());
            Collection allFiles = context.lookupAll(CsmFile.class);
            for (CsmFile csmFile : allFiles) {
                if (csmFile instanceof FileImpl) {
                    ((FileImpl)csmFile).dumpPPStates(printOut);
                    continue;
                }
                printOut.printf("UNKNOWN FOR ME [%s] %s\n", csmFile.getClass().getName(), csmFile.toString());
            }
        }
    }

    public static final class FileTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "General File Information";
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====Files info:\nGlobal ParseCount=%d\n", FileImpl.getLongParseCount());
            Collection allFiles = context.lookupAll(CsmFile.class);
            for (CsmFile csmFile : allFiles) {
                if (csmFile instanceof FileImpl) {
                    ((FileImpl)csmFile).dumpInfo(printOut);
                    continue;
                }
                if (csmFile instanceof FileSnapshot) {
                    ((FileSnapshot)csmFile).dumpInfo(printOut);
                    continue;
                }
                printOut.printf("UNKNOWN FOR ME [%s] %s\n", csmFile.getClass().getName(), csmFile.toString());
            }
            DataObject dob = (DataObject)context.lookup(DataObject.class);
            if (dob != null) {
                NativeFileItemSet nfis = (NativeFileItemSet)dob.getLookup().lookup(NativeFileItemSet.class);
                if (nfis != null) {
                    printOut.printf("NativeFileItemSet has %d elements\n", nfis.getItems().size());
                    int ind = 0;
                    for (NativeFileItem item : nfis.getItems()) {
                        FileObject valid;
                        String msg;
                        printOut.printf("[%d] NativeFileItem %s of class %s\n", ++ind, item.getAbsolutePath(), item.getClass().getName());
                        NativeProject nativeProject = item.getNativeProject();
                        printOut.printf(" from project %s [%s]\n", nativeProject.getProjectDisplayName(), nativeProject.getProjectRoot());
                        printOut.printf("\tLang=%s Flavor=%s excluded=%s\n", item.getLanguage(), item.getLanguageFlavor(), item.isExcluded());
                        printOut.print("\tUser Include Paths:\n");
                        for (FSPath path : item.getUserIncludePaths()) {
                            msg = CndFileUtils.isLocalFileSystem((FileSystem)path.getFileSystem()) ? path.getPath() : ((Object)path.getURL()).toString();
                            valid = path.getFileObject();
                            if (valid != null && !valid.isValid()) {
                                valid = null;
                            }
                            printOut.printf("\t\t%s%s\n", msg, valid == null ? "[invalid]" : "");
                        }
                        printOut.print("\tUser Macros:\n");
                        for (String macro : item.getUserMacroDefinitions()) {
                            printOut.printf("\t\t%s\n", macro);
                        }
                        printOut.print("\tSystem Include Paths:\n");
                        for (FSPath path : item.getSystemIncludePaths()) {
                            msg = CndFileUtils.isLocalFileSystem((FileSystem)path.getFileSystem()) ? path.getPath() : ((Object)path.getURL()).toString();
                            valid = path.getFileObject();
                            if (valid != null && !valid.isValid()) {
                                valid = null;
                            }
                            printOut.printf("\t\t%s%s\n", msg, valid == null ? "[invalid]" : "");
                        }
                        printOut.print("\tSystem Macros:\n");
                        for (String macro : item.getSystemMacroDefinitions()) {
                            printOut.printf("\t\t%s\n", macro);
                        }
                    }
                } else {
                    printOut.printf("no NativeFileItemSet in %s\n", dob);
                }
            } else {
                printOut.printf("no file object in lookup\n", new Object[0]);
            }
        }
    }

    public static final class StandAloneProviderTrace
    implements CndDiagnosticProvider {
        public String getDisplayName() {
            return "Standalone Files Information";
        }

        public void dumpInfo(Lookup context, PrintWriter printOut) {
            printOut.printf("====CsmStandaloneFileProviders info:\n", new Object[0]);
            for (CsmStandaloneFileProvider sap : Lookup.getDefault().lookupAll(CsmStandaloneFileProvider.class)) {
                if (sap instanceof CsmStandaloneFileProviderImpl) {
                    ((CsmStandaloneFileProviderImpl)sap).dumpInfo(printOut);
                    continue;
                }
                printOut.printf("UNKNOWN FOR ME [%s] %s\n", sap.getClass().getName(), sap.toString());
            }
        }
    }
}

