/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.syntaxerr;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.syntaxerr.CsmErrorInfo;
import org.netbeans.modules.cnd.modelimpl.parser.spi.CsmParserProvider;
import org.netbeans.modules.cnd.modelimpl.syntaxerr.SimpleErrorInfo;
import org.netbeans.modules.cnd.modelimpl.syntaxerr.spi.ParserErrorFilter;
import org.openide.util.NbBundle;

public abstract class BaseParserErrorFilter
extends ParserErrorFilter {
    private static final char LF = '\n';

    protected Collection<CsmErrorInfo> toErrorInfo(Collection<CsmParserProvider.ParserError> errors, CsmFile file) {
        ArrayList<CsmErrorInfo> result = new ArrayList<CsmErrorInfo>();
        if (!errors.isEmpty()) {
            CharSequence text = file.getText();
            CsmParserProvider.ParserError prev = null;
            ContextCache prevLine = new ContextCache();
            for (CsmParserProvider.ParserError e : errors) {
                if (!this.equal(prev, e)) {
                    result.add(this.toErrorInfo(e, text, prevLine));
                }
                prev = e;
            }
        }
        return result;
    }

    private boolean equal(CsmParserProvider.ParserError e1, CsmParserProvider.ParserError e2) {
        if (e1 == null != (e2 == null)) {
            return false;
        }
        return e1.getLine() == e2.getLine() && e1.getColumn() == e2.getColumn();
    }

    private CsmErrorInfo toErrorInfo(CsmParserProvider.ParserError e, CharSequence text, ContextCache prevLine) {
        return this.toErrorInfo(this.getMessage(e), e.getLine(), e.getColumn(), text, prevLine, e.getTokenText());
    }

    private CsmErrorInfo toErrorInfo(String message, int line, int column, CharSequence text, ContextCache prevLine, String tokenText) {
        int start = 0;
        int currLine = 1;
        if (prevLine.line <= line) {
            start = prevLine.offset;
            currLine = prevLine.line;
        }
        while (start < text.length() && currLine < line) {
            char c;
            if ((c = text.charAt(start++)) != '\n') continue;
            ++currLine;
        }
        prevLine.offset = start;
        prevLine.line = currLine;
        int end = start + 1;
        while (end < text.length() && text.charAt(end++) != '\n') {
        }
        --end;
        if (tokenText != null) {
            int tokenStart = start + column - 1;
            int tokenEnd = tokenStart + tokenText.length();
            if (0 <= tokenStart && 0 <= tokenEnd && tokenEnd <= text.length() && text.subSequence(tokenStart, tokenEnd).equals(tokenText)) {
                start = tokenStart;
                end = tokenEnd;
            }
        }
        return new SimpleErrorInfo(start, end, message, this.getDefaultSeverity());
    }

    private String getMessage(CsmParserProvider.ParserError e) {
        String tokenText = e.getTokenText();
        if (tokenText == null) {
            return NbBundle.getMessage(BaseParserErrorFilter.class, (String)"MSG_PARSER_ERROR");
        }
        if (e.isEof()) {
            return NbBundle.getMessage(BaseParserErrorFilter.class, (String)"MSG_UNEXPECTED_EOF");
        }
        return NbBundle.getMessage(BaseParserErrorFilter.class, (String)"MSG_UNEXPECTED_TOKEN", (Object)tokenText);
    }

    protected CsmErrorInfo.Severity getDefaultSeverity() {
        return CsmErrorInfo.Severity.ERROR;
    }

    private static class ContextCache {
        int offset;
        int line = 1;

        private ContextCache() {
        }
    }
}

