/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.KeyHolder;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryListenerImpl;
import org.netbeans.modules.cnd.modelimpl.uid.KeyBasedUID;
import org.netbeans.modules.cnd.modelimpl.uid.UIDManager;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.api.RepositoryAccessor;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class RepositoryUtils {
    private static final Logger LOG = Logger.getLogger(RepositoryUtils.class.getName());
    private static final boolean TRACE_ARGS = CndUtils.getBoolean((String)"cnd.repository.trace.args", (boolean)false);
    private static final boolean TRACE_REPOSITORY_ACCESS = TRACE_ARGS || DebugUtils.getBoolean((String)"cnd.modelimpl.trace.repository", (boolean)false);
    private static final Repository repository = RepositoryAccessor.getRepository();
    private static int CURRENT_VERSION_OF_PERSISTENCY = 142;
    private static volatile int counter = 0;
    private static RepositoryListenerProxy myRepositoryListenerProxy;

    private RepositoryUtils() {
    }

    public static <T> T get(CsmUID<T> uid) {
        Key key = RepositoryUtils.UIDtoKey(uid);
        Persistent obj = RepositoryUtils.get(key);
        assert (obj == null || obj instanceof CsmIdentifiable) : "unexpected object with class " + obj.getClass() + obj;
        Persistent out = obj;
        return (T)out;
    }

    public static Persistent tryGet(Key key) {
        assert (key != null);
        Persistent out = repository.tryGet(key);
        if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
            System.err.printf("%d:trying key %s got %s", RepositoryUtils.nextIndex(), key, out);
        }
        return out;
    }

    public static Persistent get(Key key) {
        assert (key != null);
        if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
            long time = System.currentTimeMillis();
            int index = RepositoryUtils.nextIndex();
            System.err.println(index + ": " + System.identityHashCode(key) + "@getting key " + key);
            Persistent out = repository.get(key);
            time = System.currentTimeMillis() - time;
            System.err.println(index + ": " + System.identityHashCode(key) + "@got" + (out == null ? " - NULL" : "") + " in " + time + "ms the key " + key);
            return out;
        }
        return repository.get(key);
    }

    private static synchronized int nextIndex() {
        return counter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void remove(CsmUID<T> uid, CsmObject obj) {
        Key key = RepositoryUtils.UIDtoKey(uid);
        if (key != null) {
            try {
                if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
                    long time = System.currentTimeMillis();
                    int index = RepositoryUtils.nextIndex();
                    System.err.println(index + ": " + System.identityHashCode(key) + "@removing key " + key);
                    if (!TraceFlags.SAFE_REPOSITORY_ACCESS) {
                        repository.remove(key);
                    }
                    time = System.currentTimeMillis() - time;
                    System.err.println(index + ": " + System.identityHashCode(key) + "@removed in " + time + "ms the key " + key);
                    return;
                }
                if (!TraceFlags.SAFE_REPOSITORY_ACCESS) {
                    repository.remove(key);
                }
            }
            finally {
                RepositoryUtils.disposeUID(uid, obj);
            }
        }
    }

    public static <T> void disposeUID(CsmUID<T> uid, CsmObject obj) {
        if (uid instanceof KeyBasedUID) {
            ((KeyBasedUID)uid).dispose(obj);
        }
    }

    public static <T> void remove(Collection<? extends CsmUID<T>> uids) {
        if (uids != null) {
            for (CsmUID<T> uid : uids) {
                RepositoryUtils.remove(uid, null);
            }
        }
    }

    public static <T> CsmUID<T> put(T csmObj) {
        CsmUID<T> uid = null;
        if (csmObj != null) {
            uid = UIDProviderIml.get(csmObj, false);
            assert (uid != null);
            Key key = RepositoryUtils.UIDtoKey(uid);
            RepositoryUtils.put(key, (Persistent)csmObj);
            if (!(csmObj instanceof CsmNamespace) && !(csmObj instanceof CsmProject) && !(csmObj instanceof CsmInstantiation)) assert (uid.getObject() != null);
        }
        return uid;
    }

    public static void put(Key key, Persistent obj) {
        if (key != null) {
            if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
                long time = System.currentTimeMillis();
                int index = RepositoryUtils.nextIndex();
                System.err.println(index + ": " + System.identityHashCode(key) + "@putting key " + key);
                repository.put(key, obj);
                time = System.currentTimeMillis() - time;
                System.err.println(index + ": " + System.identityHashCode(key) + "@put in " + time + "ms the key " + key);
                return;
            }
            repository.put(key, obj);
        }
    }

    public static void hang(Object csmObj) {
        if (csmObj != null) {
            CsmUID<Object> uid = UIDProviderIml.get(csmObj, false);
            assert (uid != null);
            Key key = RepositoryUtils.UIDtoKey(uid);
            RepositoryUtils.hang(key, (Persistent)csmObj);
            if (!(csmObj instanceof CsmNamespace) && !(csmObj instanceof CsmProject)) assert (uid.getObject() != null);
        }
    }

    public static void hang(Key key, Persistent obj) {
        if (key != null) {
            if (TRACE_REPOSITORY_ACCESS && RepositoryUtils.isTracingKey(key)) {
                long time = System.currentTimeMillis();
                int index = RepositoryUtils.nextIndex();
                System.err.println(index + ": " + System.identityHashCode(key) + "@hanging key " + key);
                repository.hang(key, obj);
                time = System.currentTimeMillis() - time;
                System.err.println(index + ": " + System.identityHashCode(key) + "@hung in " + time + "ms the key " + key);
                return;
            }
            repository.hang(key, obj);
        }
    }

    public static <T> Collection<CsmUID<T>> put(Collection<T> decls) {
        assert (decls != null);
        ArrayList<CsmUID<T>> uids = new ArrayList<CsmUID<T>>(decls.size());
        for (T decl : decls) {
            if (!(decl instanceof CsmIdentifiable)) continue;
            CsmUID<T> uid = RepositoryUtils.put(decl);
            uids.add(uid);
        }
        return uids;
    }

    public static <T extends CsmObject> void setSelfUIDs(Collection<T> decls) {
        assert (decls != null);
        for (CsmObject decl : decls) {
            Utils.setSelfUID(decl);
        }
    }

    public static <T> Key UIDtoKey(CsmUID<T> uid) {
        if (uid instanceof KeyHolder) {
            return ((KeyHolder)uid).getKey();
        }
        return null;
    }

    public static <T> CharSequence getUnitName(CsmUID<T> uid) {
        Key key = RepositoryUtils.UIDtoKey(uid);
        assert (key != null);
        CharSequence unitName = key.getUnit();
        return unitName;
    }

    public static void startup() {
        repository.startup(CURRENT_VERSION_OF_PERSISTENCY);
        repository.unregisterRepositoryListener((RepositoryListener)RepositoryUtils.getRepositoryListenerProxy());
        repository.registerRepositoryListener((RepositoryListener)RepositoryUtils.getRepositoryListenerProxy());
    }

    private static synchronized RepositoryListenerProxy getRepositoryListenerProxy() {
        if (myRepositoryListenerProxy == null) {
            myRepositoryListenerProxy = new RepositoryListenerProxy();
        }
        return myRepositoryListenerProxy;
    }

    public static void shutdown() {
        repository.shutdown();
    }

    public static void cleanCashes() {
        repository.cleanCaches();
    }

    public static void debugClear() {
        repository.debugClear();
    }

    public static <T> void closeUnit(CsmUID<T> uid, Set<Integer> requiredUnits, boolean cleanRepository) {
        RepositoryUtils.closeUnit(RepositoryUtils.UIDtoKey(uid), requiredUnits, cleanRepository);
    }

    public static void closeUnit(int unitId, Set<Integer> requiredUnits, boolean cleanRepository) {
        RepositoryListenerImpl.instance().onExplicitClose(KeyUtilities.getUnitName(unitId));
        RepositoryUtils._closeUnit(unitId, requiredUnits, cleanRepository);
    }

    public static void closeUnit(Key key, Set<Integer> requiredUnits, boolean cleanRepository) {
        assert (key != null);
        RepositoryUtils._closeUnit(key.getUnitId(), requiredUnits, cleanRepository);
        if (cleanRepository) {
            UIDManager.instance().clearProjectCache(key);
        }
    }

    private static void _closeUnit(int unitId, Set<Integer> requiredUnits, boolean cleanRepository) {
        int errors;
        if (!cleanRepository && (errors = myRepositoryListenerProxy.getErrorCount(unitId)) > 0) {
            if (LOG.isLoggable(Level.INFO)) {
                CharSequence unit = KeyUtilities.getUnitNameSafe(unitId);
                LOG.log(Level.INFO, "Clean index for project {0} \"{1}\" because index was corrupted (was {1} errors).", new Object[]{unitId, unit, errors});
            }
            cleanRepository = true;
        }
        myRepositoryListenerProxy.cleanErrorCount(unitId);
        repository.closeUnit(unitId, cleanRepository, requiredUnits);
    }

    public static int getRepositoryErrorCount(ProjectBase project) {
        return RepositoryUtils.getRepositoryListenerProxy().getErrorCount(project.getUnitId());
    }

    public static void registerRepositoryError(ProjectBase project, Exception e) {
        CsmUID<CsmProject> uid = project.getUID();
        assert (uid != null);
        Key key = RepositoryUtils.UIDtoKey(uid);
        RepositoryUtils.getRepositoryListenerProxy().anExceptionHappened(key.getUnitId(), key.getUnit(), new RepositoryException((Throwable)e));
    }

    public static void onProjectDeleted(NativeProject nativeProject) {
        Key key = KeyUtilities.createProjectKey(nativeProject);
        repository.removeUnit(key.getUnitId());
    }

    public static void openUnit(ProjectBase project) {
        CsmUID<CsmProject> uid = project.getUID();
        assert (uid != null);
        Key key = RepositoryUtils.UIDtoKey(uid);
        RepositoryUtils.openUnit(key);
    }

    public static void openUnit(Key key) {
        RepositoryUtils.openUnit(key.getUnitId(), key.getUnit());
    }

    private static void openUnit(int unitId, CharSequence unitName) {
        RepositoryListenerImpl.instance().onExplicitOpen(unitId);
        repository.openUnit(unitId, unitName);
    }

    public static void unregisterRepositoryListener(RepositoryListener listener) {
        repository.unregisterRepositoryListener(listener);
    }

    private static boolean isTracingKey(Key key) {
        if (TRACE_ARGS) {
            return key.getDepth() == 3 && ("argc".contentEquals(key.getAt(2)) || "main".contentEquals(key.getAt(2)));
        }
        return true;
    }

    private static class RepositoryListenerProxy
    implements RepositoryListener {
        private RepositoryListener parent = RepositoryListenerImpl.instance();
        private Map<Integer, Integer> wasErrors = new ConcurrentHashMap<Integer, Integer>();
        private boolean fatalError = false;

        private RepositoryListenerProxy() {
        }

        public int getErrorCount(int unitId) {
            Integer i = this.wasErrors.get(unitId);
            if (i == null) {
                return this.fatalError ? 1 : 0;
            }
            return this.fatalError ? i + 1 : i;
        }

        public void cleanErrorCount(int unitId) {
            this.wasErrors.remove(unitId);
            this.fatalError = false;
        }

        public boolean unitOpened(int unitId, CharSequence unitName) {
            return this.parent.unitOpened(unitId, unitName);
        }

        public void unitClosed(int unitId, CharSequence unitName) {
            this.parent.unitClosed(unitId, unitName);
        }

        public void anExceptionHappened(int unitId, CharSequence unitName, RepositoryException exc) {
            this.primitiveErrorStrategy(unitId, exc);
            this.parent.anExceptionHappened(unitId, unitName, exc);
        }

        private void primitiveErrorStrategy(int unitId, RepositoryException exc) {
            Integer i = this.wasErrors.get(unitId);
            i = i == null ? Integer.valueOf(1) : Integer.valueOf(i + 1);
            this.wasErrors.put(unitId, i);
        }
    }
}

