/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.Timer;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;
import org.netbeans.modules.cnd.utils.CndUtils;

public class RepositoryListenerImpl
implements RepositoryListener {
    private static final RepositoryListenerImpl instance = new RepositoryListenerImpl();
    private static final int IMPLICIT_CLOSE_INTERVAL = Integer.getInteger("cnd.implicit.close.interval", 20);
    private static final String TRACE_PROJECT_NAME = System.getProperty("cnd.repository.trace.project");
    private static final boolean TRACE_PROJECT = TRACE_PROJECT_NAME != null && TRACE_PROJECT_NAME.length() > 0;
    private final Object lock = new Lock();
    private Map<Integer, UnitTimer> unitTimers = new HashMap<Integer, UnitTimer>();
    private Set<Integer> explicitelyOpened = new HashSet<Integer>();

    private RepositoryListenerImpl() {
        Runtime.getRuntime().addShutdownHook(new RepositoryShutdownHook());
    }

    public static RepositoryListenerImpl instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unitOpened(int unitId, CharSequence unitName) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: unitOpened %s\n", unitName);
        }
        if (TRACE_PROJECT && TRACE_PROJECT_NAME.equals(unitName)) {
            this.trace("Watched project %s is opening\n", unitName);
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.explicitelyOpened.contains(unitId)) {
                if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                    this.trace("RepositoryListener: implicit open !!! %s\n", unitName);
                }
                this.unitTimers.put(unitId, new UnitTimer(unitId, unitName, IMPLICIT_CLOSE_INTERVAL * 1000));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unitClosed(int unitId, CharSequence unitName) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: unitClosed %s\n", unitName);
        }
        if (TRACE_PROJECT && TRACE_PROJECT_NAME.equals(unitName)) {
            this.trace("Watched project %s is explicitly closing\n", unitName);
        }
        Object object = this.lock;
        synchronized (object) {
            this.killTimer(unitId);
            this.explicitelyOpened.remove(unitId);
        }
    }

    public void anExceptionHappened(int unitId, CharSequence unitName, RepositoryException exc) {
        assert (exc != null);
        if (TraceFlags.DEBUG_BROKEN_REPOSITORY && exc.getMessage() != null && exc.getMessage().contains("INTENTIONAL")) {
            return;
        }
        if (exc.getCause() != null) {
            exc.getCause().printStackTrace(System.err);
        }
        DiagnosticExceptoins.register(exc.getCause());
    }

    private void killTimer(int unitId) {
        UnitTimer unitTimer = this.unitTimers.remove(unitId);
        if (unitTimer != null) {
            if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                this.trace("RepositoryListener: killing timer for %d %s\n", unitId, KeyUtilities.getUnitName(unitId));
            }
            unitTimer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExplicitOpen(int unitId) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: onExplicitOpen %d %s\n", unitId, KeyUtilities.getUnitName(unitId));
        }
        Object object = this.lock;
        synchronized (object) {
            this.killTimer(unitId);
            this.explicitelyOpened.add(unitId);
        }
    }

    public void onExplicitClose(CharSequence unitName) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: onExplicitClose %s\n", unitName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeoutElapsed(int unitId, CharSequence unitName) {
        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
            this.trace("RepositoryListener: timeout elapsed for %s\n", unitName);
        }
        Object object = this.lock;
        synchronized (object) {
            UnitTimer unitTimer = this.unitTimers.remove(unitId);
            if (unitTimer != null) {
                if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                    this.trace("RepositoryListener: scheduling closure for %s\n", unitName);
                }
                unitTimer.cancel();
                this.scheduleClosing(unitId);
            }
        }
    }

    private void scheduleClosing(final int unitId) {
        assert (Thread.holdsLock(this.lock));
        final CharSequence unitName = KeyUtilities.getUnitName(unitId);
        if (this.explicitelyOpened.contains(unitId)) {
            if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                this.trace("Cancelling closure (A) for implicitely opened unit %s\n", unitName);
            }
            return;
        }
        ModelImpl.instance().enqueueModelTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = RepositoryListenerImpl.this.lock;
                synchronized (object) {
                    if (RepositoryListenerImpl.this.explicitelyOpened.contains(unitId)) {
                        if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                            RepositoryListenerImpl.this.trace("Cancelling closure (B) for implicitely opened unit %s\n", new Object[]{unitName});
                        }
                        return;
                    }
                }
                if (TraceFlags.TRACE_REPOSITORY_LISTENER) {
                    RepositoryListenerImpl.this.trace("RepositoryListener: closing implicitely opened unit %s\n", new Object[]{unitName});
                }
                if (TRACE_PROJECT && TRACE_PROJECT_NAME.equals(unitName)) {
                    RepositoryListenerImpl.this.trace("Watched project %s is implicitely closing\n", new Object[]{unitName});
                }
                RepositoryUtils.closeUnit(unitId, null, !TraceFlags.PERSISTENT_REPOSITORY);
            }
        }, "Closing implicitly opened project " + unitName + ":" + unitId);
    }

    private void trace(String format, Object ... args) {
        Object[] newArgs = new Object[args.length + 1];
        newArgs[0] = System.currentTimeMillis();
        System.arraycopy(args, 0, newArgs, 1, args.length);
        System.err.printf("RepositoryListener [%d] " + format, newArgs);
    }

    private static final class Lock {
        private Lock() {
        }
    }

    private class UnitTimer
    implements ActionListener {
        private final int unitId;
        private final CharSequence unitName;
        private final Timer timer;

        public UnitTimer(int unitId, CharSequence unitName, int interval) {
            this.unitId = unitId;
            this.unitName = unitName;
            this.timer = new Timer(interval, this);
            this.timer.start();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RepositoryListenerImpl.this.timeoutElapsed(this.unitId, this.unitName);
        }

        public void cancel() {
            this.timer.stop();
        }
    }

    private static class RepositoryShutdownHook
    extends Thread {
        public RepositoryShutdownHook() {
            this.setName("Repository Shutdown Hook Thread");
        }

        @Override
        public void run() {
            if (!CndUtils.isUnitTestMode()) {
                RepositoryUtils.shutdown();
            }
        }
    }
}

