/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.IOException;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectNameBasedKey;
import org.netbeans.modules.cnd.repository.spi.KeyDataPresentation;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.CharSequences;

abstract class ProjectFileNameBasedKey
extends ProjectNameBasedKey {
    protected static final CharSequence NO_FILE = CharSequences.create((CharSequence)"<No File Name>");
    protected final int fileNameIndex;

    protected ProjectFileNameBasedKey(int unitID, int fileID) {
        super(unitID);
        this.fileNameIndex = fileID;
    }

    protected ProjectFileNameBasedKey(FileImpl file) {
        this(ProjectFileNameBasedKey.getFileUnitId(file), ProjectFileNameBasedKey.getFileNameId(file));
    }

    protected ProjectFileNameBasedKey(KeyDataPresentation presentation) {
        super(presentation);
        this.fileNameIndex = presentation.getFilePresentation();
    }

    static int getFileUnitId(FileImpl file) {
        CndUtils.assertNotNull((Object)file, (String)"Null file");
        return file == null ? -1 : file.getUnitId();
    }

    private static int getFileNameId(FileImpl file) {
        assert (file != null);
        return file == null ? -1 : file.getFileId();
    }

    @Override
    public void write(RepositoryDataOutput aStream) throws IOException {
        super.write(aStream);
        aStream.writeInt(this.fileNameIndex);
    }

    protected ProjectFileNameBasedKey(RepositoryDataInput aStream) throws IOException {
        super(aStream);
        this.fileNameIndex = aStream.readInt();
    }

    @Override
    public int hashCode() {
        int key = super.hashCode();
        key = 19 * key + this.fileNameIndex;
        return key;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ProjectFileNameBasedKey other = (ProjectFileNameBasedKey)obj;
        return this.fileNameIndex == other.fileNameIndex;
    }

    int getProjectFileIndex() {
        return this.fileNameIndex;
    }

    protected CharSequence getFileName() {
        return KeyUtilities.getFileNameById(this.getUnitId(), this.fileNameIndex);
    }

    protected CharSequence getFileNameSafe() {
        return KeyUtilities.getFileNameByIdSafe(this.getUnitId(), this.fileNameIndex);
    }

    @Override
    public int getDepth() {
        assert (super.getDepth() == 0);
        return 1;
    }

    @Override
    public CharSequence getAt(int level) {
        assert (super.getDepth() == 0 && level < this.getDepth());
        return this.getFileName();
    }

    @Override
    public final int getFilePresentation() {
        return this.fileNameIndex;
    }
}

