/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.IOException;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectFileNameBasedKey;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.repository.spi.KeyDataPresentation;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

abstract class OffsetableKey
extends ProjectFileNameBasedKey
implements Comparable<OffsetableKey> {
    private final int startOffset;
    private int endOffset = -2147483647;
    private final int hashCode;
    private final CharSequence name;

    protected OffsetableKey(CsmOffsetable obj, String kind, CharSequence name) {
        this((FileImpl)obj.getContainingFile(), obj.getStartOffset(), obj.getEndOffset(), kind, name);
    }

    protected OffsetableKey(FileImpl containingFile, int startOffset, String kind, CharSequence name) {
        this(containingFile, startOffset, -2147483647, kind, name);
    }

    protected OffsetableKey(FileImpl containingFile, int startOffset, int endOffset, String kind, CharSequence name) {
        super(containingFile);
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        assert (kind.length() == 1);
        this.name = NameCache.getManager().getString(name);
        this.hashCode = this._hashCode() << 8 | kind.charAt(0) & 0xFF;
    }

    protected OffsetableKey(KeyDataPresentation presentation) {
        super(presentation);
        this.startOffset = presentation.getStartPresentation();
        this.endOffset = presentation.getEndPresentation();
        this.name = NameCache.getManager().getString(presentation.getNamePresentation());
        this.hashCode = this._hashCode() << 8 | presentation.getKindPresentation() & 0xFF;
    }

    char getKind() {
        return (char)(this.hashCode & 0xFF);
    }

    CharSequence getName() {
        if (this.name != null && 0 < this.name.length() && this.isDigit(this.name.charAt(0))) {
            return CharSequences.empty();
        }
        return this.name;
    }

    private boolean isDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    int getStartOffset() {
        return this.startOffset;
    }

    final int getEndOffset() {
        return this.endOffset;
    }

    final void cacheEndOffset(int endOffset) {
        assert (this.endOffset == -2147483647 || this.endOffset == endOffset) : "end offset is set already to " + this.endOffset;
        this.endOffset = endOffset;
    }

    @Override
    public void write(RepositoryDataOutput aStream) throws IOException {
        super.write(aStream);
        aStream.writeInt(this.startOffset);
        aStream.writeInt(this.endOffset);
        aStream.writeInt(this.hashCode);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, aStream);
    }

    protected OffsetableKey(RepositoryDataInput aStream) throws IOException {
        super(aStream);
        this.startOffset = aStream.readInt();
        this.endOffset = aStream.readInt();
        this.hashCode = aStream.readInt();
        this.name = PersistentUtils.readUTF(aStream, NameCache.getManager());
        assert (CharSequences.isCompact((CharSequence)this.name));
    }

    @Override
    public String toString() {
        return this.name + "[" + this.getKind() + " " + this.getStartOffset() + "-" + (this.getEndOffset() == -2147483647 ? "U" : Integer.valueOf(this.getEndOffset())) + "] {" + this.getFileNameSafe() + "; " + this.getProjectName() + "}";
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        OffsetableKey other = (OffsetableKey)obj;
        assert (CharSequences.isCompact((CharSequence)this.name));
        assert (CharSequences.isCompact((CharSequence)other.name));
        return this.startOffset == other.startOffset && (this.endOffset == other.endOffset || this.endOffset == -2147483647 || other.endOffset == -2147483647) && this.getKind() == other.getKind() && this.name.equals(other.name);
    }

    @Override
    public int hashCode() {
        return (this.hashCode >> 8) + 37 * (this.hashCode & 0xFF);
    }

    private int _hashCode() {
        int retValue = 19 * super.hashCode() + this.name.hashCode();
        retValue = 19 * retValue + this.startOffset;
        return retValue;
    }

    @Override
    public int compareTo(OffsetableKey other) {
        int ofs2;
        if (this == other) {
            return 0;
        }
        assert (this.getKind() == other.getKind());
        assert (this.getUnitId() == other.getUnitId());
        assert (this.fileNameIndex == other.fileNameIndex);
        int ofs1 = this.getStartOffset();
        if (ofs1 == (ofs2 = other.getStartOffset())) {
            return 0;
        }
        return ofs1 - ofs2;
    }

    @Override
    public int getDepth() {
        return super.getDepth() + 2;
    }

    @Override
    public CharSequence getAt(int level) {
        int superDepth = super.getDepth();
        if (level < superDepth) {
            return super.getAt(level);
        }
        switch (level - superDepth) {
            case 0: {
                return new String(new char[]{this.getKind()});
            }
            case 1: {
                return this.name;
            }
        }
        throw new IllegalArgumentException("not supported level" + level);
    }

    @Override
    public int getSecondaryDepth() {
        return 2;
    }

    @Override
    public int getSecondaryAt(int level) {
        switch (level) {
            case 0: {
                return this.startOffset;
            }
            case 1: {
                return this.endOffset;
            }
        }
        throw new IllegalArgumentException("not supported level" + level);
    }

    @Override
    public final int getStartPresentation() {
        return this.startOffset;
    }

    @Override
    public final int getEndPresentation() {
        return this.endOffset;
    }

    @Override
    public final CharSequence getNamePresentation() {
        return this.name;
    }

    @Override
    public final short getKindPresentation() {
        return (short)this.getKind();
    }
}

