/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.repository;

import java.io.IOException;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmObjectFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectNameBasedKey;
import org.netbeans.modules.cnd.repository.spi.KeyDataPresentation;
import org.netbeans.modules.cnd.repository.spi.PersistentFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class IncludedFileStorageKey
extends ProjectNameBasedKey {
    private final int includedUnitIndex;

    public IncludedFileStorageKey(ProjectBase startProject, ProjectBase includedProject) {
        super(startProject.getUnitId());
        this.includedUnitIndex = includedProject.getUnitId();
    }

    IncludedFileStorageKey(RepositoryDataInput aStream) throws IOException {
        super(aStream);
        this.includedUnitIndex = aStream.readUnitId();
    }

    @Override
    public void write(RepositoryDataOutput aStream) throws IOException {
        super.write(aStream);
        aStream.writeUnitId(this.includedUnitIndex);
    }

    IncludedFileStorageKey(KeyDataPresentation presentation) {
        super(presentation);
        this.includedUnitIndex = presentation.getUnitPresentation();
    }

    public int getIncludedUnitIndex() {
        return this.includedUnitIndex;
    }

    @Override
    public String toString() {
        return "IncludedFileContainerKey (" + this.getProjectName() + ", " + KeyUtilities.getUnitName(this.includedUnitIndex) + ")";
    }

    @Override
    public int hashCode() {
        return 777 + (37 * this.includedUnitIndex + super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IncludedFileStorageKey other = (IncludedFileStorageKey)obj;
        return this.includedUnitIndex == other.includedUnitIndex;
    }

    public PersistentFactory getPersistentFactory() {
        return CsmObjectFactory.instance();
    }

    @Override
    public int getSecondaryDepth() {
        return 2;
    }

    @Override
    public int getSecondaryAt(int level) {
        assert (level == 0 || level == 1);
        if (level == 0) {
            return this.includedUnitIndex;
        }
        if (level == 1) {
            return 21;
        }
        throw new IllegalArgumentException("invalid level " + level + " for " + this);
    }

    @Override
    public boolean hasCache() {
        return true;
    }

    @Override
    public final short getKindPresentation() {
        return 21;
    }
}

