/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.platform;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.modules.dlight.libs.common.InvalidFileObjectSupport;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

final class ExternalUpdateListener
extends FileChangeAdapter
implements Runnable {
    static final Logger LOG = Logger.getLogger("ExternalUpdateListener");
    private final ModelSupport modelSupport;
    private volatile LinkedList<Pair> events = new LinkedList();
    private final Object eventsLock = new Object();

    ExternalUpdateListener(ModelSupport outer) {
        this.modelSupport = outer;
    }

    public void fileChanged(FileEvent fe) {
        if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
            LOG.log(Level.INFO, "External updates: try to register fileChanged {0}", fe);
        }
        this.register(fe, EventKind.CHANGED);
    }

    public void fileDataCreated(FileEvent fe) {
        if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
            LOG.log(Level.INFO, "External updates: try to register fileDataCreated {0}", fe);
        }
        this.register(fe, EventKind.CREATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileRenamed(FileRenameEvent fe) {
        FileObject fo;
        ModelImpl model;
        if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
            LOG.log(Level.INFO, "External updates: try to register fileRenamed {0}", fe);
        }
        if ((model = this.modelSupport.theModel) != null && this.isCOrCpp(fo = fe.getFile())) {
            FSPath newPath = FSPath.toFSPath((FileObject)fo);
            String strPrevExt = fe.getExt() == null || fe.getExt().isEmpty() ? "" : "." + fe.getExt();
            String strPrevPath = CndPathUtilitities.getDirName((String)newPath.getPath()) + '/' + fe.getName() + strPrevExt;
            FSPath prevPath = new FSPath(newPath.getFileSystem(), strPrevPath);
            FileObject removedFO = InvalidFileObjectSupport.getInvalidFileObject((FileSystem)prevPath.getFileSystem(), (CharSequence)prevPath.getPath());
            FileEvent deleteFE = new FileEvent((FileObject)fe.getSource(), removedFO, fe.isExpected(), fe.getTime());
            Object object = this.eventsLock;
            synchronized (object) {
                if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                    LOG.log(Level.INFO, "External updates: registered fileRenamed {0}", fe);
                }
                this.events.addLast(new Pair(EventKind.DELETED, deleteFE));
                this.events.addLast(new Pair(EventKind.CREATED, (FileEvent)fe));
            }
        }
    }

    public void fileDeleted(FileEvent fe) {
        if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
            LOG.log(Level.INFO, "External updates: try to register fileDeleted {0}", fe);
        }
        this.register(fe, EventKind.DELETED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
            LOG.info("External updates: running update task");
        }
        block3: while (true) {
            LinkedList<Pair> curEvents;
            Object object = this.eventsLock;
            synchronized (object) {
                if (this.events.isEmpty()) {
                    if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                        LOG.info("External updates: empty queue");
                    }
                    return;
                }
                curEvents = this.events;
                this.events = new LinkedList();
            }
            Iterator i$ = curEvents.iterator();
            while (true) {
                if (!i$.hasNext()) continue block3;
                Pair pair = (Pair)i$.next();
                ModelImpl model = this.modelSupport.theModel;
                if (model == null) {
                    return;
                }
                FileObject fo = pair.fe.getFile();
                if (fo == null) continue;
                EventKind curKind = pair.kind;
                if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                    LOG.log(Level.INFO, "External updates: Updating for {0} {1}", new Object[]{curKind, fo});
                }
                CsmFile[] files = model.findFiles(FSPath.toFSPath((FileObject)fo), false, false);
                HashSet<ProjectBase> handledProjects = new HashSet<ProjectBase>();
                for (int i = 0; i < files.length; ++i) {
                    FileImpl file = (FileImpl)files[i];
                    ProjectBase project = file.getProjectImpl(true);
                    if (project == null) continue;
                    handledProjects.add(project);
                    if (curKind == EventKind.DELETED) {
                        if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                            LOG.log(Level.INFO, "External updates: project {0} found for deleted {1}", new Object[]{project, file});
                        }
                        project.checkForRemoved();
                        continue;
                    }
                    if (curKind == EventKind.CHANGED) {
                        if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                            LOG.log(Level.INFO, "External updates: project {0} found for changed {1}", new Object[]{project, file});
                        }
                        project.onFileImplExternalChange(file);
                        continue;
                    }
                    if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                        LOG.log(Level.INFO, "External updates: project {0} found for {1}", new Object[]{project, fo});
                    }
                    project.onFileObjectExternalCreate(fo);
                }
                if (curKind != EventKind.CREATED) continue;
                Collection ownerCsmProjects = CsmUtilities.getOwnerCsmProjects((FileObject)fo);
                for (CsmProject prj : ownerCsmProjects) {
                    ProjectBase project;
                    if (!(prj instanceof ProjectBase) || handledProjects.contains(project = (ProjectBase)prj)) continue;
                    if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                        LOG.log(Level.INFO, "External updates: project {0} found for {1}", new Object[]{project, fo});
                    }
                    project.onFileObjectExternalCreate(fo);
                }
                if (!TraceFlags.TRACE_EXTERNAL_CHANGES || !ownerCsmProjects.isEmpty()) continue;
                LOG.log(Level.INFO, "External updates: No CsmProject found for {0}", fo);
            }
            break;
        }
    }

    private boolean isCOrCpp(FileObject fo) {
        String mime = fo.getMIMEType();
        if (mime == null) {
            mime = FileUtil.getMIMEType((FileObject)fo);
            if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                LOG.log(Level.INFO, "External updates: MIME resolved: {0}", mime);
            }
        }
        return MIMENames.isFortranOrHeaderOrCppOrC((String)mime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(FileEvent fe, EventKind kind) {
        FileObject fo;
        ModelImpl model = this.modelSupport.theModel;
        if (model != null && (!(fo = fe.getFile()).isValid() || this.isCOrCpp(fo))) {
            Object object = this.eventsLock;
            synchronized (object) {
                if (TraceFlags.TRACE_EXTERNAL_CHANGES) {
                    LOG.log(Level.INFO, "External updates: registered {0} {1}", new Object[]{kind, fe});
                }
                this.events.addLast(new Pair(kind, fe));
            }
            model.enqueueModelTask(this, "External File Updater");
        }
    }

    private static final class Pair {
        private final EventKind kind;
        private final FileEvent fe;

        public Pair(EventKind kind, FileEvent fe) {
            this.kind = kind;
            this.fe = fe;
        }

        public String toString() {
            return "Pair{kind=" + (Object)((Object)this.kind) + ", fe=" + this.fe + '}';
        }
    }

    private static enum EventKind {
        CREATED,
        CHANGED,
        DELETED;

    }
}

