/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.symtab;

import java.util.Map;
import java.util.TreeMap;
import org.netbeans.modules.cnd.modelimpl.parser.symtab.SymTabEntry;

public final class SymTab {
    private final Map<CharSequence, SymTabEntry> entries = new TreeMap<CharSequence, SymTabEntry>();
    private final Map<CharSequence, SymTabEntry> imported = new TreeMap<CharSequence, SymTabEntry>();
    private final int nestingLevel;
    private CharSequence name;

    SymTab(int nestingLevel, CharSequence name) {
        this.nestingLevel = nestingLevel;
        this.name = name;
    }

    public CharSequence getName() {
        return this.name;
    }

    SymTabEntry lookup(CharSequence entry) {
        SymTabEntry out = this.entries.get(entry);
        if (out == null) {
            out = this.imported.get(entry);
        }
        return out;
    }

    SymTabEntry enter(CharSequence entry) {
        SymTabEntry newEntry = new SymTabEntry(entry, this);
        this.entries.put(entry, newEntry);
        return newEntry;
    }

    void importSymTab(SymTab symTab) {
        this.imported.putAll(symTab.entries);
    }

    int getNestingLevel() {
        return this.nestingLevel;
    }

    public String toString() {
        return "SymTab{nestingLevel=" + this.nestingLevel + "entries=" + this.entries + "\nimported=" + this.imported + '}';
    }
}

