/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.symtab;

import java.io.IOException;
import org.netbeans.modules.cnd.modelimpl.parser.symtab.DictionaryEntry;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.openide.util.Exceptions;

public class Dictionary {
    private DictionaryEntry[] scope;
    private DictionaryEntry[] endScope;
    private int nscopes;
    private int currentScope;
    private DictionaryEntry[] bucket;
    private int nbuckets;

    protected Dictionary(int nrBuckets, int nrScopes, int nrCharacters) {
        this.init(nrBuckets, nrScopes);
    }

    int hash(CharSequence s) {
        return s.hashCode();
    }

    int getBucketIndex(CharSequence key) {
        return this.hash(key) % this.nbuckets;
    }

    DictionaryEntry lookup(CharSequence key) {
        return this.lookup(key, null);
    }

    DictionaryEntry lookup(CharSequence key, DictionaryEntry.ObjectType tp) {
        int h = this.getBucketIndex(key);
        for (DictionaryEntry q = this.bucket[h]; q != null; q = q.getNext()) {
            if (h != q.getHashCode()) {
                System.err.printf("dictionary.cpp lookup, h not equal to q.getHashCode() for %s\n", key);
            }
            if (h != q.getHashCode() || !this.strcmp(key, q.getKey())) continue;
            if (tp == DictionaryEntry.UNSPECIFIED_TYPE) {
                return q;
            }
            if (q.isTypeOf(tp)) {
                return q;
            }
            return null;
        }
        return null;
    }

    void define(CharSequence key, DictionaryEntry value) {
        this.defineInScope(key, value, this.currentScope);
    }

    void defineInScope(CharSequence key, DictionaryEntry entry, int sc) {
        int h = this.getBucketIndex(key);
        entry.this_scope = sc;
        entry.setKey(this.strdup(key));
        entry.setHashCode(h);
        entry.setNext(this.bucket[h]);
        this.bucket[h] = entry;
        if (this.endScope[sc] == null) {
            this.scope[sc] = this.endScope[sc] = entry;
        } else {
            this.endScope[sc].setScope(entry);
            this.endScope[sc] = entry;
        }
    }

    void saveScope() {
        ++this.currentScope;
        if (this.currentScope >= this.nscopes) {
            this.panic("saveScope: overflow");
        }
    }

    void restoreScope() {
        if (this.currentScope == 0) {
            this.panic("restoreScope: underflow");
        }
        --this.currentScope;
    }

    DictionaryEntry getCurrentScope() {
        if (this.currentScope < 0 || this.currentScope > this.nscopes) {
            this.panic("getCurrentScope: no scope");
        }
        return this.scope[this.currentScope];
    }

    int getCurrentScopeIndex() {
        return this.currentScope;
    }

    DictionaryEntry removeScope() {
        return this.removeScope(-1);
    }

    DictionaryEntry removeScope(int sc) {
        if (sc == -1) {
            sc = this.currentScope;
        }
        for (DictionaryEntry de = this.scope[sc]; de != null; de = de.getNextInScope()) {
            this.remove(de);
        }
        DictionaryEntry r = this.scope[sc];
        this.endScope[sc] = null;
        this.scope[sc] = null;
        return r;
    }

    DictionaryEntry remove(CharSequence key) {
        int h = this.getBucketIndex(key);
        DictionaryEntry prev = null;
        for (DictionaryEntry q = this.bucket[h]; q != null; q = q.getNext()) {
            if (h == q.getHashCode() && this.strcmp(key, q.getKey())) {
                if (prev == null) {
                    this.bucket[h] = q.getNext();
                } else {
                    prev.setNext(q.getNext());
                }
                q.setNext(null);
                return q;
            }
            prev = q;
        }
        assert (false);
        return null;
    }

    DictionaryEntry remove(DictionaryEntry de) {
        if (de == null) {
            this.panic("Dictionary remove: null ptr");
        }
        int h = this.getBucketIndex(de.getKey());
        DictionaryEntry prev = null;
        for (DictionaryEntry curr = this.bucket[h]; curr != null; curr = curr.getNext()) {
            if (de == curr) {
                if (prev == null) {
                    this.bucket[h] = de.getNext();
                } else {
                    prev.setNext(de.getNext());
                }
                de.setNext(null);
                return de;
            }
            prev = curr;
        }
        return null;
    }

    private boolean strcmp(CharSequence s1, CharSequence s2) {
        return s1.equals(s2);
    }

    private CharSequence strdup(CharSequence key) {
        return NameCache.getManager().getString(key);
    }

    void dumpScope(Appendable stream, int sc) {
        if (sc == -1) {
            sc = this.currentScope;
        }
        for (DictionaryEntry s = this.scope[sc]; s != null; s = s.getNextInScope()) {
            this.dumpSymbol(stream, s);
        }
    }

    void dumpScopes() {
        DictionaryEntry dictEntry;
        int i;
        this.printf("Scopes", new Object[0]);
        for (i = 0; i < 10; ++i) {
            this.printf("     %d     ", i);
        }
        this.printf("\n", new Object[0]);
        this.printf(" first", new Object[0]);
        for (i = 0; i < 10; ++i) {
            if (this.scope[i] != null) {
                dictEntry = this.scope[i];
                this.printf("%10s ", dictEntry.getKey());
                continue;
            }
            this.printf("           ", new Object[0]);
        }
        this.printf("\n", new Object[0]);
        this.printf(" last ", new Object[0]);
        for (i = 0; i < 10; ++i) {
            if (this.endScope[i] != null) {
                dictEntry = this.endScope[i];
                this.printf("%10s ", dictEntry.getKey());
                continue;
            }
            this.printf("           ", new Object[0]);
        }
        this.printf("\n", new Object[0]);
    }

    void dumpSymbol(Appendable stream, DictionaryEntry e) {
        try {
            stream.append(e.getKey()).append("\n");
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    void printf(CharSequence msg, Object ... args) {
        System.err.printf(((Object)msg).toString(), args);
    }

    final void panic(CharSequence msg) {
        throw new IllegalStateException(msg == null ? "" : ((Object)msg).toString());
    }

    private void init(int nrBuckets, int nrScopes) {
        int i;
        this.bucket = new DictionaryEntry[nrBuckets];
        if (this.bucket == null) {
            this.panic("can't alloc buckets");
        }
        this.nbuckets = nrBuckets;
        for (i = 0; i < nrBuckets; ++i) {
            this.bucket[i] = null;
        }
        this.scope = new DictionaryEntry[nrScopes];
        if (this.scope == null) {
            this.panic("can't alloc scopes");
        }
        this.endScope = new DictionaryEntry[nrScopes];
        if (this.endScope == null) {
            this.panic("can't alloc endScope");
        }
        this.nscopes = nrScopes;
        for (i = 0; i < nrScopes; ++i) {
            this.scope[i] = null;
            this.endScope[i] = null;
        }
        this.currentScope = 0;
    }
}

