/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTElif;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTIf;
import org.netbeans.modules.cnd.apt.structure.APTIfdef;
import org.netbeans.modules.cnd.apt.structure.APTIfndef;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.structure.APTIncludeNext;
import org.netbeans.modules.cnd.apt.structure.APTPragma;
import org.netbeans.modules.cnd.apt.structure.APTStream;
import org.netbeans.modules.cnd.apt.structure.APTUndefine;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.support.APTWalker;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.indexing.api.CndTextIndex;
import org.netbeans.modules.cnd.indexing.api.CndTextIndexKey;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.repository.api.CacheLocation;

public final class APTIndexingWalker
extends APTWalker {
    private final Set<String> ids = new HashSet<String>();
    private final CndTextIndexKey key;
    private final CacheLocation location;

    public APTIndexingWalker(APTFile apt, CndTextIndexKey key, CacheLocation location) {
        super(apt, null);
        assert (apt.isTokenized()) : "only full APT have to be passed here " + apt.getPath();
        this.key = key;
        this.location = location;
    }

    protected void onDefine(APT apt) {
        APTDefine defineNode = (APTDefine)apt;
        this.analyzeList(defineNode.getBody());
    }

    protected boolean onIf(APT apt) {
        this.analyzeStream(((APTIf)apt).getCondition());
        return true;
    }

    protected boolean onElif(APT apt, boolean wasInPrevBranch) {
        this.analyzeStream(((APTElif)apt).getCondition());
        return true;
    }

    protected boolean onIfndef(APT apt) {
        this.analyzeToken(((APTIfndef)apt).getMacroName());
        return true;
    }

    protected boolean onIfdef(APT apt) {
        this.analyzeToken(((APTIfdef)apt).getMacroName());
        return true;
    }

    protected void onUndef(APT apt) {
        this.analyzeToken(((APTUndefine)apt).getName());
    }

    protected boolean onElse(APT apt, boolean wasInPrevBranch) {
        return true;
    }

    protected void onEndif(APT apt, boolean wasInBranch) {
    }

    protected void onPragmaNode(APT apt) {
        APTPragma pragma = (APTPragma)apt;
        this.analyzeToken(pragma.getName());
        this.analyzeStream(pragma.getTokenStream());
    }

    protected void onInclude(APT apt) {
        this.analyzeStream(((APTInclude)apt).getInclude());
    }

    protected void onIncludeNext(APT apt) {
        this.analyzeStream(((APTIncludeNext)apt).getInclude());
    }

    protected void onStreamNode(APT apt) {
        this.analyzeStream(((APTStream)apt).getTokenStream());
    }

    protected boolean stopOnErrorDirective() {
        return false;
    }

    public void index() {
        super.visit();
        CndTextIndex.put((CacheLocation)this.location, (CndTextIndexKey)this.key, this.ids);
    }

    private boolean analyzeToken(APTToken token) {
        if (token != null && !APTUtils.isEOF((Token)token) && (APTUtils.isID((Token)token) || token.getType() == 486)) {
            this.ids.add(token.getText());
            return true;
        }
        return false;
    }

    private void analyzeList(List<APTToken> tokens) {
        if (tokens != null) {
            for (APTToken token : tokens) {
                this.analyzeToken(token);
            }
        }
    }

    private void analyzeStream(TokenStream ts) {
        if (ts != null) {
            try {
                APTToken token = (APTToken)ts.nextToken();
                while (!APTUtils.isEOF((Token)token)) {
                    this.analyzeToken(token);
                    token = (APTToken)ts.nextToken();
                }
            }
            catch (TokenStreamException ex) {
                DiagnosticExceptoins.register(ex);
            }
        }
    }
}

