/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser;

import java.util.ArrayList;
import java.util.Stack;
import org.antlr.runtime.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.apt.support.APTTokenStreamBuilder;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageSupport;
import org.netbeans.modules.cnd.apt.utils.APTCommentsFilter;
import org.netbeans.modules.cnd.modelimpl.parser.FortranParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.FortranToken;
import org.netbeans.modules.cnd.modelimpl.parser.FortranTokenStream;

public class FortranLexicalPrepass {
    private FortranTokenStream tokens;
    private Stack<Token> doLabels;
    private int sourceForm;

    public FortranLexicalPrepass(FortranTokenStream tokens) {
        this.tokens = tokens;
        this.doLabels = new Stack();
    }

    public void setSourceForm(int sourceForm) {
        this.sourceForm = sourceForm;
    }

    private boolean isAssignment(int start, int end) {
        return this.tokens.getToken(start).getType() == 458 && start + 3 < end && this.tokens.getToken(start + 1).getType() == 368 && this.tokens.getToken(start + 2).getType() == 328;
    }

    private boolean isOperator(int start, int end) {
        return this.tokens.getToken(start).getType() == 340 && start + 3 < end && this.tokens.getToken(start + 1).getType() == 368 && this.tokens.getToken(start + 2).getType() == 279 && this.tokens.getToken(start + 3).getType() == 321;
    }

    private void convertToIdents(int start, int end) {
        for (int i = start; i < end; ++i) {
            Token tmpToken = this.tokens.getToken(i);
            if (tmpToken != null) {
                if (!FortranLexer.isKeyword(tmpToken) || this.isAssignment(i, end) || this.isOperator(i, end)) continue;
                tmpToken.setType(263);
                continue;
            }
            System.out.println("convertToIdents(): couldn't retrieve token");
            System.out.println("start: " + start + " end: " + end + " i: " + i);
            this.tokens.printCurrLine();
        }
    }

    public int salesScanForToken(int start, int desiredToken) {
        int tmpToken;
        int lookAhead = 0;
        if (this.tokens.currLineLA(1) == 393) {
            return -1;
        }
        lookAhead = start;
        do {
            int parenOffset;
            if ((tmpToken = this.tokens.currLineLA(++lookAhead)) == 368 || tmpToken == 420) {
                parenOffset = this.tokens.findToken(lookAhead - 1, 368);
                ++parenOffset;
                lookAhead = this.matchClosingParen(start, lookAhead);
                tmpToken = this.tokens.currLineLA(lookAhead);
                continue;
            }
            if (tmpToken != 357) continue;
            parenOffset = this.tokens.findToken(lookAhead - 1, 357);
            lookAhead = this.matchClosingParen(lookAhead + 1, parenOffset += 2);
            tmpToken = this.tokens.currLineLA(lookAhead);
        } while (tmpToken != -1 && tmpToken != 269 && tmpToken != desiredToken);
        if (tmpToken == desiredToken) {
            return lookAhead - 1;
        }
        return -1;
    }

    private boolean matchIfConstStmt(int lineStart, int lineEnd) {
        int rparenOffset = -1;
        int commaOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 292 && this.tokens.currLineLA(lineStart + 2) == 368) {
            rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 2);
            commaOffset = this.salesScanForToken(rparenOffset + 1, 405);
            if (rparenOffset == -1) {
                System.err.println("Error in IF stmt at line: " + this.tokens.getToken(0).getLine());
                return false;
            }
            if (this.tokens.currLineLA(rparenOffset + 1) == 293) {
                this.convertToIdents(lineStart + 1, rparenOffset);
                return true;
            }
            if (commaOffset != -1 && this.tokens.currLineLA(rparenOffset + 1) == 331) {
                this.convertToIdents(lineStart + 1, rparenOffset);
                this.tokens.addToken(lineStart, 355, "__T_ARITHMETIC_IF_STMT__");
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean matchElseStmt(int lineStart, int lineEnd) {
        boolean isElseIf = false;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 365) {
            if (lineEnd >= 2) {
                if (this.tokens.currLineLA(lineStart + 2) == 303) {
                    this.convertToIdents(lineStart + 2, lineEnd);
                } else {
                    isElseIf = this.matchIfConstStmt(lineStart + 1, lineEnd);
                }
            }
            return true;
        }
        return false;
    }

    private boolean matchDataDecl(int lineStart, int lineEnd) {
        int tokenType = this.tokens.currLineLA(1);
        if (this.isIntrinsicType(tokenType) || this.isPrefixToken(tokenType) || (tokenType == 445 || tokenType == 257) && this.tokens.currLineLA(lineStart + 2) == 368) {
            if (this.isSubDecl(lineStart, lineEnd)) {
                return false;
            }
            if (this.isFuncDecl(lineStart, lineEnd)) {
                this.fixupFuncDecl(lineStart, lineEnd);
            } else {
                this.fixupDataDecl(lineStart, lineEnd);
            }
            return true;
        }
        if (tokenType == 449) {
            this.fixupFuncDecl(lineStart, lineEnd);
            return true;
        }
        return false;
    }

    private boolean matchDerivedTypeStmt(int lineStart, int lineEnd) {
        Token identToken = null;
        if (this.tokens.currLineLA(lineStart + 1) == 445 && this.tokens.currLineLA(lineStart + 2) != 368) {
            int colonOffset = this.tokens.findToken(lineStart, 332);
            if (colonOffset != -1) {
                int identOffset = colonOffset + 1;
                this.convertToIdents(identOffset, lineEnd);
            } else {
                identToken = this.tokens.getToken(lineStart + 1);
                int identOffset = lineStart + 1;
                if (FortranLexer.isKeyword(identToken)) {
                    identToken.setType(263);
                }
                if (this.tokens.currLineLA(lineStart + 3) == 368) {
                    int rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 3) - 1;
                    if (this.isIntrinsicType(this.tokens.currLineLA(lineStart + 4))) {
                        this.fixupDeclTypeSpec(lineStart + 3, lineEnd);
                    } else {
                        this.convertToIdents(lineStart + 3, lineEnd);
                    }
                    if (lineEnd - 1 > rparenOffset + 1 && FortranLexer.isKeyword(this.tokens.currLineLA(rparenOffset + 2))) {
                        this.tokens.getToken(rparenOffset + 1).setType(263);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private boolean matchSub(int lineStart, int lineEnd) {
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        int bindOffset = this.tokens.findToken(lineStart, 357);
        if (bindOffset != -1) {
            this.convertToIdents(lineStart + 1, bindOffset + lineStart);
        } else {
            this.convertToIdents(lineStart + 1, lineEnd);
        }
        return true;
    }

    private boolean matchEnd(int lineStart, int lineEnd) {
        boolean matchedEnd = false;
        boolean isEndDo = false;
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 286) {
            if (lineEnd > 2) {
                identOffset = this.tokens.currLineLA(lineStart + 2) == 253 ? lineStart + 3 : (this.tokens.currLineLA(lineStart + 2) == 264 ? this.matchGenericSpec(lineStart + 2, lineEnd) : lineStart + 2);
            }
            if (this.tokens.currLineLA(lineStart + 2) == 359) {
                isEndDo = true;
            }
            matchedEnd = true;
        } else if (tokenType == 323) {
            identOffset = lineStart + 2;
            matchedEnd = true;
        } else if (tokenType == 285) {
            identOffset = this.matchGenericSpec(lineStart + 1, lineEnd);
        } else {
            if (lineEnd > 1) {
                identOffset = lineStart + 1;
            }
            matchedEnd = true;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
        }
        if (isEndDo || tokenType == 435) {
            this.fixupLabeledEndDo(lineStart, lineEnd);
        }
        return matchedEnd;
    }

    private boolean matchModule(int lineStart, int lineEnd) {
        this.convertToIdents(lineStart + 1, lineEnd);
        return true;
    }

    private boolean matchBlockData(int lineStart, int lineEnd) {
        if (lineEnd < lineStart + 2) {
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 253) {
            if (this.tokens.currLineLA(lineStart + 2) == 301) {
                if (lineEnd >= lineStart + 3 && FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 3))) {
                    this.tokens.getToken(lineStart + 2).setType(263);
                }
                return true;
            }
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 311) {
            if (FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 2))) {
                this.tokens.getToken(lineStart + 1).setType(263);
            }
            return true;
        }
        return false;
    }

    private boolean matchUseStmt(int lineStart, int lineEnd) {
        Object onlyToken = null;
        int colonOffset = this.tokens.findToken(lineStart, 332);
        int identPos = colonOffset != -1 ? colonOffset + 1 : lineStart + 1;
        if (FortranLexer.isKeyword(this.tokens.currLineLA(identPos + 1))) {
            this.tokens.getToken(identPos).setType(263);
        }
        if (++identPos < lineEnd) {
            if (this.tokens.currLineLA(identPos + 1) == 405 && this.tokens.currLineLA(identPos + 2) == 429) {
                identPos += 3;
            }
            this.convertToIdents(identPos, lineEnd);
        }
        return true;
    }

    private boolean matchLabel(int lineStart, int lineEnd) {
        return this.tokens.currLineLA(1) == 331;
    }

    private boolean matchIdentColon(int lineStart, int lineEnd) {
        int secondToken = this.tokens.currLineLA(lineStart + 2);
        if (secondToken == 425) {
            if (FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 1))) {
                this.tokens.getToken(lineStart).setType(263);
            }
            return true;
        }
        return false;
    }

    private boolean matchProcStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        if (lineEnd < lineStart + 2) {
            return false;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 383 && this.tokens.currLineLA(lineStart + 2) != 368) {
            int colonOffset = -1;
            colonOffset = this.tokens.findToken(lineStart + 1, 332);
            identOffset = colonOffset != -1 ? colonOffset + 1 : lineStart + 1;
        } else if (this.tokens.currLineLA(lineStart + 1) == 372 && this.tokens.currLineLA(lineStart + 2) == 383) {
            if (lineEnd < lineStart + 4) {
                return false;
            }
            identOffset = lineStart + 2;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            return true;
        }
        return false;
    }

    private boolean matchProcDeclStmt(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 383) {
            int lParenOffset = lineStart + 1;
            int rParenOffset = this.matchClosingParen(lineStart, lParenOffset + 1);
            int colonOffset = this.tokens.findToken(rParenOffset + 1, 332);
            if (colonOffset != -1) {
                this.convertToIdents(colonOffset + 1, lineEnd);
            } else {
                this.convertToIdents(rParenOffset + 1, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchAttrStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (firstToken == 322) {
            int lParenOffset = this.tokens.findToken(lineStart + 1, 368);
            identOffset = this.matchClosingParen(lineStart, lParenOffset + 1);
        } else if (firstToken == 357) {
            int rParenOffset;
            identOffset = rParenOffset = this.matchClosingParen(lineStart, lineStart + 2);
        } else if (firstToken == 441) {
            int lParenOffset = this.tokens.findToken(lineStart + 1, 368);
            if (lParenOffset != -1) {
                identOffset = lParenOffset;
                lineEnd = this.matchClosingParen(lineStart, lParenOffset + 1);
            }
        } else if (firstToken == 291) {
            int lparenOffset = -1;
            int rparenOffset = -1;
            if (this.tokens.currLineLA(lineStart + 2) != 400) {
                while ((lparenOffset = this.tokens.findToken(lineStart, 368)) != -1 && (rparenOffset = this.matchClosingParen(lineStart, lparenOffset + 1)) != -1) {
                    for (int i = lparenOffset; i < rparenOffset; ++i) {
                        if (!FortranLexer.isKeyword(this.tokens.currLineLA(i + 1)) || this.tokens.currLineLA(i + 1) == 280 || this.tokens.currLineLA(i + 1) == 454) continue;
                        this.tokens.getToken(i).setType(263);
                    }
                    if ((this.tokens.currLineLA(rparenOffset + 1) != 368 || (rparenOffset = this.matchClosingParen(lineStart, rparenOffset + 1)) != -1) && (lineStart = rparenOffset) < lineEnd && this.tokens.currLineLA(lineStart + 1) != 269) continue;
                    break;
                }
            }
        } else {
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            return true;
        }
        return false;
    }

    private int matchClosingParen(int lineStart, int offset) {
        int tmpTokenType;
        int lookAhead = 0;
        int nestingLevel = 0;
        lookAhead = offset;
        nestingLevel = 1;
        do {
            if ((tmpTokenType = this.tokens.currLineLA(++lookAhead)) == 368 || tmpTokenType == 420) {
                ++nestingLevel;
            } else if (tmpTokenType == 321 || tmpTokenType == 367) {
                --nestingLevel;
            }
            if (tmpTokenType != 269 && tmpTokenType != -1 || nestingLevel == 0) continue;
            System.err.println("Error: matchClosingParen(): Missing closing paren on line " + this.tokens.getToken(lookAhead - 1).getLine() + ":");
            System.err.println("nestingLevel: " + nestingLevel);
            System.err.println("lookAhead is: " + lookAhead);
            this.tokens.printPackedList();
        } while (nestingLevel != 0 || tmpTokenType != 321 && tmpTokenType != 367 && tmpTokenType != 269 && tmpTokenType != -1);
        if (tmpTokenType == 321 || tmpTokenType == 367) {
            return lookAhead;
        }
        return -1;
    }

    private int fixupDeclTypeSpec(int lineStart, int lineEnd) {
        int kindOffsetEnd = -1;
        if (this.tokens.currLineLA(lineStart + 1) == 445 || this.tokens.currLineLA(lineStart + 1) == 257) {
            int rparenOffset = -1;
            if (this.tokens.currLineLA(lineStart + 2) != 368) {
                System.err.println("Derived type or Class declaration error!");
            }
            rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            this.convertToIdents(lineStart + 1, rparenOffset);
            return rparenOffset - 1;
        }
        if (this.tokens.currLineLA(lineStart + 2) == 368) {
            int kindTokenOffset = -1;
            int lenTokenOffset = -1;
            kindOffsetEnd = this.matchClosingParen(lineStart, this.tokens.findToken(lineStart, 368) + 1);
            kindTokenOffset = this.tokens.findToken(lineStart + 1, 280);
            lenTokenOffset = this.tokens.findToken(lineStart + 1, 454);
            this.convertToIdents(lineStart + 1, kindOffsetEnd);
            if (kindTokenOffset != -1 && kindTokenOffset < kindOffsetEnd && this.tokens.currLineLA(kindTokenOffset + 2) == 328) {
                this.tokens.getToken(kindTokenOffset).setType(280);
            }
            if (lenTokenOffset != -1 && lenTokenOffset < kindOffsetEnd && this.tokens.currLineLA(lenTokenOffset + 2) == 328) {
                this.tokens.getToken(lenTokenOffset).setType(454);
            }
            return kindOffsetEnd - 1;
        }
        if (this.tokens.currLineLA(lineStart + 1) == 371) {
            ++lineStart;
        }
        return lineStart;
    }

    private void fixupDataDecl(int lineStart, int lineEnd) {
        int identOffset = this.tokens.findToken(lineStart = this.fixupDeclTypeSpec(lineStart, lineEnd), 332);
        identOffset = identOffset != -1 ? ++identOffset : lineStart + 1;
        this.convertToIdents(identOffset, lineEnd);
    }

    private void fixupFuncDecl(int lineStart, int lineEnd) {
        int newLineStart = 0;
        Token resultToken = null;
        Token bindToken = null;
        newLineStart = this.fixupDeclTypeSpec(lineStart, lineEnd);
        if (newLineStart != lineStart) {
            lineStart = newLineStart + 1;
        }
        int identOffset = this.tokens.findToken(lineStart, 449) + 1;
        int resultOffset = this.salesScanForToken(lineStart, 406);
        int bindOffset = this.salesScanForToken(lineStart, 357);
        if (resultOffset != -1) {
            resultToken = this.tokens.getToken(resultOffset);
        }
        if (bindOffset != -1) {
            bindToken = this.tokens.getToken(bindOffset);
        }
        this.convertToIdents(identOffset, lineEnd);
        if (resultToken != null) {
            resultToken.setType(406);
        }
        if (bindToken != null) {
            bindToken.setType(357);
        }
    }

    private boolean isIntrinsicType(int type) {
        return type == 375 || type == 381 || type == 371 || type == 289 || type == 426 || type == 351 || type == 408;
    }

    private int skipTypeSpec(int lineStart) {
        int rparenOffset = -1;
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (this.isIntrinsicType(firstToken) || firstToken == 445) {
            if (firstToken == 371) {
                ++lineStart;
            }
            if (this.tokens.currLineLA(lineStart + 2) == 287 && this.tokens.currLineLA(lineStart + 3) == 331) {
                lineStart += 2;
            }
            if (this.tokens.currLineLA(lineStart + 2) == 368) {
                rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            }
            lineStart = rparenOffset != -1 ? rparenOffset : ++lineStart;
            return lineStart;
        }
        return lineStart;
    }

    private int skipPrefix(int lineStart) {
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        lineStart = this.skipTypeSpec(lineStart);
        while (this.isPrefixToken(this.tokens.currLineLA(lineStart + 1))) {
            ++lineStart;
        }
        return lineStart;
    }

    private boolean isPrefixToken(int token) {
        return token == 387 || token == 350 || token == 308;
    }

    private boolean isFuncDecl(int lineStart, int lineEnd) {
        return this.tokens.currLineLA((lineStart = this.skipPrefix(lineStart)) + 1) == 449 && (this.tokens.currLineLA(lineStart + 2) == 263 || FortranLexer.isKeyword(this.tokens.currLineLA(3)));
    }

    private boolean isSubDecl(int lineStart, int lineEnd) {
        return this.tokens.currLineLA((lineStart = this.skipPrefix(lineStart)) + 1) == 275 && (this.tokens.currLineLA(lineStart + 2) == 263 || FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 2)));
    }

    private boolean isValidDataEditDesc(String line, int lineIndex) {
        char secondChar = '\u0000';
        char firstChar = Character.toLowerCase(line.charAt(lineIndex));
        if (lineIndex < line.length() - 1) {
            secondChar = Character.toLowerCase(line.charAt(lineIndex + 1));
        }
        return firstChar == 'i' || firstChar == 'b' && secondChar != 'n' && secondChar != 'z' || firstChar == 'o' || firstChar == 'z' || firstChar == 'f' || firstChar == 'g' || firstChar == 'l' || firstChar == 'a' || firstChar == 'd' && (secondChar == 't' || this.isDigit(secondChar)) || firstChar == 'e' && (secondChar == 'n' || secondChar == 's' || this.isDigit(secondChar));
    }

    private int findFormatItemEnd(String line, int lineIndex) {
        char currChar;
        int lineLength = line.length();
        do {
            currChar = line.charAt(lineIndex);
        } while (++lineIndex < lineLength && currChar != ',' && currChar != ')' && currChar != '/' && currChar != ':');
        return lineIndex - 1;
    }

    private int matchVList(String line, int lineIndex) {
        int tmpLineIndex = lineIndex + 2;
        int lineLength = line.length();
        if (line.charAt(tmpLineIndex) == '\'' || line.charAt(tmpLineIndex) == '\"') {
            ++tmpLineIndex;
            while (line.charAt(tmpLineIndex) != '\'' && line.charAt(tmpLineIndex) != '\"' && tmpLineIndex < lineLength) {
                ++tmpLineIndex;
            }
        }
        if (tmpLineIndex == lineLength) {
            return lineIndex;
        }
        if (line.charAt(tmpLineIndex) == '\'' || line.charAt(tmpLineIndex) == '\"') {
            ++tmpLineIndex;
        }
        if (line.charAt(tmpLineIndex) == '(') {
            ++tmpLineIndex;
            while (tmpLineIndex < lineLength && Character.isDigit(line.charAt(tmpLineIndex))) {
                ++tmpLineIndex;
            }
            if (tmpLineIndex == lineLength) {
                return lineIndex;
            }
            if (line.charAt(tmpLineIndex) == ')') {
                return ++tmpLineIndex;
            }
            System.err.println("Error: Unable to match v-list in data-edit-desc!");
            return lineIndex;
        }
        return lineIndex;
    }

    private int getDataEditDesc(String line, int lineIndex, int lineEnd) {
        while (lineIndex < lineEnd && this.isDigit(line.charAt(lineIndex))) {
            ++lineIndex;
        }
        if (this.isValidDataEditDesc(line, lineIndex)) {
            if (Character.toLowerCase(line.charAt(lineIndex)) == 'd' && Character.toLowerCase(line.charAt(lineIndex + 1)) == 't') {
                lineIndex = this.matchVList(line, lineIndex);
            }
            return this.findFormatItemEnd(line, lineIndex);
        }
        return -1;
    }

    private boolean isDigit(char tmpChar) {
        return tmpChar >= '0' && tmpChar <= '9';
    }

    private boolean isLetter(char tmpChar) {
        return (tmpChar = Character.toLowerCase(tmpChar)) >= 'a' && tmpChar <= 'z';
    }

    private boolean isValidControlEditDesc(String line, int lineIndex) {
        char secondChar = '\u0000';
        char firstChar = Character.toLowerCase(line.charAt(lineIndex));
        if (lineIndex < line.length() - 1) {
            secondChar = Character.toLowerCase(line.charAt(lineIndex + 1));
        }
        if (firstChar == ':' || firstChar == '/' || firstChar == 'p' || firstChar == 't' || firstChar == 's' || firstChar == 'b' || firstChar == 'r' || firstChar == 'd' || firstChar == 'x') {
            if (firstChar == 's') {
                if (secondChar != 's' && secondChar != 'p' && Character.isLetterOrDigit(secondChar)) {
                    return false;
                }
                if (firstChar == 't' && !this.isDigit(secondChar) && secondChar != 'l' && secondChar != 'r') {
                    return false;
                }
                if (firstChar == 'b' && secondChar != 'n' && secondChar != 'z') {
                    return false;
                }
                if (firstChar == 'r' && secondChar != 'u' && secondChar != 'd' && secondChar != 'z' && secondChar != 'n' && secondChar != 'c' && secondChar != 'p') {
                    return false;
                }
                if (firstChar == 'd' && secondChar != 'c' && secondChar != 'p') {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private int getControlEditDesc(String line, int lineIndex, int lineLength) {
        while (lineIndex < lineLength && line.charAt(lineIndex) >= '0' && line.charAt(lineIndex) <= '9') {
            ++lineIndex;
        }
        if (this.isValidControlEditDesc(line, lineIndex)) {
            return this.findFormatItemEnd(line, lineIndex);
        }
        return -1;
    }

    private int getCharString(String line, int lineIndex, char quoteChar) {
        char nextChar;
        if ((nextChar = line.charAt(++lineIndex)) == '\'' || nextChar == '\"') {
            return this.getCharString(line, lineIndex, nextChar);
        }
        while ((nextChar = line.charAt(++lineIndex)) != '\'' && nextChar != '\"') {
        }
        return lineIndex;
    }

    private int getCharStringEditDesc(String line, int lineIndex, int lineLength) {
        int startIndex = lineIndex;
        while (lineIndex < lineLength && this.isDigit(line.charAt(lineIndex))) {
            ++lineIndex;
        }
        char quoteChar = Character.toLowerCase(line.charAt(lineIndex));
        if (quoteChar == 'h' && startIndex != lineIndex) {
            return lineIndex + Integer.parseInt(line.substring(startIndex, lineIndex));
        }
        if (quoteChar != '\'' && quoteChar != '\"') {
            return -1;
        }
        lineIndex = this.getCharString(line, lineIndex, quoteChar);
        return this.findFormatItemEnd(line, lineIndex + 1);
    }

    private int parseFormatString(String line, int lineIndex, int lineNum, int charPos) {
        int descIndex = 0;
        boolean foundClosingParen = false;
        int lineLength = line.length();
        while (lineIndex < lineLength - 1 && !foundClosingParen) {
            descIndex = this.getCharStringEditDesc(line, lineIndex, lineLength);
            if (descIndex == -1) {
                descIndex = this.getDataEditDesc(line, lineIndex, lineLength);
                if (descIndex == -1) {
                    descIndex = this.getControlEditDesc(line, lineIndex, lineLength);
                    if (descIndex != -1 && (descIndex - lineIndex > 0 || line.charAt(descIndex) != '/')) {
                        this.tokens.addToken(this.tokens.createToken(276, line.substring(lineIndex, descIndex), lineNum, charPos));
                        charPos += line.substring(lineIndex, descIndex).length();
                    }
                } else {
                    this.tokens.addToken(this.tokens.createToken(345, line.substring(lineIndex, descIndex), lineNum, charPos));
                    charPos += line.substring(lineIndex, descIndex).length();
                }
            } else {
                this.tokens.addToken(this.tokens.createToken(283, line.substring(lineIndex, descIndex), lineNum, charPos));
                charPos += line.substring(lineIndex, descIndex).length();
            }
            if (descIndex != -1 || descIndex == -1 && !this.isDigit(line.charAt(lineIndex)) && line.charAt(lineIndex) != '(') {
                String termString = null;
                if (descIndex == -1) {
                    descIndex = lineIndex;
                }
                if (line.charAt(descIndex) == ',') {
                    termString = new String(",");
                    this.tokens.addToken(this.tokens.createToken(405, ",", lineNum, charPos));
                } else if (line.charAt(descIndex) == ')') {
                    this.tokens.addToken(this.tokens.createToken(321, ")", lineNum, charPos));
                } else {
                    termString = line.charAt(descIndex) == ':' ? new String(":") : (line.charAt(descIndex) == '/' ? new String("/") : null);
                    if (termString != null) {
                        this.tokens.addToken(this.tokens.createToken(276, termString, lineNum, charPos));
                    }
                }
                lineIndex = descIndex + 1;
            } else {
                int startIndex = lineIndex;
                while (lineIndex < lineLength && this.isDigit(line.charAt(lineIndex))) {
                    ++lineIndex;
                    ++charPos;
                }
                if (startIndex != lineIndex) {
                    this.tokens.addToken(this.tokens.createToken(331, line.substring(startIndex, lineIndex), lineNum, charPos - (lineIndex - startIndex)));
                }
                if (line.charAt(lineIndex) == '(') {
                    this.tokens.addToken(this.tokens.createToken(368, "(", lineNum, charPos));
                    descIndex = this.parseFormatString(line, ++lineIndex, lineNum, ++charPos);
                    if (descIndex == -1) {
                        System.err.println("Could not parse the format string: " + line);
                        return -1;
                    }
                    lineIndex = descIndex + 1;
                } else {
                    return -1;
                }
            }
            ++charPos;
        }
        if (lineIndex < lineLength && line.charAt(lineIndex) == ')') {
            this.tokens.addToken(this.tokens.createToken(321, ")", lineNum, charPos));
            ++lineIndex;
        }
        return lineIndex;
    }

    private int fixupFormatStmt(int lineStart, int lineEnd) {
        int lineIndex = 0;
        int i = 0;
        int lineLength = 0;
        int lineNum = 0;
        int charPos = 0;
        ArrayList<Token> origLine = new ArrayList<Token>();
        lineNum = this.tokens.getToken(lineStart).getLine();
        charPos = this.tokens.getToken(++lineStart).getCharPositionInLine();
        if (this.tokens.currLineLA(lineStart + 1) != 368) {
            return -1;
        }
        String line = this.tokens.lineToString(lineStart, lineEnd);
        origLine.addAll(this.tokens.getTokensList());
        this.tokens.clearTokensList();
        for (i = 0; i < lineStart; ++i) {
            this.tokens.addToken((Token)origLine.get(i));
        }
        lineIndex = 0;
        lineLength = line.length();
        lineIndex = this.parseFormatString(line, lineIndex, lineNum, charPos);
        this.tokens.addToken(this.tokens.createToken(269, "\n", lineNum, charPos + lineIndex));
        if (lineIndex == -1) {
            System.err.println("Error in format statement " + line + " at line " + lineNum);
            this.tokens.clearTokensList();
            for (i = 0; i < lineEnd; ++i) {
                this.tokens.addToken((Token)origLine.get(i));
            }
        }
        return lineIndex;
    }

    private boolean matchIOStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 273) {
            if (this.tokens.currLineLA(lineStart + 2) == 328) {
                return false;
            }
            identOffset = lineStart + 1;
        } else if (this.tokens.currLineLA(lineStart + 2) == 368) {
            identOffset = lineStart + 2;
            if (tokenType == 416) {
                int rparenOffset = -1;
                rparenOffset = this.matchClosingParen(lineStart + 2, lineStart + 2);
                if (rparenOffset != -1 && rparenOffset < lineEnd - 1 && this.tokens.currLineLA(rparenOffset + 1) != 269) {
                    this.tokens.addToken(lineStart, 346, "__T_INQUIRE_STMT_2__");
                    ++identOffset;
                }
            }
        } else if ((tokenType == 414 || tokenType == 354) && this.tokens.currLineLA(lineStart + 2) != 328) {
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (tokenType == 397) {
                this.fixupFormatStmt(lineStart, lineEnd);
            }
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 331) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchProgramStmt(int lineStart, int lineEnd) {
        if (FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 2))) {
            this.tokens.getToken(lineStart + 1).setType(263);
        }
        return true;
    }

    private boolean labelsMatch(String label1, String label2) {
        return Integer.parseInt(label1) == Integer.parseInt(label2);
    }

    private void fixupLabeledEndDo(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(1) != 331) {
            return;
        }
        if (!this.doLabels.empty()) {
            String doLabelString = this.doLabels.peek().getText();
            Token firstToken = this.tokens.getToken(0);
            int endType = this.tokens.currLineLA(lineStart + 1);
            String labeledDoText = new String("LABELED_DO_TERM");
            if (this.labelsMatch(doLabelString, firstToken.getText())) {
                this.tokens.addToken(1, 380, labeledDoText);
                this.doLabels.pop();
                while (!this.doLabels.empty() && this.labelsMatch(this.doLabels.peek().getText(), firstToken.getText())) {
                    if (!(this.tokens.appendToken(331, new String(firstToken.getText())) && this.tokens.appendToken(380, labeledDoText) && this.tokens.appendToken(455, new String("CONTINUE")) && this.tokens.appendToken(269, null))) {
                        System.err.println("Couldn't add tokens!");
                        break;
                    }
                    this.doLabels.pop();
                }
            }
        }
    }

    private boolean matchActionStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 270) {
            if (this.tokens.currLineLA(lineStart + 2) != 341) {
                return false;
            }
            identOffset = lineStart + 2;
        } else if (tokenType == 374) {
            int colonOffset = -1;
            colonOffset = this.tokens.findToken(lineStart + 1, 332);
            if (colonOffset != -1) {
                this.tokens.addToken(lineStart, 274, "__T_ALLOCATE_STMT_1__");
                ++lineStart;
                identOffset = colonOffset + 2;
            } else {
                identOffset = lineStart + 1;
            }
        } else {
            identOffset = lineStart + 1;
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 331 && tokenType != 295) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchSingleTokenStmt(int lineStart, int lineEnd) {
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (firstToken == 431 || firstToken == 377 || firstToken == 401 || firstToken == 303 || firstToken == 439 || firstToken == 411 || firstToken == 315 || firstToken == 330 || firstToken == 313 || firstToken == 290 || firstToken == 257 && this.tokens.currLineLA(lineStart + 2) != 398 || firstToken == 264 || firstToken == 379 || firstToken == 318 || firstToken == 301) {
            if (firstToken == 315 || firstToken == 290 && this.tokens.currLineLA(lineStart + 2) == 398) {
                this.convertToIdents(lineStart + 2, lineEnd);
            } else if (firstToken == 264) {
                int identOffset = this.matchGenericSpec(lineStart + 1, lineEnd);
                if (identOffset != -1) {
                    this.convertToIdents(identOffset, lineEnd);
                }
            } else if (firstToken == 379) {
                if (lineStart + 3 < lineEnd) {
                    if (this.tokens.currLineLA(lineStart + 3) == 368) {
                        int resultLA = this.matchClosingParen(lineStart + 3, lineStart + 3);
                        this.convertToIdents(lineStart + 1, resultLA - 1);
                        if (this.tokens.currLineLA(resultLA) == 406) {
                            this.convertToIdents(resultLA, lineEnd);
                        }
                    }
                } else {
                    this.convertToIdents(lineStart + 1, lineEnd);
                }
            } else {
                this.convertToIdents(lineStart + 1, lineEnd);
            }
            if (firstToken == 303) {
                this.tokens.addToken(lineStart, 438, "__T_WHERE_CONSTRUCT_STMT__");
            } else if (firstToken == 411) {
                this.tokens.addToken(lineStart, 356, "__T_FORALL_CONSTRUCT_STMT__");
            }
            return true;
        }
        return false;
    }

    private boolean matchDoStmt(int lineStart, int lineEnd) {
        int whileOffset = -1;
        if (this.tokens.currLineLA(lineStart + 2) == 269) {
            return true;
        }
        if (this.tokens.currLineLA(lineStart + 2) == 331) {
            this.doLabels.push((Token)new FortranToken(this.tokens.getToken(lineStart + 1)));
        }
        if (this.tokens.currLineLA(lineStart + 3) == 269) {
            return true;
        }
        whileOffset = this.tokens.findToken(lineStart + 1, 415);
        int equalsOffset = this.salesScanForToken(lineStart + 1, 328);
        int identOffset = equalsOffset != -1 ? lineStart + 1 : whileOffset + 1;
        this.convertToIdents(identOffset, lineEnd);
        return true;
    }

    private boolean matchOneLineStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int rparenOffset = -1;
        int tokenType = this.tokens.currLineLA(lineStart + 1);
        if (tokenType == 303 || tokenType == 292 || tokenType == 411) {
            if (this.tokens.currLineLA(lineStart + 2) == 368) {
                identOffset = lineStart + 2;
                rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
                this.convertToIdents(identOffset, rparenOffset);
                if (!this.matchLine(rparenOffset, lineEnd)) {
                    this.matchAssignStmt(rparenOffset, lineEnd);
                }
                if (tokenType == 303) {
                    this.tokens.addToken(lineStart, 360, "__T_WHERE_STMT__");
                } else if (tokenType == 292) {
                    this.tokens.addToken(lineStart, 366, "__T_IF_STMT__");
                } else {
                    this.tokens.addToken(lineStart, 418, "__T_FORALL_STMT__");
                }
                if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 331) {
                    this.fixupLabeledEndDo(lineStart, lineEnd);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private int matchDataRef(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 263 || FortranLexer.isKeyword(this.tokens.currLineLA(lineStart + 1))) {
            if (this.tokens.currLineLA(lineStart + 2) == 368) {
                int tmpLineStart = this.matchClosingParen(lineStart, lineStart + 2);
                lineStart = tmpLineStart - 1;
            }
            if (this.tokens.currLineLA(lineStart + 2) == 272) {
                return this.matchDataRef(lineStart + 2, lineEnd);
            }
            return lineStart;
        }
        return lineStart;
    }

    private boolean matchAssignStmt(int lineStart, int lineEnd) {
        int identOffset = -1;
        int assignType = 0;
        if (lineEnd < lineStart + 3) {
            return false;
        }
        int newLineStart = this.matchDataRef(lineStart, lineEnd);
        if (this.tokens.currLineLA(newLineStart + 2) == 328 || this.tokens.currLineLA(newLineStart + 2) == 450) {
            identOffset = lineStart;
            assignType = this.tokens.currLineLA(newLineStart + 2);
        } else if (this.tokens.currLineLA(newLineStart + 2) == 368) {
            int rparenOffset = -1;
            rparenOffset = this.matchClosingParen(newLineStart, newLineStart + 2);
            if (this.tokens.currLineLA(rparenOffset + 1) == 328 || this.tokens.currLineLA(rparenOffset + 1) == 450) {
                identOffset = lineStart;
                assignType = this.tokens.currLineLA(rparenOffset + 1);
            }
        }
        if (identOffset != -1) {
            this.convertToIdents(identOffset, lineEnd);
            if (assignType == 328) {
                this.tokens.addToken(lineStart, 324, "__T_ASSIGNMENT_STMT__");
            } else if (assignType == 450) {
                this.tokens.addToken(lineStart, 444, "__T_PTR_ASSIGNMENT_STMT__");
            }
            if (lineStart > 0 && this.tokens.currLineLA(lineStart) == 331) {
                this.fixupLabeledEndDo(lineStart, lineEnd);
            }
            return true;
        }
        return false;
    }

    private int matchGenericSpec(int lineStart, int lineEnd) {
        int firstToken = this.tokens.currLineLA(lineStart + 1);
        if (firstToken == 340 || firstToken == 458) {
            return lineStart + 1;
        }
        if (firstToken == 373 || firstToken == 298) {
            if (this.tokens.currLineLA(lineStart + 2) != 368) {
                return -1;
            }
            int rparenOffset = this.matchClosingParen(lineStart, lineStart + 2);
            return rparenOffset + 1;
        }
        return lineStart;
    }

    private boolean matchGenericBinding(int lineStart, int lineEnd) {
        if (this.tokens.currLineLA(lineStart + 1) == 307) {
            int colonOffset = this.salesScanForToken(lineStart + 1, 332);
            if (colonOffset == -1) {
                return false;
            }
            int nextToken = this.tokens.currLineLA(colonOffset + 2);
            if (nextToken == 340 || nextToken == 458) {
                this.convertToIdents(colonOffset + 2, lineEnd);
            } else if (nextToken == 373 || nextToken == 298) {
                int nextTokenLA = colonOffset + 2;
                if (this.tokens.currLineLA(nextTokenLA + 1) != 368) {
                    return false;
                }
                int rparenOffset = this.matchClosingParen(lineStart, nextTokenLA + 1);
                this.convertToIdents(rparenOffset + 1, lineEnd);
            }
            return true;
        }
        return false;
    }

    private boolean matchLine(int lineStart, int lineEnd) {
        if (this.matchDataDecl(lineStart, lineEnd)) {
            return true;
        }
        if (this.matchDerivedTypeStmt(lineStart, lineEnd)) {
            return true;
        }
        switch (this.tokens.currLineLA(lineStart + 1)) {
            case 275: 
            case 308: 
            case 350: 
            case 387: {
                return this.matchSub(lineStart, lineEnd);
            }
            case 261: 
            case 285: 
            case 286: 
            case 296: 
            case 304: 
            case 323: 
            case 327: 
            case 342: 
            case 358: 
            case 363: 
            case 386: 
            case 395: 
            case 407: 
            case 435: 
            case 436: 
            case 437: 
            case 451: {
                return this.matchEnd(lineStart, lineEnd);
            }
            case 383: {
                if (this.matchProcStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchProcDeclStmt(lineStart, lineEnd);
            }
            case 372: {
                if (this.matchProcStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchModule(lineStart, lineEnd);
            }
            case 253: 
            case 311: {
                return this.matchBlockData(lineStart, lineEnd);
            }
            case 319: {
                return this.matchUseStmt(lineStart, lineEnd);
            }
            case 362: {
                return this.matchProgramStmt(lineStart, lineEnd);
            }
            case 265: 
            case 268: 
            case 270: 
            case 281: 
            case 295: 
            case 338: 
            case 353: 
            case 364: 
            case 374: 
            case 382: 
            case 447: 
            case 455: 
            case 459: {
                return this.matchActionStmt(lineStart, lineEnd);
            }
            case 292: {
                if (this.matchIfConstStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchOneLineStmt(lineStart, lineEnd);
            }
            case 365: {
                if (this.matchElseStmt(lineStart, lineEnd)) {
                    return true;
                }
                return this.matchSingleTokenStmt(lineStart, lineEnd);
            }
            case 359: {
                return this.matchDoStmt(lineStart, lineEnd);
            }
            case 252: 
            case 273: 
            case 298: 
            case 336: 
            case 354: 
            case 373: 
            case 397: 
            case 414: 
            case 416: {
                return this.matchIOStmt(lineStart, lineEnd);
            }
            case 277: 
            case 284: 
            case 288: 
            case 291: 
            case 294: 
            case 322: 
            case 357: 
            case 361: 
            case 370: 
            case 390: 
            case 404: 
            case 409: 
            case 412: 
            case 421: 
            case 422: 
            case 430: 
            case 434: 
            case 441: 
            case 442: {
                return this.matchAttrStmt(lineStart, lineEnd);
            }
        }
        return this.matchSingleTokenStmt(lineStart, lineEnd);
    }

    private void fixupFixedFormatLine(int lineStart, int lineEnd, boolean startsWithKeyword) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        if (startsWithKeyword) {
            Token token;
            do {
                System.out.println("fixed-format line must start with keyword");
                this.tokens.printPackedList();
                buffer = buffer.append(this.tokens.getToken(lineStart + i).getText());
                TokenStream ts = APTTokenStreamBuilder.buildTokenStream((String)buffer.toString().toUpperCase(), (String)"Fortran Language");
                ts = new APTCommentsFilter(ts);
                ts = APTLanguageSupport.getInstance().getFilter("Fortran Language").getFilteredStream(ts);
                FortranParserEx.MyTokenSource myLexer = new FortranParserEx.MyTokenSource(ts);
                token = myLexer.nextToken();
            } while (lineStart + ++i < lineEnd && !FortranLexer.isKeyword(token.getType()));
            if (lineStart + i == lineEnd) {
                System.err.println("Error: Expected keyword on line: " + token.getLine());
            } else {
                int j = 0;
                for (j = lineStart; j < lineStart + i; ++j) {
                    Token tmpToken = this.tokens.getToken(j);
                    tmpToken.setChannel(99);
                    this.tokens.set(j, tmpToken);
                }
                this.tokens.add(j, token);
            }
        } else {
            System.out.println("fixed-format line must NOT start with keyword");
        }
    }

    private int scanForRealConsts(int lineStart, int lineEnd) {
        for (int i = lineStart; i < lineEnd; ++i) {
            if (this.tokens.currLineLA(i + 1) == 394) {
                this.tokens.getToken(i).setType(392);
                continue;
            }
            if (this.tokens.currLineLA(i + 1) != 331 || i + 2 >= lineEnd || this.tokens.currLineLA(i + 2) != 378 && this.tokens.currLineLA(i + 2) != 394) continue;
            StringBuffer newTokenText = new StringBuffer();
            int line = this.tokens.getToken(i).getLine();
            int col = this.tokens.getToken(i).getCharPositionInLine();
            newTokenText.append(this.tokens.getToken(i).getText());
            newTokenText.append(this.tokens.getToken(i + 1).getText());
            if (this.sourceForm != 2 && col + this.tokens.getToken(i).getText().length() != this.tokens.getToken(i + 1).getCharPositionInLine()) {
                System.err.println("Error: Whitespace within real constant at {line:col}: " + line + ":" + (col + 1));
            }
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.add(i, this.tokens.createToken(392, newTokenText.toString(), line, col));
            --lineEnd;
        }
        return lineEnd;
    }

    private int scanForRelationalOp(int lineStart, int lineEnd) {
        for (int i = lineStart; i < lineEnd; ++i) {
            int type;
            if (i + 2 >= lineEnd) {
                return lineEnd;
            }
            if (this.tokens.currLineLA(i + 1) != 378 || this.tokens.currLineLA(i + 2) != 263 || this.tokens.currLineLA(i + 3) != 378) continue;
            int line = this.tokens.getToken(i).getLine();
            int col = this.tokens.getToken(i).getCharPositionInLine();
            String text = this.tokens.getToken(i + 1).getText();
            if (text.compareToIgnoreCase("EQ") == 0) {
                type = 343;
            } else if (text.compareToIgnoreCase("NE") == 0) {
                type = 389;
            } else if (text.compareToIgnoreCase("GT") == 0) {
                type = 262;
            } else if (text.compareToIgnoreCase("GE") == 0) {
                type = 254;
            } else if (text.compareToIgnoreCase("LT") == 0) {
                type = 448;
            } else {
                if (text.compareToIgnoreCase("LE") != 0) continue;
                type = 453;
            }
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.removeToken(i);
            this.tokens.add(i, this.tokens.createToken(type, "." + text + ".", line, col));
            lineEnd -= 2;
        }
        return lineEnd;
    }

    public void performPrepass() {
        int tokensStart;
        int commaIndex = -1;
        int equalsIndex = -1;
        int lineLength = 0;
        int newLineLength = 0;
        Token eof = null;
        if (this.sourceForm == 2) {
            tokensStart = this.tokens.mark();
            this.tokens.fixupFixedFormat();
            this.tokens.rewind(tokensStart);
        }
        if ((tokensStart = this.tokens.mark()) != -1) {
            this.tokens.seek(-1);
            tokensStart = -1;
        }
        while (this.tokens.LA(1) != -1) {
            commaIndex = -1;
            equalsIndex = -1;
            int lineStart = 0;
            int rawLineStart = this.tokens.mark();
            this.tokens.setCurrLine(rawLineStart);
            lineLength = this.tokens.getCurrLineLength();
            int rawLineEnd = this.tokens.findTokenInSuper(rawLineStart, 269);
            if (rawLineEnd == -1) {
                rawLineEnd = this.tokens.getRawLineLength();
            }
            rawLineEnd += rawLineStart;
            if (this.tokens.currLineLA(1) == 267) {
                ++lineStart;
            }
            if (this.matchLabel(lineStart, lineLength)) {
                ++lineStart;
            }
            if (this.matchIdentColon(lineStart, lineLength)) {
                lineStart += 2;
            }
            if ((newLineLength = this.scanForRealConsts(lineStart, lineLength)) != lineLength) {
                lineLength = newLineLength;
            }
            if (this.sourceForm == 2 && (newLineLength = this.scanForRelationalOp(lineStart, lineLength)) != lineLength) {
                lineLength = newLineLength;
            }
            if ((commaIndex = this.salesScanForToken(lineStart, 405)) != -1) {
                this.matchLine(lineStart, lineLength);
            } else {
                equalsIndex = this.salesScanForToken(lineStart, 328);
                if (equalsIndex == -1) {
                    equalsIndex = this.salesScanForToken(lineStart, 450);
                }
                if (equalsIndex != -1) {
                    if (!(this.matchOneLineStmt(lineStart, lineLength) || this.matchProcStmt(lineStart, lineLength) || this.matchAssignStmt(lineStart, lineLength) || this.matchDataDecl(lineStart, lineLength) || this.matchGenericBinding(lineStart, lineLength))) {
                        System.err.println("Couldn't match line!");
                    }
                } else if (!this.matchLine(lineStart, lineLength)) {
                    this.matchOneLineStmt(lineStart, lineLength);
                }
            }
            for (int i = rawLineStart; i < rawLineEnd; ++i) {
                this.tokens.consume();
            }
            this.tokens.finalizeLine();
        }
        eof = this.tokens.LT(1);
        eof.setText("EOF");
        this.tokens.addTokenToNewList(eof);
        this.tokens.rewind(tokensStart);
    }

    private static class FortranLexer {
        public static final int EOF = -1;
        public static final int NULL_TREE_LOOKAHEAD = 3;
        public static final int ELLIPSIS = 4;
        public static final int DOT = 5;
        public static final int ASSIGNEQUAL = 6;
        public static final int COLON = 7;
        public static final int COMMA = 8;
        public static final int QUESTIONMARK = 9;
        public static final int SEMICOLON = 10;
        public static final int POINTERTO = 11;
        public static final int LPAREN = 12;
        public static final int RPAREN = 13;
        public static final int LSQUARE = 14;
        public static final int RSQUARE = 15;
        public static final int LCURLY = 16;
        public static final int RCURLY = 17;
        public static final int EQUAL = 18;
        public static final int NOTEQUAL = 19;
        public static final int LESSTHANOREQUALTO = 20;
        public static final int LESSTHAN = 21;
        public static final int GREATERTHANOREQUALTO = 22;
        public static final int GREATERTHAN = 23;
        public static final int DIVIDE = 24;
        public static final int DIVIDEEQUAL = 25;
        public static final int PLUS = 26;
        public static final int PLUSEQUAL = 27;
        public static final int PLUSPLUS = 28;
        public static final int MINUS = 29;
        public static final int MINUSEQUAL = 30;
        public static final int MINUSMINUS = 31;
        public static final int STAR = 32;
        public static final int TIMESEQUAL = 33;
        public static final int MOD = 34;
        public static final int MODEQUAL = 35;
        public static final int SHIFTRIGHT = 36;
        public static final int SHIFTRIGHTEQUAL = 37;
        public static final int SHIFTLEFT = 38;
        public static final int SHIFTLEFTEQUAL = 39;
        public static final int AND = 40;
        public static final int NOT = 41;
        public static final int OR = 42;
        public static final int AMPERSAND = 43;
        public static final int BITWISEANDEQUAL = 44;
        public static final int TILDE = 45;
        public static final int BITWISEOR = 46;
        public static final int BITWISEOREQUAL = 47;
        public static final int BITWISEXOR = 48;
        public static final int BITWISEXOREQUAL = 49;
        public static final int POINTERTOMBR = 50;
        public static final int DOTMBR = 51;
        public static final int SCOPE = 52;
        public static final int AT = 53;
        public static final int DOLLAR = 54;
        public static final int BACK_SLASH = 55;
        public static final int DEFINED = 56;
        public static final int DBL_SHARP = 57;
        public static final int SHARP = 58;
        public static final int FUN_LIKE_MACRO_LPAREN = 59;
        public static final int LAST_CONST_TEXT_TOKEN = 62;
        public static final int FLOATONE = 63;
        public static final int FLOATTWO = 64;
        public static final int HEXADECIMALINT = 65;
        public static final int OCTALINT = 66;
        public static final int DECIMALINT = 67;
        public static final int Whitespace = 68;
        public static final int EndOfLine = 69;
        public static final int Skip = 70;
        public static final int PreProcComment = 71;
        public static final int PPLiterals = 72;
        public static final int Space = 73;
        public static final int PreProcBlockComment = 74;
        public static final int PreProcLineComment = 75;
        public static final int Comment = 76;
        public static final int CPPComment = 77;
        public static final int CHAR_LITERAL = 78;
        public static final int STRING_LITERAL = 79;
        public static final int InterStringWhitespace = 80;
        public static final int StringPart = 81;
        public static final int Escape = 82;
        public static final int Digit = 83;
        public static final int Decimal = 84;
        public static final int LongSuffix = 85;
        public static final int UnsignedSuffix = 86;
        public static final int FloatSuffix = 87;
        public static final int Exponent = 88;
        public static final int Vocabulary = 89;
        public static final int NUMBER = 90;
        public static final int IDENT = 91;
        public static final int BINARYINT = 92;
        public static final int INCLUDE_STRING = 93;
        public static final int SYS_INCLUDE_STRING = 94;
        public static final int END_PREPROC_DIRECTIVE = 61;
        public static final int INCLUDE = 95;
        public static final int INCLUDE_NEXT = 96;
        public static final int DEFINE = 97;
        public static final int UNDEF = 98;
        public static final int IFDEF = 99;
        public static final int IFNDEF = 100;
        public static final int IF = 101;
        public static final int ELIF = 102;
        public static final int ELSE = 103;
        public static final int ENDIF = 104;
        public static final int PRAGMA = 105;
        public static final int LINE = 106;
        public static final int ERROR = 107;
        public static final int PREPROC_DIRECTIVE = 108;
        public static final int LITERAL_OPERATOR = 110;
        public static final int LITERAL_alignof = 111;
        public static final int LITERAL___alignof__ = 112;
        public static final int LITERAL_typeof = 113;
        public static final int LITERAL___typeof__ = 114;
        public static final int LITERAL___typeof = 115;
        public static final int LITERAL_template = 116;
        public static final int LITERAL_typedef = 117;
        public static final int LITERAL_enum = 118;
        public static final int LITERAL_namespace = 119;
        public static final int LITERAL_extern = 120;
        public static final int LITERAL_inline = 121;
        public static final int LITERAL__inline = 122;
        public static final int LITERAL___inline__ = 123;
        public static final int LITERAL___inline = 124;
        public static final int LITERAL_virtual = 125;
        public static final int LITERAL_explicit = 126;
        public static final int LITERAL_friend = 127;
        public static final int LITERAL__stdcall = 128;
        public static final int LITERAL___stdcall = 129;
        public static final int LITERAL_typename = 130;
        public static final int LITERAL_auto = 131;
        public static final int LITERAL_register = 132;
        public static final int LITERAL_static = 133;
        public static final int LITERAL_mutable = 134;
        public static final int LITERAL_const = 135;
        public static final int LITERAL___const__ = 136;
        public static final int LITERAL___const = 137;
        public static final int LITERAL_const_cast = 138;
        public static final int LITERAL_volatile = 139;
        public static final int LITERAL___volatile__ = 140;
        public static final int LITERAL___volatile = 141;
        public static final int LITERAL_char = 142;
        public static final int LITERAL_wchar_t = 143;
        public static final int LITERAL_bool = 144;
        public static final int LITERAL_short = 145;
        public static final int LITERAL_int = 146;
        public static final int LITERAL_long = 147;
        public static final int LITERAL_signed = 148;
        public static final int LITERAL___signed__ = 149;
        public static final int LITERAL___signed = 150;
        public static final int LITERAL_unsigned = 151;
        public static final int LITERAL___unsigned__ = 152;
        public static final int LITERAL_float = 153;
        public static final int LITERAL_double = 154;
        public static final int LITERAL_void = 155;
        public static final int LITERAL__declspec = 156;
        public static final int LITERAL___declspec = 157;
        public static final int LITERAL_class = 158;
        public static final int LITERAL_struct = 159;
        public static final int LITERAL_union = 160;
        public static final int LITERAL_this = 161;
        public static final int LITERAL_true = 162;
        public static final int LITERAL_false = 163;
        public static final int LITERAL_public = 164;
        public static final int LITERAL_protected = 165;
        public static final int LITERAL_private = 166;
        public static final int LITERAL_throw = 167;
        public static final int LITERAL_case = 168;
        public static final int LITERAL_default = 169;
        public static final int LITERAL_if = 170;
        public static final int LITERAL_else = 171;
        public static final int LITERAL_switch = 172;
        public static final int LITERAL_while = 173;
        public static final int LITERAL_do = 174;
        public static final int LITERAL_for = 175;
        public static final int LITERAL_goto = 176;
        public static final int LITERAL_continue = 177;
        public static final int LITERAL_break = 178;
        public static final int LITERAL_return = 179;
        public static final int LITERAL_try = 180;
        public static final int LITERAL_catch = 181;
        public static final int LITERAL_using = 182;
        public static final int LITERAL_export = 183;
        public static final int LITERAL_asm = 184;
        public static final int LITERAL__asm = 185;
        public static final int LITERAL___asm__ = 186;
        public static final int LITERAL___asm = 187;
        public static final int LITERAL_sizeof = 189;
        public static final int LITERAL_dynamic_cast = 190;
        public static final int LITERAL_static_cast = 191;
        public static final int LITERAL_reinterpret_cast = 192;
        public static final int LITERAL_new = 193;
        public static final int LITERAL__cdecl = 194;
        public static final int LITERAL___cdecl = 195;
        public static final int LITERAL__near = 196;
        public static final int LITERAL___near = 197;
        public static final int LITERAL__far = 198;
        public static final int LITERAL___far = 199;
        public static final int LITERAL___interrupt = 200;
        public static final int LITERAL_pascal = 201;
        public static final int LITERAL__pascal = 202;
        public static final int LITERAL___pascal = 203;
        public static final int LITERAL_delete = 204;
        public static final int LITERAL__int64 = 205;
        public static final int LITERAL___int64 = 206;
        public static final int LITERAL___w64 = 207;
        public static final int LITERAL___extension__ = 208;
        public static final int LITERAL___attribute__ = 209;
        public static final int LITERAL_restrict = 210;
        public static final int LITERAL___restrict = 211;
        public static final int LITERAL___complex__ = 212;
        public static final int LITERAL___imag = 213;
        public static final int LITERAL___real = 214;
        public static final int LITERAL___global = 215;
        public static final int LITERAL__Complex = 216;
        public static final int LITERAL___thread = 217;
        public static final int LITERAL___attribute = 218;
        public static final int LITERAL__Imaginary = 219;
        public static final int T_CLOSE = 252;
        public static final int T_BLOCK = 253;
        public static final int T_GE = 254;
        public static final int T_CONTAINS = 255;
        public static final int T_ABSTRACT = 256;
        public static final int T_CLASS = 257;
        public static final int T_NOPASS = 258;
        public static final int T_UNFORMATTED = 259;
        public static final int T_LESSTHAN = 260;
        public static final int T_ENDSUBROUTINE = 261;
        public static final int T_GT = 262;
        public static final int T_IDENT = 263;
        public static final int T_INTERFACE = 264;
        public static final int T_RETURN = 265;
        public static final int T_XYZ = 266;
        public static final int T_EOF = 267;
        public static final int T_CALL = 268;
        public static final int T_EOS = 269;
        public static final int T_GO = 270;
        public static final int T_AND = 271;
        public static final int T_PERCENT = 272;
        public static final int T_PRINT = 273;
        public static final int T_ALLOCATE_STMT_1 = 274;
        public static final int T_SUBROUTINE = 275;
        public static final int T_CONTROL_EDIT_DESC = 276;
        public static final int T_ENUMERATOR = 277;
        public static final int Alphanumeric_Character = 278;
        public static final int T_DEFINED_OP = 279;
        public static final int T_KIND = 280;
        public static final int T_STOP = 281;
        public static final int T_GREATERTHAN_EQ = 282;
        public static final int T_CHAR_STRING_EDIT_DESC = 283;
        public static final int T_ALLOCATABLE = 284;
        public static final int T_ENDINTERFACE = 285;
        public static final int T_END = 286;
        public static final int T_ASTERISK = 287;
        public static final int T_PRIVATE = 288;
        public static final int T_DOUBLEPRECISION = 289;
        public static final int T_CASE = 290;
        public static final int T_IMPLICIT = 291;
        public static final int T_IF = 292;
        public static final int T_THEN = 293;
        public static final int T_DIMENSION = 294;
        public static final int T_GOTO = 295;
        public static final int T_ENDMODULE = 296;
        public static final int T_IN = 297;
        public static final int T_WRITE = 298;
        public static final int T_FORMATTED = 299;
        public static final int WS = 300;
        public static final int T_DATA = 301;
        public static final int T_FALSE = 302;
        public static final int T_WHERE = 303;
        public static final int T_ENDIF = 304;
        public static final int T_SLASH = 305;
        public static final int SQ_Rep_Char = 306;
        public static final int T_GENERIC = 307;
        public static final int T_RECURSIVE = 308;
        public static final int DQ_Rep_Char = 309;
        public static final int T_ELSEIF = 310;
        public static final int T_BLOCKDATA = 311;
        public static final int OCTAL_CONSTANT = 312;
        public static final int T_SELECTTYPE = 313;
        public static final int T_MINUS = 314;
        public static final int T_SELECT = 315;
        public static final int T_FINAL = 316;
        public static final int T_UNDERSCORE = 317;
        public static final int T_IMPORT = 318;
        public static final int T_USE = 319;
        public static final int T_FILE = 320;
        public static final int T_RPAREN = 321;
        public static final int T_INTENT = 322;
        public static final int T_ENDBLOCK = 323;
        public static final int T_ASSIGNMENT_STMT = 324;
        public static final int T_PAUSE = 325;
        public static final int T_BACKSPACE = 326;
        public static final int T_ENDFILE = 327;
        public static final int T_EQUALS = 328;
        public static final int T_NON_INTRINSIC = 329;
        public static final int T_SELECTCASE = 330;
        public static final int T_DIGIT_STRING = 331;
        public static final int T_COLON_COLON = 332;
        public static final int T_NON_OVERRIDABLE = 333;
        public static final int Special_Character = 334;
        public static final int T_INCLUDE = 335;
        public static final int T_OPEN = 336;
        public static final int T_POWER = 337;
        public static final int T_ASSOCIATE = 338;
        public static final int T_CHAR_CONSTANT = 339;
        public static final int T_OPERATOR = 340;
        public static final int T_TO = 341;
        public static final int T_ENDASSOCIATE = 342;
        public static final int T_EQ = 343;
        public static final int T_GREATERTHAN = 344;
        public static final int T_DATA_EDIT_DESC = 345;
        public static final int T_INQUIRE_STMT_2 = 346;
        public static final int T_EQV = 347;
        public static final int HEX_CONSTANT = 348;
        public static final int Digit_String = 349;
        public static final int T_ELEMENTAL = 350;
        public static final int T_CHARACTER = 351;
        public static final int PREPROCESS_LINE = 352;
        public static final int T_NULLIFY = 353;
        public static final int T_REWIND = 354;
        public static final int T_ARITHMETIC_IF_STMT = 355;
        public static final int T_FORALL_CONSTRUCT_STMT = 356;
        public static final int T_BIND = 357;
        public static final int T_ENDFORALL = 358;
        public static final int T_DO = 359;
        public static final int T_WHERE_STMT = 360;
        public static final int T_POINTER = 361;
        public static final int T_PROGRAM = 362;
        public static final int T_ENDTYPE = 363;
        public static final int T_WAIT = 364;
        public static final int T_ELSE = 365;
        public static final int T_IF_STMT = 366;
        public static final int T_RBRACKET = 367;
        public static final int T_LPAREN = 368;
        public static final int T_EXTENDS = 369;
        public static final int T_OPTIONAL = 370;
        public static final int T_DOUBLE = 371;
        public static final int T_MODULE = 372;
        public static final int T_READ = 373;
        public static final int T_ALLOCATE = 374;
        public static final int T_INTEGER = 375;
        public static final int T_OR = 376;
        public static final int T_EQUIVALENCE = 377;
        public static final int T_PERIOD = 378;
        public static final int T_ENTRY = 379;
        public static final int T_LABEL_DO_TERMINAL = 380;
        public static final int T_REAL = 381;
        public static final int T_CYCLE = 382;
        public static final int T_PROCEDURE = 383;
        public static final int T_EQ_EQ = 384;
        public static final int T_SLASH_EQ = 385;
        public static final int T_ENDSELECT = 386;
        public static final int T_PURE = 387;
        public static final int T_TRUE = 388;
        public static final int T_NE = 389;
        public static final int T_INTRINSIC = 390;
        public static final int T_PASS = 391;
        public static final int T_REAL_CONSTANT = 392;
        public static final int LINE_COMMENT = 393;
        public static final int T_PERIOD_EXPONENT = 394;
        public static final int T_ENDWHERE = 395;
        public static final int MISC_CHAR = 396;
        public static final int T_FORMAT = 397;
        public static final int T_DEFAULT = 398;
        public static final int T_SLASH_SLASH = 399;
        public static final int T_NONE = 400;
        public static final int T_NAMELIST = 401;
        public static final int T_SEQUENCE = 402;
        public static final int T_PRECISION = 403;
        public static final int T_ASYNCHRONOUS = 404;
        public static final int T_COMMA = 405;
        public static final int T_RESULT = 406;
        public static final int T_ENDBLOCKDATA = 407;
        public static final int T_LOGICAL = 408;
        public static final int T_VALUE = 409;
        public static final int Letter = 410;
        public static final int T_FORALL = 411;
        public static final int T_SAVE = 412;
        public static final int T_HOLLERITH = 413;
        public static final int T_FLUSH = 414;
        public static final int T_WHILE = 415;
        public static final int T_INQUIRE = 416;
        public static final int T_DEFERRED = 417;
        public static final int T_FORALL_STMT = 418;
        public static final int T_ASSIGN = 419;
        public static final int T_LBRACKET = 420;
        public static final int T_EXTERNAL = 421;
        public static final int T_VOLATILE = 422;
        public static final int T_OUT = 423;
        public static final int CONTINUE_CHAR = 424;
        public static final int T_COLON = 425;
        public static final int T_COMPLEX = 426;
        public static final int T_PLUS = 427;
        public static final int T_STMT_FUNCTION = 428;
        public static final int T_ONLY = 429;
        public static final int T_PROTECTED = 430;
        public static final int T_COMMON = 431;
        public static final int T_INOUT = 432;
        public static final int T_NEQV = 433;
        public static final int T_PUBLIC = 434;
        public static final int T_ENDDO = 435;
        public static final int T_ENDPROGRAM = 436;
        public static final int T_ENDFUNCTION = 437;
        public static final int T_WHERE_CONSTRUCT_STMT = 438;
        public static final int T_ELSEWHERE = 439;
        public static final int T_ENUM = 440;
        public static final int T_PARAMETER = 441;
        public static final int T_TARGET = 442;
        public static final int T_DOUBLECOMPLEX = 443;
        public static final int T_PTR_ASSIGNMENT_STMT = 444;
        public static final int T_TYPE = 445;
        public static final int T_LESSTHAN_EQ = 446;
        public static final int T_DEALLOCATE = 447;
        public static final int T_LT = 448;
        public static final int T_FUNCTION = 449;
        public static final int T_EQ_GT = 450;
        public static final int T_ENDENUM = 451;
        public static final int BINARY_CONSTANT = 452;
        public static final int T_LE = 453;
        public static final int T_LEN = 454;
        public static final int T_CONTINUE = 455;
        public static final int T_NOT = 456;
        public static final int Rep_Char = 457;
        public static final int T_ASSIGNMENT = 458;
        public static final int T_EXIT = 459;
        public static final int FORTRAN_COMMENT = 460;
        public static final int FIRST_ASSIGN = 461;
        public static final int FIRST_DIVIDE = 462;
        public static final int FIRST_STAR = 463;
        public static final int FIRST_MOD = 464;
        public static final int FIRST_NOT = 465;
        public static final int FIRST_AMPERSAND = 466;
        public static final int COMMENT = 467;
        public static final int CPP_COMMENT = 468;
        public static final int FIRST_OR = 469;
        public static final int FIRST_BITWISEXOR = 470;
        public static final int FIRST_COLON = 471;
        public static final int FIRST_LESS = 472;
        public static final int FIRST_GREATER = 473;
        public static final int FIRST_MINUS = 474;
        public static final int FIRST_PLUS = 475;
        public static final int FIRST_QUOTATION = 476;
        public static final int H_char_sequence = 477;
        public static final int Q_char_sequence = 478;
        public static final int DirectiveBody = 479;
        public static final int CHAR_LITERAL_BODY = 480;
        public static final int STRING_LITERAL_BODY = 481;
        public static final int ID_LIKE = 485;
        public static final int ID_DEFINED = 486;
        public static final int Identifier = 487;
        public static final int PostPPKwdChar = 488;
        public static final int PostInclChar = 489;
        public static final int PostIfChar = 490;
        public static final int LAST_LEXER_FAKE_RULE = 491;

        private FortranLexer() {
        }

        public static boolean isKeyword(Token tmpToken) {
            return FortranLexer.isKeyword(tmpToken.getType());
        }

        public static boolean isKeyword(int tokenType) {
            switch (tokenType) {
                case 252: 
                case 253: 
                case 255: 
                case 256: 
                case 257: 
                case 258: 
                case 259: 
                case 261: 
                case 264: 
                case 265: 
                case 268: 
                case 270: 
                case 273: 
                case 275: 
                case 277: 
                case 280: 
                case 281: 
                case 284: 
                case 285: 
                case 286: 
                case 288: 
                case 289: 
                case 290: 
                case 291: 
                case 292: 
                case 293: 
                case 294: 
                case 295: 
                case 296: 
                case 297: 
                case 298: 
                case 299: 
                case 301: 
                case 303: 
                case 304: 
                case 307: 
                case 308: 
                case 310: 
                case 311: 
                case 313: 
                case 315: 
                case 316: 
                case 318: 
                case 319: 
                case 320: 
                case 322: 
                case 323: 
                case 325: 
                case 326: 
                case 327: 
                case 329: 
                case 330: 
                case 333: 
                case 336: 
                case 338: 
                case 340: 
                case 341: 
                case 342: 
                case 350: 
                case 351: 
                case 353: 
                case 354: 
                case 358: 
                case 359: 
                case 361: 
                case 362: 
                case 363: 
                case 364: 
                case 365: 
                case 369: 
                case 370: 
                case 371: 
                case 372: 
                case 373: 
                case 374: 
                case 375: 
                case 377: 
                case 379: 
                case 381: 
                case 382: 
                case 383: 
                case 386: 
                case 387: 
                case 390: 
                case 391: 
                case 395: 
                case 397: 
                case 398: 
                case 400: 
                case 401: 
                case 402: 
                case 403: 
                case 404: 
                case 406: 
                case 407: 
                case 408: 
                case 409: 
                case 411: 
                case 412: 
                case 414: 
                case 415: 
                case 416: 
                case 417: 
                case 419: 
                case 421: 
                case 422: 
                case 423: 
                case 426: 
                case 429: 
                case 430: 
                case 431: 
                case 432: 
                case 434: 
                case 435: 
                case 436: 
                case 437: 
                case 439: 
                case 440: 
                case 441: 
                case 442: 
                case 443: 
                case 445: 
                case 447: 
                case 449: 
                case 451: 
                case 454: 
                case 455: 
                case 458: 
                case 459: {
                    return true;
                }
            }
            return false;
        }
    }
}

