/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.fsm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModule;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class ModuleImpl
extends OffsetableDeclarationBase<CsmNamespaceDefinition>
implements CsmModule,
CsmNamespaceDefinition,
MutableDeclarationsContainer,
Disposable {
    private final List<CsmUID<CsmOffsetableDeclaration>> declarations;
    private final CharSequence name;

    private ModuleImpl(CsmFile file, int startOffset, int endOffset, String name) {
        super(file, startOffset, endOffset);
        this.declarations = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        this.name = NameCache.getManager().getString((CharSequence)name);
    }

    public static ModuleImpl create(CsmFile file, int startOffset, int endOffset, String name) {
        ModuleImpl moduleImpl = new ModuleImpl(file, startOffset, endOffset, name);
        ModuleImpl.postObjectCreateRegistration(true, moduleImpl);
        return moduleImpl;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.NAMESPACE_DEFINITION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        Collection<CsmOffsetableDeclaration> decls;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            decls = UIDCsmConverter.UIDsToDeclarations(this.declarations);
        }
        return decls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmSelect.CsmFilter filter) {
        Iterator<CsmOffsetableDeclaration> out;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            out = UIDCsmConverter.UIDsToDeclarationsFiltered(this.declarations, filter);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int start, int end, CharSequence name) {
        CsmUID out = null;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            out = UIDUtilities.findExistingUIDInList(this.declarations, start, end, name);
        }
        return (CsmOffsetableDeclaration)UIDCsmConverter.UIDtoDeclaration(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int start, CharSequence name, CsmDeclaration.Kind kind) {
        CsmUID out = null;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            out = UIDUtilities.findExistingUIDInList(this.declarations, start, name, kind);
        }
        return (CsmOffsetableDeclaration)UIDCsmConverter.UIDtoDeclaration(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDeclaration(CsmOffsetableDeclaration decl) {
        FunctionImpl f;
        CsmUID<CsmOffsetableDeclaration> uid = RepositoryUtils.put(decl);
        assert (uid != null);
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            UIDUtilities.insertIntoSortedUIDList(uid, this.declarations);
        }
        if (decl instanceof FunctionImpl && !NamespaceImpl.isNamespaceScope(f = (FunctionImpl)decl)) {
            f.setScope((CsmScope)this);
        }
        RepositoryUtils.put(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDeclaration(CsmOffsetableDeclaration declaration) {
        CsmUID<CsmOffsetableDeclaration> uid = UIDCsmConverter.declarationToUID(declaration);
        assert (uid != null);
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            this.declarations.remove(uid);
        }
        RepositoryUtils.remove(uid, (CsmObject)declaration);
        RepositoryUtils.put(this);
    }

    public CsmNamespace getNamespace() {
        return null;
    }

    public CharSequence getQualifiedName() {
        return this.name;
    }

    public CharSequence getName() {
        return this.name;
    }

    public CsmScope getScope() {
        return this.getContainingFile();
    }

    public Collection<CsmScopeElement> getScopeElements() {
        ArrayList<CsmScopeElement> l = new ArrayList<CsmScopeElement>();
        for (CsmDeclaration csmDeclaration : this.getDeclarations()) {
            if (!this.isOfMyScope(csmDeclaration)) continue;
            l.add((CsmScopeElement)csmDeclaration);
        }
        return l;
    }

    private boolean isOfMyScope(CsmDeclaration decl) {
        if (decl instanceof VariableImpl) {
            return !NamespaceImpl.isNamespaceScope((VariableImpl)decl, false);
        }
        if (decl instanceof FunctionImpl) {
            return !NamespaceImpl.isNamespaceScope((FunctionImpl)decl);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> uids;
        Collection<CsmOffsetableDeclaration> decls;
        super.dispose();
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            decls = this.getDeclarations();
            uids = new ArrayList<CsmUID<CsmOffsetableDeclaration>>(this.declarations);
            this.declarations.clear();
        }
        Utils.disposeAll(decls);
        RepositoryUtils.remove(uids);
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        factory.writeUIDCollection(this.declarations, output, true);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        if (this.getName().length() == 0) {
            this.writeUID(output);
        }
    }

    public ModuleImpl(RepositoryDataInput input) throws IOException {
        super(input);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        int collSize = input.readInt();
        this.declarations = collSize < 0 ? new ArrayList<CsmUID<CsmOffsetableDeclaration>>() : new ArrayList<CsmUID<CsmOffsetableDeclaration>>(collSize);
        factory.readUIDCollection(this.declarations, input, collSize);
        this.name = PersistentUtils.readUTF(input, NameCache.getManager());
        assert (this.name != null);
        if (this.getName().length() == 0) {
            this.readUID(input);
        }
    }
}

