/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.services.CsmClassifierResolver;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmUsingResolver;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardEnum;
import org.netbeans.modules.cnd.modelimpl.csm.InheritanceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Context;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.impl.services.BaseUtilitiesProviderImpl;
import org.netbeans.modules.cnd.modelutil.AntiLoop;
import org.openide.util.CharSequences;

public final class Resolver3
implements Resolver {
    private final ProjectBase project;
    private final CsmFile file;
    private final CsmFile startFile;
    private final int origOffset;
    private Resolver parentResolver;
    private final Map<CharSequence, CsmObject> usedNamespaces = new LinkedHashMap<CharSequence, CsmObject>();
    private final Map<CharSequence, CsmNamespace> namespaceAliases = new HashMap<CharSequence, CsmNamespace>();
    private final Map<CharSequence, CsmDeclaration> usingDeclarations = new HashMap<CharSequence, CsmDeclaration>();
    private final Map<CharSequence, CsmClassifier> currUsedClassifiers = new HashMap<CharSequence, CsmClassifier>();
    private CsmClassifier currLocalClassifier;
    private boolean currDone = false;
    private CharSequence[] names;
    private int currNamIdx;
    private int interestedKind;
    private boolean resolveInBaseClass;
    private final boolean SUPRESS_RECURSION_EXCEPTION = Boolean.getBoolean("cnd.modelimpl.resolver3.hide.exception");
    private final Context context;
    private Set<CsmFile> visitedFiles = new HashSet<CsmFile>();
    private static final CsmSelect.CsmFilter NO_FILTER = CsmSelect.getFilterBuilder().createOffsetFilter(0, Integer.MAX_VALUE);
    private static final CsmSelect.CsmFilter NAMESPACE_FILTER = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION, CsmDeclaration.Kind.NAMESPACE_ALIAS, CsmDeclaration.Kind.USING_DECLARATION, CsmDeclaration.Kind.USING_DIRECTIVE});
    private static final CsmSelect.CsmFilter CLASS_FILTER = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION, CsmDeclaration.Kind.NAMESPACE_ALIAS, CsmDeclaration.Kind.USING_DECLARATION, CsmDeclaration.Kind.USING_DIRECTIVE, CsmDeclaration.Kind.TYPEDEF, CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.UNION});

    private CharSequence currName() {
        return this.names != null && this.currNamIdx < this.names.length ? this.names[this.currNamIdx] : CharSequences.empty();
    }

    Resolver3(CsmFile file, int offset, Resolver parent, CsmFile startFile) {
        this.file = file;
        this.origOffset = offset;
        this.parentResolver = parent;
        this.project = (ProjectBase)file.getProject();
        this.startFile = startFile;
        this.context = new Context(file, this.origOffset, this);
    }

    private Resolver3(CsmFile file, int offset, Resolver parent) {
        this(file, offset, parent, parent == null ? file : parent.getStartFile());
    }

    private CsmClassifier findClassifier(CsmNamespace ns, CharSequence qualifiedNamePart) {
        CsmClassifier result = null;
        while (ns != null && result == null) {
            String fqn = ns.getQualifiedName() + "::" + qualifiedNamePart;
            result = this.findClassifierUsedInFile(fqn);
            ns = ns.getParent();
        }
        return result;
    }

    private CsmClassifier findClassifierUsedInFile(CharSequence qualifiedName) {
        CsmClassifier result = null;
        CharSequence id = CharSequences.create((CharSequence)qualifiedName);
        CsmClassifier globalResult = CsmClassifierResolver.getDefault().findClassifierUsedInFile(id, this.getStartFile(), this.needClasses());
        if (!this.currDone) {
            this.currLocalClassifier = null;
            this.gatherMaps(this.file, false, this.origOffset);
            this.currDone = true;
        }
        if (this.currLocalClassifier != null && this.needClassifiers()) {
            result = this.currLocalClassifier;
        }
        if (result == null) {
            if (this.currUsedClassifiers.containsKey(id)) {
                result = this.currUsedClassifiers.get(id);
            } else {
                result = globalResult;
                this.currUsedClassifiers.put(id, result);
            }
        }
        return result;
    }

    @Override
    public CsmFile getStartFile() {
        return this.startFile;
    }

    private CsmNamespace findNamespace(CsmNamespace ns, CharSequence qualifiedNamePart) {
        CsmNamespace result = null;
        if (ns == null) {
            result = this.findNamespace(qualifiedNamePart);
        } else {
            for (CsmNamespace containingNs = ns; containingNs != null && result == null; containingNs = containingNs.getParent()) {
                String fqn = (containingNs.isGlobal() ? "" : containingNs.getQualifiedName() + "::") + qualifiedNamePart;
                result = this.findNamespace(fqn);
            }
        }
        return result;
    }

    private CsmNamespace findNamespace(CharSequence qualifiedName) {
        CsmNamespace result = this.project.findNamespace(qualifiedName);
        if (result == null) {
            Iterator<CsmProject> iter = this.getLibraries().iterator();
            while (iter.hasNext() && result == null) {
                CsmProject lib = iter.next();
                result = lib.findNamespace(qualifiedName);
            }
        }
        return result;
    }

    @Override
    public Collection<CsmProject> getLibraries() {
        return Resolver3.getSearchLibraries(this.startFile.getProject());
    }

    public static Collection<CsmProject> getSearchLibraries(CsmProject prj) {
        if (prj.isArtificial() && prj instanceof ProjectBase) {
            HashSet<CsmProject> libs = new HashSet<CsmProject>();
            for (ProjectBase projectBase : ((ProjectBase)prj).getDependentProjects()) {
                if (projectBase.isArtificial()) continue;
                libs.addAll(projectBase.getLibraries());
            }
            return libs;
        }
        return prj.getLibraries();
    }

    @Override
    public CsmClassifier getOriginalClassifier(CsmClassifier orig) {
        if (this.isRecursionOnResolving(200)) {
            return null;
        }
        AntiLoop set = new AntiLoop(100);
        while (true) {
            CsmClass resovedClassifier;
            CsmClassForwardDeclaration fd;
            set.add(orig);
            if (CsmKindUtilities.isClassForwardDeclaration((CsmObject)orig)) {
                fd = (CsmClassForwardDeclaration)orig;
                resovedClassifier = fd.getCsmClass();
                if (resovedClassifier == null) {
                    break;
                }
            } else if (CsmKindUtilities.isEnumForwardDeclaration((CsmObject)orig)) {
                fd = (CsmEnumForwardDeclaration)orig;
                resovedClassifier = fd.getCsmEnum();
                if (resovedClassifier == null) {
                    break;
                }
            } else if (CsmKindUtilities.isTypedef((CsmObject)orig)) {
                CsmType t = ((CsmTypedef)orig).getType();
                resovedClassifier = t.getClassifier();
                if (resovedClassifier == null) {
                    break;
                }
            } else {
                if (!ForwardClass.isForwardClass((CsmObject)orig) && !ForwardEnum.isForwardEnum((CsmObject)orig)) break;
                resovedClassifier = this.findClassifierUsedInFile(orig.getQualifiedName());
            }
            if (set.contains((CsmClassifier)resovedClassifier) && ((resovedClassifier = this.findOtherClassifier(orig)) == null || set.contains((CsmClassifier)resovedClassifier))) break;
            orig = resovedClassifier;
        }
        return orig;
    }

    private CsmClassifier findOtherClassifier(CsmClassifier out) {
        CsmClassifier cls;
        block1: {
            CsmOffsetableDeclaration decl;
            CsmNamespace ns = BaseUtilitiesProviderImpl.getImpl()._getClassNamespace(out);
            cls = null;
            if (ns == null) break block1;
            CsmUID uid = UIDs.get((Object)out);
            CharSequence fqn = out.getQualifiedName();
            Collection<CsmOffsetableDeclaration> col = ns instanceof NamespaceImpl ? ((NamespaceImpl)ns).getDeclarationsRange(fqn, new CsmDeclaration.Kind[]{CsmDeclaration.Kind.CLASS, CsmDeclaration.Kind.UNION, CsmDeclaration.Kind.STRUCT, CsmDeclaration.Kind.ENUM, CsmDeclaration.Kind.TYPEDEF, CsmDeclaration.Kind.TEMPLATE_DECLARATION, CsmDeclaration.Kind.TEMPLATE_SPECIALIZATION, CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION, CsmDeclaration.Kind.ENUM_FORWARD_DECLARATION}) : ns.getDeclarations();
            Iterator i$ = col.iterator();
            while (i$.hasNext() && (!CsmKindUtilities.isClassifier((CsmObject)(decl = (CsmOffsetableDeclaration)i$.next())) || !decl.getQualifiedName().equals(fqn) || UIDs.get((Object)decl).equals(uid) || ForwardClass.isForwardClass((CsmObject)(cls = (CsmClassifier)decl)))) {
            }
        }
        return cls;
    }

    @Override
    public boolean isRecursionOnResolving(int maxRecursion) {
        Resolver3 parent = (Resolver3)this.parentResolver;
        int count = 0;
        while (parent != null) {
            if (parent.origOffset == this.origOffset && parent.file.equals(this.file)) {
                return true;
            }
            parent = (Resolver3)parent.parentResolver;
            if (++count <= maxRecursion) continue;
            return true;
        }
        return false;
    }

    private CsmObject resolveInUsings(CsmNamespace containingNS, CharSequence nameToken) {
        if (this.isRecursionOnResolving(200)) {
            return null;
        }
        CsmClassifier result = null;
        for (CsmUsingDirective udir : CsmUsingResolver.getDefault().findUsingDirectives(containingNS)) {
            String fqn = udir.getName() + "::" + nameToken;
            if (fqn.startsWith("::")) {
                fqn = fqn.substring(2);
            }
            if ((result = this.findClassifierUsedInFile(fqn)) == null) continue;
            break;
        }
        if (result == null) {
            CsmUsingResolver ur = CsmUsingResolver.getDefault();
            Collection decls = ur.findUsedDeclarations(containingNS);
            for (CsmDeclaration decl : decls) {
                if (CharSequences.comparator().compare(nameToken, decl.getName()) != 0) continue;
                if (CsmKindUtilities.isClassifier((CsmObject)decl) && this.needClassifiers()) {
                    result = decl;
                    break;
                }
                if (!CsmKindUtilities.isClass((CsmObject)decl) || !this.needClasses()) continue;
                result = decl;
                break;
            }
        }
        return result;
    }

    void traceRecursion() {
        System.out.println("Detected recursion in resolver:");
        System.out.println("\t" + this);
        Resolver3 parent = (Resolver3)this.parentResolver;
        while (parent != null) {
            System.out.println("\t" + parent);
            parent = (Resolver3)parent.parentResolver;
        }
        new Exception().printStackTrace(System.err);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.file.getAbsolutePath()).append(":").append(this.origOffset);
        buf.append(":Looking for ");
        if (this.needClassifiers()) {
            if (this.needClasses()) {
                buf.append("c");
            } else {
                buf.append("C");
            }
        }
        if (this.needNamespaces()) {
            buf.append("N");
        }
        buf.append(":").append(this.currName());
        for (int i = 0; i < this.names.length; ++i) {
            if (i == 0) {
                buf.append("?");
            } else {
                buf.append("::");
            }
            buf.append(this.names[i]);
        }
        if (this.context.getContainingClass() != null) {
            buf.append(":Class=").append(this.context.getContainingClass().getName());
        }
        if (this.context.getContainingNamespace() != null) {
            buf.append(":NS=").append(this.context.getContainingNamespace().getName());
        }
        return buf.toString();
    }

    private void gatherMaps(CsmFile file, boolean visitIncludedFiles, int offset) {
        if (file == null || this.visitedFiles.contains(file)) {
            return;
        }
        this.visitedFiles.add(file);
        CsmSelect.CsmFilter filter = offset == Integer.MAX_VALUE ? NO_FILTER : CsmSelect.getFilterBuilder().createOffsetFilter(0, offset);
        if (visitIncludedFiles) {
            Iterator iter = CsmSelect.getIncludes((CsmFile)file, (CsmSelect.CsmFilter)filter);
            while (iter.hasNext()) {
                CsmInclude inc = (CsmInclude)iter.next();
                CsmFile incFile = inc.getIncludeFile();
                if (incFile == null) continue;
                this.gatherMaps(incFile, true, Integer.MAX_VALUE);
            }
        }
        if (offset == Integer.MAX_VALUE) {
            filter = this.needClassifiers() ? CLASS_FILTER : NAMESPACE_FILTER;
        }
        Iterator declarations = CsmSelect.getDeclarations((CsmFile)file, (CsmSelect.CsmFilter)filter);
        this.gatherMaps(declarations, false, offset);
        if (!visitIncludedFiles) {
            this.visitedFiles.remove(file);
        }
    }

    private void gatherMaps(Iterable<? extends CsmObject> declarations, boolean inLocalContext, int offset) {
        this.gatherMaps(declarations.iterator(), inLocalContext, offset);
    }

    private void gatherMaps(Iterator<? extends CsmObject> it, boolean inLocalContext, int offset) {
        while (it.hasNext()) {
            CsmObject o = it.next();
            assert (o instanceof CsmOffsetable);
            try {
                int start = ((CsmOffsetable)o).getStartOffset();
                int end = ((CsmOffsetable)o).getEndOffset();
                if (start >= offset) break;
                if (o instanceof CsmScopeElement) {
                    if (!inLocalContext && CsmKindUtilities.isFunctionDefinition((CsmObject)o)) {
                        if (end < offset) continue;
                        this.gatherMaps((CsmScopeElement)o, end, true, offset);
                        continue;
                    }
                    this.gatherMaps((CsmScopeElement)o, end, inLocalContext, offset);
                    continue;
                }
                if (!FileImpl.reportErrors) continue;
                System.err.println("Expected CsmScopeElement, got " + o);
            }
            catch (NullPointerException ex) {
                if (!FileImpl.reportErrors) continue;
                System.err.println("Unexpected NULL element in declarations collection");
                DiagnosticExceptoins.register(ex);
            }
        }
    }

    private CsmClassifier findNestedClassifier(CsmClassifier clazz) {
        if (CsmKindUtilities.isClass((CsmObject)clazz)) {
            Iterator it = CsmSelect.getClassMembers((CsmClass)((CsmClass)clazz), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter(this.currName(), true, true, false));
            while (it.hasNext()) {
                CsmMember member = (CsmMember)it.next();
                if (CharSequences.comparator().compare(this.currName(), member.getName()) != 0 || !CsmKindUtilities.isClassifier((CsmObject)member)) continue;
                return (CsmClassifier)member;
            }
        }
        return null;
    }

    private void doProcessTypedefsInUpperNamespaces(CsmNamespaceDefinition nsd) {
        CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createKindFilter(new CsmDeclaration.Kind[]{CsmDeclaration.Kind.NAMESPACE_DEFINITION, CsmDeclaration.Kind.TYPEDEF});
        Iterator iter = CsmSelect.getDeclarations((CsmNamespaceDefinition)nsd, (CsmSelect.CsmFilter)filter);
        while (iter.hasNext()) {
            CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)iter.next();
            if (decl.getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
                this.processTypedefsInUpperNamespaces((CsmNamespaceDefinition)decl);
                continue;
            }
            if (decl.getKind() != CsmDeclaration.Kind.TYPEDEF) continue;
            CsmTypedef typedef = (CsmTypedef)decl;
            if (CharSequences.comparator().compare(this.currName(), typedef.getName()) != 0) continue;
            this.currLocalClassifier = typedef;
        }
    }

    private void processTypedefsInUpperNamespaces(CsmNamespaceDefinition nsd) {
        if (CharSequences.comparator().compare(nsd.getName(), this.currName()) == 0) {
            ++this.currNamIdx;
            this.doProcessTypedefsInUpperNamespaces(nsd);
        } else {
            CsmNamespace cns = this.context.getContainingNamespace();
            if (cns != null && cns.equals(nsd.getNamespace())) {
                this.doProcessTypedefsInUpperNamespaces(nsd);
            }
        }
    }

    private void gatherMaps(CsmScopeElement element, int end, boolean inLocalContext, int offset) {
        CsmDeclaration.Kind kind;
        CsmDeclaration.Kind kind2 = kind = element instanceof CsmDeclaration ? ((CsmDeclaration)element).getKind() : null;
        if (kind != null) {
            switch (kind) {
                case NAMESPACE_DEFINITION: {
                    CsmNamespaceDefinition nsd = (CsmNamespaceDefinition)element;
                    if (nsd.getName().length() == 0) {
                        this.usedNamespaces.put(nsd.getQualifiedName(), (CsmObject)nsd.getNamespace());
                    }
                    if (offset < end || this.isInContext((CsmScope)nsd)) {
                        this.gatherMaps(nsd.getDeclarations(), inLocalContext, offset);
                    } else if (this.needClassifiers()) {
                        this.processTypedefsInUpperNamespaces(nsd);
                    }
                    return;
                }
                case NAMESPACE_ALIAS: {
                    CsmNamespaceAlias alias = (CsmNamespaceAlias)element;
                    this.namespaceAliases.put(alias.getAlias(), alias.getReferencedNamespace());
                    return;
                }
                case USING_DECLARATION: {
                    CsmDeclaration decl = this.resolveUsingDeclaration((CsmUsingDeclaration)element);
                    if (decl != null) {
                        CharSequence id = decl.getKind() == CsmDeclaration.Kind.FUNCTION || decl.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION || decl.getKind() == CsmDeclaration.Kind.FUNCTION_LAMBDA || decl.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND || decl.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION ? ((CsmFunction)decl).getSignature() : decl.getName();
                        this.usingDeclarations.put(id, decl);
                    }
                    return;
                }
                case USING_DIRECTIVE: {
                    CsmUsingDirective udir = (CsmUsingDirective)element;
                    CharSequence name = udir.getName();
                    if (!this.usedNamespaces.containsKey(name)) {
                        this.usedNamespaces.put(name, (CsmObject)udir);
                    }
                    return;
                }
                case TYPEDEF: {
                    CsmTypedef typedef = (CsmTypedef)element;
                    if (offset > end && CharSequences.comparator().compare(this.currName(), typedef.getName()) == 0) {
                        this.currLocalClassifier = typedef;
                    }
                    return;
                }
            }
        }
        if (element instanceof CsmDeclarationStatement) {
            CsmDeclarationStatement ds = (CsmDeclarationStatement)element;
            if (ds.getStartOffset() < offset) {
                this.gatherMaps(((CsmDeclarationStatement)element).getDeclarators(), inLocalContext, offset);
            }
        } else if (CsmKindUtilities.isScope((CsmObject)element)) {
            if (inLocalContext && this.needClassifiers() && CsmKindUtilities.isClassifier((CsmObject)element) && (!CsmKindUtilities.isClassForwardDeclaration((CsmObject)element) || offset > end) && CharSequences.comparator().compare(this.currName(), ((CsmClassifier)element).getName()) == 0) {
                this.currLocalClassifier = (CsmClassifier)element;
            }
            if (offset < end || this.isInContext((CsmScope)element)) {
                this.gatherMaps(((CsmScope)element).getScopeElements(), inLocalContext, offset);
            }
        }
    }

    private boolean isInContext(CsmScope scope) {
        if (!CsmKindUtilities.isClass((CsmObject)scope) && !CsmKindUtilities.isNamespace((Object)scope)) {
            return false;
        }
        CsmQualifiedNamedElement el = (CsmQualifiedNamedElement)scope;
        CsmNamespace ns = this.context.getContainingNamespace();
        if (ns != null && this.startsWith(ns.getQualifiedName(), el.getQualifiedName())) {
            return true;
        }
        CsmClass cls = this.context.getContainingClass();
        return cls != null && this.startsWith(cls.getQualifiedName(), el.getQualifiedName());
    }

    private boolean startsWith(CharSequence qname, CharSequence prefix) {
        if (qname.length() < prefix.length()) {
            return false;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            if (qname.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return qname.length() == prefix.length() || qname.charAt(prefix.length()) == ':';
    }

    private CsmDeclaration resolveUsingDeclaration(CsmUsingDeclaration udecl) {
        if (this.isRecursionOnResolving(5)) {
            return null;
        }
        return udecl.getReferencedDeclaration();
    }

    @Override
    public CsmObject resolve(CharSequence[] nameTokens, int interestedKind) {
        CsmObject result = null;
        this.names = nameTokens;
        this.currNamIdx = 0;
        this.interestedKind = interestedKind;
        if (nameTokens.length == 1) {
            result = this.resolveSimpleName(result, nameTokens[0], interestedKind);
        } else if (nameTokens.length > 1) {
            result = this.resolveCompoundName(nameTokens, result, interestedKind);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmObject resolveSimpleName(CsmObject result, CharSequence name, int interestedKind) {
        CsmClass cls;
        CsmNamespace containingNS = null;
        if (result == null && this.needClassifiers() && (result = this.resolveInClass(cls = this.context.getContainingClass(), name)) == null && (this.parentResolver == null || !((Resolver3)this.parentResolver).resolveInBaseClass)) {
            result = this.resolveInBaseClasses(cls, name);
            if (this.needTemplateClassesOnly() && !CsmKindUtilities.isTemplate((CsmObject)result)) {
                result = null;
            }
        }
        if (result == null && this.needClassifiers() && (result = this.findClassifier(containingNS = this.context.getContainingNamespace(), name)) == null && containingNS != null) {
            result = this.resolveInUsings(containingNS, name);
        }
        if (result == null && this.needNamespaces()) {
            containingNS = this.context.getContainingNamespace();
            result = this.findNamespace(containingNS, name);
        }
        if (result == null && this.needClassifiers()) {
            result = this.findClassifierUsedInFile(name);
            if (this.needTemplateClassesOnly() && !CsmKindUtilities.isTemplate((CsmObject)result)) {
                result = null;
            }
        }
        CsmObject backupResult = result;
        if (!this.needForwardClassesOnly() && ForwardClass.isForwardClass(result)) {
            result = null;
        }
        if (result == null) {
            CsmNamespace o;
            CsmDeclaration decl;
            this.gatherMaps(this.file, !FileImpl.isFileBeingParsedInCurrentThread(this.file), this.origOffset);
            if (this.currLocalClassifier != null && this.needClassifiers()) {
                result = this.currLocalClassifier;
            }
            if (result == null && (decl = this.usingDeclarations.get(CharSequences.create((CharSequence)name))) != null) {
                result = decl;
            }
            if (result == null && this.needClassifiers()) {
                for (Map.Entry<CharSequence, CsmObject> entry : this.usedNamespaces.entrySet()) {
                    String nsp = ((Object)entry.getKey()).toString();
                    String fqn = nsp + "::" + name;
                    result = this.findClassifierUsedInFile(fqn);
                    if (result == null) {
                        result = this.findClassifier(containingNS, fqn);
                    }
                    if (result == null) {
                        CsmObject val = entry.getValue();
                        if (CsmKindUtilities.isUsingDirective((CsmObject)val)) {
                            val = ((CsmUsingDirective)val).getReferencedNamespace();
                            entry.setValue(val);
                        }
                        if (val == null) {
                            val = this.findNamespace(nsp);
                            entry.setValue(val);
                        }
                        if (CsmKindUtilities.isNamespace((Object)val)) {
                            CsmNamespace ns = (CsmNamespace)val;
                            if (!nsp.contains(ns.getQualifiedName())) {
                                fqn = ((Object)ns.getQualifiedName()).toString() + "::" + name;
                                result = this.findClassifierUsedInFile(fqn);
                            }
                            if (result == null) {
                                result = this.resolveInUsings(ns, name);
                            }
                        }
                    }
                    if (result == null) continue;
                    break;
                }
            }
            if (result == null && this.needNamespaces() && (o = this.namespaceAliases.get(CharSequences.create((CharSequence)name))) instanceof CsmNamespace) {
                result = o;
            }
            if (result == null && this.needNamespaces()) {
                String nsp;
                String fqn;
                Iterator<CharSequence> iter = this.usedNamespaces.keySet().iterator();
                while (iter.hasNext() && (result = this.findNamespace(fqn = (nsp = ((Object)iter.next()).toString()) + "::" + name)) == null) {
                }
            }
        }
        if (result == null) {
            result = backupResult;
        }
        if (result == null && TemplateUtils.isTemplateQualifiedName(((Object)name).toString())) {
            Resolver aResolver = ResolverFactory.createResolver(this.file, this.origOffset);
            try {
                result = aResolver.resolve(Utils.splitQualifiedName(TemplateUtils.getTemplateQualifiedNameWithoutSiffix(((Object)name).toString())), 8);
            }
            finally {
                ResolverFactory.releaseResolver(aResolver);
            }
        }
        if (this.needTemplateClassesOnly() && !CsmKindUtilities.isTemplate((CsmObject)result)) {
            result = null;
        }
        if (result == null && this.needClassifiers() && !this.needForwardClassesOnly()) {
            result = this.resolve(Utils.splitQualifiedName(((Object)name).toString()), 16);
        }
        if (this.needForwardClassesOnly() && !CsmKindUtilities.isClassForwardDeclaration((CsmObject)result)) {
            result = null;
        }
        return result;
    }

    private String fullName(CharSequence[] nameTokens) {
        StringBuilder sb = new StringBuilder(nameTokens[0]);
        for (int i = 1; i < nameTokens.length; ++i) {
            sb.append("::");
            sb.append(nameTokens[i]);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmObject resolveCompoundName(CharSequence[] nameTokens, CsmObject result, int interestedKind) {
        CsmNamespace containingNS;
        String fullName = this.fullName(nameTokens);
        if (this.needClassifiers()) {
            result = this.findClassifierUsedInFile(fullName);
        }
        if (result == null && this.needClassifiers()) {
            containingNS = this.context.getContainingNamespace();
            result = this.findClassifier(containingNS, fullName);
        }
        if (result == null && this.needNamespaces()) {
            containingNS = this.context.getContainingNamespace();
            result = this.findNamespace(containingNS, fullName);
        }
        if (result == null && this.needClassifiers()) {
            CsmType type;
            this.gatherMaps(this.file, !FileImpl.isFileBeingParsedInCurrentThread(this.file), this.origOffset);
            if (this.currLocalClassifier != null && CsmKindUtilities.isTypedef((CsmObject)this.currLocalClassifier) && (type = ((CsmTypedef)this.currLocalClassifier).getType()) != null) {
                CsmClassifier currentClassifier = this.getTypeClassifier(type);
                while (this.currNamIdx < this.names.length - 1 && currentClassifier != null) {
                    ++this.currNamIdx;
                    if (!CsmKindUtilities.isTypedef((CsmObject)(currentClassifier = this.findNestedClassifier(currentClassifier)))) continue;
                    CsmType curType = ((CsmTypedef)currentClassifier).getType();
                    currentClassifier = curType == null ? null : this.getTypeClassifier(curType);
                }
                if (this.currNamIdx == this.names.length - 1) {
                    result = currentClassifier;
                }
            }
            if (result == null) {
                String nsp;
                String fqn;
                Iterator<CharSequence> iter = this.usedNamespaces.keySet().iterator();
                while (iter.hasNext() && (result = this.findClassifierUsedInFile(fqn = (nsp = ((Object)iter.next()).toString()) + "::" + fullName)) == null) {
                }
            }
            if (result == null) {
                int i;
                CsmNamespace ns = null;
                String nsName = ((Object)nameTokens[0]).toString();
                for (i = 1; i < nameTokens.length; ++i) {
                    CsmObject nsObj = null;
                    Resolver aResolver = ResolverFactory.createResolver(this.file, this.origOffset);
                    try {
                        nsObj = aResolver.resolve(Utils.splitQualifiedName(nsName), 1);
                    }
                    finally {
                        ResolverFactory.releaseResolver(aResolver);
                    }
                    if (!(nsObj instanceof CsmNamespace)) break;
                    ns = (CsmNamespace)nsObj;
                    CharSequence token = nameTokens[i];
                    nsName = ns.getQualifiedName() + "::" + token;
                }
                --i;
                if (ns != null) {
                    int j;
                    StringBuilder sb = new StringBuilder(ns.getQualifiedName());
                    for (j = i; j < nameTokens.length; ++j) {
                        sb.append("::");
                        sb.append(nameTokens[j]);
                    }
                    result = this.findClassifierUsedInFile(sb.toString());
                    if (result == null) {
                        sb = new StringBuilder(nameTokens[i]);
                        for (j = i + 1; j < nameTokens.length; ++j) {
                            sb.append("::");
                            sb.append(nameTokens[j]);
                        }
                        result = this.resolveInUsings(ns, sb.toString());
                    }
                }
            }
        }
        if (result == null && this.needNamespaces()) {
            CsmObject obj = null;
            Resolver aResolver = ResolverFactory.createResolver(this.file, this.origOffset);
            try {
                obj = aResolver.resolve(Utils.splitQualifiedName(((Object)nameTokens[0]).toString()), 1);
            }
            finally {
                ResolverFactory.releaseResolver(aResolver);
            }
            if (obj instanceof CsmNamespace) {
                CsmNamespace ns = (CsmNamespace)obj;
                for (int i = 1; i < nameTokens.length; ++i) {
                    CsmNamespace newNs = null;
                    CharSequence name = nameTokens[i];
                    Collection aliases = CsmUsingResolver.getDefault().findNamespaceAliases(ns);
                    for (CsmNamespaceAlias alias : aliases) {
                        if (!((Object)alias.getAlias()).toString().equals(((Object)name).toString())) continue;
                        newNs = alias.getReferencedNamespace();
                        break;
                    }
                    if (newNs == null) {
                        Collection namespaces = ns.getNestedNamespaces();
                        for (CsmNamespace namespace : namespaces) {
                            if (!((Object)namespace.getName()).toString().equals(((Object)name).toString())) continue;
                            newNs = namespace;
                            break;
                        }
                    }
                    if ((ns = newNs) == null) break;
                }
                result = ns;
            }
        }
        if (result == null && TemplateUtils.isTemplateQualifiedName(fullName.toString())) {
            StringBuilder sb2 = new StringBuilder(TemplateUtils.getTemplateQualifiedNameWithoutSiffix(((Object)nameTokens[0]).toString()));
            for (int i = 1; i < nameTokens.length; ++i) {
                sb2.append("::");
                sb2.append(TemplateUtils.getTemplateQualifiedNameWithoutSiffix(((Object)nameTokens[i]).toString()));
            }
            Resolver aResolver = ResolverFactory.createResolver(this.file, this.origOffset);
            try {
                result = aResolver.resolve(Utils.splitQualifiedName(sb2.toString()), interestedKind);
            }
            finally {
                ResolverFactory.releaseResolver(aResolver);
            }
        }
        if (result == null && this.needClassifiers() && !this.needForwardClassesOnly()) {
            result = this.resolve(nameTokens, 16);
        }
        if (this.needForwardClassesOnly() && !CsmKindUtilities.isClassForwardDeclaration((CsmObject)result)) {
            result = null;
        }
        return result;
    }

    private CsmClassifier getTypeClassifier(CsmType type) {
        if (this.isRecursionOnResolving(200)) {
            return null;
        }
        return type.getClassifier();
    }

    private CsmObject resolveInBaseClasses(CsmClass cls, CharSequence name) {
        this.resolveInBaseClass = true;
        CsmObject res = this._resolveInBaseClasses(cls, name, new HashSet<CharSequence>(), 0);
        this.resolveInBaseClass = false;
        return res;
    }

    private CsmObject _resolveInBaseClasses(CsmClass cls, CharSequence name, Set<CharSequence> antiLoop, int depth) {
        if (depth == 50) {
            String msg = "Recursion in resolver3:resolveInBaseClasses[" + name + "]" + this.file.getAbsolutePath() + ":" + this.origOffset;
            if (this.SUPRESS_RECURSION_EXCEPTION) {
                Utils.LOG.warning(msg);
            } else {
                new Exception(msg).printStackTrace(System.err);
            }
            return null;
        }
        if (this.isNotNullNotUnresolved(cls)) {
            List<CsmClass> toAnalyze = this.getClassesContainers(cls);
            for (CsmClass csmClass : toAnalyze) {
                for (CsmInheritance inh : csmClass.getBaseClasses()) {
                    CsmClass base = this.getInheritanceClass(inh);
                    if (base == null || antiLoop.contains(base.getQualifiedName())) continue;
                    antiLoop.add(base.getQualifiedName());
                    CsmObject result = this.resolveInClass(base, name);
                    if (result != null) {
                        return result;
                    }
                    result = this._resolveInBaseClasses(base, name, antiLoop, depth + 1);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }

    private CsmClass getInheritanceClass(CsmInheritance inh) {
        if (inh instanceof InheritanceImpl) {
            if (this.isRecursionOnResolving(200)) {
                return null;
            }
            CsmClassifier out = inh.getClassifier();
            if (CsmKindUtilities.isClass((CsmObject)(out = this.getOriginalClassifier(out)))) {
                return (CsmClass)out;
            }
        }
        return this.getCsmClass(inh);
    }

    private CsmClass getCsmClass(CsmInheritance inh) {
        CsmClassifier classifier = inh.getClassifier();
        if (CsmKindUtilities.isClass((CsmObject)(classifier = this.getOriginalClassifier(classifier)))) {
            return (CsmClass)classifier;
        }
        return null;
    }

    private boolean isNotNullNotUnresolved(Object obj) {
        return obj != null && !Unresolved.isUnresolved(obj);
    }

    private CsmObject resolveInClass(CsmClass cls, CharSequence name) {
        if (this.isNotNullNotUnresolved(cls)) {
            List<CsmClass> classesContainers = this.getClassesContainers(cls);
            for (CsmClass csmClass : classesContainers) {
                CsmClassifier classifier = null;
                CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createNameFilter(name, true, true, false);
                Iterator it = CsmSelect.getClassMembers((CsmClass)csmClass, (CsmSelect.CsmFilter)filter);
                while (it.hasNext()) {
                    CsmMember member = (CsmMember)it.next();
                    if (!CsmKindUtilities.isClassifier((CsmObject)member) || CsmKindUtilities.isClassForwardDeclaration((CsmObject)(classifier = (CsmClassifier)member))) continue;
                    return classifier;
                }
                if (classifier == null) continue;
                return classifier;
            }
        }
        return null;
    }

    private List<CsmClass> getClassesContainers(CsmClass cls) {
        ArrayList<CsmClass> out = new ArrayList<CsmClass>();
        CsmClass container = cls;
        while (CsmKindUtilities.isClass((CsmObject)container)) {
            out.add(container);
            container = container.getScope();
        }
        return out;
    }

    private boolean needClassifiers() {
        return (this.interestedKind & 2) == 2 || this.needClasses() || this.needTemplateClasses() || this.needForwardClasses();
    }

    private boolean needNamespaces() {
        return (this.interestedKind & 1) == 1;
    }

    private boolean needClasses() {
        return (this.interestedKind & 4) == 4 || this.needTemplateClasses() || this.needForwardClasses();
    }

    private boolean needTemplateClasses() {
        return (this.interestedKind & 8) == 8;
    }

    private boolean needTemplateClassesOnly() {
        return this.interestedKind == 8;
    }

    private boolean needForwardClasses() {
        return (this.interestedKind & 0x10) == 16;
    }

    private boolean needForwardClassesOnly() {
        return this.interestedKind == 16;
    }
}

