/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.resolver;

import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver3;
import org.netbeans.modules.cnd.modelimpl.impl.services.BaseUtilitiesProviderImpl;

public class Context {
    private final CsmFile file;
    private final int origOffset;
    private final Resolver3 resolver;
    private CsmNamespace containingNamespace;
    private CsmClass containingClass;
    private CsmFunctionDefinition containingFunction;
    private boolean contextFound = false;

    Context(CsmFile file, int origOffset, Resolver3 resolver) {
        this.file = file;
        this.origOffset = origOffset;
        this.resolver = resolver;
    }

    CsmNamespace getContainingNamespace() {
        if (!this.contextFound) {
            this.findContext(this.origOffset);
        }
        return this.containingNamespace;
    }

    CsmClass getContainingClass() {
        if (!this.contextFound) {
            this.findContext(this.origOffset);
        }
        return this.containingClass;
    }

    CsmFunctionDefinition getContainingFunction() {
        if (!this.contextFound) {
            this.findContext(this.origOffset);
        }
        return this.containingFunction;
    }

    private void findContext(int offset) {
        this.contextFound = true;
        CsmSelect.CsmFilter filter = CsmSelect.getFilterBuilder().createOffsetFilter(0, offset);
        Iterator<CsmOffsetableDeclaration> declarations = this.file instanceof FileImpl ? ((FileImpl)this.file).getDeclarations(offset) : CsmSelect.getDeclarations((CsmFile)this.file, (CsmSelect.CsmFilter)filter);
        this.findContext(declarations, filter, offset);
    }

    private void findContext(Iterator<?> it, CsmSelect.CsmFilter filter, int offset) {
        while (it.hasNext()) {
            CsmFunction fun;
            CsmFunctionDefinition fd;
            CsmDeclaration decl = (CsmDeclaration)it.next();
            if (decl.getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
                CsmNamespaceDefinition nd = (CsmNamespaceDefinition)decl;
                if (nd.getStartOffset() >= offset || offset >= nd.getEndOffset()) continue;
                this.containingNamespace = nd.getNamespace();
                this.findContext(CsmSelect.getDeclarations((CsmNamespaceDefinition)nd, (CsmSelect.CsmFilter)filter), filter, offset);
                continue;
            }
            if (decl.getKind() == CsmDeclaration.Kind.CLASS || decl.getKind() == CsmDeclaration.Kind.STRUCT || decl.getKind() == CsmDeclaration.Kind.UNION) {
                CsmClass cls = (CsmClass)decl;
                if (cls.getStartOffset() >= offset || offset >= cls.getEndOffset()) continue;
                this.containingClass = cls;
                this.findContext(CsmSelect.getClassMembers((CsmClass)this.containingClass, (CsmSelect.CsmFilter)filter), filter, offset);
                continue;
            }
            if (decl.getKind() != CsmDeclaration.Kind.FUNCTION_DEFINITION && decl.getKind() != CsmDeclaration.Kind.FUNCTION_LAMBDA && decl.getKind() != CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION || (fd = (CsmFunctionDefinition)decl).getStartOffset() >= offset || offset >= fd.getEndOffset()) continue;
            this.containingFunction = fd;
            CsmNamespace ns = BaseUtilitiesProviderImpl.getImpl()._getFunctionNamespace((CsmFunction)fd);
            if (ns != null && !ns.isGlobal()) {
                this.containingNamespace = ns;
            }
            if ((fun = this.getFunctionDeclaration(fd)) == null || !CsmKindUtilities.isMethodDeclaration((CsmObject)fun)) continue;
            this.containingClass = this.getMethodContainingClass((CsmMethod)fun);
        }
    }

    private CsmFunction getFunctionDeclaration(CsmFunctionDefinition fd) {
        if (this.resolver.isRecursionOnResolving(200)) {
            return null;
        }
        return fd.getDeclaration();
    }

    private CsmClass getMethodContainingClass(CsmMethod m) {
        return m.getContainingClass();
    }
}

