/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public abstract class StatementBase
extends OffsetableBase
implements CsmStatement {
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;

    protected StatementBase(AST ast, CsmFile file, CsmScope scope) {
        this(ast, file, StatementBase.getStartOffset(ast), StatementBase.getEndOffset(ast), scope);
    }

    protected StatementBase(CsmFile file, int start, int end, CsmScope scope) {
        this(null, file, start, end, scope);
    }

    private StatementBase(AST ast, CsmFile file, int start, int end, CsmScope scope) {
        super(file, start, end);
        if (scope != null) {
            this.setScope(scope);
        }
    }

    public synchronized CsmScope getScope() {
        CsmScope scope = this.scopeRef;
        if (scope == null) {
            scope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        }
        return scope;
    }

    protected final void setScope(CsmScope scope) {
        if (scope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(scope);
            assert (this.scopeUID != null || scope == null);
        } else {
            this.scopeRef = scope;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, output);
    }

    protected StatementBase(RepositoryDataInput input) throws IOException {
        super(input);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(input);
    }

    @Override
    public String toString() {
        return "" + this.getKind() + ' ' + this.getOffsetString();
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null) : "no object for UID " + this.scopeUID;
        }
    }

    public static abstract class StatementBuilder
    extends OffsetableDeclarationBase.ScopedDeclarationBuilder {
        abstract StatementBase create();
    }

    public static interface StatementBuilderContainer {
        public void addStatementBuilder(StatementBuilder var1);
    }
}

