/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;
import org.netbeans.modules.cnd.modelimpl.parser.spi.CsmParserProvider;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;

public abstract class LazyStatementImpl
extends StatementBase
implements CsmScope {
    private static final List<CsmStatement> EMPTY = Collections.emptyList();
    private volatile SoftReference<List<CsmStatement>> statements = null;

    protected LazyStatementImpl(CsmFile file, int start, int end, CsmFunction scope) {
        super(file, start, end, (CsmScope)scope);
    }

    public CsmStatement.Kind getKind() {
        return CsmStatement.Kind.COMPOUND;
    }

    public List<CsmStatement> getStatements() {
        if (this.statements == null) {
            return this.createStatements();
        }
        List<CsmStatement> list = this.statements.get();
        return list == null ? this.createStatements() : list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CsmStatement> createStatements() {
        List<CsmStatement> list;
        List<CsmStatement> list2 = list = this.statements == null ? null : this.statements.get();
        if (list == null) {
            CndUtils.assertTrueInConsole((!SwingUtilities.isEventDispatchThread() || CndUtils.isCodeCompletionUnitTestMode() ? 1 : 0) != 0, (String)"Calling Parser in UI Thread");
            LazyStatementImpl lazyStatementImpl = this;
            synchronized (lazyStatementImpl) {
                List<CsmStatement> refList;
                if (this.statements != null && (refList = this.statements.get()) != null) {
                    return refList;
                }
                this.statements = new SoftReference<List<CsmStatement>>(EMPTY);
                list = new ArrayList<CsmStatement>();
                if (this.renderStatements(list)) {
                    this.statements = new SoftReference<List<CsmStatement>>(list);
                    return list;
                }
                return Collections.emptyList();
            }
        }
        return list;
    }

    private boolean renderStatements(List<CsmStatement> list) {
        FileImpl file = (FileImpl)this.getContainingFile();
        TokenStream stream = file.getTokenStream(this.getStartOffset(), this.getEndOffset(), this.getFirstTokenID(), true);
        if (stream == null) {
            int startOffset = this.getStartOffset();
            int[] lineColumn = file.getLineColumn(startOffset);
            Utils.LOG.log(Level.SEVERE, "Can''t create compound statement: can''t create token stream for file {0} at {1}:{2}", new Object[]{file.getAbsolutePath(), lineColumn[0], lineColumn[1]});
            return false;
        }
        CsmParserProvider.CsmParserResult result = this.resolveLazyStatement(stream);
        if (result != null) {
            result.render(list);
        }
        return true;
    }

    public void renderStatements(AST ast, List<CsmStatement> list, Map<Integer, CsmObject> objects) {
        AST aST = ast = ast == null ? null : ast.getFirstChild();
        while (ast != null) {
            StatementBase stmt = AstRenderer.renderStatement(ast, this.getContainingFile(), this, objects);
            if (stmt != null) {
                list.add(stmt);
            }
            ast = ast.getNextSibling();
        }
    }

    public Collection<CsmScopeElement> getScopeElements() {
        List<CsmStatement> out = this.getStatements();
        return out;
    }

    protected abstract CsmParserProvider.CsmParserResult resolveLazyStatement(TokenStream var1);

    protected abstract int getFirstTokenID();

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
    }

    public LazyStatementImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.statements = null;
    }
}

