/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public final class ExpressionBase
extends OffsetableBase
implements CsmExpression {
    private List<CsmExpression> operands;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private List<CsmStatement> lambdas;

    private ExpressionBase(AST ast, CsmFile file, CsmScope scope) {
        super(file, ExpressionBase.getStartOffset(ast), ExpressionBase.getEndOffset(ast));
        if (scope != null) {
            this.setScope(scope);
        }
    }

    public static ExpressionBase create(AST ast, CsmFile file, CsmScope scope) {
        ExpressionBase expr = new ExpressionBase(ast, file, scope);
        ArrayList<CsmStatement> lambdas = new ArrayList<CsmStatement>();
        for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            if (token.getType() != 548) continue;
            lambdas.add(AstRenderer.renderStatement(token, file, scope));
        }
        if (!lambdas.isEmpty()) {
            expr.setLambdas(lambdas);
        }
        return expr;
    }

    private ExpressionBase(int startOffset, int endOffset, CsmFile file, CsmScope scope) {
        super(file, startOffset, endOffset);
        if (scope != null) {
            this.setScope(scope);
        }
    }

    public static ExpressionBase create(int startOffset, int endOffset, CsmFile file, CsmScope scope) {
        return new ExpressionBase(startOffset, endOffset, file, scope);
    }

    public CsmExpression.Kind getKind() {
        return null;
    }

    public CsmScope getScope() {
        return this._getScope();
    }

    public List<CsmStatement> getLambdas() {
        if (this.lambdas == null) {
            return Collections.emptyList();
        }
        return this.lambdas;
    }

    public void setLambdas(List<CsmStatement> lambdas) {
        this.lambdas = lambdas;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        if (this.lambdas != null) {
            Utils.disposeAll(this.lambdas);
        }
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            CsmScope csmScope = this.scopeRef = this.scopeRef != null ? this.scopeRef : UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    private synchronized CsmScope _getScope() {
        CsmScope scope = this.scopeRef;
        if (scope == null) {
            scope = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (scope != null || this.scopeUID == null) : "null object for UID " + this.scopeUID;
        }
        return scope;
    }

    protected void setScope(CsmScope scope) {
        if (scope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(scope);
            assert (this.scopeUID != null || scope == null);
        } else {
            this.scopeRef = scope;
        }
    }

    public List<CsmExpression> getOperands() {
        if (this.operands == null) {
            this.operands = new ArrayList<CsmExpression>(0);
        }
        return Collections.unmodifiableList(this.operands);
    }

    public CsmExpression getParent() {
        return null;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeExpressions(this.operands, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, output);
    }

    public ExpressionBase(RepositoryDataInput input) throws IOException {
        super(input);
        this.operands = PersistentUtils.readExpressions(new ArrayList(0), input);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(input);
    }

    public static class ExpressionBuilder
    extends OffsetableDeclarationBase.ScopedDeclarationBuilder {
        private int level = 0;

        public void enterExpression() {
            ++this.level;
        }

        public void leaveExpression() {
            --this.level;
        }

        public boolean isTopExpression() {
            return this.level == 0;
        }

        public ExpressionBase create() {
            ExpressionBase expr = new ExpressionBase(this.getStartOffset(), this.getEndOffset(), this.getFile(), this.getScope());
            return expr;
        }
    }

    public static interface ExpressionBuilderContainer {
        public void addExpressionBuilder(ExpressionBuilder var1);
    }
}

