/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public class CompoundStatementImpl
extends StatementBase
implements CsmCompoundStatement {
    private volatile List<CsmStatement> statements;

    protected CompoundStatementImpl(AST ast, CsmFile file, CsmScope scope) {
        super(ast, file, scope);
    }

    protected CompoundStatementImpl(CsmScope scope, CsmFile file, int start, int end) {
        super(file, start, end, scope);
    }

    public static CompoundStatementImpl create(AST ast, CsmFile file, CsmScope scope) {
        CompoundStatementImpl stmt = new CompoundStatementImpl(ast, file, scope);
        stmt.init(ast);
        return stmt;
    }

    private void init(AST ast) {
        this.renderStatements(ast);
    }

    public CsmStatement.Kind getKind() {
        return CsmStatement.Kind.COMPOUND;
    }

    public final List<CsmStatement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<CsmStatement> statements) {
        this.statements = statements;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.statements != null) {
            Utils.disposeAll(this.statements);
        }
    }

    protected void renderStatements(AST ast) {
        this.statements = Collections.emptyList();
        ArrayList<CsmStatement> out = new ArrayList<CsmStatement>();
        if (ast != null) {
            for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
                StatementBase stmt = AstRenderer.renderStatement(token, this.getContainingFile(), (CsmScope)this);
                if (stmt == null) continue;
                out.add(stmt);
            }
        }
        this.statements = out;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        List<CsmStatement> out = this.getStatements();
        return out;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
    }

    public CompoundStatementImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.statements = null;
    }

    public static class CompoundStatementBuilder
    extends StatementBase.StatementBuilder
    implements StatementBase.StatementBuilderContainer {
        private List<StatementBase.StatementBuilder> statements = new ArrayList<StatementBase.StatementBuilder>();

        @Override
        public void addStatementBuilder(StatementBase.StatementBuilder statement) {
            this.statements.add(statement);
        }

        protected List<StatementBase.StatementBuilder> getStatements() {
            return this.statements;
        }

        @Override
        public CompoundStatementImpl create() {
            CompoundStatementImpl stmt = new CompoundStatementImpl(this.getScope(), this.getFile(), this.getStartOffset(), this.getEndOffset());
            ArrayList<StatementBase> stmts = new ArrayList<StatementBase>();
            for (StatementBase.StatementBuilder statementBuilder : this.statements) {
                statementBuilder.setScope((CsmScope)stmt);
                stmts.add(statementBuilder.create());
            }
            if (stmts.isEmpty()) {
                stmt.statements = Collections.emptyList();
            } else {
                stmt.statements = stmts;
            }
            return stmt;
        }
    }
}

