/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.textcache.DefaultCache;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileObject;

public class SourceRootContainer {
    private final Map<CharSequence, Integer> projectRoots = new ConcurrentHashMap<CharSequence, Integer>();
    private final boolean isFixedRoots;

    public SourceRootContainer(boolean isFixedRoots) {
        this.isFixedRoots = isFixedRoots;
    }

    public boolean isMySource(String includePath) {
        Integer val;
        if (this.projectRoots.containsKey(DefaultCache.getManager().getString((CharSequence)includePath))) {
            return true;
        }
        do {
            int i;
            if ((i = includePath.lastIndexOf(92)) <= 0) {
                i = includePath.lastIndexOf(47);
            }
            if (i <= 0) {
                return false;
            }
            includePath = includePath.substring(0, i);
        } while ((val = this.projectRoots.get(DefaultCache.getManager().getString((CharSequence)includePath))) == null || !(this.isFixedRoots ? val > 0x1FFFFFFF : val > 0));
        return true;
    }

    public void fixFolder(String path) {
        if (path != null) {
            this.projectRoots.put(FilePathCache.getManager().getString((CharSequence)path), 0x3FFFFFFF);
        }
    }

    public void addSources(Collection<NativeFileItem> items) {
        for (NativeFileItem nativeFileItem : items) {
            this.addFileItemBasedPath(nativeFileItem);
        }
    }

    private void addFileItemBasedPath(NativeFileItem nativeFileItem) {
        FileObject fo = nativeFileItem.getFileObject();
        FileObject parent = fo.getParent();
        String path = CndFileUtils.normalizePath((FileObject)parent);
        this.addPath(path);
        try {
            String canonicalPath = CndFileUtils.getCanonicalPath((FileObject)parent);
            if (!path.equals(canonicalPath)) {
                this.addPath(canonicalPath);
            }
        }
        catch (IOException ex) {
            DiagnosticExceptoins.register(ex);
        }
    }

    private void addPath(String path) {
        CharSequence added = FilePathCache.getManager().getString((CharSequence)path);
        Integer integer = this.projectRoots.get(added);
        if (integer == null) {
            this.projectRoots.put(added, 1);
        } else {
            this.projectRoots.put(added, integer + 1);
        }
    }

    void clear() {
        this.projectRoots.clear();
    }
}

