/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class ParserThread
implements Runnable {
    private volatile boolean stopped = false;
    private boolean isStoped = false;

    ParserThread() {
    }

    public void stop() {
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this._run();
        }
        finally {
            this.isStoped = true;
        }
    }

    public boolean isStoped() {
        return this.isStoped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void _run() {
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            this.trace("started");
        }
        ParserQueue queue = ParserQueue.instance();
        while (!this.stopped) {
            if (TraceFlags.TRACE_PARSER_QUEUE) {
                this.trace("polling queue");
            }
            try {
                String standalone;
                ProjectBase project;
                String parseCase;
                Diagnostic.StopWatch stw;
                FileImpl file;
                String oldThreadName;
                Thread currentThread;
                block36: {
                    long parseTime;
                    block40: {
                        block37: {
                            ParserQueue.Entry entry = queue.poll();
                            if (entry == null) {
                                if (TraceFlags.TRACE_PARSER_QUEUE) {
                                    this.trace("waiting");
                                }
                                this.isStoped = true;
                                queue.waitReady();
                                this.isStoped = false;
                                continue;
                            }
                            currentThread = Thread.currentThread();
                            oldThreadName = currentThread.getName();
                            file = entry.getFile();
                            if (TraceFlags.TRACE_PARSER_QUEUE) {
                                this.trace("parsing started: " + entry.toString(TraceFlags.TRACE_PARSER_QUEUE_DETAILS));
                            }
                            stw = TraceFlags.TIMING ? new Diagnostic.StopWatch() : null;
                            parseCase = ": Parsing ";
                            project = null;
                            Collection<APTPreprocHandler.State> states = entry.getPreprocStates();
                            Collection<Object> preprocHandlers = new ArrayList(states.size());
                            project = file.getProjectImpl(true);
                            for (APTPreprocHandler.State state : states) {
                                if (project.isDisposing()) continue;
                                if (state == FileImpl.DUMMY_STATE) {
                                    CndUtils.assertTrueInConsole((states.size() == 1 ? 1 : 0) != 0, (String)"Dummy state sould never be mixed with normal states \n", states);
                                    preprocHandlers = FileImpl.DUMMY_HANDLERS;
                                    parseCase = ": ONE FILE Reparsing ";
                                    break;
                                }
                                if (state == FileImpl.PARTIAL_REPARSE_STATE) {
                                    CndUtils.assertTrueInConsole((states.size() == 1 ? 1 : 0) != 0, (String)"reparse Dummy state sould never be mixed with normal states \n", states);
                                    preprocHandlers = FileImpl.PARTIAL_REPARSE_HANDLERS;
                                    parseCase = ": PARTIAL Reparsing ";
                                    break;
                                }
                                APTPreprocHandler preprocHandler = project.createPreprocHandlerFromState(file.getAbsolutePath(), state);
                                if (TraceFlags.TRACE_PARSER_QUEUE) {
                                    System.err.println("before ensureParse on " + file.getAbsolutePath() + ParserQueue.tracePreprocState(state));
                                }
                                preprocHandlers.add(preprocHandler);
                            }
                            if (!project.isDisposing()) {
                                currentThread.setName(oldThreadName + parseCase + file.getAbsolutePath());
                                if (TraceFlags.SUSPEND_PARSE_FILE_TIME > 0) {
                                    try {
                                        System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_FILE_TIME + "ms before parsing " + file.getAbsolutePath());
                                        Thread.sleep(TraceFlags.SUSPEND_PARSE_FILE_TIME);
                                        System.err.println("awoke after sleep");
                                    }
                                    catch (InterruptedException ex) {
                                        // empty catch block
                                    }
                                }
                                file.ensureParsed(preprocHandlers);
                            }
                            if (stw == null) break block36;
                            if (!TraceFlags.TIMING_PARSE_PER_FILE_FLAT) break block37;
                            standalone = CsmStandaloneFileProvider.getDefault().isStandalone((CsmFile)file) ? "STANDALONE " : "";
                            parseTime = stw.stopAndReport(parseCase + standalone + file.getBuffer().getUrl());
                            break block40;
                        }
                        parseTime = stw.stop();
                    }
                    ParserQueue.instance().addParseStatistics(project, file, parseTime);
                }
                try {
                    queue.onFileParsingFinished(file);
                    if (TraceFlags.TRACE_PARSER_QUEUE) {
                        this.trace("parsing done for " + file.getAbsolutePath() + " took " + file.getLastParseTime() + "ms");
                    }
                    Notificator.instance().flush();
                    if (TraceFlags.TRACE_PARSER_QUEUE) {
                        this.trace("model event flushed");
                    }
                }
                catch (Throwable thr) {
                    thr.printStackTrace(System.err);
                }
                currentThread.setName(oldThreadName);
                continue;
                catch (Throwable thr) {
                    block38: {
                        long parseTime;
                        block41: {
                            block39: {
                                try {
                                    DiagnosticExceptoins.register(thr);
                                    if (stw == null) break block38;
                                    if (!TraceFlags.TIMING_PARSE_PER_FILE_FLAT) break block39;
                                }
                                catch (Throwable throwable) {
                                    if (stw != null) {
                                        long parseTime2;
                                        if (TraceFlags.TIMING_PARSE_PER_FILE_FLAT) {
                                            String standalone2 = CsmStandaloneFileProvider.getDefault().isStandalone((CsmFile)file) ? "STANDALONE " : "";
                                            parseTime2 = stw.stopAndReport(parseCase + standalone2 + file.getBuffer().getUrl());
                                        } else {
                                            parseTime2 = stw.stop();
                                        }
                                        ParserQueue.instance().addParseStatistics(project, file, parseTime2);
                                    }
                                    try {
                                        queue.onFileParsingFinished(file);
                                        if (TraceFlags.TRACE_PARSER_QUEUE) {
                                            this.trace("parsing done for " + file.getAbsolutePath() + " took " + file.getLastParseTime() + "ms");
                                        }
                                        Notificator.instance().flush();
                                        if (TraceFlags.TRACE_PARSER_QUEUE) {
                                            this.trace("model event flushed");
                                        }
                                    }
                                    catch (Throwable thr2) {
                                        thr2.printStackTrace(System.err);
                                    }
                                    currentThread.setName(oldThreadName);
                                    throw throwable;
                                }
                                standalone = CsmStandaloneFileProvider.getDefault().isStandalone((CsmFile)file) ? "STANDALONE " : "";
                                parseTime = stw.stopAndReport(parseCase + standalone + file.getBuffer().getUrl());
                                break block41;
                            }
                            parseTime = stw.stop();
                        }
                        ParserQueue.instance().addParseStatistics(project, file, parseTime);
                    }
                    try {
                        queue.onFileParsingFinished(file);
                        if (TraceFlags.TRACE_PARSER_QUEUE) {
                            this.trace("parsing done for " + file.getAbsolutePath() + " took " + file.getLastParseTime() + "ms");
                        }
                        Notificator.instance().flush();
                        if (TraceFlags.TRACE_PARSER_QUEUE) {
                            this.trace("model event flushed");
                        }
                    }
                    catch (Throwable thr3) {
                        thr3.printStackTrace(System.err);
                    }
                    currentThread.setName(oldThreadName);
                }
            }
            catch (InterruptedException ex) {
                if (!TraceFlags.TRACE_PARSER_QUEUE) break;
                this.trace("interrupted");
                break;
            }
        }
        if (TraceFlags.TRACE_PARSER_QUEUE) {
            this.trace(this.stopped ? "stopped" : "finished");
        }
    }

    private void trace(String text) {
        System.err.println(Thread.currentThread().getName() + ": " + text);
    }
}

