/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.CsmObjectBuilder;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.SpecializationDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.openide.util.CharSequences;

public abstract class OffsetableIdentifiableBase<T>
extends OffsetableBase
implements CsmIdentifiable,
Persistent,
SelfPersistent {
    private CsmUID<?> uid = null;

    protected OffsetableIdentifiableBase(CsmFile containingFile, int startOffset, int endOffset) {
        super(containingFile, startOffset, endOffset);
    }

    protected abstract CsmUID<?> createUID();

    @Override
    public void dispose() {
        RepositoryUtils.disposeUID(this.uid, this);
        super.dispose();
    }

    public CsmUID<T> getUID() {
        if (this.uid == null) {
            this.uid = this.createUID();
        }
        return this.uid;
    }

    protected final void setSelfUID() {
        if (this.uid != null) {
            if (UIDProviderIml.isSelfUID(this.uid)) {
                return;
            }
            new Exception("replacing " + this.uid + " to self UID").printStackTrace();
        }
        this.uid = UIDProviderIml.createSelfUID(this);
    }

    protected void cleanUID() {
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
    }

    protected OffsetableIdentifiableBase(RepositoryDataInput input) throws IOException {
        super(input);
    }

    protected final void writeUID(RepositoryDataOutput output) throws IOException {
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        factory.writeUID(this.uid, output);
    }

    protected final void readUID(RepositoryDataInput input) throws IOException {
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        this.uid = factory.readUID(input);
    }

    public static abstract class OffsetableIdentifiableBuilder
    extends OffsetableBase.OffsetableBuilder
    implements CsmObjectBuilder {
        private CharSequence name;
        private int nameStartOffset = -1;
        private int nameEndOffset = -1;
        private boolean isMacroExpanded = false;

        public OffsetableIdentifiableBuilder() {
        }

        protected OffsetableIdentifiableBuilder(OffsetableIdentifiableBuilder builder) {
            super(builder);
            this.name = builder.name;
            this.nameStartOffset = builder.nameStartOffset;
            this.nameEndOffset = builder.nameEndOffset;
            this.isMacroExpanded = builder.isMacroExpanded;
        }

        public void setName(CharSequence name) {
            this.name = name;
        }

        public void setNameStartOffset(int nameStartOffset) {
            this.nameStartOffset = nameStartOffset;
        }

        public void setNameEndOffset(int nameEndOffset) {
            this.nameEndOffset = nameEndOffset;
        }

        public void setMacroExpanded() {
            this.isMacroExpanded = true;
        }

        public CharSequence getName() {
            if (this.name == null) {
                return NameCache.getManager().getString(CharSequences.empty());
            }
            return NameCache.getManager().getString(this.name);
        }

        public CharSequence getRawName() {
            if (this.name == null) {
                return NameCache.getManager().getString(CharSequences.empty());
            }
            return NameCache.getManager().getString(CharSequences.create((CharSequence)((Object)this.name).toString().replace("::", ".")));
        }

        public NameHolder getNameHolder() {
            if (this.nameStartOffset != -1 && this.nameEndOffset != -1) {
                return NameHolder.createName(this.name, this.nameStartOffset, this.nameEndOffset, this.isMacroExpanded);
            }
            return NameHolder.createName(this.name);
        }

        protected void addReference(CsmObject obj) {
            this.getNameHolder().addReference(this.getFileContent(), obj);
        }
    }

    public static class NameBuilder
    extends OffsetableBase.OffsetableBuilder {
        boolean global = false;
        List<NamePart> nameParts = new ArrayList<NamePart>();

        public void addNamePart(CharSequence part) {
            this.nameParts.add(new NamePart(part));
        }

        public void setGlobal() {
            this.global = true;
        }

        public List<CharSequence> getNameParts() {
            ArrayList<CharSequence> names = new ArrayList<CharSequence>();
            for (NamePart namePart : this.nameParts) {
                names.add(namePart.part);
            }
            return names;
        }

        public List<NamePart> getNames() {
            return this.nameParts;
        }

        public CharSequence getName() {
            StringBuilder sb = new StringBuilder();
            boolean firstScope = !this.global;
            for (NamePart part : this.nameParts) {
                if (!firstScope) {
                    sb.append("::");
                }
                sb.append(part.part);
                firstScope = false;
            }
            return NameCache.getManager().getString((CharSequence)sb.toString());
        }

        public CharSequence getLastNamePart() {
            return this.nameParts.get((int)(this.nameParts.size() - 1)).part;
        }

        public void addParameterBuilder(SpecializationDescriptor.SpecializationParameterBuilder param) {
            if (!this.nameParts.isEmpty()) {
                this.nameParts.get((int)(this.nameParts.size() - 1)).params.add(param);
            }
        }

        public static class NamePart {
            CharSequence part;
            List<SpecializationDescriptor.SpecializationParameterBuilder> params = new ArrayList<SpecializationDescriptor.SpecializationParameterBuilder>();

            public NamePart(CharSequence part) {
                this.part = part;
            }

            public CharSequence getPart() {
                return this.part;
            }

            public List<SpecializationDescriptor.SpecializationParameterBuilder> getParams() {
                return this.params;
            }
        }
    }
}

