/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.BuiltinTypes;
import org.netbeans.modules.cnd.modelimpl.csm.CsmObjectBuilder;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.TypeFactory;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.RawNamable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.CompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public abstract class OffsetableDeclarationBase<T>
extends OffsetableIdentifiableBase<T>
implements CsmOffsetableDeclaration {
    public static final char UNIQUE_NAME_SEPARATOR = ':';

    protected OffsetableDeclarationBase(CsmFile file, int startOffset, int endOffset) {
        super(file, startOffset, endOffset);
    }

    public CharSequence getUniqueName() {
        return CharSequences.create((CharSequence)(Utils.getCsmDeclarationKindkey(this.getKind()) + ':' + this.getUniqueNameWithoutPrefix()));
    }

    public CharSequence getUniqueNameWithoutPrefix() {
        return this.getQualifiedName();
    }

    protected final CsmProject getProject() {
        CsmFile file = this.getContainingFile();
        assert (file != null);
        return file != null ? file.getProject() : null;
    }

    public CharSequence getQualifiedNamePostfix() {
        if (TraceFlags.SET_UNNAMED_QUALIFIED_NAME && this.getName().length() == 0) {
            return this.getOffsetBasedName();
        }
        return this.getName();
    }

    protected CharSequence toStringName() {
        CharSequence name = CsmKindUtilities.isTemplate((CsmObject)this) ? ((CsmTemplate)this).getDisplayName() : this.getName();
        if (this instanceof RawNamable) {
            StringBuilder out = new StringBuilder(name);
            out.append('(');
            boolean first = true;
            for (CharSequence part : ((RawNamable)((Object)this)).getRawName()) {
                if (first) {
                    first = false;
                } else {
                    out.append("::");
                }
                out.append(part);
            }
            out.append(')');
            name = out.toString();
        }
        return name;
    }

    private String getOffsetBasedName() {
        return "[" + this.getContainingFile().getName() + ":" + this.getStartOffset() + "-" + this.getEndOffset() + "]";
    }

    @Override
    protected CsmUID<? extends CsmOffsetableDeclaration> createUID() {
        return UIDUtilities.createDeclarationUID(this);
    }

    protected static TemplateDescriptor createTemplateDescriptor(AST node, CsmFile file, CsmScope scope, StringBuilder classTemplateSuffix, boolean global) {
        boolean _template = false;
        boolean specialization = false;
        switch (node.getType()) {
            case 499: 
            case 505: 
            case 506: 
            case 523: 
            case 525: 
            case 527: 
            case 529: {
                _template = true;
                break;
            }
            case 510: 
            case 513: 
            case 514: 
            case 515: {
                _template = true;
                specialization = true;
            }
        }
        if (_template) {
            AST startTemplateSign;
            AST templateNode;
            boolean templateClass = false;
            List<CsmTemplateParameter> templateParams = null;
            AST templateClassNode = templateNode = node.getFirstChild();
            if (templateNode == null || templateNode.getType() != 116) {
                return null;
            }
            AST qIdToken = AstUtil.findChildOfType(node, 542);
            AST aST = startTemplateSign = qIdToken != null ? AstUtil.findChildOfType(qIdToken, 21) : null;
            if (startTemplateSign != null) {
                AST scopeSign;
                AST endTemplateSign = null;
                for (AST sibling = startTemplateSign.getNextSibling(); sibling != null; sibling = sibling.getNextSibling()) {
                    if (sibling.getType() != 23) continue;
                    endTemplateSign = sibling;
                    break;
                }
                if (endTemplateSign != null && (scopeSign = endTemplateSign.getNextSibling()) != null && scopeSign.getType() == 52) {
                    AST templateSiblingNode;
                    if (specialization && classTemplateSuffix != null) {
                        classTemplateSuffix.append(TemplateUtils.getSpecializationSuffix(qIdToken, null));
                    }
                    if ((templateSiblingNode = templateNode.getNextSibling()) != null && templateSiblingNode.getType() == 116) {
                        templateNode = templateSiblingNode;
                        templateClass = true;
                    } else {
                        templateClass = true;
                        _template = false;
                    }
                }
            }
            int inheritedTemplateParametersNumber = 0;
            if (templateClass) {
                templateParams = TemplateUtils.getTemplateParameters(templateClassNode, file, scope, global);
                inheritedTemplateParametersNumber = templateParams.size();
            }
            String templateSuffix = "";
            if (_template) {
                if (specialization) {
                    templateSuffix = qIdToken == null ? "<>" : TemplateUtils.getSpecializationSuffix(qIdToken, null);
                } else {
                    StringBuilder sb = new StringBuilder();
                    TemplateUtils.addSpecializationSuffix(templateNode.getFirstChild(), sb, null);
                    templateSuffix = '<' + sb.toString() + '>';
                }
                if (templateParams != null) {
                    templateParams.addAll(TemplateUtils.getTemplateParameters(templateNode, file, scope, global));
                } else {
                    templateParams = TemplateUtils.getTemplateParameters(templateNode, file, scope, global);
                }
            }
            return new TemplateDescriptor(templateParams, templateSuffix, inheritedTemplateParametersNumber, specialization, global);
        }
        return null;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
    }

    protected OffsetableDeclarationBase(RepositoryDataInput input) throws IOException {
        super(input);
    }

    @Override
    public String toString() {
        CharSequence name = this.toStringName();
        return "" + this.getKind() + ' ' + name + this.getOffsetString() + this.getPositionString();
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        OffsetableDeclarationBase other = (OffsetableDeclarationBase)obj;
        if (!this.getKind().equals((Object)other.getKind())) {
            return false;
        }
        return this.getName().equals(other.getName());
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.getName().hashCode();
    }

    protected boolean registerInProject() {
        return false;
    }

    protected static <T> void postObjectCreateRegistration(boolean register, OffsetableDeclarationBase<T> obj) {
        if (register) {
            if (!obj.registerInProject()) {
                RepositoryUtils.put(obj);
            }
        } else {
            Utils.setSelfUID(obj);
        }
    }

    protected static <T> void temporaryRepositoryRegistration(boolean global, OffsetableDeclarationBase<T> obj) {
        if (global) {
            RepositoryUtils.hang(obj);
        } else {
            Utils.setSelfUID(obj);
        }
    }

    public static class DeclaratorBuilder
    implements CsmObjectBuilder {
        private int level = 0;
        private CharSequence name;
        private OffsetableIdentifiableBase.NameBuilder nameBuilder;

        public void setName(CharSequence name) {
            this.name = name;
        }

        public CharSequence getName() {
            return this.name;
        }

        public void enterDeclarator() {
            ++this.level;
        }

        public void leaveDeclarator() {
            --this.level;
        }

        public boolean isTopDeclarator() {
            return this.level == 0;
        }

        public OffsetableIdentifiableBase.NameBuilder getNameBuilder() {
            return this.nameBuilder;
        }

        public void setNameBuilder(OffsetableIdentifiableBase.NameBuilder nameBuilder) {
            this.nameBuilder = nameBuilder;
        }
    }

    public static class SimpleDeclarationBuilder
    extends ScopedDeclarationBuilder {
        private boolean typedefSpecifier = false;
        private boolean friendSpecifier = false;
        private boolean typeSpecifier = false;
        private boolean inDeclSpecifiers = false;
        private DeclaratorBuilder declaratorBuilder;
        private TypeFactory.TypeBuilder typeBuilder;
        private CsmObjectBuilder parametersListBuilder;
        private TemplateDescriptor.TemplateDescriptorBuilder templateDescriptorBuilder;
        private ExpressionBase.ExpressionBuilder initializerBuilder;
        private boolean _static = false;
        private boolean _extern = false;
        private boolean _const = false;
        private boolean constructor = false;
        private boolean destructor = false;

        public SimpleDeclarationBuilder() {
        }

        protected SimpleDeclarationBuilder(SimpleDeclarationBuilder builder) {
            super(builder);
            this.typedefSpecifier = builder.typeSpecifier;
            this.friendSpecifier = builder.friendSpecifier;
            this.typeSpecifier = builder.typeSpecifier;
            this.inDeclSpecifiers = builder.inDeclSpecifiers;
            this.declaratorBuilder = builder.declaratorBuilder;
            this.typeBuilder = builder.typeBuilder;
            this.parametersListBuilder = builder.parametersListBuilder;
            this.templateDescriptorBuilder = builder.templateDescriptorBuilder;
            this.initializerBuilder = builder.initializerBuilder;
            this._static = builder._static;
            this._extern = builder._extern;
            this._const = builder._const;
            this.constructor = builder.constructor;
            this.destructor = builder.destructor;
        }

        public void setInitializerBuilder(ExpressionBase.ExpressionBuilder initializerBuilder) {
            this.initializerBuilder = initializerBuilder;
        }

        public ExpressionBase.ExpressionBuilder getInitializerBuilder() {
            return this.initializerBuilder;
        }

        public void setConstructor() {
            this.constructor = true;
        }

        public void setDestructor() {
            this.destructor = true;
        }

        public boolean isConstructor() {
            return this.constructor;
        }

        public boolean isDestructor() {
            return this.destructor;
        }

        public void setFriend() {
            this.friendSpecifier = true;
        }

        public boolean isFriend() {
            return this.friendSpecifier;
        }

        public void setStatic() {
            this._static = true;
        }

        public void setExtern() {
            this._extern = true;
        }

        public void setConst() {
            this._const = true;
        }

        public boolean isStatic() {
            return this._static;
        }

        public boolean isExtern() {
            return this._extern;
        }

        public boolean isConst() {
            return this._const;
        }

        public void setTypedefSpecifier() {
            this.typedefSpecifier = true;
            if (this.typeBuilder != null) {
                this.typeBuilder.setTypedef();
            }
        }

        public boolean hasTypedefSpecifier() {
            return this.typedefSpecifier;
        }

        public void setTypeSpecifier() {
            this.typeSpecifier = true;
        }

        public boolean hasTypeSpecifier() {
            return this.typeSpecifier && this.inDeclSpecifiers;
        }

        public void declSpecifiers() {
            this.inDeclSpecifiers = true;
        }

        public void endDeclSpecifiers() {
            this.inDeclSpecifiers = false;
        }

        public boolean isInDeclSpecifiers() {
            return this.inDeclSpecifiers;
        }

        public void setDeclaratorBuilder(DeclaratorBuilder declaratorBuilder) {
            this.declaratorBuilder = declaratorBuilder;
        }

        public void setTemplateDescriptorBuilder(TemplateDescriptor.TemplateDescriptorBuilder templateDescriptorBuilder) {
            this.templateDescriptorBuilder = templateDescriptorBuilder;
            if (templateDescriptorBuilder != null) {
                this.setStartOffset(templateDescriptorBuilder.getStartOffset());
            }
        }

        public TemplateDescriptor.TemplateDescriptorBuilder getTemplateDescriptorBuilder() {
            return this.templateDescriptorBuilder;
        }

        public TemplateDescriptor getTemplateDescriptor() {
            TemplateDescriptor td = null;
            if (this.getTemplateDescriptorBuilder() != null) {
                this.getTemplateDescriptorBuilder().setScope(this.getScope());
                td = this.getTemplateDescriptorBuilder().create();
            }
            return td;
        }

        public void setTypeBuilder(TypeFactory.TypeBuilder typeBuilder) {
            this.typeBuilder = typeBuilder;
        }

        public TypeFactory.TypeBuilder getTypeBuilder() {
            return this.typeBuilder;
        }

        public DeclaratorBuilder getDeclaratorBuilder() {
            return this.declaratorBuilder;
        }

        public void setParametersListBuilder(CsmObjectBuilder parametersListBuilder) {
            this.parametersListBuilder = parametersListBuilder;
        }

        public CsmObjectBuilder getParametersListBuilder() {
            return this.parametersListBuilder;
        }

        public boolean isFunction() {
            return this.parametersListBuilder != null;
        }

        protected CsmType getType() {
            CsmType type = null;
            if (this.getTypeBuilder() != null) {
                this.getTypeBuilder().setScope(this.getScope());
                type = this.getTypeBuilder().create();
            }
            if (type == null) {
                type = TypeFactory.createSimpleType((CsmClassifier)BuiltinTypes.getBuiltIn("int"), this.getFile(), this.getStartOffset(), this.getStartOffset());
            }
            return type;
        }

        public CsmDeclaration create() {
            throw new UnsupportedOperationException("Should not be used.");
        }
    }

    public static abstract class ScopedDeclarationBuilder
    extends OffsetableIdentifiableBase.OffsetableIdentifiableBuilder {
        private boolean global = true;
        private CsmObjectBuilder parent;
        private CsmScope scope;

        public ScopedDeclarationBuilder() {
        }

        protected ScopedDeclarationBuilder(ScopedDeclarationBuilder builder) {
            super(builder);
            this.global = builder.global;
            this.parent = builder.parent;
            this.scope = builder.scope;
        }

        public void setScope(CsmScope scope) {
            this.scope = scope;
        }

        public void setParent(CsmObjectBuilder parent) {
            this.parent = parent;
        }

        public CsmObjectBuilder getParent() {
            return this.parent;
        }

        public CsmScope getScope() {
            if (this.scope != null) {
                return this.scope;
            }
            this.scope = this.parent instanceof NamespaceDefinitionImpl.NamespaceBuilder ? ((NamespaceDefinitionImpl.NamespaceBuilder)this.parent).getNamespace() : (NamespaceImpl)this.getFile().getProject().getGlobalNamespace();
            return this.scope;
        }

        protected void addDeclaration(CsmOffsetableDeclaration decl) {
            if (this.parent != null) {
                if (this.parent instanceof NamespaceDefinitionImpl.NamespaceBuilder) {
                    ((NamespaceDefinitionImpl.NamespaceBuilder)this.parent).addDeclaration(decl);
                }
            } else {
                this.getFileContent().addDeclaration(decl);
            }
            if (this.getScope() instanceof CsmNamespace) {
                ((NamespaceImpl)this.getScope()).addDeclaration(decl);
            }
        }

        public boolean isGlobal() {
            return this.global && !(this.scope instanceof CompoundStatementImpl);
        }

        public void setLocal() {
            this.global = false;
        }

        @Override
        public CharSequence getName() {
            String[] split = ((Object)super.getName()).toString().split("::");
            return NameCache.getManager().getString((CharSequence)split[split.length - 1]);
        }

        public CharSequence[] getScopeNames() {
            if (super.getName() != null) {
                String[] split = ((Object)super.getName()).toString().split("::");
                CharSequence[] res = new CharSequence[split.length - 1];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = NameCache.getManager().getString((CharSequence)split[i]);
                }
                return res;
            }
            return new CharSequence[0];
        }
    }
}

