/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmValidable;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.CsmObjectBuilder;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.PositionManager;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;

public abstract class OffsetableBase
implements CsmOffsetable,
Disposable,
CsmValidable {
    private CsmFile fileRef;
    private final CsmUID<CsmFile> fileUID;
    private final int startPosition;
    private final int endPosition;

    protected OffsetableBase(CsmOffsetable pos) {
        this(pos.getContainingFile(), pos.getStartOffset(), pos.getEndOffset());
    }

    protected OffsetableBase(CsmFile file, int start, int end) {
        this.fileUID = UIDCsmConverter.fileToUID(file);
        this.fileRef = null;
        if (end < start) {
            if (CndUtils.isDebugMode()) {
                CndUtils.assertTrueInConsole((boolean)false, (String)("end < start for " + (file != null ? file.getAbsolutePath() : "null file") + ":[" + start + "-" + end + "]"));
            }
            end = start;
        }
        this.startPosition = PositionManager.createPositionID(this.fileUID, start, PositionManager.Position.Bias.FOWARD);
        this.endPosition = PositionManager.createPositionID(this.fileUID, end, PositionManager.Position.Bias.BACKWARD);
    }

    public final int getStartOffset() {
        return PositionManager.getOffset(this.fileUID, this.startPosition);
    }

    public final int getEndOffset() {
        return this.endPosition != 0 ? PositionManager.getOffset(this.fileUID, this.endPosition) : PositionManager.getOffset(this.fileUID, this.startPosition);
    }

    public final CsmOffsetable.Position getStartPosition() {
        return PositionManager.getPosition(this.fileUID, this.startPosition);
    }

    public final CsmOffsetable.Position getEndPosition() {
        return PositionManager.getPosition(this.fileUID, this.endPosition);
    }

    public static int getStartOffset(AST node) {
        CsmAST csmAst;
        if (node != null && (csmAst = AstUtil.getFirstCsmAST(node)) != null) {
            return csmAst.getOffset();
        }
        return 0;
    }

    public static int getEndOffset(AST node) {
        if (node != null) {
            AST lastChild = AstUtil.getLastChildRecursively(node);
            if (lastChild.getType() != 1 && lastChild instanceof CsmAST) {
                return ((CsmAST)lastChild).getEndOffset();
            }
            lastChild = AstUtil.getLastNonEOFChildRecursively(node);
            if (lastChild instanceof CsmAST) {
                return ((CsmAST)lastChild).getEndOffset();
            }
        }
        return 0;
    }

    public CsmFile getContainingFile() {
        return this._getFile(true);
    }

    public boolean isValid() {
        return CsmBaseUtilities.isValid((CsmObject)this._getFile(false)) && this.fileRef == null;
    }

    public CharSequence getText() {
        return this.getContainingFile().getText(this.getStartOffset(), this.getEndOffset());
    }

    @Override
    public void dispose() {
        this.onDispose();
    }

    private synchronized void onDispose() {
        if (this.fileRef == null) {
            this.fileRef = UIDCsmConverter.UIDtoFile(this.fileUID);
            assert (this.fileRef != null) : "no object for UID " + this.fileUID;
        }
    }

    private synchronized CsmFile _getFile(boolean checkNull) {
        CsmFile file = this.fileRef;
        if (file == null) {
            file = UIDCsmConverter.UIDtoFile(this.fileUID);
            assert (file != null || !checkNull) : "no object for UID " + this.fileUID + " in object " + this.getClass() + ":" + this.getOffsetString();
        }
        return file;
    }

    public void write(RepositoryDataOutput output) throws IOException {
        output.writeInt(this.startPosition);
        output.writeInt(this.endPosition);
        assert (this.fileUID != null);
        UIDObjectFactory.getDefaultFactory().writeUID(this.fileUID, output);
    }

    protected OffsetableBase(RepositoryDataInput input) throws IOException {
        this.startPosition = input.readInt();
        this.endPosition = input.readInt();
        this.fileUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        assert (this.fileUID != null);
        this.fileRef = null;
    }

    protected String getOffsetString() {
        return "[" + this.getStartOffset() + "-" + this.getEndOffset() + "]";
    }

    protected CharSequence getPositionString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        CsmFile containingFile = this._getFile(false);
        if (containingFile == null) {
            sb.append(" NO CONTAINER ").append(this.fileUID);
        } else {
            sb.append(containingFile.getName());
        }
        sb.append(' ');
        CsmOffsetable.Position pos = this.getStartPosition();
        sb.append(pos.getLine());
        sb.append(':');
        sb.append(pos.getColumn());
        sb.append('-');
        pos = this.getEndPosition();
        sb.append(pos.getLine());
        sb.append(':');
        sb.append(pos.getColumn());
        sb.append(']');
        return sb;
    }

    public String toString() {
        return this.getOffsetString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OffsetableBase other = (OffsetableBase)obj;
        if (!(this.fileUID == other.fileUID || this.fileUID != null && this.fileUID.equals(other.fileUID))) {
            return false;
        }
        if (this.startPosition != other.startPosition) {
            return false;
        }
        return this.endPosition == other.endPosition;
    }

    public int hashCode() {
        int hash = 7;
        hash = 47 * hash + (this.fileUID != null ? this.fileUID.hashCode() : 0);
        hash = 47 * hash + this.startPosition;
        hash = 47 * hash + this.endPosition;
        return hash;
    }

    public static abstract class OffsetableBuilder
    implements CsmObjectBuilder {
        private CsmFile file;
        private FileContent fileContent;
        private int startOffset;
        private int endOffset;

        public OffsetableBuilder() {
        }

        protected OffsetableBuilder(OffsetableBuilder builder) {
            this.file = builder.file;
            this.fileContent = builder.fileContent;
            this.startOffset = builder.startOffset;
            this.endOffset = builder.endOffset;
        }

        public void setFile(CsmFile file) {
            this.file = file;
            this.fileContent = ((FileImpl)file).getParsingFileContent();
        }

        public void setStartOffset(int startOffset) {
            this.startOffset = startOffset;
        }

        public void setEndOffset(int endOffset) {
            this.endOffset = endOffset;
        }

        public CsmFile getFile() {
            return this.file;
        }

        public FileContent getFileContent() {
            return this.fileContent;
        }

        public int getStartOffset() {
            return this.startOffset;
        }

        public int getEndOffset() {
            return this.endOffset;
        }
    }
}

