/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.ChangeEventImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ListenersImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.PersistentKey;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

public class Notificator {
    private static ThreadLocal<Notificator> instance = new ThreadLocal<Notificator>(){

        @Override
        protected Notificator initialValue() {
            return new Notificator();
        }
    };
    private int transactionLevel = 0;
    private ChangeEventImpl currEvent;

    private Notificator() {
    }

    public static Notificator instance() {
        return instance.get();
    }

    private String getCurrThreadString() {
        Thread thread = Thread.currentThread();
        return thread.getName() + ' ' + thread.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTransaction() {
        Notificator notificator = this;
        synchronized (notificator) {
            ++this.transactionLevel;
            if (TraceFlags.DEBUG) {
                Diagnostic.trace("    > " + this.transactionLevel + ' ' + this.getCurrThreadString());
            }
            this.resetEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() {
        Notificator notificator = this;
        synchronized (notificator) {
            --this.transactionLevel;
            if (TraceFlags.DEBUG) {
                Diagnostic.trace("    < " + this.transactionLevel + ' ' + this.getCurrThreadString());
            }
            if (this.transactionLevel <= 0) {
                this.flush();
            }
        }
    }

    private ChangeEventImpl getEvent() {
        if (this.currEvent == null) {
            ChangeEventImpl ev;
            this.currEvent = ev = new ChangeEventImpl(this);
        }
        return this.currEvent;
    }

    private void resetEvent() {
        this.currEvent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Notificator notificator = this;
        synchronized (notificator) {
            this.resetEvent();
        }
    }

    private boolean isEventEmpty() {
        return this.currEvent == null || this.currEvent.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNewFile(CsmFile file) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addNewFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRemovedFile(CsmFile file) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addRemovedFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChangedFile(CsmFile file) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addChangedFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNewDeclaration(CsmOffsetableDeclaration decl) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addNewDeclaration(decl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRemovedDeclaration(CsmOffsetableDeclaration decl) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addRemovedDeclaration(decl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerChangedDeclaration(CsmOffsetableDeclaration oldDecl, CsmOffsetableDeclaration newDecl) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addChangedDeclaration(oldDecl, newDecl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNewNamespace(CsmNamespace ns) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addNewNamespace(ns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRemovedNamespace(CsmNamespace ns) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addRemovedNamespace(ns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerChangedLibraryDependency(CsmProject project) {
        Notificator notificator = this;
        synchronized (notificator) {
            this.getEvent().addProjectThatChangedLibs(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        ChangeEventImpl ev;
        Notificator notificator = this;
        synchronized (notificator) {
            this.transactionLevel = 0;
            if (this.isEventEmpty()) {
                return;
            }
            ev = this.getEvent();
            this.resetEvent();
        }
        IdMaker<CsmFile, CharSequence> idFileMaker = new IdMaker<CsmFile, CharSequence>(){

            @Override
            public CharSequence id(CsmFile o) {
                return o.getAbsolutePath();
            }
        };
        Notificator.processFiles(idFileMaker, ev.getNewFiles(), ev.getRemovedFiles(), ev.getChangedFiles());
        IdMaker<CsmOffsetableDeclaration, PersistentKey> idDeclMaker = new IdMaker<CsmOffsetableDeclaration, PersistentKey>(){

            @Override
            public PersistentKey id(CsmOffsetableDeclaration o) {
                return PersistentKey.createKey(o);
            }
        };
        Notificator.processDeclarations(idDeclMaker, ev.getNewDeclarations(), ev.getRemovedDeclarations(), ev.getChangedDeclarations());
        Notificator.gatherProjects(ev);
        ListenersImpl.getImpl().fireModelChanged(ev);
    }

    private static void gatherProjects(ChangeEventImpl ev) {
        Collection<CsmProject> projects = ev.getChangedProjects();
        Collection[] files = new Collection[]{ev.getNewFiles(), ev.getChangedFiles(), ev.getRemovedFiles()};
        for (int i = 0; i < files.length; ++i) {
            Iterator iter = files[i].iterator();
            while (iter.hasNext()) {
                projects.add(((CsmFile)iter.next()).getProject());
            }
        }
        Collection[] decls = new Collection[]{ev.getNewDeclarations(), ev.getChangedDeclarations().values(), ev.getRemovedDeclarations()};
        for (int i = 0; i < decls.length; ++i) {
            for (Object o : decls[i]) {
                if (!(o instanceof CsmOffsetableDeclaration)) continue;
                projects.add(((CsmOffsetableDeclaration)o).getContainingFile().getProject());
            }
        }
    }

    private static void processFiles(IdMaker<CsmFile, CharSequence> idMaker, Collection<CsmFile> added, Collection<CsmFile> removed, Collection<CsmFile> changed) {
        CharSequence id;
        HashSet<CharSequence> idsAdded = new HashSet<CharSequence>();
        Iterator<CsmFile> iter = added.iterator();
        while (iter.hasNext()) {
            idsAdded.add(idMaker.id(iter.next()));
        }
        HashSet<CharSequence> idsRemoved = new HashSet<CharSequence>();
        Iterator<CsmFile> iter2 = removed.iterator();
        while (iter2.hasNext()) {
            idsRemoved.add(idMaker.id(iter2.next()));
        }
        HashSet<CsmFile> rightAdded = new HashSet<CsmFile>();
        HashSet<CsmFile> rightRemoved = new HashSet<CsmFile>();
        for (CsmFile o : removed) {
            id = idMaker.id(o);
            if (idsAdded.contains(id)) {
                changed.add(o);
                continue;
            }
            rightRemoved.add(o);
        }
        for (CsmFile o : added) {
            id = idMaker.id(o);
            if (idsRemoved.contains(id)) continue;
            rightAdded.add(o);
        }
        added.clear();
        added.addAll(rightAdded);
        removed.clear();
        removed.addAll(rightRemoved);
    }

    private static void processDeclarations(IdMaker<CsmOffsetableDeclaration, PersistentKey> idMaker, Collection<CsmOffsetableDeclaration> added, Collection<CsmOffsetableDeclaration> removed, Map<CsmOffsetableDeclaration, CsmOffsetableDeclaration> changed) {
        PersistentKey id;
        HashMap<PersistentKey, CsmOffsetableDeclaration> idsAdded = new HashMap<PersistentKey, CsmOffsetableDeclaration>();
        for (CsmOffsetableDeclaration decl : added) {
            idsAdded.put(idMaker.id(decl), decl);
        }
        HashMap<PersistentKey, CsmOffsetableDeclaration> idsRemoved = new HashMap<PersistentKey, CsmOffsetableDeclaration>();
        for (CsmOffsetableDeclaration decl : removed) {
            idsRemoved.put(idMaker.id(decl), decl);
        }
        HashSet<CsmOffsetableDeclaration> rightAdded = new HashSet<CsmOffsetableDeclaration>();
        HashSet<CsmOffsetableDeclaration> rightRemoved = new HashSet<CsmOffsetableDeclaration>();
        for (CsmOffsetableDeclaration decl : removed) {
            id = idMaker.id(decl);
            if (idsAdded.containsKey(id)) {
                changed.put(decl, (CsmOffsetableDeclaration)idsAdded.get(id));
                continue;
            }
            rightRemoved.add(decl);
        }
        for (CsmOffsetableDeclaration decl : added) {
            id = idMaker.id(decl);
            if (idsRemoved.containsKey(id)) continue;
            rightAdded.add(decl);
        }
        added.clear();
        added.addAll(rightAdded);
        removed.clear();
        if (rightRemoved.size() > 0) {
            for (CsmOffsetableDeclaration decl : rightRemoved) {
                CharSequence uniqueName = decl.getUniqueName();
                CsmProject project = decl.getContainingFile().getProject();
                CsmOffsetableDeclaration duplicated = (CsmOffsetableDeclaration)project.findDeclaration(uniqueName);
                if (duplicated != null) {
                    changed.put(decl, duplicated);
                    continue;
                }
                removed.add(decl);
            }
        }
    }

    private static interface IdMaker<T, S> {
        public S id(T var1);
    }
}

