/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.SourceRootContainer;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.repository.api.CacheLocation;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.APTStringManager;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileSystem;

public final class LibProjectImpl
extends ProjectBase {
    private final CharSequence includePath;
    private final SourceRootContainer projectRoots = new SourceRootContainer(true);

    private LibProjectImpl(ModelImpl model, FileSystem fs, String includePathName, CacheLocation cacheLocation) {
        super(model, fs, includePathName, includePathName, cacheLocation);
        this.includePath = FilePathCache.getManager().getString((CharSequence)includePathName);
        this.projectRoots.fixFolder(includePathName);
        assert (this.includePath != null);
    }

    public static LibProjectImpl createInstance(ModelImpl model, FileSystem fs, String includePathName, CacheLocation cacheLocation) {
        ProjectBase instance = null;
        assert (includePathName != null);
        if (TraceFlags.PERSISTENT_REPOSITORY) {
            try {
                instance = LibProjectImpl.readInstance(model, fs, includePathName, includePathName, cacheLocation);
            }
            catch (Exception e) {
                LibProjectImpl.cleanRepository(fs, includePathName, true, cacheLocation);
                DiagnosticExceptoins.register(e);
            }
        }
        if (instance == null) {
            instance = new LibProjectImpl(model, fs, includePathName, cacheLocation);
        }
        if (instance instanceof LibProjectImpl) {
            assert (((LibProjectImpl)instance).includePath != null);
        } else assert (false) : "Wrong instance, should be LibProjectImpl: " + instance;
        CndUtils.assertTrue((instance.getFileSystem() == fs ? 1 : 0) != 0);
        return (LibProjectImpl)instance;
    }

    protected CharSequence getPath() {
        return this.includePath;
    }

    @Override
    protected void ensureFilesCreated() {
    }

    protected boolean isStableStatus() {
        return true;
    }

    @Override
    public Collection<ProjectBase> getDependentProjects() {
        return LibraryManager.getInstance(this).getProjectsByLibrary(this);
    }

    @Override
    protected Collection<Key> getLibrariesKeys() {
        return Collections.emptySet();
    }

    @Override
    public List<CsmProject> getLibraries() {
        return Collections.emptyList();
    }

    @Override
    protected final ParserQueue.Position getIncludedFileParserQueuePosition() {
        return ParserQueue.Position.TAIL;
    }

    public boolean isArtificial() {
        return true;
    }

    @Override
    public NativeFileItem getNativeFileItem(CsmUID<CsmFile> file) {
        return null;
    }

    @Override
    protected void putNativeFileItem(CsmUID<CsmFile> file, NativeFileItem nativeFileItem) {
    }

    @Override
    protected NativeFileItem removeNativeFileItem(CsmUID<CsmFile> file) {
        return null;
    }

    @Override
    protected void clearNativeFileContainer() {
    }

    @Override
    public boolean isStable(CsmFile skipFile) {
        if (!this.isDisposing()) {
            return !ParserQueue.instance().hasPendingProjectRelatedWork(this, (FileImpl)skipFile);
        }
        return false;
    }

    @Override
    protected SourceRootContainer getProjectRoots() {
        return this.projectRoots;
    }

    @Override
    public void write(RepositoryDataOutput aStream) throws IOException {
        super.write(aStream);
        assert (this.includePath != null);
        APTSerializeUtils.writeFileNameIndex((CharSequence)this.includePath, (RepositoryDataOutput)aStream, (int)this.getUnitId());
    }

    public LibProjectImpl(RepositoryDataInput aStream) throws IOException {
        super(aStream);
        this.includePath = APTSerializeUtils.readFileNameIndex((RepositoryDataInput)aStream, (APTStringManager)FilePathCache.getManager(), (int)this.getUnitId());
        assert (this.includePath != null);
        this.setPlatformProject(this.includePath);
    }
}

