/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;

class FileStateCache {
    private static final boolean TRACE = false;
    private static final boolean cacheStates = TraceFlags.CACHE_FILE_STATE;
    private static final int CACHE_SIZE = 10;
    private static final int MAX_KEY_SIZE = 1000;
    private static int stateCacheAttempt = 0;
    private static int stateCacheSuccessAttempt = 0;
    private final Map<APTPreprocHandler.StateKey, Value> stateCache = new LinkedHashMap<APTPreprocHandler.StateKey, Value>();
    private final ReadWriteLock stateCacheLock = new ReentrantReadWriteLock();
    private final FileImpl file;

    FileStateCache(FileImpl file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheVisitedState(APTPreprocHandler.State inputState, APTPreprocHandler outputHandler, FilePreprocessorConditionState pcState) {
        if (cacheStates && inputState.isCompileContext()) {
            this.stateCacheLock.writeLock().lock();
            try {
                if ((this.stateCache.isEmpty() || APTHandlersSupport.getIncludeStackDepth((APTPreprocHandler.State)inputState) == 1) && this.isCacheableState(inputState)) {
                    if (this.stateCache.size() == 10) {
                        int min = Integer.MAX_VALUE;
                        APTPreprocHandler.StateKey key = null;
                        for (Map.Entry<APTPreprocHandler.StateKey, Value> entry : this.stateCache.entrySet()) {
                            if (entry.getValue().value.get() == null) {
                                key = entry.getKey();
                                break;
                            }
                            if (entry.getValue().count >= min) continue;
                            key = entry.getKey();
                            min = entry.getValue().count;
                        }
                        this.stateCache.remove(key);
                    }
                    this.stateCache.put(FileStateCache.createKey(inputState), new Value(new PreprocessorStatePair(outputHandler.getState(), pcState)));
                }
            }
            finally {
                this.stateCacheLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PreprocessorStatePair getCachedVisitedState(APTPreprocHandler.State inputState) {
        PreprocessorStatePair res = null;
        if (cacheStates && inputState.isCompileContext()) {
            this.stateCacheLock.readLock().lock();
            APTPreprocHandler.StateKey key = null;
            try {
                Value value;
                if (this.isCacheableState(inputState) && (value = this.stateCache.get(key = FileStateCache.createKey(inputState))) != null) {
                    res = (PreprocessorStatePair)value.value.get();
                    value.count++;
                }
            }
            finally {
                this.stateCacheLock.readLock().unlock();
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearStateCache() {
        if (cacheStates) {
            try {
                this.stateCacheLock.writeLock().lock();
                this.stateCache.clear();
            }
            finally {
                this.stateCacheLock.writeLock().unlock();
            }
        }
    }

    private static APTPreprocHandler.StateKey createKey(APTPreprocHandler.State inputState) {
        return APTHandlersSupport.getStateKey((APTPreprocHandler.State)inputState);
    }

    private boolean isCacheableState(APTPreprocHandler.State inputState) {
        return true;
    }

    private static class Value {
        private final Reference<PreprocessorStatePair> value;
        private int count;

        private Value(PreprocessorStatePair value) {
            this.value = CndTraceFlags.WEAK_REFS_HOLDERS ? new WeakReference<PreprocessorStatePair>(value) : new SoftReference<PreprocessorStatePair>(value);
        }
    }
}

