/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.PrintWriter;
import java.util.Collection;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.openide.filesystems.FileObject;

public class FileSnapshot
implements CsmFile {
    private final CharSequence absPath;
    private final CsmProject project;
    private final CharSequence name;
    private final Collection<CsmInclude> includes;
    private final Collection<CsmErrorDirective> errors;
    private final Collection<CsmOffsetableDeclaration> declarations;
    private final Collection<CsmMacro> macros;
    private final Collection<CsmScopeElement> scoped;
    private final CsmFile.FileType fileType;
    private final boolean isSource;
    private final boolean isHeader;
    private final FileImpl delegate;

    FileSnapshot(FileImpl impl) {
        this.absPath = impl.getAbsolutePath();
        this.project = impl.getProject();
        this.name = impl.getName();
        this.includes = impl.getIncludes();
        this.errors = impl.getErrors();
        this.declarations = impl.getDeclarations();
        this.macros = impl.getMacros();
        this.scoped = impl.getScopeElements();
        this.isSource = impl.isSourceFile();
        this.isHeader = impl.isHeaderFile();
        this.fileType = impl.getFileType();
        this.delegate = impl;
    }

    public CharSequence getAbsolutePath() {
        return this.absPath;
    }

    public FileObject getFileObject() {
        return this.delegate.getFileObject();
    }

    public CsmProject getProject() {
        return this.project;
    }

    public CharSequence getText() {
        assert (false);
        return this.delegate.getText();
    }

    public CharSequence getText(int start, int end) {
        assert (false);
        return this.delegate.getText(start, end);
    }

    public Collection<CsmInclude> getIncludes() {
        return this.includes;
    }

    public Collection<CsmErrorDirective> getErrors() {
        return this.errors;
    }

    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        return this.declarations;
    }

    public Collection<CsmMacro> getMacros() {
        return this.macros;
    }

    public boolean isParsed() {
        return true;
    }

    public void scheduleParsing(boolean wait) throws InterruptedException {
    }

    public boolean isSourceFile() {
        return this.isSource;
    }

    public boolean isHeaderFile() {
        return this.isHeader;
    }

    public CsmFile.FileType getFileType() {
        return this.fileType;
    }

    public CharSequence getName() {
        return this.name;
    }

    public Collection<CsmScopeElement> getScopeElements() {
        return this.scoped;
    }

    public boolean isValid() {
        return true;
    }

    public void dumpInfo(PrintWriter printOut) {
        printOut.printf("Snapshot %s\n", this.absPath);
    }

    public void dumpIndex(PrintWriter printOut) {
        printOut.printf("Snapshot %s\n", this.absPath);
    }
}

