/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.cnd.antlr.Parser;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmTracer;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageFilter;
import org.netbeans.modules.cnd.apt.support.lang.APTLanguageSupport;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.debug.CndTraceFlags;
import org.netbeans.modules.cnd.indexing.api.CndTextIndexKey;
import org.netbeans.modules.cnd.modelimpl.content.file.FakeIncludePair;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponentDeclarations;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponentIncludes;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponentInstantiations;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponentMacros;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponentReferences;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContentSignature;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.EnumImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileSnapshot;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileStateCache;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileTokenStreamCache;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParseStatistics;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProgressSupport;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.CPPParserEx;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTIndexingWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;
import org.netbeans.modules.cnd.modelimpl.parser.spi.CsmParserProvider;
import org.netbeans.modules.cnd.modelimpl.platform.FileBufferDoc;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.syntaxerr.spi.ReadOnlyTokenBuffer;
import org.netbeans.modules.cnd.modelimpl.trace.TraceUtils;
import org.netbeans.modules.cnd.modelimpl.uid.KeyBasedUID;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.dlight.libs.common.PathUtilities;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;

public final class FileImpl
implements CsmFile,
Disposable,
Persistent,
SelfPersistent,
CsmIdentifiable {
    private final ThreadLocal<AtomicReference<FileContent>> parsingFileContentRef = new ThreadLocal<AtomicReference<FileContent>>(){

        @Override
        protected AtomicReference<FileContent> initialValue() {
            return new AtomicReference<Object>(null);
        }
    };
    public static final boolean reportErrors = TraceFlags.REPORT_PARSING_ERRORS | TraceFlags.DEBUG;
    private static final boolean reportParse = Boolean.getBoolean("parser.log.parse");
    private static final boolean logState = Boolean.getBoolean("parser.log.state");
    private static final boolean emptyAstStatictics = Boolean.getBoolean("parser.empty.ast.statistics");
    public static final int UNDEFINED_FILE = 0;
    public static final int SOURCE_FILE = 1;
    public static final int SOURCE_C_FILE = 2;
    public static final int SOURCE_CPP_FILE = 3;
    public static final int HEADER_FILE = 4;
    private static volatile AtomicLong parseCount = new AtomicLong(1L);
    private Collection<CsmParserProvider.ParserError> parsingErrors;
    private FileBuffer fileBuffer;
    static final Collection<APTPreprocHandler> DUMMY_HANDLERS = new EmptyCollection<APTPreprocHandler>();
    static final APTPreprocHandler.State DUMMY_STATE = new SpecialStateImpl();
    static final APTPreprocHandler.State PARTIAL_REPARSE_STATE = new SpecialStateImpl();
    static final Collection<APTPreprocHandler> PARTIAL_REPARSE_HANDLERS = new EmptyCollection<APTPreprocHandler>();
    private Object projectRef;
    private final CsmUID<CsmProject> projectUID;
    private final ReentrantReadWriteLock projectLock = new ReentrantReadWriteLock();
    private int lastParseTime;
    private volatile State state;
    private volatile ParsingState parsingState;
    private CsmFile.FileType fileType = CsmFile.FileType.UNDEFINED_FILE;
    private final Object stateLock = new StateLock();
    private volatile FileContent currentFileContent;
    private FileContentSignature lastFileBasedSignature;
    private FileSnapshot fileSnapshot;
    private final Object snapShotLock = new Object();
    private volatile boolean disposed = false;
    private long lastParsed = Long.MIN_VALUE;
    private long lastParsedCRC;
    private int hash = 0;
    private Reference<List<CsmReference>> lastMacroUsages = null;
    private static Hook hook = null;
    private final AtomicInteger inEnsureParsed = new AtomicInteger(0);
    private final Object changeStateLock = new ChangeStateLock();
    private final Object tokStreamLock = new TokenStreamLock();
    private Reference<FileTokenStreamCache> tsRef = new SoftReference<Object>(null);
    public static final Comparator<CsmOffsetable> START_OFFSET_COMPARATOR = new Comparator<CsmOffsetable>(){

        @Override
        public int compare(CsmOffsetable o1, CsmOffsetable o2) {
            int ofs2;
            if (o1 == o2) {
                return 0;
            }
            int ofs1 = o1.getStartOffset();
            if (ofs1 == (ofs2 = o2.getStartOffset())) {
                return 0;
            }
            return ofs1 - ofs2;
        }
    };
    private static final boolean TRACE_SCHUDULE_PARSING = Boolean.getBoolean("cnd.trace.schedule.parsing");
    private volatile boolean alreadyInFixFakeRegistrations = false;
    private CsmUID<CsmFile> uid = null;
    private final FileStateCache stateCache = new FileStateCache(this);
    private final AtomicBoolean hasBrokenIncludes;

    public static boolean isFileBeingParsedInCurrentThread(CsmFile file) {
        if (file instanceof FileImpl) {
            return ((FileImpl)file).getParsingFileContent() != null;
        }
        return false;
    }

    public FileContent getParsingFileContent() {
        return this.parsingFileContentRef.get().get();
    }

    public static void incParseCount() {
        parseCount.incrementAndGet();
    }

    public static int getParseCount() {
        return (int)(parseCount.get() & 0xFFFFFFFFL);
    }

    public static long getLongParseCount() {
        return parseCount.get();
    }

    FileContentSignature getSignature() {
        return FileContentSignature.create(this);
    }

    void debugInvalidate() {
        this.state = State.INITIAL;
    }

    public FileImpl(FileBuffer fileBuffer, ProjectBase project, CsmFile.FileType fileType, NativeFileItem nativeFileItem) {
        this.state = State.INITIAL;
        this.parsingState = ParsingState.NOT_BEING_PARSED;
        this.projectUID = UIDCsmConverter.projectToUID(project);
        assert (this.projectUID instanceof KeyBasedUID);
        this.fileBuffer = fileBuffer;
        this.hasBrokenIncludes = new AtomicBoolean(false);
        this.currentFileContent = FileContent.createFileContent(this, project);
        this.projectRef = new WeakReference<ProjectBase>(project);
        this.fileType = fileType;
        if (nativeFileItem != null) {
            project.putNativeFileItem(this.getUID(), nativeFileItem);
        }
        Notificator.instance().registerNewFile(this);
    }

    public static void setHook(Hook aHook) {
        hook = aHook;
    }

    public final NativeFileItem getNativeFileItem() {
        return this.getProjectImpl(true).getNativeFileItem(this.getUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProjectBase _getProject(boolean assertNotNull) {
        ProjectBase prj;
        Object o = this.projectRef;
        if (o instanceof ProjectBase) {
            return (ProjectBase)o;
        }
        if (o instanceof Reference && (prj = (ProjectBase)((Reference)o).get()) != null) {
            return prj;
        }
        this.projectLock.readLock().lock();
        try {
            prj = null;
            if (this.projectRef instanceof ProjectBase) {
                prj = (ProjectBase)this.projectRef;
            } else if (this.projectRef instanceof Reference) {
                prj = (ProjectBase)((Reference)this.projectRef).get();
            }
            if (prj == null) {
                prj = (ProjectBase)UIDCsmConverter.UIDtoProject(this.projectUID);
                if (assertNotNull) assert (prj != null || this.projectUID == null) : "empty project for UID " + this.projectUID;
                this.projectRef = new WeakReference<ProjectBase>(prj);
            }
            ProjectBase projectBase = prj;
            return projectBase;
        }
        finally {
            this.projectLock.readLock().unlock();
        }
    }

    public final boolean isSourceFile() {
        return FileImpl.isSourceFileType(this.fileType);
    }

    public static boolean isSourceFileType(CsmFile.FileType fileType) {
        switch (fileType) {
            case SOURCE_CPP_FILE: 
            case SOURCE_C_FILE: 
            case SOURCE_FILE: 
            case SOURCE_FORTRAN_FILE: {
                return true;
            }
        }
        return false;
    }

    public boolean isCppFile() {
        return this.fileType == CsmFile.FileType.SOURCE_CPP_FILE;
    }

    void setSourceFile() {
        if (this.fileType != CsmFile.FileType.SOURCE_C_FILE && this.fileType != CsmFile.FileType.SOURCE_CPP_FILE && this.fileType != CsmFile.FileType.SOURCE_FORTRAN_FILE) {
            this.fileType = CsmFile.FileType.SOURCE_FILE;
        }
    }

    public boolean isHeaderFile() {
        return this.fileType == CsmFile.FileType.HEADER_FILE;
    }

    public CsmFile.FileType getFileType() {
        return this.fileType;
    }

    void setHeaderFile() {
        if (this.fileType == CsmFile.FileType.UNDEFINED_FILE) {
            this.fileType = CsmFile.FileType.HEADER_FILE;
        }
    }

    public APTLanguageFilter getLanguageFilter(APTPreprocHandler.State ppState) {
        FileImpl startFile;
        FileImpl fileImpl = startFile = ppState == null ? null : Utils.getStartFile(ppState);
        if (startFile != null && startFile != this) {
            return startFile.getLanguageFilter(null);
        }
        return APTLanguageSupport.getInstance().getFilter(this.getFileLanguage(), this.getFileLanguageFlavor());
    }

    public String getFileLanguage() {
        return Utils.getLanguage(this.fileType, ((Object)this.getAbsolutePath()).toString());
    }

    public String getFileLanguageFlavor() {
        if ("Fortran Language".equals(this.getFileLanguage())) {
            try {
                return CndLexerUtilities.detectFortranFormat((CharSequence)this.getBuffer().getText()) == CndLexerUtilities.FortranFormat.FIXED ? "Fortran Fixed" : "Fortran Free";
            }
            catch (IOException ex) {
                return "Fortran Free";
            }
        }
        if (CndTraceFlags.LANGUAGE_FLAVOR_CPP11) {
            return "C++11";
        }
        NativeFileItem nativeFileItem = this.getNativeFileItem();
        if (nativeFileItem != null) {
            return Utils.getLanguageFlavor(nativeFileItem.getLanguageFlavor());
        }
        return "";
    }

    public APTPreprocHandler getPreprocHandler(int offset) {
        PreprocessorStatePair bestStatePair = this.getContextPreprocStatePair(offset, offset);
        return this.getPreprocHandler(bestStatePair);
    }

    private APTPreprocHandler getPreprocHandler(PreprocessorStatePair statePair) {
        if (statePair == null) {
            return null;
        }
        ProjectBase projectImpl = this.getProjectImpl(true);
        if (projectImpl == null) {
            return null;
        }
        return projectImpl.getPreprocHandler(this.fileBuffer.getAbsolutePath(), statePair);
    }

    public Collection<APTPreprocHandler> getPreprocHandlersForParse() {
        ProjectBase projectImpl = this.getProjectImpl(true);
        return projectImpl == null ? Collections.emptyList() : projectImpl.getPreprocHandlersForParse(this);
    }

    public Collection<PreprocessorStatePair> getPreprocStatePairs() {
        ProjectBase projectImpl = this.getProjectImpl(true);
        if (projectImpl == null) {
            return Collections.emptyList();
        }
        return projectImpl.getPreprocessorStatePairs(this);
    }

    public Collection<APTPreprocHandler> getFileContainerOwnPreprocHandlersToDump() {
        ProjectBase projectImpl = this.getProjectImpl(true);
        return projectImpl == null ? Collections.emptyList() : projectImpl.getFileContainerPreprocHandlersToDump(this.getAbsolutePath());
    }

    public Collection<PreprocessorStatePair> getFileContainerOwnPreprocessorStatePairsToDump() {
        ProjectBase projectImpl = this.getProjectImpl(true);
        if (projectImpl == null) {
            return Collections.emptyList();
        }
        return projectImpl.getFileContainerStatePairsToDump(this.getAbsolutePath());
    }

    private PreprocessorStatePair getContextPreprocStatePair(int startContext, int endContext) {
        ProjectBase projectImpl = this.getProjectImpl(true);
        if (projectImpl == null) {
            return null;
        }
        Collection<PreprocessorStatePair> preprocStatePairs = projectImpl.getPreprocessorStatePairs(this);
        for (PreprocessorStatePair statePair : preprocStatePairs) {
            if (!statePair.pcState.isInActiveBlock(startContext, endContext)) continue;
            return statePair;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBuffer(FileBuffer fileBuffer) {
        Object object = this.changeStateLock;
        synchronized (object) {
            this.fileBuffer = fileBuffer;
            if (this.state != State.INITIAL || this.parsingState != ParsingState.NOT_BEING_PARSED) {
                if (reportParse || logState || TraceFlags.DEBUG || TraceFlags.TRACE_191307_BUG) {
                    System.err.printf("#setBuffer changing to MODIFIED %s is %s with current state %s %s\n", new Object[]{this.getAbsolutePath(), this.fileType, this.state, this.parsingState});
                }
                this.state = State.MODIFIED;
                this.postMarkedAsModified();
            }
        }
    }

    private void postMarkedAsModified() {
        assert (Thread.holdsLock(this.changeStateLock)) : "must be called under changeStateLock";
        this.tsRef.clear();
        if (this.parsingState == ParsingState.BEING_PARSED) {
            this.parsingState = ParsingState.MODIFIED_WHILE_BEING_PARSED;
        }
    }

    public FileBuffer getBuffer() {
        return this.fileBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void ensureParsed(Collection<APTPreprocHandler> handlers) {
        block92: {
            if (TraceFlags.PARSE_HEADERS_WITH_SOURCES && this.isHeaderFile()) {
                return;
            }
            try {
                if (this.inEnsureParsed.incrementAndGet() != 1) if (!FileImpl.$assertionsDisabled) {
                    throw new AssertionError((Object)("concurrent ensureParsed in file " + this.getAbsolutePath() + (Object)this.parsingState + (Object)this.state));
                }
                modelState = ModelImpl.instance().getState();
                if (modelState == CsmModelState.CLOSING || modelState == CsmModelState.OFF) {
                    if (TraceFlags.TRACE_VALIDATION || TraceFlags.TRACE_MODEL_STATE) {
                        System.err.printf("ensureParsed: %s file is interrupted on closing model\n", new Object[]{this.getAbsolutePath()});
                    }
                    var3_3 = this.changeStateLock;
                    synchronized (var3_3) {
                        this.state = State.INITIAL;
                    }
                    RepositoryUtils.put(this);
                    return;
                }
                newSignature = null;
                oldSignature = null;
                tryPartialReparse = handlers == FileImpl.PARTIAL_REPARSE_HANDLERS;
                v0 = triggerParsingActivity = handlers != FileImpl.DUMMY_HANDLERS;
                if (handlers == FileImpl.DUMMY_HANDLERS || handlers == FileImpl.PARTIAL_REPARSE_HANDLERS) {
                    handlers = this.getPreprocHandlersForParse();
                }
                var9_10 = this.stateLock;
                synchronized (var9_10) {
                    block91: {
                        block90: {
                            var11_11 = this.changeStateLock;
                            synchronized (var11_11) {
                                curState = this.state;
                                this.parsingState = ParsingState.BEING_PARSED;
                            }
                            if ((FileImpl.reportParse || FileImpl.logState || TraceFlags.DEBUG) && FileImpl.traceFile(this.getAbsolutePath())) {
                                System.err.printf("#ensureParsed %s is %s, has %d handlers, state %s %s triggerParsingActivity=%s\n", new Object[]{this.getAbsolutePath(), this.fileType, handlers.size(), curState, this.parsingState, triggerParsingActivity});
                                i = 0;
                                for (APTPreprocHandler aPTPreprocHandler : handlers) {
                                    this.logParse("EnsureParsed handler " + i++, aPTPreprocHandler);
                                }
                            }
                            if ((fullAPT = this.getFileAPT(true)) != null) break block90;
                            i$ = this.changeStateLock;
                            synchronized (i$) {
                                this.parsingState = ParsingState.NOT_BEING_PARSED;
                            }
                            return;
                        }
                        if (CndTraceFlags.TEXT_INDEX) {
                            aptIndexingWalker = new APTIndexingWalker(fullAPT, this.getTextIndexKey(), this.getProjectImpl(true).getCacheLocation());
                            aptIndexingWalker.index();
                        }
                        switch (5.$SwitchMap$org$netbeans$modules$cnd$modelimpl$csm$core$FileImpl$State[curState.ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                if (TraceFlags.TIMING_PARSE_PER_FILE_FLAT && curState == State.PARSED) {
                                    System.err.printf("additional parse with PARSED state " + (Object)this.parsingState + "for %s\n", new Object[]{this.getAbsolutePath()});
                                }
                                time = System.currentTimeMillis();
                                try {
                                    parseParams = new ParseDescriptor(this, fullAPT, null, false, triggerParsingActivity);
                                    for (APTPreprocHandler preprocHandler : handlers) {
                                        ParseDescriptor.access$200((ParseDescriptor)parseParams, preprocHandler);
                                        this._parse((ParseDescriptor)parseParams);
                                        if (this.parsingState != ParsingState.MODIFIED_WHILE_BEING_PARSED) continue;
                                        break;
                                    }
                                    this.updateModelAfterParsing((ParseDescriptor)parseParams);
                                }
                                finally {
                                    this.postParse();
                                    parseParams = this.changeStateLock;
                                    synchronized (parseParams) {
                                        if (this.parsingState == ParsingState.BEING_PARSED) {
                                            this.state = State.PARSED;
                                        }
                                    }
                                    this.postParseNotify();
                                    this.lastParseTime = (int)(System.currentTimeMillis() - time);
                                }
                                if (TraceFlags.DUMP_PARSE_RESULTS) {
                                    new CsmTracer().dumpModel((CsmFile)this);
                                    ** break;
                                }
lbl93:
                                // 3 sources

                                break block91;
                            }
                            case 4: {
                                first = true;
                                time = System.currentTimeMillis();
                                try {
                                    parseParams = new ParseDescriptor(this, fullAPT, null, true, triggerParsingActivity);
                                    if (this.lastFileBasedSignature == null && (tryPartialReparse || !this.fileBuffer.isFileBased())) {
                                        this.lastFileBasedSignature = FileContentSignature.create(this);
                                    }
                                    for (APTPreprocHandler preprocHandler : handlers) {
                                        ParseDescriptor.access$200(parseParams, preprocHandler);
                                        if (first) {
                                            this._reparse(parseParams);
                                            first = false;
                                        } else {
                                            this._parse(parseParams);
                                        }
                                        if (this.parsingState != ParsingState.MODIFIED_WHILE_BEING_PARSED) continue;
                                        break;
                                    }
                                    this.updateModelAfterParsing(parseParams);
                                    if (tryPartialReparse) {
                                        if (!FileImpl.$assertionsDisabled && this.lastFileBasedSignature == null) {
                                            throw new AssertionError();
                                        }
                                        newSignature = FileContentSignature.create(this);
                                        oldSignature = this.lastFileBasedSignature;
                                        this.lastFileBasedSignature = null;
                                    }
                                }
                                finally {
                                    this.postParse();
                                    var13_18 = this.changeStateLock;
                                    synchronized (var13_18) {
                                        if (this.parsingState == ParsingState.BEING_PARSED) {
                                            this.state = State.PARSED;
                                        }
                                    }
                                    this.postParseNotify();
                                    this.lastParseTime = (int)(System.currentTimeMillis() - time);
                                }
                                if (TraceFlags.DUMP_PARSE_RESULTS || TraceFlags.DUMP_REPARSE_RESULTS) {
                                    new CsmTracer().dumpModel((CsmFile)this);
                                    ** break;
                                }
lbl135:
                                // 3 sources

                                break block91;
                            }
                            default: {
                                System.err.println("unexpected state in ensureParsed " + (Object)curState);
                                break block91;
                            }
                        }
                        {
                            catch (Throwable var25_35) {
                                throw var25_35;
                            }
                        }
                        finally {
                            var10_14 = this.changeStateLock;
                            synchronized (var10_14) {
                                this.parsingState = ParsingState.NOT_BEING_PARSED;
                            }
                        }
                    }
                }
                modelState = ModelImpl.instance().getState();
                if (modelState == CsmModelState.CLOSING || modelState == CsmModelState.OFF) {
                    if (TraceFlags.TRACE_VALIDATION || TraceFlags.TRACE_MODEL_STATE) {
                        System.err.printf("after ensureParsed: %s file is interrupted on closing model\n", new Object[]{this.getAbsolutePath()});
                    }
                    var9_10 = this.changeStateLock;
                    synchronized (var9_10) {
                        this.state = State.INITIAL;
                    }
                    RepositoryUtils.put(this);
                    break block92;
                }
                if (tryPartialReparse && newSignature != null) {
                    if (!FileImpl.$assertionsDisabled && oldSignature == null) {
                        throw new AssertionError();
                    }
                    DeepReparsingUtils.finishPartialReparse(this, oldSignature, newSignature);
                }
            }
            finally {
                if (this.inEnsureParsed.decrementAndGet() != 0) {
                    CndUtils.assertTrueInConsole((boolean)false, (String)("broken state in file " + this.getAbsolutePath() + (Object)this.parsingState + (Object)this.state));
                }
                var3_3 = this.stateLock;
                synchronized (var3_3) {
                    this.stateLock.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureParsedOnInclusion(Collection<APTPreprocHandler> handlers, CsmParserProvider.CsmParseCallback semaHandler) {
        block47: {
            Object object;
            try {
                Object object2;
                CsmModelState modelState = ModelImpl.instance().getState();
                if (modelState == CsmModelState.CLOSING || modelState == CsmModelState.OFF) {
                    if (TraceFlags.TRACE_VALIDATION || TraceFlags.TRACE_MODEL_STATE) {
                        System.err.printf("ensureParsed: %s file is interrupted on closing model\n", this.getAbsolutePath());
                    }
                    object = this.changeStateLock;
                    synchronized (object) {
                        this.state = State.INITIAL;
                    }
                    RepositoryUtils.put(this);
                    return;
                }
                assert (handlers != DUMMY_HANDLERS) : "dummy handlers can not be on inclusion";
                assert (handlers != PARTIAL_REPARSE_HANDLERS) : "dummy reparse handlers can not be on inclusion";
                APTFile fullAPT = this.getFileAPT(true);
                if (fullAPT == null) {
                    return;
                }
                long time = System.currentTimeMillis();
                try {
                    State curState;
                    int parseLevel;
                    Object object3 = this.changeStateLock;
                    synchronized (object3) {
                        parseLevel = this.inEnsureParsed.incrementAndGet();
                        curState = this.state;
                        this.parsingState = ParsingState.BEING_PARSED;
                    }
                    if (parseLevel > 1 && TraceFlags.TIMING_PARSE_PER_FILE_FLAT) {
                        System.err.printf(parseLevel + (curState == State.PARSED ? " additional " : " ") + "include parse with curState " + (Object)((Object)curState) + "for %s\n", this.getAbsolutePath());
                    }
                    ParseDescriptor parseParams = new ParseDescriptor(this, fullAPT, semaHandler, false, false);
                    for (APTPreprocHandler preprocHandler : handlers) {
                        parseParams.setCurrentPreprocHandler(preprocHandler);
                        this._parse(parseParams);
                        if (this.parsingState != ParsingState.MODIFIED_WHILE_BEING_PARSED) continue;
                        break;
                    }
                    this.updateModelAfterParsing(parseParams);
                }
                finally {
                    object2 = this.changeStateLock;
                    synchronized (object2) {
                        int val = this.inEnsureParsed.decrementAndGet();
                        if (val < 0) assert (false) : "broken state in file " + this.getAbsolutePath() + (Object)((Object)this.parsingState) + (Object)((Object)this.state);
                        if (val == 0) {
                            if (this.parsingState == ParsingState.BEING_PARSED) {
                                this.state = State.PARSED;
                            }
                            this.parsingState = ParsingState.NOT_BEING_PARSED;
                        }
                    }
                    this.lastParseTime = (int)(System.currentTimeMillis() - time);
                    this.postParse();
                    this.postParseNotify();
                }
                modelState = ModelImpl.instance().getState();
                if (modelState != CsmModelState.CLOSING && modelState != CsmModelState.OFF) break block47;
                if (TraceFlags.TRACE_VALIDATION || TraceFlags.TRACE_MODEL_STATE) {
                    System.err.printf("after ensureParsed: %s file is interrupted on closing model\n", this.getAbsolutePath());
                }
                object2 = this.changeStateLock;
                synchronized (object2) {
                    this.state = State.INITIAL;
                }
                RepositoryUtils.put(this);
            }
            finally {
                object = this.stateLock;
                synchronized (object) {
                    this.stateLock.notifyAll();
                }
            }
        }
    }

    private void postParse() {
        if (this.isValid()) {
            RepositoryUtils.put(this);
        }
        if (this.isValid()) {
            this.getProjectImpl(true).getGraph().putFile(this);
        }
    }

    private void postParseNotify() {
        if (this.isValid()) {
            Notificator.instance().registerChangedFile(this);
            Notificator.instance().flush();
        } else {
            Notificator.instance().reset();
        }
    }

    void onProjectParseFinished(boolean prjLibsAlreadyParsed) {
        if (this.fixFakeRegistrations(true)) {
            if (this.isValid()) {
                RepositoryUtils.put(this);
            }
            if (this.isValid()) {
                Notificator.instance().registerChangedFile(this);
                Notificator.instance().flush();
                ProgressSupport.instance().fireFileParsingFinished(this);
            } else {
                Notificator.instance().reset();
            }
        }
    }

    int getLastParseTime() {
        return this.lastParseTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validate() {
        Object object = this.changeStateLock;
        synchronized (object) {
            if (this.state == State.PARSED) {
                long lastModified = this.getBuffer().lastModified();
                if ((TraceFlags.USE_CURR_PARSE_TIME ? lastModified > this.lastParsed : lastModified != this.lastParsed) && this.lastParsedCRC != this.getBuffer().getCRC()) {
                    if (TraceFlags.TRACE_VALIDATION || TraceFlags.TRACE_191307_BUG) {
                        System.err.printf("VALIDATED %s\n\t lastModified=%d\n\t   lastParsed=%d\n", this.getAbsolutePath(), lastModified, this.lastParsed);
                    }
                    if (reportParse || logState || TraceFlags.DEBUG) {
                        System.err.printf("#validate changing to MODIFIED %s is %s with current state %s %s\n", new Object[]{this.getAbsolutePath(), this.fileType, this.state, this.parsingState});
                    }
                    this.state = State.MODIFIED;
                    this.postMarkedAsModified();
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markReparseNeeded(boolean invalidateCache) {
        Object object = this.changeStateLock;
        synchronized (object) {
            if (reportParse || logState || TraceFlags.DEBUG || TraceFlags.TRACE_191307_BUG) {
                System.err.printf("#markReparseNeeded %s is %s with current state %s, %s\n", new Object[]{this.getAbsolutePath(), this.fileType, this.state, this.parsingState});
                if (TraceFlags.TRACE_191307_BUG) {
                    new Exception("markReparseNeeded is called").printStackTrace(System.err);
                }
            }
            if (this.state != State.INITIAL || this.parsingState != ParsingState.NOT_BEING_PARSED) {
                this.state = State.MODIFIED;
                this.postMarkedAsModified();
            }
            if (invalidateCache) {
                FileBuffer buf = this.getBuffer();
                APTDriver.invalidateAPT((APTFileBuffer)buf);
                APTFileCacheManager.getInstance((FileSystem)buf.getFileSystem()).invalidate(buf.getAbsolutePath());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markMoreParseNeeded() {
        Object object = this.changeStateLock;
        synchronized (object) {
            if (reportParse || logState || TraceFlags.DEBUG) {
                System.err.printf("#markMoreParseNeeded %s is %s with current state %s, %s\n", new Object[]{this.getAbsolutePath(), this.fileType, this.state, this.parsingState});
            }
            switch (this.state) {
                case PARSED: {
                    this.state = State.PARTIAL;
                    break;
                }
            }
        }
    }

    public final int getErrorCount() {
        this.checkNotInParsingThreadImpl();
        return this.currentFileContent.getErrorCount();
    }

    public void parseOnInclude(APTPreprocHandler.State stateBefore, CsmParserProvider.CsmParseCallback semaHandler) {
        assert (stateBefore != null);
        assert (!stateBefore.isCleaned()) : "have to be not cleaned state";
        ProjectBase prj = this.getProjectImpl(true);
        if (prj == null) {
            return;
        }
        APTPreprocHandler preprocHandler = prj.createPreprocHandlerFromState(this.getAbsolutePath(), stateBefore);
        if (preprocHandler == null) {
            return;
        }
        this.ensureParsedOnInclusion(Collections.singletonList(preprocHandler), semaHandler);
    }

    public APTFile getFileAPT(boolean full) {
        CharSequence guardMacro;
        APTFile fileAPT = null;
        FileBufferDoc.ChangedSegment changedSegment = null;
        try {
            fileAPT = full ? APTDriver.findAPT((APTFileBuffer)this.getBuffer(), (String)this.getFileLanguage(), (String)this.getFileLanguageFlavor()) : APTDriver.findAPTLight((APTFileBuffer)this.getBuffer());
            if (this.getBuffer() instanceof FileBufferDoc) {
                changedSegment = ((FileBufferDoc)this.getBuffer()).getLastChangedSegment();
            }
        }
        catch (FileNotFoundException ex) {
            APTUtils.LOG.log(Level.WARNING, "FileImpl: file {0} not found, probably removed", new Object[]{this.getBuffer().getAbsolutePath()});
        }
        catch (IOException ex) {
            DiagnosticExceptoins.register(ex);
        }
        if (fileAPT != null && APTUtils.LOG.isLoggable(Level.FINE) && (guardMacro = fileAPT.getGuardMacro()).length() == 0 && !this.isSourceFile()) {
            APTUtils.LOG.log(Level.FINE, "FileImpl: file {0} does not have guard", new Object[]{this.getBuffer().getAbsolutePath()});
        }
        return fileAPT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _reparse(ParseDescriptor parseParams) {
        this.parsingFileContentRef.get().set(parseParams.content);
        try {
            if (TraceFlags.DEBUG) {
                Diagnostic.trace("------ reparsing " + this.fileBuffer.getUrl());
            }
            Object object = this.snapShotLock;
            synchronized (object) {
                this.fileSnapshot = new FileSnapshot(this);
            }
            if (reportParse || logState || TraceFlags.DEBUG) {
                this.logParse("ReParsing", parseParams.getCurrentPreprocHandler());
            }
            this.disposeAll(false);
            CsmParserProvider.CsmParserResult parsing = this.doParse(parseParams);
            if (parsing != null && this.isValid()) {
                parsing.render(parseParams);
            }
            this.fileSnapshot = null;
        }
        finally {
            this.parsingFileContentRef.get().set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CsmFile getSnapshot() {
        Object object = this.snapShotLock;
        synchronized (object) {
            FileSnapshot res = this.fileSnapshot;
            if (res != null) {
                return res;
            }
            return new FileSnapshot(this);
        }
    }

    @Override
    public void dispose() {
        this.disposed = true;
        this.onDispose();
        Notificator.instance().registerRemovedFile(this);
        this.disposeAll(true);
    }

    public void onProjectClose() {
        this.onDispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onDispose() {
        RepositoryUtils.disposeUID(this.uid, this);
        this.projectLock.writeLock().lock();
        try {
            if (this.projectRef == null) {
                this.projectRef = (ProjectBase)UIDCsmConverter.UIDtoProject(this.projectUID);
                assert (this.projectRef != null || this.projectUID == null) : "empty project for UID " + this.projectUID;
            }
        }
        finally {
            this.projectLock.writeLock().unlock();
        }
    }

    private void disposeAll(boolean clearNonDisposable) {
        Collection uids = this.currentFileContent.cleanDeclarations();
        this.clearFakeRegistrations();
        this.hasBrokenIncludes.set(false);
        if (clearNonDisposable) {
            this.currentFileContent.cleanOther();
        }
        this.currentFileContent.put();
        Collection arr = UIDCsmConverter.UIDsToDeclarations(uids);
        Utils.disposeAll(arr);
        RepositoryUtils.remove(uids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AST debugParse() {
        Collection<APTPreprocHandler> handlers = this.getFileContainerOwnPreprocHandlersToDump();
        if (handlers.isEmpty()) {
            return null;
        }
        APTFile fullAPT = this.getFileAPT(true);
        ParseDescriptor params = new ParseDescriptor(this, fullAPT, null, false, false, false);
        params.setCurrentPreprocHandler(handlers.iterator().next());
        Object object = this.stateLock;
        synchronized (object) {
            CsmParserProvider.CsmParserResult parsing = this._parse(params);
            Object ast = parsing.getAST();
            if (ast instanceof AST) {
                return (AST)ast;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmParserProvider.CsmParserResult _parse(ParseDescriptor parseParams) {
        this.parsingFileContentRef.get().set(parseParams.content);
        try {
            Diagnostic.StopWatch sw;
            Diagnostic.StopWatch stopWatch = sw = TraceFlags.TIMING_PARSE_PER_FILE_DEEP ? new Diagnostic.StopWatch() : null;
            if (reportParse || logState || TraceFlags.DEBUG) {
                this.logParse("Parsing", parseParams.getCurrentPreprocHandler());
            }
            CsmParserProvider.CsmParserResult parsing = this.doParse(parseParams);
            if (TraceFlags.TIMING_PARSE_PER_FILE_DEEP) {
                sw.stopAndReport("Parsing of " + this.fileBuffer.getUrl() + " took \t");
            }
            if (parsing != null) {
                Diagnostic.StopWatch sw2;
                Diagnostic.StopWatch stopWatch2 = sw2 = TraceFlags.TIMING_PARSE_PER_FILE_DEEP ? new Diagnostic.StopWatch() : null;
                if (this.isValid()) {
                    parsing.render(parseParams);
                    if (TraceFlags.TIMING_PARSE_PER_FILE_DEEP) {
                        sw2.stopAndReport("Rendering of " + this.fileBuffer.getUrl() + " took \t");
                    }
                }
            }
            CsmParserProvider.CsmParserResult csmParserResult = parsing;
            return csmParserResult;
        }
        finally {
            this.parsingFileContentRef.get().set(null);
        }
    }

    private void logParse(String title, APTPreprocHandler preprocHandler) {
        if (reportParse || logState || TraceFlags.DEBUG) {
            System.err.printf("# %s %s \n#\t(%s %s %s) \n#\t(Thread=%s)\n", title, this.fileBuffer.getUrl(), TraceUtils.getPreprocStateString(preprocHandler.getState()), TraceUtils.getMacroString(preprocHandler, TraceFlags.logMacros), TraceUtils.getPreprocStartEntryString(preprocHandler.getState()), Thread.currentThread().getName());
            if (logState) {
                System.err.printf("%s\n\n", preprocHandler.getState());
            }
        }
    }

    private boolean createAndCacheFullTokenStream(int startContext, int endContext, FileTokenStreamCache tsCache) {
        PreprocessorStatePair bestStatePair = this.getContextPreprocStatePair(startContext, endContext);
        APTPreprocHandler preprocHandler = this.getPreprocHandler(bestStatePair);
        if (preprocHandler == null) {
            return false;
        }
        APTPreprocHandler.State ppState = preprocHandler.getState();
        AtomicReference<Object> cacheEntry = new AtomicReference<Object>(null);
        AtomicReference<Object> pcBuilder = new AtomicReference<Object>(null);
        TokenStream tokenStream = this.createParsingTokenStreamForHandler(preprocHandler, false, cacheEntry, pcBuilder);
        if (tokenStream == null) {
            return false;
        }
        APTLanguageFilter languageFilter = this.getLanguageFilter(ppState);
        tsCache.addNewPair(pcBuilder.get(), tokenStream, languageFilter);
        this.setAPTCacheEntry(preprocHandler, cacheEntry.get(), false);
        return true;
    }

    private TokenStream createParsingTokenStreamForHandler(APTPreprocHandler preprocHandler, boolean filtered, AtomicReference<APTFileCacheEntry> cacheOut, AtomicReference<FilePreprocessorConditionState.Builder> pcBuilderOut) {
        APTFile apt = this.getFileAPT(true);
        if (apt == null) {
            return null;
        }
        if (preprocHandler == null) {
            return null;
        }
        APTPreprocHandler.State ppState = preprocHandler.getState();
        ProjectBase startProject = Utils.getStartProject(ppState);
        if (startProject == null) {
            System.err.println(" null project for " + APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)ppState) + "\n while getting TS of file " + this.getAbsolutePath() + "\n of project " + this.getProject());
            return null;
        }
        FilePreprocessorConditionState.Builder pcBuilder = new FilePreprocessorConditionState.Builder(this.getAbsolutePath());
        if (pcBuilderOut != null) {
            pcBuilderOut.set(pcBuilder);
        }
        APTFileCacheEntry cacheEntry = this.getAPTCacheEntry(preprocHandler, Boolean.FALSE);
        if (cacheOut != null) {
            cacheOut.set(cacheEntry);
        }
        APTParseFileWalker walker = new APTParseFileWalker(startProject, apt, this, preprocHandler, false, pcBuilder, cacheEntry);
        return walker.getTokenStream(filtered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TokenStream getTokenStream(int startContextOffset, int endContextOffset, int firstTokenIDIfExpandMacros, boolean filtered) {
        boolean trace = false;
        FileTokenStreamCache cache = this.tsRef.get();
        TokenStream stream = cache == null ? null : cache.getTokenStreamInActiveBlock(filtered, startContextOffset, endContextOffset, firstTokenIDIfExpandMacros);
        if (stream != null) {
            if (trace) {
                System.err.printf("found for %s %s stream [%d-%d]\n", this.getAbsolutePath(), filtered ? "filtered" : "", startContextOffset, endContextOffset);
            }
        } else {
            Object object = this.tokStreamLock;
            synchronized (object) {
                cache = this.tsRef.get();
                if (cache == null) {
                    cache = new FileTokenStreamCache();
                    this.tsRef = new WeakReference<FileTokenStreamCache>(cache);
                } else {
                    stream = cache.getTokenStreamInActiveBlock(filtered, startContextOffset, endContextOffset, firstTokenIDIfExpandMacros);
                }
                if (stream == null) {
                    if (trace) {
                        System.err.printf("creating for %s %s stream [%d-%d]\n", this.getAbsolutePath(), filtered ? "filtered" : "", startContextOffset, endContextOffset);
                    }
                    if (this.createAndCacheFullTokenStream(startContextOffset, endContextOffset, cache)) {
                        stream = cache.getTokenStreamInActiveBlock(filtered, startContextOffset, endContextOffset, firstTokenIDIfExpandMacros);
                    }
                } else if (trace) {
                    System.err.printf("found for just cached %s %s stream [%d-%d]\n", this.getAbsolutePath(), filtered ? "filtered" : "", startContextOffset, endContextOffset);
                }
            }
        }
        return stream;
    }

    private TokenStream getTokenStreamOfIncludedFile(CsmInclude include) {
        FileImpl file = (FileImpl)include.getIncludeFile();
        if (file != null && file.isValid()) {
            PreprocessorStatePair includeContextPair = this.getContextPreprocStatePair(include.getStartOffset(), include.getEndOffset());
            if (includeContextPair == null) {
                return file.getTokenStream(0, Integer.MAX_VALUE, 0, true);
            }
            APTPreprocHandler.State thisFileStartState = includeContextPair.state;
            LinkedList reverseInclStack = APTHandlersSupport.extractIncludeStack((APTPreprocHandler.State)thisFileStartState);
            reverseInclStack.addLast(new IncludeInfoImpl(include, file.getAbsolutePath()));
            ProjectBase projectImpl = this.getProjectImpl(true);
            if (projectImpl == null) {
                return file.getTokenStream(0, Integer.MAX_VALUE, 0, true);
            }
            APTPreprocHandler preprocHandler = projectImpl.createEmptyPreprocHandler(this.getAbsolutePath());
            APTPreprocHandler restorePreprocHandlerFromIncludeStack = projectImpl.restorePreprocHandlerFromIncludeStack(reverseInclStack, this.getAbsolutePath(), preprocHandler, thisFileStartState);
            TokenStream includedFileTS = file.createParsingTokenStreamForHandler(restorePreprocHandlerFromIncludeStack, true, null, null);
            if (includedFileTS != null) {
                APTLanguageFilter languageFilter = file.getLanguageFilter(thisFileStartState);
                return languageFilter.getFilteredStream(includedFileTS);
            }
        }
        return null;
    }

    public void getErrors(ErrorListener errorListener) {
        ArrayList<CsmParserProvider.ParserError> parserErrors = new ArrayList<CsmParserProvider.ParserError>();
        this.getErrors(parserErrors);
        for (CsmParserProvider.ParserError e : parserErrors) {
            errorListener.error(e.message, e.line, e.column);
        }
    }

    public final APTFileCacheEntry getAPTCacheEntry(APTPreprocHandler preprocHandler, Boolean createExclusiveIfAbsent) {
        if (!TraceFlags.APT_FILE_CACHE_ENTRY) {
            return null;
        }
        APTFileCacheEntry out = APTFileCacheManager.getInstance((FileSystem)this.getBuffer().getFileSystem()).getEntry(this.getAbsolutePath(), preprocHandler, createExclusiveIfAbsent);
        assert (createExclusiveIfAbsent == null || out != null);
        return out;
    }

    public final void setAPTCacheEntry(APTPreprocHandler preprocHandler, APTFileCacheEntry entry, boolean cleanOthers) {
        if (TraceFlags.APT_FILE_CACHE_ENTRY) {
            FileBuffer buf = this.getBuffer();
            APTFileCacheManager.getInstance((FileSystem)buf.getFileSystem()).setAPTCacheEntry(buf.getAbsolutePath(), preprocHandler, entry, cleanOthers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ReadOnlyTokenBuffer getErrors(final Collection<CsmParserProvider.ParserError> result) {
        long time;
        block8: {
            ParserBasedTokenBuffer parserBasedTokenBuffer;
            TokenStream tokenStream;
            int flags;
            CsmParserProvider.ParserErrorDelegate delegate;
            block9: {
                delegate = new CsmParserProvider.ParserErrorDelegate(){

                    @Override
                    public void onError(CsmParserProvider.ParserError e) {
                        result.add(e);
                    }
                };
                if (TraceFlags.TRACE_ERROR_PROVIDER) {
                    System.err.printf("\n\n>>> Start parsing (getting errors) %s \n", this.getName());
                }
                time = TraceFlags.TRACE_ERROR_PROVIDER ? System.currentTimeMillis() : 0L;
                flags = 8;
                if (!TraceFlags.TRACE_ERROR_PROVIDER) {
                    flags |= 4;
                }
                tokenStream = this.getTokenStream(0, Integer.MAX_VALUE, 0, true);
                if (tokenStream == null) break block8;
                if (!TraceFlags.CPP_PARSER_NEW_GRAMMAR) break block9;
                CsmProject project = this.getProject();
                if (this.parsingErrors != null) {
                    result.addAll(this.parsingErrors);
                }
                ParserBasedTokenBuffer parserBasedTokenBuffer2 = new ParserBasedTokenBuffer(null);
                if (!TraceFlags.TRACE_ERROR_PROVIDER) return parserBasedTokenBuffer2;
                System.err.printf("<<< Done parsing (getting errors) %s %d ms\n\n\n", this.getName(), System.currentTimeMillis() - time);
                return parserBasedTokenBuffer2;
            }
            try {
                CPPParserEx parser = CPPParserEx.getInstance(this, tokenStream, flags);
                parser.setErrorDelegate(delegate);
                parser.setLazyCompound(false);
                parser.translation_unit();
                parserBasedTokenBuffer = new ParserBasedTokenBuffer((Parser)parser);
                if (!TraceFlags.TRACE_ERROR_PROVIDER) return parserBasedTokenBuffer;
            }
            catch (Throwable ex) {
                try {
                    System.err.println(ex.getClass().getName() + " at parsing file " + this.fileBuffer.getAbsolutePath());
                    if (!TraceFlags.TRACE_ERROR_PROVIDER) return null;
                }
                catch (Throwable throwable) {
                    if (!TraceFlags.TRACE_ERROR_PROVIDER) throw throwable;
                    System.err.printf("<<< Done parsing (getting errors) %s %d ms\n\n\n", this.getName(), System.currentTimeMillis() - time);
                    throw throwable;
                }
                System.err.printf("<<< Done parsing (getting errors) %s %d ms\n\n\n", this.getName(), System.currentTimeMillis() - time);
                return null;
            }
            System.err.printf("<<< Done parsing (getting errors) %s %d ms\n\n\n", this.getName(), System.currentTimeMillis() - time);
            return parserBasedTokenBuffer;
        }
        if (!TraceFlags.TRACE_ERROR_PROVIDER) return null;
        System.err.printf("<<< Done parsing (getting errors) %s %d ms\n\n\n", this.getName(), System.currentTimeMillis() - time);
        return null;
    }

    private CsmParserProvider.CsmParserResult doParse(ParseDescriptor parseParams) {
        Hook aHook;
        if (reportErrors && !ParserThreadManager.instance().isParserThread() && !ParserThreadManager.instance().isStandalone()) {
            String text = "Reparsing should be done only in a special Code Model Thread!!!";
            Diagnostic.trace(text);
            new Throwable(text).printStackTrace(System.err);
        }
        APTPreprocHandler preprocHandler = parseParams.getCurrentPreprocHandler();
        APTFile aptFull = parseParams.fullAPT;
        assert (preprocHandler != null);
        if (preprocHandler == null) {
            return null;
        }
        ParseStatistics.getInstance().fileParsed(this, preprocHandler);
        CsmParserProvider.CsmParserResult parseResult = null;
        if (aptFull != null) {
            APTPreprocHandler.State ppState;
            ProjectBase startProject;
            if (TraceFlags.TRACE_CACHE) {
                System.err.println("CACHE: parsing using full APT for " + this.getAbsolutePath());
            }
            if ((startProject = Utils.getStartProject(ppState = preprocHandler.getState())) == null) {
                System.err.println(" null project for " + APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)ppState) + "\n while parsing file " + this.getAbsolutePath() + "\n of project " + this.getProject());
                return null;
            }
            FilePreprocessorConditionState.Builder pcBuilder = new FilePreprocessorConditionState.Builder(this.getAbsolutePath());
            APTFileCacheEntry aptCacheEntry = this.getAPTCacheEntry(preprocHandler, Boolean.FALSE);
            APTParseFileWalker walker = new APTParseFileWalker(startProject, aptFull, this, preprocHandler, parseParams.triggerParsingActivity, pcBuilder, aptCacheEntry);
            walker.setFileContent(parseParams.content);
            if (TraceFlags.DEBUG) {
                System.err.println("doParse " + this.getAbsolutePath() + " with " + ParserQueue.tracePreprocState(ppState));
            }
            TokenStream filteredTokenStream = walker.getFilteredTokenStream(this.getLanguageFilter(ppState));
            long time = emptyAstStatictics ? System.currentTimeMillis() : 0L;
            CsmParserProvider.CsmParser parser = CsmParserProvider.createParser(parseParams);
            assert (parser != null) : "no parser for " + this;
            parser.init(this, filteredTokenStream, parseParams.callback);
            if (TraceFlags.CPP_PARSER_NEW_GRAMMAR) {
                if (this.parsingErrors == null) {
                    this.parsingErrors = new ArrayList<CsmParserProvider.ParserError>();
                }
                this.parsingErrors.clear();
                CsmParserProvider.ParserErrorDelegate delegate = new CsmParserProvider.ParserErrorDelegate(){

                    @Override
                    public void onError(CsmParserProvider.ParserError e) {
                        FileImpl.this.parsingErrors.add(e);
                    }
                };
                parser.setErrorDelegate(delegate);
            }
            parseResult = parser.parse(parseParams.lazyCompound ? CsmParserProvider.CsmParser.ConstructionKind.TRANSLATION_UNIT : CsmParserProvider.CsmParser.ConstructionKind.TRANSLATION_UNIT_WITH_COMPOUND);
            FilePreprocessorConditionState pcState = pcBuilder.build();
            startProject.setParsedPCState(this, ppState, pcState);
            if (emptyAstStatictics) {
                time = System.currentTimeMillis() - time;
                boolean empty = parseResult.isEmptyAST();
                if (empty) {
                    System.err.println("PARSED FILE " + this.getAbsolutePath() + " HAS EMPTY AST" + ' ' + time + " ms");
                }
            }
            if (TraceFlags.DUMP_AST) {
                parseResult.dumpAST();
            }
            parseParams.content.setErrorCount(parseResult.getErrorCount());
            if (this.parsingState == ParsingState.MODIFIED_WHILE_BEING_PARSED) {
                parseResult = null;
                if (TraceFlags.TRACE_CACHE) {
                    System.err.println("CACHE: not save cache for file modified during parsing" + this.getAbsolutePath());
                }
            }
        }
        this.clearStateCache();
        this.lastParsed = this.fileBuffer.lastModified();
        this.lastParsedCRC = this.fileBuffer.getCRC();
        if (TraceFlags.USE_CURR_PARSE_TIME) {
            this.lastParsed = Math.max(System.currentTimeMillis(), this.fileBuffer.lastModified());
        }
        this.lastMacroUsages = null;
        if (TraceFlags.TRACE_VALIDATION) {
            System.err.printf("PARSED    %s \n\tlastModified=%d\n\t  lastParsed=%d  diff=%d\n", this.getAbsolutePath(), this.fileBuffer.lastModified(), this.lastParsed, this.fileBuffer.lastModified() - this.lastParsed);
        }
        if ((aHook = hook) != null) {
            aHook.parsingFinished(this, preprocHandler);
        }
        return parseResult;
    }

    public List<CsmReference> getLastMacroUsages() {
        Reference<List<CsmReference>> ref = this.lastMacroUsages;
        return ref != null ? ref.get() : null;
    }

    public void setLastMacroUsages(List<CsmReference> res) {
        this.lastMacroUsages = new SoftReference<List<CsmReference>>(Collections.unmodifiableList(res));
    }

    public long getLastParsedTime() {
        return this.lastParsed;
    }

    void updateModelAfterParsing(ParseDescriptor parseParams) {
        Map<CsmUID<FunctionImplEx<?>>, AST> fakeASTs = parseParams.content.getFakeASTs();
        ProjectBase projectImpl = this.getProjectImpl(true);
        CsmUID<CsmFile> thisFileUID = this.getUID();
        for (Map.Entry<CsmUID<FunctionImplEx<?>>, AST> entry : fakeASTs.entrySet()) {
            projectImpl.trackFakeFunctionAST(thisFileUID, entry.getKey(), entry.getValue());
        }
        this.hasBrokenIncludes.set(parseParams.content.hasBrokenIncludes());
        this.currentFileContent = parseParams.content.toWeakReferenceBasedCopy();
        this.currentFileContent.put();
        RepositoryUtils.put(this);
    }

    public void addInstantiation(CsmInstantiation inst) {
        this.getFileInstantiations().addInstantiation(inst);
    }

    public String getText(int start, int end) {
        try {
            return this.fileBuffer.getText(start, end);
        }
        catch (IOException e) {
            DiagnosticExceptoins.register(e);
            return "";
        }
    }

    public CharSequence getText() {
        try {
            return this.fileBuffer.getText();
        }
        catch (IOException e) {
            DiagnosticExceptoins.register(e);
            return "";
        }
    }

    public CsmProject getProject() {
        return this._getProject(false);
    }

    public CsmUID<CsmProject> getProjectUID() {
        return this.projectUID;
    }

    public ProjectBase getProjectImpl(boolean assertNotNull) {
        return this._getProject(assertNotNull);
    }

    public CharSequence getName() {
        return CharSequences.create((CharSequence)PathUtilities.getBaseName((String)((Object)this.getAbsolutePath()).toString()));
    }

    public Collection<CsmInclude> getIncludes() {
        this.checkNotInParsingThreadImpl();
        return this.getFileIncludes().getIncludes();
    }

    public Collection<CsmErrorDirective> getErrors() {
        this.checkNotInParsingThreadImpl();
        return new ArrayList<CsmErrorDirective>(this.currentFileContent.getErrors());
    }

    public Iterator<CsmInclude> getIncludes(CsmSelect.CsmFilter filter) {
        this.checkNotInParsingThreadImpl();
        return this.getFileIncludes().getIncludes(filter);
    }

    public Collection<CsmInclude> getBrokenIncludes() {
        this.checkNotInParsingThreadImpl();
        return this.getFileIncludes().getBrokenIncludes();
    }

    public boolean hasBrokenIncludes() {
        this.checkNotInParsingThreadImpl();
        return this.hasBrokenIncludes.get();
    }

    public Collection<CsmFunction> getStaticFunctionDeclarations() {
        return this.getFileDeclarations().getStaticFunctionDeclarations();
    }

    public Iterator<CsmFunction> getStaticFunctionDeclarations(CsmSelect.CsmFilter filter) {
        return this.getFileDeclarations().getStaticFunctionDeclarations(filter);
    }

    public Collection<CsmVariable> getStaticVariableDeclarations() {
        return this.getFileDeclarations().getStaticVariableDeclarations();
    }

    public Iterator<CsmVariable> getStaticVariableDeclarations(CsmSelect.CsmFilter filter) {
        return this.getFileDeclarations().getStaticVariableDeclarations(filter);
    }

    public boolean hasDeclarations() {
        return this.getFileDeclarations().hasDeclarations();
    }

    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        return this.getFileDeclarations().getDeclarations();
    }

    public int getDeclarationsSize() {
        return this.getFileDeclarations().getDeclarationsSize();
    }

    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmSelect.CsmFilter filter) {
        return this.getFileDeclarations().getDeclarations(filter);
    }

    public Collection<CsmUID<CsmOffsetableDeclaration>> getDeclarations(CsmDeclaration.Kind[] kinds, CharSequence prefix) {
        return this.getFileDeclarations().getDeclarations(kinds, prefix);
    }

    public Collection<CsmUID<CsmOffsetableDeclaration>> getDeclarations(int startOffset, int endOffset) {
        return this.getFileDeclarations().getDeclarations(startOffset, endOffset);
    }

    public Iterator<CsmOffsetableDeclaration> getDeclarations(int offset) {
        return this.getFileDeclarations().getDeclarations(offset);
    }

    public Collection<CsmReference> getReferences() {
        return this.getFileReferences().getReferences();
    }

    public Collection<CsmReference> getReferences(Collection<CsmObject> objects) {
        return this.getFileReferences().getReferences(objects);
    }

    public boolean addReference(CsmReference ref, CsmObject referencedObject) {
        return this.getFileReferences().addReference(ref, referencedObject);
    }

    public CsmReference getReference(int offset) {
        return this.getFileReferences().getReference(offset);
    }

    public boolean addResolvedReference(CsmReference ref, CsmObject referencedObject) {
        return this.getFileReferences().addResolvedReference(ref, referencedObject);
    }

    public void removeResolvedReference(CsmReference ref) {
        this.getFileReferences().removeResolvedReference(ref);
    }

    public CsmReference getResolvedReference(CsmReference ref) {
        return this.getFileReferences().getResolvedReference(ref);
    }

    public Collection<CsmMacro> getMacros() {
        this.checkNotInParsingThreadImpl();
        return this.getFileMacros().getMacros();
    }

    public Iterator<CsmMacro> getMacros(CsmSelect.CsmFilter filter) {
        this.checkNotInParsingThreadImpl();
        return this.getFileMacros().getMacros(filter);
    }

    public Collection<CsmUID<CsmMacro>> findMacroUids(CharSequence name) {
        this.checkNotInParsingThreadImpl();
        return this.getFileMacros().findMacroUids(name);
    }

    public CharSequence getAbsolutePath() {
        return this.fileBuffer.getAbsolutePath();
    }

    public FileObject getFileObject() {
        return this.fileBuffer.getFileObject();
    }

    public Collection<CsmScopeElement> getScopeElements() {
        this.checkNotInParsingThreadImpl();
        return this.currentFileContent.getScopeElements();
    }

    public boolean isValid() {
        if (this.disposed) {
            return false;
        }
        ProjectBase project = this._getProject(false);
        return project != null && project.isValid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsed() {
        Object object = this.changeStateLock;
        synchronized (object) {
            return this.state == State.PARSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLwmReady() {
        Object object = this.changeStateLock;
        synchronized (object) {
            this.state = State.PARSED;
            this.postParse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final State getState() {
        Object object = this.changeStateLock;
        synchronized (object) {
            return this.state;
        }
    }

    public final String getStateFromTest() {
        assert (CndUtils.isUnitTestMode());
        return this.state.toString();
    }

    public final String getParsingStateFromTest() {
        assert (CndUtils.isUnitTestMode());
        return this.parsingState.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isParsingOrParsed() {
        Object object = this.changeStateLock;
        synchronized (object) {
            return this.state == State.PARSED || this.parsingState != ParsingState.NOT_BEING_PARSED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void scheduleParsing(boolean wait) throws InterruptedException {
        Object object = this.stateLock;
        synchronized (object) {
            while (!this.isParsed()) {
                String oldName = wait ? Thread.currentThread().getName() : "";
                try {
                    if (wait) {
                        StringBuilder name = new StringBuilder(oldName);
                        name.append(": scheduleParsing ").append(this.getAbsolutePath());
                        name.append(" in states ").append((Object)this.state).append(", ").append((Object)this.parsingState);
                        Thread.currentThread().setName(name.toString());
                    }
                    if (!this.isParsingOrParsed()) {
                        boolean added;
                        if (TRACE_SCHUDULE_PARSING) {
                            System.err.printf("scheduleParsing: enqueue %s in states %s, %s\n", new Object[]{this.getAbsolutePath(), this.state, this.parsingState});
                        }
                        if (!(added = ParserQueue.instance().addToBeParsedNext(this))) {
                            return;
                        }
                    }
                    if (!wait) return;
                    if (TRACE_SCHUDULE_PARSING) {
                        System.err.printf("scheduleParsing: waiting for %s in states %s, %s\n", new Object[]{this.getAbsolutePath(), this.state, this.parsingState});
                    }
                    this.stateLock.wait();
                    if (!TRACE_SCHUDULE_PARSING) continue;
                    System.err.printf("scheduleParsing: lock notified for %s in states %s, %s\n", new Object[]{this.getAbsolutePath(), this.state, this.parsingState});
                }
                finally {
                    if (!wait) continue;
                    Thread.currentThread().setName(oldName);
                }
            }
            return;
        }
    }

    private void clearFakeRegistrations() {
        this.getProjectImpl(true).cleanAllFakeFunctionAST(this.getUID());
    }

    private boolean fixFakeRegistrations(boolean projectParsedMode) {
        this.checkNotInParsingThreadImpl();
        boolean result = false;
        result |= this.fixFakeFunctionRegistrations(projectParsedMode);
        return result |= this.fixFakeIncludeRegistrations(projectParsedMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fixFakeFunctionRegistrations(boolean projectParsedMode) {
        List<CsmUID<FunctionImplEx<?>>> fakeFunctionRegistrations;
        this.checkNotInParsingThreadImpl();
        boolean wereFakes = false;
        FileContent curContent = this.currentFileContent;
        List<CsmUID<FunctionImplEx<?>>> list = fakeFunctionRegistrations = curContent.getFakeFunctionRegistrations();
        synchronized (list) {
            if (!this.alreadyInFixFakeRegistrations) {
                this.alreadyInFixFakeRegistrations = true;
                if (fakeFunctionRegistrations.isEmpty() || !this.isValid()) {
                    this.alreadyInFixFakeRegistrations = false;
                    return false;
                }
                if (fakeFunctionRegistrations.size() > 0) {
                    for (int i = 0; i < fakeFunctionRegistrations.size(); ++i) {
                        CsmUID<FunctionImplEx<?>> fakeUid = fakeFunctionRegistrations.get(i);
                        AST fakeAST = this.getProjectImpl(true).getFakeFunctionAST(this.getUID(), fakeUid);
                        CsmDeclaration curElem = (CsmDeclaration)fakeUid.getObject();
                        if (curElem == null) continue;
                        if (curElem instanceof FunctionImplEx) {
                            wereFakes = true;
                            FileImpl.incParseCount();
                            if (((FunctionImplEx)curElem).fixFakeRegistration(curContent, projectParsedMode, fakeAST)) {
                                this.getProjectImpl(true).trackFakeFunctionAST(this.getUID(), fakeUid, null);
                            }
                            FileImpl.incParseCount();
                            continue;
                        }
                        DiagnosticExceptoins.register(new Exception("Incorrect fake registration class: " + curElem.getClass() + " for fake UID:" + fakeUid));
                    }
                }
                this.alreadyInFixFakeRegistrations = false;
            }
        }
        return wereFakes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fixFakeIncludeRegistrations(boolean projectParsedMode) {
        this.checkNotInParsingThreadImpl();
        boolean wereFakes = false;
        FileContent fileContent = this.currentFileContent;
        Iterator<FakeIncludePair> i$ = fileContent.getFakeIncludeRegistrations().iterator();
        while (i$.hasNext()) {
            FakeIncludePair fakeIncludePair;
            FakeIncludePair fakeIncludePair2 = fakeIncludePair = i$.next();
            synchronized (fakeIncludePair2) {
                FileImpl includedFile;
                CsmOffsetableDeclaration container;
                CsmInclude include;
                if (!fakeIncludePair.isFixed() && (include = (CsmInclude)UIDCsmConverter.UIDtoIdentifiable(fakeIncludePair.getIncludeUid())) != null && (container = UIDCsmConverter.UIDtoDeclaration(fakeIncludePair.getContainerUid())) != null && container.isValid() && (includedFile = (FileImpl)include.getIncludeFile()) != null && includedFile.isValid()) {
                    FileContent includedFileContent = includedFile.currentFileContent;
                    TokenStream ts = this.getTokenStreamOfIncludedFile(include);
                    if (ts != null) {
                        CsmParserProvider.CsmParserResult result;
                        CsmParserProvider.CsmParser parser = CsmParserProvider.createParser(includedFile);
                        assert (parser != null) : "no parser for " + this;
                        parser.init(this, ts, null);
                        if (container instanceof EnumImpl) {
                            EnumImpl enumImpl = (EnumImpl)container;
                            result = parser.parse(CsmParserProvider.CsmParser.ConstructionKind.ENUM_BODY);
                            result.render(includedFileContent, enumImpl, Boolean.FALSE);
                            fakeIncludePair.markFixed();
                            wereFakes = true;
                        } else if (container instanceof ClassImpl) {
                            ClassImpl cls = (ClassImpl)container;
                            result = parser.parse(CsmParserProvider.CsmParser.ConstructionKind.CLASS_BODY);
                            CsmDeclaration.Kind kind = cls.getKind();
                            CsmVisibility visibility = CsmVisibility.PRIVATE;
                            if (kind == CsmDeclaration.Kind.CLASS) {
                                visibility = CsmVisibility.PUBLIC;
                            } else if (kind == CsmDeclaration.Kind.STRUCT || kind == CsmDeclaration.Kind.UNION) {
                                visibility = CsmVisibility.PUBLIC;
                            }
                            result.render(includedFileContent, cls, visibility, Boolean.FALSE);
                            fakeIncludePair.markFixed();
                            wereFakes = true;
                        } else if (container instanceof NamespaceDefinitionImpl) {
                            CsmParserProvider.CsmParserResult result2 = parser.parse(CsmParserProvider.CsmParser.ConstructionKind.NAMESPACE_DEFINITION_BODY);
                            result2.render(includedFileContent, (NamespaceDefinitionImpl)container);
                            fakeIncludePair.markFixed();
                            wereFakes = true;
                        }
                    } else {
                        APTUtils.LOG.log(Level.WARNING, "fixFakeIncludeRegistrations: file {0} has not tokens, probably empty or removed?", new Object[]{this.getBuffer().getUrl()});
                    }
                }
            }
        }
        return wereFakes;
    }

    public String toString() {
        return "" + (Object)((Object)this.state) + " FileImpl @" + this.hashCode() + ":" + super.hashCode() + ' ' + this.getAbsolutePath() + " prj:" + System.identityHashCode(this.projectUID) + this.projectUID + " " + (Object)((Object)this.parsingState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CsmUID<CsmFile> getUID() {
        CsmUID<CsmFile> out = this.uid;
        if (out == null) {
            FileImpl fileImpl = this;
            synchronized (fileImpl) {
                if (this.uid == null) {
                    this.uid = out = UIDUtilities.createFileUID(this);
                }
            }
        }
        return this.uid;
    }

    CndTextIndexKey getTextIndexKey() {
        return new CndTextIndexKey(this.getUnitId(), this.getFileId());
    }

    public int getFileId() {
        return KeyUtilities.getProjectFileIndex(((KeyBasedUID)this.getUID()).getKey());
    }

    public int getUnitId() {
        return ((KeyBasedUID)this.projectUID).getKey().getUnitId();
    }

    public void write(RepositoryDataOutput output) throws IOException {
        assert (this.projectUID != null);
        UIDObjectFactory.getDefaultFactory().writeUID(this.projectUID, output);
        PersistentUtils.writeBuffer(this.fileBuffer, output, this.getUnitId());
        output.writeBoolean(this.hasBrokenIncludes.get());
        this.currentFileContent.write(output);
        output.writeByte(this.fileType.ordinal());
        output.writeLong(this.lastParsed);
        output.writeInt(this.lastParseTime);
        output.writeLong(this.lastParsedCRC);
        State curState = this.state;
        if (curState != State.PARSED && curState != State.INITIAL) {
            if (TraceFlags.TIMING) {
                System.err.printf("file is written in intermediate state %s, switching to INITIAL: %s \n", new Object[]{curState, this.getAbsolutePath()});
            }
            curState = State.INITIAL;
        }
        output.writeByte(curState.ordinal());
    }

    public FileImpl(RepositoryDataInput input) throws IOException {
        this.projectUID = UIDObjectFactory.getDefaultFactory().readUID(input);
        assert (this.projectUID != null);
        this.projectRef = null;
        this.fileBuffer = PersistentUtils.readBuffer(input, this.getUnitId());
        this.hasBrokenIncludes = new AtomicBoolean(input.readBoolean());
        this.currentFileContent = new FileContent(this, this._getProject(false), input);
        this.fileType = CsmFile.FileType.values()[input.readByte()];
        assert (this.fileBuffer != null);
        this.lastParsed = input.readLong();
        this.lastParseTime = input.readInt();
        this.lastParsedCRC = input.readLong();
        this.state = State.values()[input.readByte()];
        this.parsingState = ParsingState.NOT_BEING_PARSED;
    }

    public int hashCode() {
        if (this.hash == 0) {
            String identityHashPath = this.getProjectImpl(true).getUniqueName() + "*" + this.getAbsolutePath();
            this.hash = identityHashPath.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof FileImpl)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        FileImpl other = (FileImpl)obj;
        if (this.getAbsolutePath().equals(other.getAbsolutePath())) {
            return this.getProjectImpl(true).getUniqueName().equals(other.getProjectImpl(true).getUniqueName());
        }
        return false;
    }

    public int getOffset(int line, int column) {
        if (line <= 0 || column <= 0) {
            throw new IllegalArgumentException("line and column are 1-based");
        }
        try {
            return this.fileBuffer.getOffsetByLineColumn(line, column);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return -1;
        }
    }

    public int[] getLineColumn(int offset) {
        if (offset == Integer.MAX_VALUE) {
            try {
                offset = this.fileBuffer.getCharBuffer().length;
            }
            catch (IOException e) {
                DiagnosticExceptoins.register(e);
                offset = 0;
            }
        }
        try {
            return this.fileBuffer.getLineColumnByOffset(offset);
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            return new int[]{0, 0};
        }
    }

    void cacheVisitedState(APTPreprocHandler.State inputState, APTPreprocHandler outputHandler, FilePreprocessorConditionState pcState) {
        this.stateCache.cacheVisitedState(inputState, outputHandler, pcState);
    }

    PreprocessorStatePair getCachedVisitedState(APTPreprocHandler.State inputState) {
        return this.stateCache.getCachedVisitedState(inputState);
    }

    void clearStateCache() {
        this.tsRef.clear();
        this.stateCache.clearStateCache();
        FileBuffer buf = this.getBuffer();
        APTFileCacheManager.getInstance((FileSystem)buf.getFileSystem()).invalidate(buf.getAbsolutePath());
    }

    private FileComponentDeclarations getFileDeclarations() {
        FileContent contentImpl = this.getThreadSensitiveContentImpl();
        FileComponentDeclarations fd = contentImpl.getFileDeclarations();
        return fd != null ? fd : FileComponentDeclarations.empty();
    }

    private FileComponentMacros getFileMacros() {
        this.checkNotInParsingThreadImpl();
        FileComponentMacros fd = this.currentFileContent.getFileMacros();
        return fd != null ? fd : FileComponentMacros.empty();
    }

    private FileComponentIncludes getFileIncludes() {
        this.checkNotInParsingThreadImpl();
        FileComponentIncludes fd = this.currentFileContent.getFileIncludes();
        return fd != null ? fd : FileComponentIncludes.empty();
    }

    private FileComponentReferences getFileReferences() {
        FileContent contentImpl = this.getThreadSensitiveContentImpl();
        FileComponentReferences fd = contentImpl.getFileReferences();
        return fd != null ? fd : FileComponentReferences.empty();
    }

    private FileComponentInstantiations getFileInstantiations() {
        this.checkNotInParsingThreadImpl();
        FileComponentInstantiations fd = this.currentFileContent.getFileInstantiations();
        return fd != null ? fd : FileComponentInstantiations.empty();
    }

    private FileContent getThreadSensitiveContentImpl() {
        FileContent contentImpl = this.getParsingFileContent();
        if (contentImpl == null) {
            contentImpl = this.currentFileContent;
        }
        return contentImpl;
    }

    private void checkNotInParsingThreadImpl() {
    }

    public static boolean traceFile(CharSequence file) {
        if (TraceFlags.TRACE_FILE_NAME != null) {
            if (TraceFlags.TRACE_FILE_NAME.length() == 0) {
                return true;
            }
            return ((Object)file).toString().endsWith(TraceFlags.TRACE_FILE_NAME);
        }
        return false;
    }

    public void dumpInfo(PrintWriter printOut) {
        ProjectBase projectImpl = this.getProjectImpl(false);
        printOut.printf("FI: %s, of %s prj=%s disposing=%s (%d)\n\tprjUID=(%d) %s\n\tfileType=%s, hasSnap=%s hasBroken=%s\n", this.getName(), projectImpl.getClass().getSimpleName(), projectImpl.getName(), projectImpl.isDisposing(), System.identityHashCode(projectImpl), System.identityHashCode(this.projectUID), this.projectUID, this.fileType, FileImpl.toYesNo(this.fileSnapshot != null), FileImpl.toYesNo(this.hasBrokenIncludes()));
        printOut.printf("\tlastParsedTime=%d, lastParsed=%d %s %s\n", new Object[]{this.lastParseTime, this.lastParsed, this.parsingState, this.state});
        FileBuffer buffer = this.getBuffer();
        printOut.printf("\tfileBuf=%s lastModified=%d\n", FileImpl.toYesNo(buffer.isFileBased()), buffer.lastModified());
    }

    public void dumpIndex(PrintWriter printOut) {
        this.getFileReferences().dump(printOut);
    }

    public void dumpPPStates(PrintWriter printOut) {
        int i = 0;
        Collection<PreprocessorStatePair> preprocStatePairs = this.getFileContainerOwnPreprocessorStatePairsToDump();
        printOut.printf("Has %d ppStatePairs:\n", preprocStatePairs.size());
        for (PreprocessorStatePair pair : preprocStatePairs) {
            printOut.printf("----------------Pair[%d]------------------------\n", ++i);
            printOut.printf("pc=%s\nstate=%s\n", pair.pcState, pair.state);
        }
        Collection<APTPreprocHandler> preprocHandlers = this.getFileContainerOwnPreprocHandlersToDump();
        printOut.printf("Converted into %d Handlers:\n", preprocHandlers.size());
        i = 0;
        for (APTPreprocHandler ppHandler : preprocHandlers) {
            printOut.printf("----------------Handler[%d]------------------------\n", ++i);
            printOut.printf("handler=%s\n", ppHandler);
        }
    }

    public void dumpIncludePPStates(PrintWriter printOut) {
        int i = 0;
        Collection<PreprocessorStatePair> preprocStatePairs = this.getFileContainerOwnPreprocessorStatePairsToDump();
        printOut.printf("Has %d OWNED ppStatePairs:\n", preprocStatePairs.size());
        for (PreprocessorStatePair pair : preprocStatePairs) {
            printOut.printf("----------------Own Pair[%d]------------------------\n", ++i);
            printOut.printf("pc=%s\nstate=%s\n", pair.pcState, pair.state);
        }
        Collection projects = CsmModelAccessor.getModel().projects();
        i = 0;
        for (CsmProject csmProject : projects) {
            if (!(csmProject instanceof ProjectBase)) continue;
            ProjectBase prj = (ProjectBase)csmProject;
            Map<CsmUID<CsmProject>, Collection<PreprocessorStatePair>> includedStates = prj.getIncludedPreprocStatePairs(this);
            if (includedStates.size() > 1) {
                printOut.printf("ALARM! the same file %s is included as library of %d projects\n", this.getAbsolutePath(), includedStates.size());
            }
            for (Map.Entry<CsmUID<CsmProject>, Collection<PreprocessorStatePair>> entry : includedStates.entrySet()) {
                Collection<PreprocessorStatePair> pairs = entry.getValue();
                printOut.printf("in project %s included %s\n", prj, UIDUtilities.getProjectName(entry.getKey()));
                for (PreprocessorStatePair pair : pairs) {
                    printOut.printf("----------------Included Pair[%d]------------------------\n", ++i);
                    printOut.printf("with pc=%s\nstate=%s\n", pair.pcState, pair.state);
                }
            }
        }
    }

    static String toYesNo(boolean b) {
        return b ? "yes" : "no";
    }

    private static class SpecialStateImpl
    implements APTPreprocHandler.State {
        public boolean isCleaned() {
            return true;
        }

        public boolean isCompileContext() {
            return false;
        }

        public boolean isValid() {
            return false;
        }
    }

    private static class EmptyCollection<T>
    extends AbstractCollection<T> {
        private EmptyCollection() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public Iterator<T> iterator() {
            return Collections.emptyList().iterator();
        }
    }

    private static class ParserBasedTokenBuffer
    implements ReadOnlyTokenBuffer {
        private final Parser parser;

        public ParserBasedTokenBuffer(Parser parser) {
            this.parser = parser;
        }

        @Override
        public int LA(int i) {
            return this.parser.LA(i);
        }

        @Override
        public Token LT(int i) {
            return this.parser.LT(i);
        }
    }

    public static interface ErrorListener {
        public void error(String var1, int var2, int var3);
    }

    private static class IncludeInfoImpl
    implements APTIncludeHandler.IncludeInfo {
        private final int line;
        private final CsmInclude include;
        private final CharSequence path;

        IncludeInfoImpl(CsmInclude include, CharSequence path) {
            this.line = include.getStartPosition().getLine();
            this.include = include;
            this.path = path;
        }

        public CharSequence getIncludedPath() {
            return this.path;
        }

        public int getIncludeDirectiveLine() {
            return this.line;
        }

        public int getIncludeDirectiveOffset() {
            return this.include.getStartOffset();
        }

        public int getIncludedDirIndex() {
            return 0;
        }

        public String toString() {
            return "restore " + this.include + " from line " + this.line + " in file " + this.include.getContainingFile();
        }
    }

    private static final class TokenStreamLock {
        private TokenStreamLock() {
        }
    }

    public static final class ParseDescriptor
    implements CsmParserProvider.CsmParserParameters {
        private final CsmParserProvider.CsmParseCallback callback;
        private final FileContent content;
        private final boolean lazyCompound;
        private final APTFile fullAPT;
        private APTPreprocHandler curPreprocHandler;
        private final FileImpl fileImpl;
        private final boolean triggerParsingActivity;

        public ParseDescriptor(FileImpl fileImpl, APTFile fullAPT, CsmParserProvider.CsmParseCallback callback, boolean emptyFileContent, boolean triggerParsingActivity) {
            this(fileImpl, fullAPT, callback, TraceFlags.EXCLUDE_COMPOUND, emptyFileContent, triggerParsingActivity);
        }

        public ParseDescriptor(FileImpl fileImpl, APTFile fullAPT, CsmParserProvider.CsmParseCallback callback, boolean lazyCompound, boolean emptyFileContent, boolean triggerParsingActivity) {
            assert (fileImpl != null) : "null file is not allowed";
            assert (fullAPT != null) : "null APTFile is not allowed";
            this.fileImpl = fileImpl;
            this.content = FileContent.getHardReferenceBasedCopy(fileImpl.currentFileContent, emptyFileContent);
            this.fullAPT = fullAPT;
            this.callback = callback;
            this.lazyCompound = lazyCompound;
            this.triggerParsingActivity = triggerParsingActivity;
        }

        private void setCurrentPreprocHandler(APTPreprocHandler preprocHandler) {
            assert (preprocHandler != null) : "null preprocHandler is not allowed";
            this.curPreprocHandler = preprocHandler;
        }

        private APTPreprocHandler getCurrentPreprocHandler() {
            assert (this.curPreprocHandler != null) : "null preprocHandler is not allowed";
            return this.curPreprocHandler;
        }

        public FileContent getFileContent() {
            return this.content;
        }

        @Override
        public CsmFile getMainFile() {
            return this.fileImpl;
        }
    }

    private static final class ChangeStateLock {
        private ChangeStateLock() {
        }
    }

    public static interface Hook {
        public void parsingFinished(CsmFile var1, APTPreprocHandler var2);
    }

    private static final class StateLock {
        private StateLock() {
        }
    }

    private static enum ParsingState {
        NOT_BEING_PARSED,
        MODIFIED_WHILE_BEING_PARSED,
        BEING_PARSED;

    }

    public static enum State {
        INITIAL,
        PARSED,
        PARTIAL,
        MODIFIED;

    }
}

