/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.File;
import java.io.PrintWriter;
import java.nio.BufferUnderflowException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmStandaloneFileProvider;
import org.netbeans.modules.cnd.api.project.DefaultSystemSettings;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.api.project.NativeProjectRegistry;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.trace.NativeProjectProvider;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class CsmStandaloneFileProviderImpl
extends CsmStandaloneFileProvider {
    private static final boolean TRACE = Boolean.getBoolean("cnd.standalone.trace");
    private static final Lock lock = new Lock();
    private static final Set<String> toBeRmoved = new HashSet<String>();
    private final CsmModelListener listener = new CsmModelListener(){

        public void projectOpened(CsmProject project) {
        }

        public void projectClosed(CsmProject project) {
        }

        public void modelChanged(CsmChangeEvent e) {
            for (CsmFile file : e.getNewFiles()) {
                CsmStandaloneFileProviderImpl.this.clean(file);
            }
            for (CsmFile file : e.getRemovedFiles()) {
                CsmStandaloneFileProviderImpl.this.onFileRemove(file);
            }
        }
    };
    private final CsmProgressListener progressListener = new CsmProgressAdapter(){

        public void projectLoaded(CsmProject project) {
            CsmStandaloneFileProviderImpl.this.clean((ProjectBase)project);
        }

        public void projectParsingFinished(CsmProject project) {
        }
    };

    public CsmStandaloneFileProviderImpl() {
        CsmListeners.getDefault().addModelListener(this.listener);
        CsmListeners.getDefault().addProgressListener(this.progressListener);
    }

    static CsmStandaloneFileProviderImpl getDefaultImpl() {
        return (CsmStandaloneFileProviderImpl)CsmStandaloneFileProvider.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmFile getCsmFile(FileObject fo) {
        if (fo == null || !fo.isValid() || !CsmUtilities.isCsmSuitable((FileObject)fo)) {
            return null;
        }
        CsmModelState modelState = CsmModelAccessor.getModelState();
        if (modelState != CsmModelState.ON) {
            if (TRACE) {
                CsmStandaloneFileProviderImpl.trace("model is %s, no extra work for %s", modelState, fo.getPath());
            }
            return null;
        }
        File file = CndFileUtils.toFile((FileObject)fo);
        if (file == null) {
            return null;
        }
        String absPath = CndFileUtils.normalizePath((FileObject)fo);
        ProjectBase project = null;
        CsmStandaloneFileProviderImpl csmStandaloneFileProviderImpl = this;
        synchronized (csmStandaloneFileProviderImpl) {
            CsmFile csmFile = ModelImpl.instance().findFile(FSPath.toFSPath((FileObject)fo), true, false);
            if (csmFile != null) {
                if (TRACE) {
                    CsmStandaloneFileProviderImpl.trace("returns file %s", csmFile);
                }
                return csmFile;
            }
            Lock lock = CsmStandaloneFileProviderImpl.lock;
            synchronized (lock) {
                if (toBeRmoved.contains(absPath)) {
                    return null;
                }
                NativeProject platformProject = NativeProjectImpl.getNativeProjectImpl(fo);
                if (platformProject != null) {
                    project = ModelImpl.instance().addProject(platformProject, absPath, true);
                    if (TRACE) {
                        CsmStandaloneFileProviderImpl.trace("added project %s", project);
                    }
                    if (project != null) {
                        project.ensureFilesCreated();
                    }
                }
            }
        }
        if (project != null && project.isValid()) {
            try {
                FileImpl out = project.getFile(absPath, false);
                if (TRACE) {
                    CsmStandaloneFileProviderImpl.trace("RETURNS STANALONE FILE %s", out);
                }
                return out;
            }
            catch (BufferUnderflowException ex) {
                DiagnosticExceptoins.register(ex);
            }
            catch (IllegalStateException ex) {
                DiagnosticExceptoins.register(ex);
            }
        }
        return null;
    }

    private void clean(ProjectBase projectOpened) {
        if (projectOpened.getPlatformProject() instanceof NativeProjectImpl) {
            return;
        }
        if (TRACE) {
            CsmStandaloneFileProviderImpl.trace("checking project %s", projectOpened.toString());
        }
        for (CsmProject dummy : ModelImpl.instance().projects()) {
            if (!(dummy.getPlatformProject() instanceof NativeProjectImpl)) continue;
            for (CsmFile file : dummy.getAllFiles()) {
                if (TRACE) {
                    CsmStandaloneFileProviderImpl.trace("\nchecking file %s", file.getAbsolutePath());
                }
                if (projectOpened.getFile(((FileImpl)file).getAbsolutePath(), false) == null) continue;
                this.scheduleProjectRemoval(dummy);
            }
        }
    }

    private void clean(CsmFile file) {
        if (!(file.getProject().getPlatformProject() instanceof NativeProjectImpl)) {
            this.notifyClosed(file);
        }
    }

    void onFileRemove(CsmFile file) {
        FileObject fo = CsmUtilities.getFileObject((CsmFile)file);
        if (fo != null && this.isOpen(fo)) {
            this.getCsmFile(fo);
        }
    }

    private boolean isOpen(FileObject fo) {
        try {
            DataObject dao = DataObject.find((FileObject)fo);
            if (dao != null) {
                return CsmUtilities.findOpenedEditor((DataObject)dao) != null;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public synchronized void notifyClosed(CsmFile csmFile) {
        String closedFilePath = ((Object)csmFile.getAbsolutePath()).toString();
        for (CsmProject csmProject : ModelImpl.instance().projects()) {
            NativeProjectImpl nativeProject;
            Object platformProject = csmProject.getPlatformProject();
            if (!(platformProject instanceof NativeProjectImpl) || !(nativeProject = (NativeProjectImpl)platformProject).getProjectRoot().equals(closedFilePath)) continue;
            for (CsmFile csmf : csmProject.getAllFiles()) {
                NativeFileItemSet set;
                FileObject fo = ((FileImpl)csmf).getFileObject();
                DataObject dao = NativeProjectProvider.getDataObject(fo);
                if (dao == null || (set = (NativeFileItemSet)dao.getLookup().lookup(NativeFileItemSet.class)) == null) continue;
                set.remove((NativeFileItem)nativeProject.findFileItem(fo));
            }
            this.scheduleProjectRemoval(csmProject);
        }
    }

    public boolean isStandalone(CsmFile file) {
        NativeFileItem nfi;
        return file instanceof FileImpl && (nfi = ((FileImpl)file).getNativeFileItem()) instanceof NativeFileItemImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleProjectRemoval(final CsmProject project) {
        if (!project.isValid()) {
            return;
        }
        Object nativeProject = project.getPlatformProject();
        if (!(nativeProject instanceof NativeProject)) {
            return;
        }
        final String root = ((NativeProject)nativeProject).getProjectRoot();
        if (TRACE) {
            CsmStandaloneFileProviderImpl.trace("schedulling removal %s", project.toString());
        }
        Lock lock = CsmStandaloneFileProviderImpl.lock;
        synchronized (lock) {
            toBeRmoved.add(root);
        }
        ModelImpl.instance().enqueueModelTask(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (project.isValid()) {
                    if (TRACE) {
                        CsmStandaloneFileProviderImpl.trace("removing %s", new Object[]{project.toString()});
                    }
                    ProjectBase projectBase = (ProjectBase)project;
                    ModelImpl.instance().closeProjectBase(projectBase, false);
                    Lock lock = lock;
                    synchronized (lock) {
                        toBeRmoved.remove(root);
                    }
                    if (TRACE) {
                        CsmStandaloneFileProviderImpl.trace("removed %s", new Object[]{project.toString()});
                    }
                }
            }
        }, "Standalone project removal.");
    }

    private static void trace(String pattern, Object ... args) {
        assert (TRACE) : "Should not be called if TRACE is off!";
        System.err.printf("### Standalone provider:  %s\n", String.format(pattern, args));
    }

    public void dumpInfo(PrintWriter printOut) {
        printOut.printf("SAProvider %s has toBeRemoved=%d entries\n", ((Object)((Object)this)).getClass().getSimpleName(), toBeRmoved.size());
        int ind = 1;
        for (String str : toBeRmoved) {
            printOut.printf("[%d] %s\n", ind++, str);
        }
    }

    private static final class NativeFileItemImpl
    implements NativeFileItem {
        private final FileObject fileObject;
        private final NativeProjectImpl project;
        private final NativeFileItem.Language lang;
        private final NativeFileItem.LanguageFlavor flavor;

        public NativeFileItemImpl(FileObject file, NativeProjectImpl project, NativeFileItem.Language language, NativeFileItem.LanguageFlavor flavor) {
            this.project = project;
            this.fileObject = file;
            this.lang = language;
            this.flavor = flavor;
        }

        public NativeProject getNativeProject() {
            return this.project;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public String getAbsolutePath() {
            return CndFileUtils.normalizePath((FileObject)this.fileObject);
        }

        public String getName() {
            return this.fileObject.getNameExt();
        }

        public List<FSPath> getSystemIncludePaths() {
            List<FSPath> result = this.project.getSystemIncludePaths();
            this.checkAbsolute(result);
            return result;
        }

        public List<FSPath> getUserIncludePaths() {
            List<FSPath> result = this.project.getUserIncludePaths();
            this.checkAbsolute(result);
            return result;
        }

        private void checkAbsolute(List<FSPath> orig) {
            ArrayList result = new ArrayList(orig.size());
            for (FSPath path : orig) {
                CndUtils.assertAbsolutePathInConsole((String)path.getPath());
            }
        }

        public List<String> getSystemMacroDefinitions() {
            return this.project.getSystemMacroDefinitions();
        }

        public List<String> getUserMacroDefinitions() {
            return this.project.getUserMacroDefinitions();
        }

        public NativeFileItem.Language getLanguage() {
            return this.lang;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return this.flavor;
        }

        public boolean isExcluded() {
            return false;
        }

        public String toString() {
            return "SA " + this.fileObject + " " + System.identityHashCode(this) + " " + this.lang + " from project:" + this.project;
        }
    }

    static final class NativeProjectImpl
    implements NativeProject {
        private final List<FSPath> sysIncludes;
        private final List<FSPath> usrIncludes;
        private final List<String> sysMacros;
        private final List<String> usrMacros;
        private final List<NativeFileItemImpl> files = new ArrayList<NativeFileItemImpl>();
        private final FileObject projectRoot;
        private final FileSystem fileSystem;
        private List<NativeProjectItemsListener> listeners = new ArrayList<NativeProjectItemsListener>();
        private final Object listenersLock = new Lock();

        static NativeProject getNativeProjectImpl(FileObject file) {
            FileSystem fs;
            NativeFileItem.LanguageFlavor flavor;
            NativeFileItem.Language lang;
            DataObject dao = NativeProjectProvider.getDataObject(file);
            if (dao == null) {
                return null;
            }
            NativeFileItemSet set = (NativeFileItemSet)dao.getLookup().lookup(NativeFileItemSet.class);
            if (set == null) {
                return null;
            }
            NativeFileItem itemPrototype = null;
            if (!set.isEmpty()) {
                Iterator iterator = set.getItems().iterator();
                Collection openProjects = NativeProjectRegistry.getDefault().getOpenProjects();
                while (iterator.hasNext()) {
                    itemPrototype = (NativeFileItem)iterator.next();
                    if (!openProjects.contains(itemPrototype.getNativeProject())) continue;
                    return null;
                }
            }
            ModelImpl model = ModelImpl.instance();
            ArrayList<FSPath> sysIncludes = new ArrayList<FSPath>();
            ArrayList<FSPath> usrIncludes = new ArrayList<FSPath>();
            ArrayList<String> sysMacros = new ArrayList<String>();
            ArrayList<String> usrMacros = new ArrayList<String>();
            ArrayList<String> undefinedMacros = new ArrayList<String>();
            if (itemPrototype != null) {
                lang = itemPrototype.getLanguage();
                flavor = itemPrototype.getLanguageFlavor();
            } else {
                lang = NativeProjectProvider.getLanguage(file, dao);
                flavor = NativeFileItem.LanguageFlavor.UNKNOWN;
            }
            NativeProject prototype = null;
            for (CsmProject csmProject : model.projects()) {
                Object p = csmProject.getPlatformProject();
                if (!(p instanceof NativeProject)) continue;
                NativeProject project = (NativeProject)p;
                if (file.getPath().startsWith(project.getProjectRoot())) {
                    prototype = project;
                    break;
                }
                for (String root : project.getSourceRoots()) {
                    if (!file.getPath().startsWith(root)) continue;
                    prototype = project;
                    break;
                }
                if (prototype == null) continue;
                break;
            }
            if (prototype != null && ModelImpl.instance().isProjectDisabled(prototype)) {
                return null;
            }
            try {
                fs = file.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                fs = CndFileUtils.getLocalFileSystem();
            }
            NativeProjectImpl impl = new NativeProjectImpl(file, sysIncludes, usrIncludes, sysMacros, usrMacros, undefinedMacros);
            if (itemPrototype != null) {
                sysIncludes.addAll(itemPrototype.getSystemIncludePaths());
                sysMacros.addAll(itemPrototype.getSystemMacroDefinitions());
                usrIncludes.addAll(itemPrototype.getUserIncludePaths());
                usrMacros.addAll(itemPrototype.getUserMacroDefinitions());
            } else if (prototype != null) {
                sysIncludes.addAll(prototype.getSystemIncludePaths());
                sysMacros.addAll(prototype.getSystemMacroDefinitions());
                usrIncludes.addAll(prototype.getUserIncludePaths());
                usrMacros.addAll(prototype.getUserMacroDefinitions());
            } else {
                sysIncludes.addAll(CndFileUtils.toFSPathList((FileSystem)fs, (Collection)DefaultSystemSettings.getDefault().getSystemIncludes(lang, (NativeProject)impl)));
                sysMacros.addAll(DefaultSystemSettings.getDefault().getSystemMacros(lang, (NativeProject)impl));
            }
            impl.checkPaths();
            impl.addFile(file, lang, flavor);
            set.add((NativeFileItem)impl.findFileItem(file));
            return impl;
        }

        private NativeProjectImpl(FileObject projectRoot, List<FSPath> sysIncludes, List<FSPath> usrIncludes, List<String> sysMacros, List<String> usrMacros, List<String> undefinedMacros) {
            this.projectRoot = projectRoot;
            this.fileSystem = NativeProjectImpl.getFileSystem(projectRoot);
            this.sysIncludes = sysIncludes;
            this.usrIncludes = usrIncludes;
            this.sysMacros = sysMacros;
            this.usrMacros = usrMacros;
        }

        private static FileSystem getFileSystem(FileObject fo) {
            try {
                return fo.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return CndFileUtils.getLocalFileSystem();
            }
        }

        private void checkPaths() {
            this.check(this.sysIncludes);
            this.check(this.usrIncludes);
        }

        private void check(List<FSPath> list) {
            Iterator<FSPath> it = list.iterator();
            while (it.hasNext()) {
                FSPath path = it.next();
                if (CndPathUtilitities.isPathAbsolute((CharSequence)path.getPath())) continue;
                CndUtils.assertTrueInConsole((boolean)false, (String)("Can not convert " + path.getPath()));
                it.remove();
            }
        }

        private void addFile(FileObject file, NativeFileItem.Language lang, NativeFileItem.LanguageFlavor flavor) {
            NativeFileItemImpl item = new NativeFileItemImpl(file, this, lang, flavor);
            this.files.add(item);
        }

        public Lookup.Provider getProject() {
            return null;
        }

        public List<String> getSourceRoots() {
            return Collections.emptyList();
        }

        public String getProjectRoot() {
            return this.projectRoot.getPath();
        }

        public FileSystem getFileSystem() {
            try {
                return this.projectRoot.getFileSystem();
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return CndFileUtils.getLocalFileSystem();
            }
        }

        public String getProjectDisplayName() {
            return this.getProjectRoot();
        }

        public List<NativeFileItem> getAllFiles() {
            return Collections.unmodifiableList(this.files);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addProjectItemsListener(NativeProjectItemsListener listener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.add(listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeProjectItemsListener(NativeProjectItemsListener listener) {
            Object object = this.listenersLock;
            synchronized (object) {
                this.listeners.remove(listener);
            }
        }

        public NativeFileItemImpl findFileItem(FileObject fileObject) {
            for (NativeFileItemImpl item : this.files) {
                if (!item.getFileObject().equals(fileObject)) continue;
                return item;
            }
            return null;
        }

        public List<FSPath> getSystemIncludePaths() {
            return this.sysIncludes;
        }

        public List<FSPath> getUserIncludePaths() {
            return this.usrIncludes;
        }

        public List<String> getSystemMacroDefinitions() {
            return this.sysMacros;
        }

        public List<String> getUserMacroDefinitions() {
            return this.usrMacros;
        }

        public List<NativeProject> getDependences() {
            return Collections.emptyList();
        }

        public void runOnProjectReadiness(NamedRunnable task) {
            task.run();
        }

        public void fireFilesPropertiesChanged() {
        }

        public final String toString() {
            return "SA " + this.projectRoot + ' ' + this.getClass().getName() + " @" + this.hashCode() + ":" + System.identityHashCode(this);
        }

        private static final class Lock {
            private Lock() {
            }
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

