/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileModel;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileModelProvider;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectSettingsValidator;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

final class CreateFilesWorker {
    private FileModel lwm;
    private boolean lwmInited;
    private final ProjectBase project;
    private final RequestProcessor PROJECT_FILES_WORKER;
    private final Set<FileImpl> reparseOnEdit = Collections.synchronizedSet(new HashSet());
    private final Set<NativeFileItem> reparseOnPropertyChanged = Collections.synchronizedSet(new HashSet());
    private final AtomicBoolean failureDetected = new AtomicBoolean(false);
    private final Set<NativeFileItem> removedFiles;
    private final ProjectSettingsValidator validator;

    CreateFilesWorker(ProjectBase project, Set<NativeFileItem> removedFiles, ProjectSettingsValidator validator) {
        this.project = project;
        this.removedFiles = removedFiles;
        this.validator = validator;
        this.PROJECT_FILES_WORKER = new RequestProcessor("CreateFilesWorker " + project.getDisplayName(), CndUtils.getNumberCndWorkerThreads());
    }

    private synchronized FileModel getLWM() {
        if (!this.lwmInited) {
            FileModelProvider provider = (FileModelProvider)Lookup.getDefault().lookup(FileModelProvider.class);
            if (provider != null) {
                this.lwm = provider.getFileModel(this.project);
            }
            this.lwmInited = true;
        }
        return this.lwm;
    }

    /*
     * WARNING - void declaration
     */
    void createProjectFilesIfNeed(List<NativeFileItem> items, boolean sources) {
        Set<CsmUID> handledFiles = Collections.synchronizedSet(new HashSet(items.size()));
        int size = items.size();
        int threads = CndUtils.getNumberCndWorkerThreads() * 3;
        CountDownLatch countDownLatch = new CountDownLatch(threads);
        int chunk = size / threads + 1;
        Iterator<NativeFileItem> it = items.iterator();
        for (int i = 0; i < threads; ++i) {
            void var11_15;
            ArrayList<NativeFileItem> list = new ArrayList<NativeFileItem>(chunk);
            boolean bl = false;
            while (var11_15 < chunk && it.hasNext()) {
                list.add(it.next());
                ++var11_15;
            }
            CreateFileRunnable createFileRunnable = new CreateFileRunnable(countDownLatch, list, sources, handledFiles);
            this.PROJECT_FILES_WORKER.post((Runnable)createFileRunnable);
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (!this.failureDetected.get() && this.validator != null && !sources) {
            HashSet<CsmUID<CsmFile>> allFilesUID = new HashSet<CsmUID<CsmFile>>(this.project.getHeaderFilesUID());
            allFilesUID.removeAll(handledFiles);
            if (TraceFlags.TRACE_VALIDATION) {
                for (CsmUID csmUID : handledFiles) {
                    System.err.printf("Hanlded %s - %d\n", csmUID, System.identityHashCode(csmUID));
                }
                for (CsmUID csmUID : allFilesUID) {
                    System.err.printf("To handle %s - %d\n", csmUID, System.identityHashCode(csmUID));
                }
            }
            for (CsmUID csmUID : allFilesUID) {
                if (csmUID == null || RepositoryUtils.getRepositoryErrorCount(this.project) > 0) {
                    this.failureDetected.set(true);
                    break;
                }
                CsmFile file = UIDCsmConverter.UIDtoFile((CsmUID<CsmFile>)csmUID);
                if (file instanceof FileImpl) {
                    FileImpl fileImpl = (FileImpl)file;
                    if (fileImpl.getState() == FileImpl.State.INITIAL || !fileImpl.validate()) {
                        if (TraceFlags.TRACE_VALIDATION) {
                            System.err.printf("Validation: %s file [%d %s] to be parsed, because of state %s\n", new Object[]{fileImpl.getAbsolutePath(), System.identityHashCode(csmUID), fileImpl.getFileType(), fileImpl.getState()});
                        }
                        this.reparseOnEdit.add(fileImpl);
                        continue;
                    }
                    if (!TraceFlags.TRACE_VALIDATION) continue;
                    System.err.printf("Validation: skip %s file [%d %s], because of state %s\n", new Object[]{fileImpl.getAbsolutePath(), System.identityHashCode(csmUID), fileImpl.getFileType(), fileImpl.getState()});
                    continue;
                }
                this.failureDetected.set(true);
                RepositoryUtils.registerRepositoryError(this.project, new Exception("Validation: file was not restored from " + csmUID));
                System.err.printf("Validation: file was not restored from %s\n", csmUID);
                break;
            }
            if (TraceFlags.DEBUG_BROKEN_REPOSITORY) {
                this.failureDetected.set(true);
                RepositoryUtils.registerRepositoryError(this.project, new Exception("Validation: INTENTIONAL interrupt"));
            }
        }
    }

    void finishProjectFilesCreation() {
        if (!this.failureDetected.get()) {
            if (!this.reparseOnEdit.isEmpty()) {
                for (FileImpl file : this.reparseOnEdit) {
                    DeepReparsingUtils.tryPartialReparseOnChangedFile(this.project, file);
                }
            }
            if (!this.reparseOnPropertyChanged.isEmpty()) {
                DeepReparsingUtils.reparseOnPropertyChanged(this.reparseOnPropertyChanged, this.project, false);
            }
        }
    }

    void checkLibraries() {
        if (!this.failureDetected.get() && this.validator != null) {
            this.reparseOnEdit.addAll(this.project.checkLibrariesAfterRestore());
        }
    }

    private class CreateFileRunnable
    implements Runnable {
        private final CountDownLatch countDownLatch;
        private final List<NativeFileItem> nativeFileItems;
        private final boolean sources;
        private final Set<CsmUID<CsmFile>> handledFiles;

        private CreateFileRunnable(CountDownLatch countDownLatch, List<NativeFileItem> nativeFileItems, boolean sources, Set<CsmUID<CsmFile>> handledFiles) {
            this.countDownLatch = countDownLatch;
            this.nativeFileItems = nativeFileItems;
            this.sources = sources;
            this.handledFiles = handledFiles;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (TraceFlags.PARSE_HEADERS_WITH_SOURCES && !this.sources) {
                    return;
                }
                for (NativeFileItem nativeFileItem : this.nativeFileItems) {
                    if (this.createProjectFilesIfNeedRun(nativeFileItem)) continue;
                    return;
                }
            }
            finally {
                this.countDownLatch.countDown();
            }
        }

        private boolean createProjectFilesIfNeedRun(NativeFileItem nativeFileItem) {
            if (CreateFilesWorker.this.failureDetected.get()) {
                return false;
            }
            CsmModelState modelState = ModelImpl.instance().getState();
            if (modelState == CsmModelState.CLOSING || modelState == CsmModelState.OFF) {
                if (TraceFlags.TRACE_VALIDATION || TraceFlags.TRACE_MODEL_STATE) {
                    System.err.printf("createProjectFilesIfNeedRun: %s file [%s] is interrupted on closing model\n", nativeFileItem.getAbsolutePath(), CreateFilesWorker.this.project.getName());
                }
                return false;
            }
            if (CreateFilesWorker.this.project.isDisposing()) {
                if (TraceFlags.TRACE_MODEL_STATE) {
                    System.err.printf("filling parser queue interrupted for %s\n", CreateFilesWorker.this.project.getName());
                }
                return false;
            }
            if (CreateFilesWorker.this.removedFiles.contains(nativeFileItem)) {
                FileImpl file = CreateFilesWorker.this.project.getFile(nativeFileItem.getAbsolutePath(), true);
                if (file != null) {
                    this.handledFiles.add(UIDCsmConverter.fileToUID(file));
                }
                return true;
            }
            assert (nativeFileItem.getFileObject() != null) : "native file item must have valid File object";
            if (TraceFlags.DEBUG) {
                ModelSupport.trace(nativeFileItem);
            }
            try {
                FileImpl fileImpl = CreateFilesWorker.this.project.createIfNeed(nativeFileItem, CreateFilesWorker.this.getLWM(), CreateFilesWorker.this.validator, CreateFilesWorker.this.reparseOnEdit, CreateFilesWorker.this.reparseOnPropertyChanged);
                this.handledFiles.add(UIDCsmConverter.fileToUID(fileImpl));
                if (CreateFilesWorker.this.project.isValidating() && RepositoryUtils.getRepositoryErrorCount(CreateFilesWorker.this.project) > 0) {
                    CreateFilesWorker.this.failureDetected.set(true);
                    return false;
                }
            }
            catch (Exception ex) {
                DiagnosticExceptoins.register(ex);
            }
            return true;
        }
    }
}

