/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.CsmObjectBuilder;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public final class NamespaceDefinitionImpl
extends OffsetableDeclarationBase<CsmNamespaceDefinition>
implements CsmNamespaceDefinition,
MutableDeclarationsContainer,
Disposable {
    private final List<CsmUID<CsmOffsetableDeclaration>> declarations;
    private final CharSequence name;
    private NamespaceImpl namespaceRef;
    private final CsmUID<CsmNamespace> namespaceUID;
    private final int leftBracketPos;

    private NamespaceDefinitionImpl(AST ast, CsmFile file, NamespaceImpl parent) {
        this(NameCache.getManager().getString(AstUtil.getText(ast)), parent, file, NamespaceDefinitionImpl.getStartOffset(ast), NamespaceDefinitionImpl.getEndOffset(ast), NamespaceDefinitionImpl.calcLeftBracketPos(ast));
    }

    private NamespaceDefinitionImpl(CharSequence name, NamespaceImpl parent, CsmFile file, int startOffset, int endOffset, int leftBracketPos) {
        super(file, startOffset, endOffset);
        this.declarations = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        this.name = name;
        NamespaceImpl nsImpl = ((ProjectBase)file.getProject()).findNamespaceCreateIfNeeded(parent, name);
        this.namespaceUID = UIDCsmConverter.namespaceToUID(nsImpl);
        assert (this.namespaceUID != null);
        this.namespaceRef = null;
        this.leftBracketPos = leftBracketPos != -1 ? leftBracketPos : startOffset;
        nsImpl.addNamespaceDefinition(this);
    }

    private NamespaceDefinitionImpl(CharSequence name, NamespaceImpl parent, NamespaceImpl ns, CsmFile file, int startOffset, int endOffset, int leftBracketPos) {
        super(file, startOffset, endOffset);
        this.declarations = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        this.name = name;
        this.namespaceUID = UIDCsmConverter.namespaceToUID(ns);
        assert (this.namespaceUID != null);
        this.namespaceRef = null;
        this.leftBracketPos = leftBracketPos != -1 ? leftBracketPos : startOffset;
        ns.addNamespaceDefinition(this);
    }

    public static NamespaceDefinitionImpl findOrCreateNamespaceDefionition(MutableDeclarationsContainer container, AST ast, NamespaceImpl parentNamespace, FileImpl containerfile) {
        int start = NamespaceDefinitionImpl.getStartOffset(ast);
        int end = NamespaceDefinitionImpl.getEndOffset(ast);
        CharSequence name = NameCache.getManager().getString(AstUtil.getText(ast));
        CsmOffsetableDeclaration candidate = container.findExistingDeclaration(start, name, CsmDeclaration.Kind.NAMESPACE_DEFINITION);
        if (TraceFlags.DYNAMIC_TESTS_TRACE && (((Object)containerfile.getName()).toString().equals("FieldInfos.cpp") || ((Object)containerfile.getName()).toString().equals("CompoundFile.cpp"))) {
            System.out.println("FieldInfos.cpp ns candidate " + candidate + " for name " + name);
        }
        if (CsmKindUtilities.isNamespaceDefinition((CsmObject)candidate)) {
            return (NamespaceDefinitionImpl)candidate;
        }
        NamespaceDefinitionImpl ns = new NamespaceDefinitionImpl(ast, containerfile, parentNamespace);
        container.addDeclaration(ns);
        return ns;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.NAMESPACE_DEFINITION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        Collection<CsmOffsetableDeclaration> decls;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            decls = UIDCsmConverter.UIDsToDeclarations(this.declarations);
        }
        return decls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmSelect.CsmFilter filter) {
        Iterator<CsmOffsetableDeclaration> out;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            out = UIDCsmConverter.UIDsToDeclarationsFiltered(this.declarations, filter);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int start, int end, CharSequence name) {
        CsmUID out = null;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            out = UIDUtilities.findExistingUIDInList(this.declarations, start, end, name);
        }
        return (CsmOffsetableDeclaration)UIDCsmConverter.UIDtoDeclaration(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CsmOffsetableDeclaration findExistingDeclaration(int start, CharSequence name, CsmDeclaration.Kind kind) {
        CsmUID out = null;
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            out = UIDUtilities.findExistingUIDInList(this.declarations, start, name, kind);
        }
        return (CsmOffsetableDeclaration)UIDCsmConverter.UIDtoDeclaration(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDeclaration(CsmOffsetableDeclaration decl) {
        FunctionImpl f;
        VariableImpl v;
        CsmUID<CsmOffsetableDeclaration> uid = RepositoryUtils.put(decl);
        assert (uid != null);
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            UIDUtilities.insertIntoSortedUIDList(uid, this.declarations);
        }
        if (decl instanceof VariableImpl && !NamespaceImpl.isNamespaceScope(v = (VariableImpl)decl, false)) {
            v.setScope((CsmScope)this);
        }
        if (decl instanceof FunctionImpl && !NamespaceImpl.isNamespaceScope(f = (FunctionImpl)decl)) {
            f.setScope((CsmScope)this);
        }
        RepositoryUtils.put(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDeclaration(CsmOffsetableDeclaration declaration) {
        CsmUID<CsmOffsetableDeclaration> uid = UIDCsmConverter.declarationToUID(declaration);
        assert (uid != null);
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            this.declarations.remove(uid);
        }
        RepositoryUtils.remove(uid, (CsmObject)declaration);
        RepositoryUtils.put(this);
    }

    public CharSequence getQualifiedName() {
        CsmNamespace ns = this.getNamespace();
        return ns != null ? ns.getQualifiedName() : this.getName();
    }

    public CsmNamespace getNamespace() {
        return this._getNamespaceImpl();
    }

    public CharSequence getName() {
        return this.name;
    }

    public CsmScope getScope() {
        return this.getContainingFile();
    }

    public Collection<CsmScopeElement> getScopeElements() {
        ArrayList<CsmScopeElement> l = new ArrayList<CsmScopeElement>();
        for (CsmDeclaration csmDeclaration : this.getDeclarations()) {
            if (!this.isOfMyScope(csmDeclaration)) continue;
            l.add((CsmScopeElement)csmDeclaration);
        }
        return l;
    }

    private boolean isOfMyScope(CsmDeclaration decl) {
        if (decl instanceof VariableImpl) {
            return !NamespaceImpl.isNamespaceScope((VariableImpl)decl, false);
        }
        if (decl instanceof FunctionImpl) {
            return !NamespaceImpl.isNamespaceScope((FunctionImpl)decl);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> uids;
        Collection<CsmOffsetableDeclaration> decls;
        super.dispose();
        this.onDispose();
        List<CsmUID<CsmOffsetableDeclaration>> list = this.declarations;
        synchronized (list) {
            decls = this.getDeclarations();
            uids = new ArrayList<CsmUID<CsmOffsetableDeclaration>>(this.declarations);
            this.declarations.clear();
        }
        Utils.disposeAll(decls);
        RepositoryUtils.remove(uids);
        NamespaceImpl ns = this._getNamespaceImpl();
        assert (ns != null);
        ns.removeNamespaceDefinition(this);
    }

    private synchronized void onDispose() {
        if (this.namespaceRef == null) {
            this.namespaceRef = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(this.namespaceUID);
            assert (this.namespaceRef != null || this.namespaceUID == null) : "no object for UID " + this.namespaceUID;
        }
    }

    private static int calcLeftBracketPos(AST node) {
        AST lcurly = AstUtil.findChildOfType(node, 16);
        return lcurly instanceof CsmAST ? ((CsmAST)lcurly).getOffset() : -1;
    }

    public int getLeftBracketOffset() {
        return this.leftBracketPos;
    }

    private synchronized NamespaceImpl _getNamespaceImpl() {
        NamespaceImpl impl = this.namespaceRef;
        if (impl == null) {
            impl = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(this.namespaceUID);
            assert (impl != null || this.namespaceUID == null) : "null object for UID " + this.namespaceUID;
        }
        return impl;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        factory.writeUIDCollection(this.declarations, output, true);
        assert (this.namespaceUID != null);
        factory.writeUID(this.namespaceUID, output);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, output);
        if (this.getName().length() == 0) {
            this.writeUID(output);
        }
        output.writeInt(this.leftBracketPos);
    }

    public NamespaceDefinitionImpl(RepositoryDataInput input) throws IOException {
        super(input);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        int collSize = input.readInt();
        this.declarations = collSize < 0 ? new ArrayList<CsmUID<CsmOffsetableDeclaration>>() : new ArrayList<CsmUID<CsmOffsetableDeclaration>>(collSize);
        factory.readUIDCollection(this.declarations, input, collSize);
        this.namespaceUID = factory.readUID(input);
        assert (this.namespaceUID != null);
        this.namespaceRef = null;
        this.name = PersistentUtils.readUTF(input, NameCache.getManager());
        assert (this.name != null);
        if (this.getName().length() == 0) {
            this.readUID(input);
        }
        this.leftBracketPos = input.readInt();
    }

    public static class NamespaceBuilder
    implements CsmObjectBuilder {
        private CharSequence name = CharSequences.empty();
        private String qName;
        private CsmFile file;
        private FileContent fileContent;
        private int startOffset;
        private int bodyStartOffset;
        private int endOffset;
        private NamespaceBuilder parent;
        private NamespaceImpl namespace;
        private NamespaceDefinitionImpl instance;
        private List<CsmOffsetableDeclaration> declarations = new ArrayList<CsmOffsetableDeclaration>();

        public void setName(CharSequence name) {
            this.name = name;
            this.qName = ((Object)name).toString();
        }

        public CharSequence getName() {
            return this.name;
        }

        public void setFile(CsmFile file) {
            this.file = file;
            this.fileContent = ((FileImpl)file).getParsingFileContent();
        }

        public void setEndOffset(int endOffset) {
            this.endOffset = endOffset;
        }

        public void setStartOffset(int startOffset) {
            this.startOffset = startOffset;
        }

        public void setBodyStartOffset(int bodyStartOffset) {
            this.bodyStartOffset = bodyStartOffset;
        }

        public void setParentNamespace(NamespaceBuilder parent) {
            this.parent = parent;
        }

        public void addDeclaration(CsmOffsetableDeclaration decl) {
            this.declarations.add(decl);
        }

        public NamespaceDefinitionImpl getNamespaceDefinitionInstance() {
            CsmOffsetableDeclaration decl;
            if (this.instance != null) {
                return this.instance;
            }
            MutableDeclarationsContainer container = this.parent == null ? this.fileContent : this.parent.getNamespaceDefinitionInstance();
            if (container != null && CsmKindUtilities.isNamespaceDefinition((CsmObject)(decl = container.findExistingDeclaration(this.startOffset, this.name, CsmDeclaration.Kind.NAMESPACE_DEFINITION)))) {
                this.instance = (NamespaceDefinitionImpl)decl;
            }
            return this.instance;
        }

        public NamespaceImpl getNamespace() {
            if (this.namespace != null) {
                return this.namespace;
            }
            this.namespace = this.parent != null ? ((ProjectBase)this.file.getProject()).findNamespaceCreateIfNeeded(this.parent.getNamespace(), this.name) : ((ProjectBase)this.file.getProject()).findNamespaceCreateIfNeeded((NamespaceImpl)((ProjectBase)this.file.getProject()).getGlobalNamespace(), this.name);
            return this.namespace;
        }

        public NamespaceDefinitionImpl create() {
            NamespaceDefinitionImpl ns = this.getNamespaceDefinitionInstance();
            if (ns == null) {
                NamespaceImpl parentNamespace = this.parent != null ? this.parent.getNamespace() : (NamespaceImpl)((ProjectBase)this.file.getProject()).getGlobalNamespace();
                ns = new NamespaceDefinitionImpl(this.name, parentNamespace, this.getNamespace(), this.file, this.startOffset, this.endOffset, this.bodyStartOffset);
                if (this.parent != null) {
                    this.parent.addDeclaration(ns);
                } else {
                    this.fileContent.addDeclaration(ns);
                }
            }
            for (CsmOffsetableDeclaration decl : this.declarations) {
                ns.addDeclaration(decl);
            }
            return ns;
        }
    }
}

