/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMethod;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public class MethodImpl<T>
extends FunctionImpl<T>
implements CsmMethod {
    private final CsmVisibility visibility;
    private static final byte ABSTRACT = 32;
    private static final byte VIRTUAL = 64;
    private static final byte EXPLICIT = -128;

    protected MethodImpl(CharSequence name, CharSequence rawName, CsmClass cls, CsmVisibility visibility, boolean _virtual, boolean _explicit, boolean _static, boolean _const, CsmFile file, int startOffset, int endOffset, boolean global) {
        super(name, rawName, (CsmScope)cls, _static, _const, file, startOffset, endOffset, global);
        this.visibility = visibility;
        this.setVirtual(_virtual);
        this.setExplicit(_explicit);
    }

    public static <T> MethodImpl<T> create(AST ast, CsmFile file, FileContent fileContent, ClassImpl cls, CsmVisibility visibility, boolean global) throws AstRendererException {
        ClassImpl scope = cls;
        int startOffset = MethodImpl.getStartOffset(ast);
        int endOffset = MethodImpl.getEndOffset(ast);
        NameHolder nameHolder = NameHolder.createFunctionName(ast);
        CharSequence name = QualifiedNameCache.getManager().getString(nameHolder.getName());
        if (name.length() == 0) {
            AstRendererException.throwAstRendererException((FileImpl)file, ast, startOffset, "Empty function name.");
        }
        CharSequence rawName = MethodImpl.initRawName(ast);
        boolean _static = AstRenderer.FunctionRenderer.isStatic(ast, file, fileContent, name);
        boolean _const = AstRenderer.FunctionRenderer.isConst(ast);
        boolean _virtual = false;
        boolean _explicit = false;
        block5: for (AST token = ast.getFirstChild(); token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 133: {
                    _static = true;
                    continue block5;
                }
                case 125: {
                    _virtual = true;
                    continue block5;
                }
                case 126: {
                    _explicit = true;
                }
            }
        }
        scope = AstRenderer.FunctionRenderer.getScope((CsmScope)scope, file, _static, false);
        MethodImpl<T> methodImpl = new MethodImpl<T>(name, rawName, cls, visibility, _virtual, _explicit, _static, _const, file, startOffset, endOffset, global);
        MethodImpl.temporaryRepositoryRegistration(global, methodImpl);
        StringBuilder clsTemplateSuffix = new StringBuilder();
        TemplateDescriptor templateDescriptor = MethodImpl.createTemplateDescriptor(ast, file, methodImpl, clsTemplateSuffix, global);
        CharSequence classTemplateSuffix = NameCache.getManager().getString((CharSequence)clsTemplateSuffix);
        methodImpl.setTemplateDescriptor(templateDescriptor, classTemplateSuffix);
        methodImpl.setReturnType(AstRenderer.FunctionRenderer.createReturnType(ast, methodImpl, file));
        methodImpl.setParameters(AstRenderer.FunctionRenderer.createParameters(ast, methodImpl, file, fileContent), AstRenderer.FunctionRenderer.isVoidParameter(ast));
        MethodImpl.postObjectCreateRegistration(global, methodImpl);
        nameHolder.addReference(fileContent, methodImpl);
        return methodImpl;
    }

    public CsmClass getContainingClass() {
        return (CsmClass)this.getScope();
    }

    public CsmVisibility getVisibility() {
        return this.visibility;
    }

    public boolean isAbstract() {
        return this.hasFlags((byte)32);
    }

    public void setAbstract(boolean _abstract) {
        this.setFlags((byte)32, _abstract);
    }

    private void setVirtual(boolean _virtual) {
        this.setFlags((byte)64, _virtual);
    }

    private void setExplicit(boolean _explicit) {
        this.setFlags((byte)-128, _explicit);
    }

    public boolean isExplicit() {
        return this.hasFlags((byte)-128);
    }

    public boolean isVirtual() {
        return this.hasFlags((byte)64);
    }

    @Override
    public boolean isConst() {
        return super.isConst();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeVisibility(this.visibility, output);
    }

    public MethodImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.visibility = PersistentUtils.readVisibility(input);
    }

    public static class MethodBuilder
    extends FunctionImpl.FunctionBuilder
    implements ClassImpl.MemberBuilder {
        private boolean _virtual = false;
        private boolean _explicit = false;
        private CsmVisibility visibility = CsmVisibility.PUBLIC;

        public CsmVisibility getVisibility() {
            return this.visibility;
        }

        public void setVisibility(CsmVisibility visibility) {
            this.visibility = visibility;
        }

        public boolean isVirtual() {
            return this._virtual;
        }

        public boolean isExplicit() {
            return this._explicit;
        }

        @Override
        public MethodImpl create() {
            CsmClass cls = (CsmClass)this.getScope();
            MethodImpl method = new MethodImpl(this.getName(), this.getRawName(), cls, this.getVisibility(), this.isVirtual(), this.isExplicit(), this.isStatic(), this.isConst(), this.getFile(), this.getStartOffset(), this.getEndOffset(), true);
            MethodImpl.temporaryRepositoryRegistration(true, method);
            StringBuilder clsTemplateSuffix = new StringBuilder();
            if (this.getTemplateDescriptorBuilder() != null) {
                method.setTemplateDescriptor(this.getTemplateDescriptor(), NameCache.getManager().getString(CharSequences.create((CharSequence)"")));
            }
            method.setReturnType(this.getType());
            ((FunctionParameterListImpl.FunctionParameterListBuilder)this.getParametersListBuilder()).setScope((CsmScope)method);
            method.setParameters(((FunctionParameterListImpl.FunctionParameterListBuilder)this.getParametersListBuilder()).create(), true);
            MethodImpl.postObjectCreateRegistration(true, method);
            this.getNameHolder().addReference(this.getFileContent(), method);
            return method;
        }
    }
}

