/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.CastUtils;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionParameterListImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.CompoundStatementImpl;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;

public class FunctionDefinitionImpl<T>
extends FunctionImplEx<T>
implements CsmFunctionDefinition {
    private CsmUID<CsmFunction> declarationUID;
    private CsmCompoundStatement body;
    private int parseCount;

    protected FunctionDefinitionImpl(CharSequence name, CharSequence rawName, CsmScope scope, boolean _static, boolean _const, CsmFile file, int startOffset, int endOffset, boolean global) {
        super(name, rawName, scope, _static, _const, file, startOffset, endOffset, global);
    }

    public static <T> FunctionDefinitionImpl<T> create(AST ast, CsmFile file, FileContent fileContent, CsmScope scope, boolean global, Map<Integer, CsmObject> objects) throws AstRendererException {
        int startOffset = FunctionDefinitionImpl.getStartOffset(ast);
        int endOffset = FunctionDefinitionImpl.getEndOffset(ast);
        NameHolder nameHolder = NameHolder.createFunctionName(ast);
        CharSequence name = QualifiedNameCache.getManager().getString(nameHolder.getName());
        if (name.length() == 0) {
            AstRendererException.throwAstRendererException((FileImpl)file, ast, startOffset, "Empty function name.");
        }
        CharSequence rawName = FunctionDefinitionImpl.initRawName(ast);
        boolean _static = AstRenderer.FunctionRenderer.isStatic(ast, file, fileContent, name);
        boolean _const = AstRenderer.FunctionRenderer.isConst(ast);
        scope = AstRenderer.FunctionRenderer.getScope(scope, file, _static, true);
        FunctionDefinitionImpl<T> functionDefinitionImpl = new FunctionDefinitionImpl<T>(name, rawName, scope, _static, _const, file, startOffset, endOffset, global);
        FunctionDefinitionImpl.temporaryRepositoryRegistration(global, functionDefinitionImpl);
        StringBuilder clsTemplateSuffix = new StringBuilder();
        TemplateDescriptor templateDescriptor = FunctionDefinitionImpl.createTemplateDescriptor(ast, file, functionDefinitionImpl, clsTemplateSuffix, global);
        CharSequence classTemplateSuffix = NameCache.getManager().getString((CharSequence)clsTemplateSuffix);
        functionDefinitionImpl.setTemplateDescriptor(templateDescriptor, classTemplateSuffix);
        functionDefinitionImpl.setReturnType(AstRenderer.FunctionRenderer.createReturnType(ast, functionDefinitionImpl, file, objects));
        functionDefinitionImpl.setParameters(AstRenderer.FunctionRenderer.createParameters(ast, functionDefinitionImpl, file, fileContent), AstRenderer.FunctionRenderer.isVoidParameter(ast));
        CharSequence[] classOrNspNames = CastUtils.isCast(ast) ? FunctionDefinitionImpl.getClassOrNspNames(ast) : functionDefinitionImpl.initClassOrNspNames(ast);
        functionDefinitionImpl.setClassOrNspNames(classOrNspNames);
        CsmCompoundStatement body = AstRenderer.findCompoundStatement(ast, file, functionDefinitionImpl);
        if (body == null) {
            throw AstRendererException.throwAstRendererException((FileImpl)file, ast, startOffset, "Null body in method definition.");
        }
        functionDefinitionImpl.setCompoundStatement(body);
        FunctionDefinitionImpl.postObjectCreateRegistration(global, functionDefinitionImpl);
        FunctionDefinitionImpl.postFunctionImpExCreateRegistration(fileContent, global, functionDefinitionImpl);
        nameHolder.addReference(fileContent, functionDefinitionImpl);
        return functionDefinitionImpl;
    }

    protected void setCompoundStatement(CsmCompoundStatement body) {
        this.body = body;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.body instanceof Disposable) {
            ((Disposable)this.body).dispose();
        }
    }

    @Override
    public CsmCompoundStatement getBody() {
        return this.body;
    }

    @Override
    public CsmFunction getDeclaration() {
        CsmFunction declaration = this._getDeclaration();
        if (declaration == null || FunctionImplEx.isFakeFunction((CsmObject)declaration) || !CsmBaseUtilities.isValid((CsmObject)declaration)) {
            int newCount = FileImpl.getParseCount();
            if (newCount == this.parseCount) {
                return declaration;
            }
            this._setDeclaration(null);
            declaration = this.findDeclaration();
            this._setDeclaration(declaration);
            this.parseCount = newCount;
        }
        return declaration;
    }

    private CsmFunction _getDeclaration() {
        CsmFunction decl = UIDCsmConverter.UIDtoDeclaration(this.declarationUID);
        return decl;
    }

    private void _setDeclaration(CsmFunction decl) {
        this.declarationUID = UIDCsmConverter.declarationToUID(decl);
        assert (this.declarationUID != null || decl == null);
    }

    private CsmDeclaration fixCastOperator(CsmClass owner) {
        CsmMember candidate = null;
        String s1 = ((Object)this.getName()).toString();
        int i1 = s1.lastIndexOf("::");
        if (i1 > 0) {
            s1 = "operator  " + s1.substring(i1 + 2);
        }
        Iterator it = CsmSelect.getClassMembers((CsmClass)owner, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter((CharSequence)"operator", false, true, false));
        while (it.hasNext()) {
            CsmMember m = (CsmMember)it.next();
            String s2 = ((Object)m.getName()).toString();
            int i2 = s2.lastIndexOf("::");
            if (i2 > 0) {
                s2 = "operator  " + s2.substring(i2 + 2);
            }
            if (!s1.equals(s2)) continue;
            if (candidate == null) {
                candidate = m;
                continue;
            }
            candidate = null;
            break;
        }
        return candidate;
    }

    private CsmFunction findDeclaration() {
        if (!this.isValid()) {
            return null;
        }
        String uname = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION) + ':' + this.getUniqueNameWithoutPrefix();
        Collection prjDecls = this.getContainingFile().getProject().findDeclarations((CharSequence)uname);
        if (prjDecls.isEmpty()) {
            uname = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.FUNCTION_FRIEND) + ':' + this.getUniqueNameWithoutPrefix();
            prjDecls = this.getContainingFile().getProject().findDeclarations((CharSequence)uname);
        }
        Collection<Object> decls = new ArrayList(1);
        if (prjDecls.isEmpty()) {
            CsmObject owner = this.findOwner();
            if (owner == null) {
                owner = CsmBaseUtilities.getFunctionClassByQualifiedName((CsmFunction)this);
            }
            if (CsmKindUtilities.isClass((CsmObject)owner)) {
                CsmDeclaration cast;
                Iterator it = CsmSelect.getClassMembers((CsmClass)((CsmClass)owner), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter(this.getName(), true, true, false));
                decls = this.findByNameAndParamsNumber(it, this.getName(), this.getParameters().size());
                if (decls.isEmpty() && this.isOperator() && (cast = this.fixCastOperator((CsmClass)owner)) != null) {
                    decls.add(cast);
                }
            } else if (CsmKindUtilities.isNamespace((Object)owner)) {
                Iterator it = CsmSelect.getDeclarations((CsmNamespace)((CsmNamespace)owner), (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter(this.getName(), true, true, false));
                decls = this.findByNameAndParamsNumber(it, this.getName(), this.getParameters().size());
            }
        } else {
            decls = this.findByNameAndParamsNumber(prjDecls.iterator(), this.getName(), this.getParameters().size());
        }
        CsmFunction decl = this.chooseDeclaration(decls);
        return decl;
    }

    private Collection<CsmDeclaration> findByNameAndParamsNumber(Iterator<? extends CsmObject> declarations, CharSequence name, int paramsNumber) {
        ArrayList<Object> out = new ArrayList<CsmDeclaration>(1);
        ArrayList<CsmFunction> best = new ArrayList<CsmFunction>(1);
        ArrayList<CsmFunction> otherVisible = new ArrayList<CsmFunction>(1);
        Iterator<? extends CsmObject> it = declarations;
        while (it.hasNext()) {
            CsmFunction decl;
            CsmObject o = it.next();
            if (!CsmKindUtilities.isFunction((CsmObject)o) || !(decl = (CsmFunction)o).getName().equals(name)) continue;
            if (decl.getParameters().size() == paramsNumber) {
                if (!FunctionImplEx.isFakeFunction((CsmObject)decl) && FunctionImpl.isObjectVisibleInFile(this.getContainingFile(), (CsmOffsetableDeclaration)decl)) {
                    best.add(decl);
                    continue;
                }
                out.add((CsmDeclaration)decl);
                continue;
            }
            if (FunctionImplEx.isFakeFunction((CsmObject)decl)) continue;
            if (FunctionImpl.isObjectVisibleInFile(this.getContainingFile(), (CsmOffsetableDeclaration)decl)) {
                otherVisible.add(decl);
            }
            out.add(decl);
        }
        if (!best.isEmpty()) {
            out = best;
        } else if (!otherVisible.isEmpty()) {
            out = otherVisible;
        }
        return out;
    }

    @Override
    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.FUNCTION_DEFINITION;
    }

    @Override
    protected String findQualifiedName() {
        CsmFunction declaration = this._getDeclaration();
        if (declaration != null) {
            return ((Object)declaration.getQualifiedName()).toString();
        }
        return super.findQualifiedName();
    }

    @Override
    public CsmScope getScope() {
        return this.getContainingFile();
    }

    @Override
    public Collection<CsmScopeElement> getScopeElements() {
        Collection<CsmScopeElement> l = super.getScopeElements();
        l.add((CsmScopeElement)this.getBody());
        return l;
    }

    @Override
    public CsmFunctionDefinition getDefinition() {
        return this;
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeCompoundStatement(this.body, output);
        UIDObjectFactory.getDefaultFactory().writeUID(this.declarationUID, output);
    }

    public FunctionDefinitionImpl(RepositoryDataInput input) throws IOException {
        super(input);
        this.body = PersistentUtils.readCompoundStatement(input);
        this.declarationUID = UIDObjectFactory.getDefaultFactory().readUID(input);
    }

    public static class FunctionDefinitionBuilder
    extends FunctionImplEx.FunctionExBuilder
    implements StatementBase.StatementBuilderContainer {
        private CompoundStatementImpl.CompoundStatementBuilder bodyBuilder;

        public void setBodyBuilder(CompoundStatementImpl.CompoundStatementBuilder builder) {
            this.bodyBuilder = builder;
        }

        public CompoundStatementImpl.CompoundStatementBuilder getBodyBuilder() {
            return this.bodyBuilder;
        }

        @Override
        public FunctionDefinitionImpl create() {
            CsmScope scope = AstRenderer.FunctionRenderer.getScope(this.getScope(), this.getFile(), this.isStatic(), true);
            FunctionDefinitionImpl impl = new FunctionDefinitionImpl(this.getName(), this.getRawName(), scope, this.isStatic(), this.isConst(), this.getFile(), this.getStartOffset(), this.getEndOffset(), true);
            FunctionDefinitionImpl.temporaryRepositoryRegistration(true, impl);
            if (this.getTemplateDescriptorBuilder() != null) {
                impl.setTemplateDescriptor(this.getTemplateDescriptor(), NameCache.getManager().getString(CharSequences.create((CharSequence)"")));
            }
            impl.setReturnType(this.getType());
            ((FunctionParameterListImpl.FunctionParameterListBuilder)this.getParametersListBuilder()).setScope((CsmScope)impl);
            impl.setParameters(((FunctionParameterListImpl.FunctionParameterListBuilder)this.getParametersListBuilder()).create(), false);
            impl.setClassOrNspNames(this.getScopeNames());
            this.bodyBuilder.setScope((CsmScope)impl);
            impl.setCompoundStatement(this.bodyBuilder.create());
            FunctionDefinitionImpl.postObjectCreateRegistration(true, impl);
            FunctionImplEx.postFunctionImpExCreateRegistration(this.getFileContent(), this.isGlobal(), impl);
            this.getNameHolder().addReference(this.getFileContent(), impl);
            this.addDeclaration(impl);
            return impl;
        }

        @Override
        public void addStatementBuilder(StatementBase.StatementBuilder builder) {
            assert (builder instanceof CompoundStatementImpl.CompoundStatementBuilder);
            this.setBodyBuilder((CompoundStatementImpl.CompoundStatementBuilder)builder);
        }

        protected void setBody(FunctionDefinitionImpl fun) {
            this.bodyBuilder.setScope((CsmScope)fun);
            fun.setCompoundStatement(this.bodyBuilder.create());
        }
    }
}

