/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.content.file.FileContent;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.ClassImpl;
import org.netbeans.modules.cnd.modelimpl.csm.DeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.InheritanceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.NameHolder;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceDefinitionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.SpecializationDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;

public class ClassImplSpecialization
extends ClassImpl
implements CsmTemplate {
    private CharSequence qualifiedNameSuffix = CharSequences.empty();
    private SpecializationDescriptor specializationDesctiptor;

    protected ClassImplSpecialization(AST ast, NameHolder name, CsmFile file) {
        super(name, ast, file);
    }

    protected ClassImplSpecialization(AST ast, NameHolder name, CsmFile file, int start, int end) {
        super(name, ast, file, start, end);
    }

    protected ClassImplSpecialization(NameHolder name, CsmDeclaration.Kind kind, CsmFile file, int start, int end) {
        super(name, kind, start, file, start, end);
    }

    @Override
    public final void init(CsmScope scope, AST ast, CsmFile file, FileContent fileContent, boolean register) throws AstRendererException {
        this.initScope(scope);
        ClassImplSpecialization.temporaryRepositoryRegistration(register, this);
        this.render(ast, file, fileContent, !register);
        this.initQualifiedName(ast, scope, register, file);
        if (register) {
            this.register(this.getScope(), false);
        }
    }

    public final void init2(SpecializationDescriptor specializationDesctiptor, CharSequence qualifiedNameSuffix, CsmScope scope, CsmFile file, FileContent fileContent, boolean register) throws AstRendererException {
        this.initScope(scope);
        ClassImplSpecialization.temporaryRepositoryRegistration(register, this);
        this.qualifiedNameSuffix = qualifiedNameSuffix;
        this.initQualifiedName(scope);
        this.specializationDesctiptor = specializationDesctiptor;
        if (register) {
            this.register(this.getScope(), false);
        }
    }

    protected final void initQualifiedName(AST ast, CsmScope scope, boolean register, CsmFile file) throws AstRendererException {
        AST qIdToken = AstUtil.findChildOfType(ast, 542);
        if (qIdToken == null) {
            throw AstRendererException.throwAstRendererException((FileImpl)file, ast, this.getStartOffset(), "Empty class specialization name.");
        }
        this.qualifiedNameSuffix = NameCache.getManager().getString((CharSequence)TemplateUtils.getSpecializationSuffix(qIdToken, this.getTemplateParameters()));
        this.initQualifiedName(scope);
        this.specializationDesctiptor = SpecializationDescriptor.createIfNeeded(ast, this.getContainingFile(), scope, register);
    }

    public static ClassImplSpecialization create(AST ast, CsmScope scope, CsmFile file, FileContent fileContent, boolean register, DeclarationsContainer container) throws AstRendererException {
        ClassImpl clsImpl = ClassImplSpecialization.findExistingClassImplInContainer(container, ast);
        ClassImplSpecialization impl = null;
        if (clsImpl instanceof ClassImplSpecialization) {
            impl = (ClassImplSpecialization)clsImpl;
        }
        NameHolder nameHolder = null;
        if (impl == null) {
            nameHolder = NameHolder.createClassName(ast);
            impl = new ClassImplSpecialization(ast, nameHolder, file);
        }
        impl.init(scope, ast, file, fileContent, register);
        if (nameHolder != null) {
            nameHolder.addReference(fileContent, impl);
        }
        return impl;
    }

    @Override
    public boolean isTemplate() {
        return true;
    }

    @Override
    public boolean isSpecialization() {
        return true;
    }

    @Override
    public boolean isExplicitSpecialization() {
        return false;
    }

    @Override
    public String getQualifiedNamePostfix() {
        return super.getQualifiedNamePostfix() + ((Object)this.qualifiedNameSuffix).toString();
    }

    protected String getQualifiedNameWithoutSuffix() {
        CsmScope scope = this.getScope();
        String name = ((Object)this.getName()).toString();
        if (CsmKindUtilities.isNamespace((Object)scope)) {
            return Utils.getQualifiedName(name, (CsmNamespace)scope);
        }
        if (CsmKindUtilities.isClass((CsmObject)scope)) {
            String n = name;
            if (name.contains("::")) {
                name = name.substring(name.lastIndexOf("::") + 2);
            }
            return ((CsmClass)scope).getQualifiedName() + "::" + name;
        }
        return name;
    }

    public List<CsmSpecializationParameter> getSpecializationParameters() {
        return this.specializationDesctiptor != null ? this.specializationDesctiptor.getSpecializationParameters() : Collections.emptyList();
    }

    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        PersistentUtils.writeUTF(this.qualifiedNameSuffix, output);
        PersistentUtils.writeSpecializationDescriptor(this.specializationDesctiptor, output);
    }

    public ClassImplSpecialization(RepositoryDataInput input) throws IOException {
        super(input);
        this.qualifiedNameSuffix = PersistentUtils.readUTF(input, NameCache.getManager());
        this.specializationDesctiptor = PersistentUtils.readSpecializationDescriptor(input);
    }

    @Override
    public String getDisplayName() {
        return this.getName() + ((Object)this.qualifiedNameSuffix).toString();
    }

    public static class ClassSpecializationBuilder
    extends ClassImpl.ClassBuilder {
        private SpecializationDescriptor.SpecializationDescriptorBuilder specializationDescriptorBuilder;
        private ClassImplSpecialization instance;

        public ClassSpecializationBuilder() {
        }

        public ClassSpecializationBuilder(ClassImpl.ClassBuilder classBuilder) {
            super(classBuilder);
        }

        public void setSpecializationDescriptorBuilder(SpecializationDescriptor.SpecializationDescriptorBuilder specializationDescriptorBuilder) {
            this.specializationDescriptorBuilder = specializationDescriptorBuilder;
        }

        public SpecializationDescriptor getSpecializationDescriptor() {
            if (this.specializationDescriptorBuilder != null) {
                this.specializationDescriptorBuilder.setScope((CsmScope)this.instance);
                return this.specializationDescriptorBuilder.create();
            }
            return null;
        }

        private ClassImplSpecialization getInstance() {
            CsmOffsetableDeclaration decl;
            if (this.instance != null) {
                return this.instance;
            }
            MutableDeclarationsContainer container = null;
            if (this.getParent() == null) {
                container = this.getFileContent();
            } else if (this.getParent() instanceof NamespaceDefinitionImpl.NamespaceBuilder) {
                container = ((NamespaceDefinitionImpl.NamespaceBuilder)this.getParent()).getNamespaceDefinitionInstance();
            }
            if (container != null && this.getName() != null && (decl = container.findExistingDeclaration(this.getStartOffset(), this.getName(), this.getKind())) != null && ClassImplSpecialization.class.equals(decl.getClass())) {
                this.instance = (ClassImplSpecialization)decl;
            }
            return this.instance;
        }

        @Override
        public ClassImpl create() {
            ClassImplSpecialization cls = this.getInstance();
            CsmScope s = this.getScope();
            if (cls == null && s != null && this.getName() != null && this.getEndOffset() != 0) {
                this.instance = cls = new ClassImplSpecialization(this.getNameHolder(), this.getKind(), this.getFile(), this.getStartOffset(), this.getEndOffset());
                try {
                    StringBuilder sb = new StringBuilder();
                    sb.append("<");
                    boolean first = true;
                    for (CsmSpecializationParameter param : this.getSpecializationDescriptor().getSpecializationParameters()) {
                        if (!first) {
                            sb.append(",");
                        }
                        sb.append(param.getText());
                        first = false;
                    }
                    sb.append(">");
                    cls.init2(this.getSpecializationDescriptor(), NameCache.getManager().getString(CharSequences.create((CharSequence)sb.toString())), s, this.getFile(), this.getFileContent(), this.isGlobal());
                }
                catch (AstRendererException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (this.getTemplateDescriptorBuilder() != null) {
                    cls.setTemplateDescriptor(this.getTemplateDescriptor());
                }
                for (InheritanceImpl.InheritanceBuilder inheritanceBuilder : this.getInheritanceBuilders()) {
                    inheritanceBuilder.setScope((CsmScope)cls);
                    cls.addInheritance(inheritanceBuilder.create(), this.isGlobal());
                }
                for (ClassImpl.MemberBuilder builder : this.getMemberBuilders()) {
                    builder.setScope((CsmScope)cls);
                    cls.addMember(builder.create(), this.isGlobal());
                }
                this.getNameHolder().addReference(this.getFileContent(), cls);
                this.addDeclaration(cls);
            }
            return cls;
        }
    }
}

