/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.openide.util.CharSequences;

public class CastUtils {
    public static boolean isCast(AST ast) {
        switch (ast.getType()) {
            case 524: 
            case 525: 
            case 526: 
            case 527: {
                return true;
            }
        }
        return false;
    }

    public static String getFunctionName(AST ast) {
        assert (CastUtils.isCast(ast));
        AST operator = AstUtil.findChildOfType(ast, 110);
        if (operator == null) {
            return "operator ???";
        }
        StringBuilder sb = new StringBuilder(operator.getText());
        sb.append(' ');
        block6: for (AST next = operator.getNextSibling(); next != null; next = next.getNextSibling()) {
            switch (next.getType()) {
                case 508: 
                case 509: {
                    sb.append(' ');
                    CastUtils.addTypeText(next, sb);
                    continue block6;
                }
                case 574: {
                    CastUtils.addTypeText(next, sb);
                    continue block6;
                }
                case 12: {
                    break block6;
                }
                case 32: 
                case 43: 
                case 135: 
                case 136: 
                case 137: {
                    sb.append(next.getText());
                    continue block6;
                }
                default: {
                    sb.append(' ');
                    sb.append(next.getText());
                }
            }
        }
        return sb.toString();
    }

    public static CharSequence getFunctionRawName(AST token) {
        assert (CastUtils.isCast(token));
        AST ast = token;
        StringBuilder l = new StringBuilder();
        block5: for (token = token.getFirstChild(); token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 91: {
                    if (l.length() > 0) {
                        l.append('.');
                    }
                    l.append(AstUtil.getText(token));
                    continue block5;
                }
                case 52: {
                    continue block5;
                }
                case 110: {
                    if (l.length() > 0) {
                        l.append('.');
                    }
                    l.append(CastUtils.getFunctionName(ast));
                    return NameCache.getManager().getString(CharSequences.create((CharSequence)l.toString()));
                }
            }
        }
        return NameCache.getManager().getString(CharSequences.create((CharSequence)l.toString()));
    }

    private static void addTypeText(AST ast, StringBuilder sb) {
        if (ast == null) {
            return;
        }
        for (AST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (492 <= child.getType() && child.getType() <= 581) {
                CastUtils.addTypeText(child, sb);
                continue;
            }
            String text = child.getText();
            assert (text != null);
            assert (text.length() > 0);
            if (sb.length() > 0 && Character.isLetterOrDigit(sb.charAt(sb.length() - 1)) && Character.isLetterOrDigit(text.charAt(0))) {
                sb.append(' ');
            }
            sb.append(text);
        }
    }

    public static boolean isMemberDefinition(AST ast) {
        assert (CastUtils.isCast(ast));
        AST child = ast.getFirstChild();
        if (child != null && child.getType() == 116) {
            child = AstRenderer.skipTemplateSibling(child);
        }
        child = AstRenderer.getFirstSiblingSkipInline(child);
        if ((child = AstRenderer.getFirstSiblingSkipQualifiers(child)) != null && child.getType() == 91) {
            if ((child = child.getNextSibling()) != null && child.getType() == 21) {
                child = AstRenderer.skipTemplateParameters(child);
            }
            if (child != null && child.getType() == 52) {
                return true;
            }
        }
        return false;
    }
}

