/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;

public class AstRendererException
extends Exception {
    public static AstRendererException throwAstRendererException(FileImpl file, AST ast, int offset, String message) throws AstRendererException {
        StringBuilder buf = new StringBuilder();
        buf.append('\n').append(file.getAbsolutePath());
        if (offset != 0) {
            int[] lineColumn = file.getLineColumn(offset);
            buf.append(':').append(lineColumn[0]);
            buf.append(':').append(lineColumn[1]);
            buf.append(": error: ").append(message);
            throw new AstRendererException(buf.toString());
        }
        if (ast != null) {
            offset = AstRendererException.getStartOffset(ast);
            if (offset == -1) {
                offset = AstRendererException.getEndOffset(ast);
            }
            if (offset != -1) {
                int[] lineColumn = file.getLineColumn(offset);
                buf.append(':').append(lineColumn[0]);
                buf.append(':').append(lineColumn[1]);
                buf.append(": error: ").append(message);
                throw new AstRendererException(buf.toString());
            }
        }
        buf.append(": undefined position : error: ").append(message);
        throw new AstRendererException(buf.toString());
    }

    private AstRendererException(String message) {
        super(message);
    }

    private static int getStartOffset(AST node) {
        CsmAST csmAst = AstUtil.getFirstCsmAST(node);
        if (csmAst != null) {
            return csmAst.getOffset();
        }
        return -1;
    }

    private static int getEndOffset(AST node) {
        AST lastChild = AstUtil.getLastChildRecursively(node);
        if (lastChild.getType() != 1 && lastChild instanceof CsmAST) {
            return ((CsmAST)lastChild).getEndOffset();
        }
        lastChild = AstUtil.getLastNonEOFChildRecursively(node);
        if (lastChild instanceof CsmAST) {
            return ((CsmAST)lastChild).getEndOffset();
        }
        return -1;
    }
}

