/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.content.project;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.modelimpl.content.project.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.FileContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.DefaultCache;
import org.netbeans.modules.cnd.modelimpl.uid.KeyBasedUID;
import org.netbeans.modules.cnd.modelimpl.uid.LazyCsmCollection;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.spi.utils.CndFileSystemProvider;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.APTStringManager;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.cache.FilePathCache;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class FileContainer
extends ProjectComponent
implements Persistent,
SelfPersistent {
    private static final boolean TRACE_PP_STATE_OUT = DebugUtils.getBoolean((String)"cnd.dump.preproc.state", (boolean)false);
    private final Object lock = new Lock();
    private final Map<CharSequence, FileEntry> myFiles = new ConcurrentHashMap<CharSequence, FileEntry>();
    private final ConcurrentMap<CharSequence, Object> canonicFiles = new ConcurrentHashMap<CharSequence, Object>();
    private final FileSystem fileSystem;
    private static final FileContainer EMPTY = new FileContainer(){

        @Override
        public void put() {
        }

        @Override
        public void putFile(FileImpl impl, APTPreprocHandler.State state) {
        }
    };
    private static final boolean TRACE = false;

    public FileContainer(ProjectBase project) {
        super(new FileContainerKey(project.getUnitId()));
        this.fileSystem = project.getFileSystem();
        this.put();
    }

    public FileContainer(RepositoryDataInput input) throws IOException {
        super(input);
        this.fileSystem = PersistentUtils.readFileSystem(input);
        FileContainer.readStringToFileEntryMap(this.fileSystem, this.getUnitId(), input, this.myFiles);
        FileContainer.readStringToStringsArrMap(this.getUnitId(), input, this.canonicFiles);
        if (CndUtils.isDebugMode()) {
            this.checkConsistency();
        }
    }

    private FileContainer() {
        super((Key)null);
        this.fileSystem = null;
    }

    public static FileContainer empty() {
        return EMPTY;
    }

    private void trace(Map<CharSequence, Object> map, String title) {
        System.err.printf("%s\n", title);
        for (Map.Entry<CharSequence, Object> entry : map.entrySet()) {
            System.err.printf("%s ->\n%s\n\n", entry.getKey(), entry.getValue());
        }
    }

    public void putFile(FileImpl impl, APTPreprocHandler.State state) {
        if (CndUtils.isDebugMode()) {
            this.checkConsistency();
        }
        CharSequence path = FileContainer.getFileKey(impl.getAbsolutePath(), true);
        CharSequence canonicalPath = this.getCanonicalKey(path);
        CsmUID<FileImpl> uid = RepositoryUtils.put(impl);
        FileEntry newEntry = new FileEntry(uid, state, path, canonicalPath);
        FileEntry old = this.myFiles.put(path, newEntry);
        this.addAlternativeFileKey(path, newEntry.canonical);
        if (old != null) {
            System.err.println("Replace file info for " + old.fileNew + " with " + impl);
        }
        if (CndUtils.isDebugMode()) {
            this.checkConsistency();
        }
    }

    public void removeFile(CharSequence file) {
        FileEntry f;
        CharSequence path = FileContainer.getFileKey(file, false);
        if (CndUtils.isDebugMode()) {
            this.checkConsistency();
        }
        if ((f = this.myFiles.remove(path)) != null) {
            this.removeAlternativeFileKey(f.canonical, path);
        }
        if (f == null || f.fileNew != null) {
            // empty if block
        }
        if (CndUtils.isDebugMode()) {
            this.checkConsistency();
        }
    }

    public FileImpl getFile(CharSequence absPath, boolean treatSymlinkAsSeparateFile) {
        FileEntry f = this.getFileEntry(absPath, treatSymlinkAsSeparateFile, false);
        return this.getFile(f);
    }

    private FileImpl getFile(FileEntry f) {
        if (f == null) {
            return null;
        }
        CsmUID fileUID = f.fileNew;
        FileImpl impl = (FileImpl)UIDCsmConverter.UIDtoFile((CsmUID<CsmFile>)f.fileNew);
        if (impl == null) {
            String postfix = "";
            if (CndUtils.isDebugMode() || CndUtils.isUnitTestMode()) {
                FileImpl impl2 = (FileImpl)UIDCsmConverter.UIDtoFile((CsmUID<CsmFile>)f.fileNew);
                postfix = impl2 == null ? " TWICE" : " second attempt OK";
            }
            if (fileUID instanceof KeyBasedUID) {
                DiagnosticExceptoins.registerIllegalRepositoryStateException("no file for UID " + postfix, fileUID);
            }
        }
        return impl;
    }

    public CsmUID<CsmFile> getFileUID(CharSequence absPath, boolean treatSymlinkAsSeparateFile) {
        FileEntry f = this.getFileEntry(absPath, treatSymlinkAsSeparateFile, false);
        if (f == null) {
            return null;
        }
        return f.fileNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidatePreprocState(CharSequence absPath) {
        FileEntry f = this.getFileEntry(absPath, false, false);
        if (f == null) {
            return;
        }
        FileEntry fileEntry = f;
        synchronized (fileEntry) {
            f.invalidateStates();
        }
        if (TRACE_PP_STATE_OUT) {
            CharSequence path = FileContainer.getFileKey(absPath, false);
            System.err.println("\nInvalidated state for file" + path + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markAsParsingPreprocStates(CharSequence absPath) {
        FileEntry f = this.getFileEntry(absPath, false, false);
        if (f == null) {
            return;
        }
        FileEntry fileEntry = f;
        synchronized (fileEntry) {
            f.markAsParsingPreprocStates();
        }
        if (TRACE_PP_STATE_OUT) {
            CharSequence path = FileContainer.getFileKey(absPath, false);
            System.err.println("\nmarkAsParsingPreprocStates for file" + path + "\n");
        }
    }

    public FileEntry getEntry(CharSequence absPath) {
        CndUtils.assertTrue((boolean)CndPathUtilitities.isPathAbsolute((CharSequence)absPath), (String)"Path should be absolute: ", (Object)absPath);
        return this.getFileEntry(absPath, false, false);
    }

    public Object getLock(CharSequence absPath) {
        FileEntry f = this.getFileEntry(absPath, false, false);
        return f == null ? this.lock : f.getLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugClearState() {
        ArrayList<FileEntry> files = new ArrayList<FileEntry>(this.myFiles.values());
        for (FileEntry file : files) {
            Object object = file.getLock();
            synchronized (object) {
                file.debugClearState();
            }
        }
        this.put();
    }

    public Collection<CsmFile> getFiles() {
        ArrayList uids = new ArrayList(this.myFiles.values().size());
        this.getFiles2(uids);
        return new LazyCsmCollection(uids, TraceFlags.SAFE_UID_ACCESS);
    }

    public Collection<CsmUID<CsmFile>> getFilesUID() {
        ArrayList<CsmUID<CsmFile>> uids = new ArrayList<CsmUID<CsmFile>>(this.myFiles.values().size());
        this.getFiles2(uids);
        return uids;
    }

    public Collection<FileImpl> getFileImpls() {
        ArrayList uids = new ArrayList(this.myFiles.values().size());
        this.getFiles2(uids);
        return new LazyCsmCollection(uids, TraceFlags.SAFE_UID_ACCESS);
    }

    private void getFiles2(List<CsmUID<CsmFile>> res) {
        ArrayList<FileEntry> files = new ArrayList<FileEntry>(this.myFiles.values());
        for (FileEntry f : files) {
            res.add((CsmUID<CsmFile>)f.fileNew);
        }
    }

    public int getSize() {
        return this.myFiles.size();
    }

    @Override
    public void write(RepositoryDataOutput aStream) throws IOException {
        super.write(aStream);
        PersistentUtils.writeFileSystem(this.fileSystem, aStream);
        FileContainer.writeStringToFileEntryMap(this.getUnitId(), aStream, this.myFiles);
        FileContainer.writeStringToStringsArrMap(this.getUnitId(), aStream, this.canonicFiles);
    }

    public static CharSequence getFileKey(CharSequence file, boolean sharedText) {
        return sharedText ? FilePathCache.getManager().getString(file) : DefaultCache.getManager().getString(file);
    }

    private CharSequence getAlternativeFileKey(CharSequence primaryKey) {
        Object out = this.canonicFiles.get(primaryKey);
        if (out instanceof CharSequence) {
            return (CharSequence)out;
        }
        if (out != null) {
            assert (((CharSequence[])out).length >= 2);
            return ((CharSequence[])out)[0];
        }
        return null;
    }

    private FileEntry getFileEntry(CharSequence absPath, boolean treatSymlinkAsSeparateFile, boolean sharedText) {
        return this.getFileEntryImpl(FileContainer.getFileKey(absPath, sharedText), treatSymlinkAsSeparateFile);
    }

    private FileEntry getFileEntryImpl(CharSequence path, boolean treatSymlinkAsSeparateFile) {
        FileEntry f = this.myFiles.get(path);
        if (!(f != null || treatSymlinkAsSeparateFile && TraceFlags.SYMLINK_AS_OWN_FILE)) {
            CharSequence path2 = this.getAlternativeFileKey(path);
            FileEntry fileEntry = f = path2 == null ? null : this.myFiles.get(path2);
            if (f != null && TraceFlags.TRACE_CANONICAL_FIND_FILE) {
                CndUtils.assertTrueInConsole((boolean)false, (String)("alternative for " + path + " is " + path2));
            }
        }
        return f;
    }

    private void addAlternativeFileKey(CharSequence primaryKey, CharSequence canonicKey) {
        CharSequence[] newVal;
        Object out = this.canonicFiles.get(canonicKey);
        if (out == null) {
            newVal = primaryKey;
        } else if (out instanceof CharSequence) {
            if (out.equals(primaryKey)) {
                return;
            }
            newVal = new CharSequence[]{(CharSequence)out, primaryKey};
        } else {
            CharSequence[] oldAr;
            for (CharSequence what : oldAr = (CharSequence[])out) {
                if (!what.equals(primaryKey)) continue;
                return;
            }
            CharSequence[] newAr = new CharSequence[oldAr.length + 1];
            System.arraycopy(oldAr, 0, newAr, 0, oldAr.length);
            newAr[oldAr.length] = primaryKey;
            newVal = newAr;
        }
        this.canonicFiles.put(canonicKey, newVal);
        if (TraceFlags.TRACE_CANONICAL_FIND_FILE) {
            if (newVal instanceof CharSequence[]) {
                System.err.println("entry for " + canonicKey + " while adding " + primaryKey + " is " + Arrays.asList(newVal).toString());
            } else {
                System.err.println("entry for " + canonicKey + " while adding " + primaryKey + " is " + newVal);
            }
        }
    }

    private void removeAlternativeFileKey(CharSequence canonicKey, CharSequence primaryKey) {
        CharSequence[] newVal;
        Object out = this.canonicFiles.get(canonicKey);
        assert (out != null) : "no entry for " + canonicKey + " of " + primaryKey;
        if (out instanceof CharSequence) {
            assert (primaryKey.equals(out)) : " primaryKey " + primaryKey + " have to be " + out;
            newVal = null;
        } else {
            Object[] oldAr = (CharSequence[])out;
            assert (oldAr.length >= 2);
            if (oldAr.length == 2) {
                assert (oldAr[0].equals(primaryKey) || oldAr[1].equals(primaryKey)) : "no primaryKey " + primaryKey + " in " + Arrays.toString(oldAr);
                newVal = oldAr[0].equals(primaryKey) ? oldAr[1] : oldAr[0];
            } else {
                CharSequence[] newAr = new CharSequence[oldAr.length - 1];
                int k = 0;
                boolean found = false;
                for (CharSequence charSequence : oldAr) {
                    if (!charSequence.equals(primaryKey)) {
                        newAr[k++] = charSequence;
                        continue;
                    }
                    found = true;
                }
                assert (found) : " not found " + primaryKey + " in " + oldAr;
                newVal = newAr;
            }
        }
        if (newVal == null) {
            boolean removed = this.canonicFiles.remove(canonicKey, out);
            CndUtils.assertTrue((boolean)removed, (String)"inconsistent state for ", (Object)primaryKey);
            if (TraceFlags.TRACE_CANONICAL_FIND_FILE) {
                System.err.println("removed entry for " + canonicKey + " while removing " + primaryKey);
            }
        } else {
            Object prevValue = this.canonicFiles.put(canonicKey, newVal);
            CndUtils.assertTrue((prevValue == out ? 1 : 0) != 0, (String)"inconsistent state for ", (Object)primaryKey);
            if (TraceFlags.TRACE_CANONICAL_FIND_FILE) {
                System.err.println("change entry for " + canonicKey + " while removing " + primaryKey + " to " + newVal);
            }
        }
    }

    private void checkConsistency() {
        int valuesSize = 0;
        for (Map.Entry entry : this.canonicFiles.entrySet()) {
            Object value = entry.getValue();
            assert (value != null);
            CharSequence[] absPaths = value instanceof CharSequence ? new CharSequence[]{(CharSequence)value} : (CharSequence[])value;
            valuesSize += absPaths.length;
            for (CharSequence path : absPaths) {
                if (this.myFiles.containsKey(path)) continue;
                CndUtils.assertTrueInConsole((boolean)false, (String)("no Entry for registered absPath " + path + " with canonical " + entry.getKey()));
            }
        }
        assert (valuesSize == this.myFiles.size()) : "different number of elements " + this.myFiles.size() + " vs " + valuesSize;
    }

    static void writeStringToFileEntryMap(int unitIndex, RepositoryDataOutput output, Map<CharSequence, FileEntry> aMap) throws IOException {
        assert (output != null);
        assert (aMap != null);
        int size = aMap.size();
        output.writeInt(size);
        Set<Map.Entry<CharSequence, FileEntry>> entrySet = aMap.entrySet();
        for (Map.Entry<CharSequence, FileEntry> anEntry : entrySet) {
            PersistentUtils.writeFileNameIndex(anEntry.getKey(), output, unitIndex);
            assert (anEntry.getValue() != null);
            anEntry.getValue().write(output, unitIndex);
        }
    }

    static void readStringToFileEntryMap(FileSystem fs, int unitIndex, RepositoryDataInput input, Map<CharSequence, FileEntry> aMap) throws IOException {
        assert (input != null);
        assert (aMap != null);
        APTStringManager pathManager = FilePathCache.getManager();
        aMap.clear();
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            CharSequence key = PersistentUtils.readFileNameIndex(input, pathManager, unitIndex);
            FileEntry value = new FileEntry(fs, input, unitIndex);
            assert (key != null);
            assert (value != null);
            aMap.put(key, value);
        }
    }

    private static void writeStringToStringsArrMap(int unitIndex, RepositoryDataOutput output, Map<CharSequence, Object> aMap) throws IOException {
        assert (output != null);
        assert (aMap != null);
        int size = aMap.size();
        output.writeInt(size);
        Set<Map.Entry<CharSequence, Object>> entrySet = aMap.entrySet();
        for (Map.Entry<CharSequence, Object> anEntry : entrySet) {
            assert (anEntry != null);
            CharSequence key = anEntry.getKey();
            Object value = anEntry.getValue();
            assert (key != null);
            assert (value != null);
            assert (value instanceof CharSequence || value instanceof CharSequence[]);
            APTSerializeUtils.writeFileNameIndex((CharSequence)key, (RepositoryDataOutput)output, (int)unitIndex);
            if (value instanceof CharSequence) {
                output.writeInt(1);
                APTSerializeUtils.writeFileNameIndex((CharSequence)((CharSequence)value), (RepositoryDataOutput)output, (int)unitIndex);
                continue;
            }
            if (!(value instanceof CharSequence[])) continue;
            CharSequence[] array = (CharSequence[])value;
            output.writeInt(array.length);
            for (int j = 0; j < array.length; ++j) {
                APTSerializeUtils.writeFileNameIndex((CharSequence)array[j], (RepositoryDataOutput)output, (int)unitIndex);
            }
        }
    }

    private static void readStringToStringsArrMap(int unitId, RepositoryDataInput input, Map<CharSequence, Object> aMap) throws IOException {
        assert (input != null);
        assert (aMap != null);
        APTStringManager pathManager = FilePathCache.getManager();
        aMap.clear();
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            CharSequence key = APTSerializeUtils.readFileNameIndex((RepositoryDataInput)input, (APTStringManager)pathManager, (int)unitId);
            assert (key != null);
            int arraySize = input.readInt();
            assert (arraySize != 0);
            if (arraySize == 1) {
                aMap.put(key, APTSerializeUtils.readFileNameIndex((RepositoryDataInput)input, (APTStringManager)pathManager, (int)unitId));
                continue;
            }
            CharSequence[] value = new CharSequence[arraySize];
            for (int j = 0; j < arraySize; ++j) {
                CharSequence path = APTSerializeUtils.readFileNameIndex((RepositoryDataInput)input, (APTStringManager)pathManager, (int)unitId);
                assert (path != null);
                value[j] = path;
            }
            aMap.put(key, value);
        }
    }

    public Map<CharSequence, FileEntry> getFileStorage() {
        return new TreeMap<CharSequence, FileEntry>(this.myFiles);
    }

    public Map<CharSequence, Object> getCanonicalNames() {
        return new TreeMap<CharSequence, Object>(this.canonicFiles);
    }

    public static FileEntry createFileEntryForMerge(CharSequence fileKey) {
        return new FileEntry(null, null, fileKey, fileKey);
    }

    static FileEntry createFileEntry(FileImpl fileImpl) {
        CharSequence path = FileContainer.getFileKey(fileImpl.getAbsolutePath(), false);
        return new FileEntry(fileImpl.getUID(), null, path, path);
    }

    private CharSequence getCanonicalKey(CharSequence fileKey) {
        try {
            CharSequence res = CndFileSystemProvider.getCanonicalPath((FileSystem)this.fileSystem, (CharSequence)fileKey);
            res = FilePathCache.getManager().getString(res);
            if (fileKey.equals(res)) {
                return fileKey;
            }
            return res;
        }
        catch (IOException e) {
            return fileKey;
        }
    }

    private static CharSequence getCanonicalKey(FileObject fileObject, CharSequence fileKey) {
        try {
            CharSequence res = CndFileUtils.getCanonicalPath((FileObject)fileObject);
            res = FilePathCache.getManager().getString(res);
            if (fileKey.equals(res)) {
                return fileKey;
            }
            return res;
        }
        catch (IOException e) {
            return fileKey;
        }
    }

    public static final class FileEntry {
        private final CsmUID<CsmFile> fileNew;
        private final CharSequence canonical;
        private volatile Object data;
        private volatile int modCount;

        private FileEntry(FileSystem fs, RepositoryDataInput input, int unitIndex) throws IOException {
            this.fileNew = UIDObjectFactory.getDefaultFactory().readUID(input);
            this.canonical = PersistentUtils.readFileNameIndex(input, FilePathCache.getManager(), unitIndex);
            this.modCount = input.readInt();
            if (input.readBoolean()) {
                int cnt = input.readInt();
                assert (cnt > 0);
                if (cnt == 1) {
                    PreprocessorStatePair pair = FileEntry.readStatePair(fs, input, unitIndex);
                    this.data = pair;
                } else {
                    this.data = new ArrayList(cnt);
                    for (int i = 0; i < cnt; ++i) {
                        PreprocessorStatePair pair = FileEntry.readStatePair(fs, input, unitIndex);
                        ((List)this.data).add(pair);
                    }
                }
            } else {
                this.data = null;
            }
        }

        private FileEntry(CsmUID<CsmFile> fileNew, APTPreprocHandler.State state, CharSequence fileKey, CharSequence canonicalFileKey) {
            this.fileNew = fileNew;
            this.data = state == null ? null : new PreprocessorStatePair(state, FilePreprocessorConditionState.PARSING);
            this.canonical = canonicalFileKey;
            this.modCount = 0;
        }

        private void write(RepositoryDataOutput output, int unitIndex) throws IOException {
            UIDObjectFactory.getDefaultFactory().writeUID(this.fileNew, output);
            PersistentUtils.writeFileNameIndex(this.canonical, output, unitIndex);
            output.writeInt(this.modCount);
            Object aData = this.data;
            output.writeBoolean(aData != null);
            if (aData != null) {
                if (aData instanceof PreprocessorStatePair) {
                    output.writeInt(1);
                    PreprocessorStatePair pair = (PreprocessorStatePair)aData;
                    FileEntry.writeStatePair(output, pair, unitIndex);
                } else {
                    Collection pairs = (Collection)aData;
                    output.writeInt(pairs.size());
                    for (PreprocessorStatePair pair : pairs) {
                        FileEntry.writeStatePair(output, pair, unitIndex);
                    }
                }
            }
        }

        private static PreprocessorStatePair readStatePair(FileSystem fs, RepositoryDataInput input, int unitIndex) throws IOException {
            if (input.readBoolean()) {
                APTPreprocHandler.State state = null;
                if (input.readBoolean()) {
                    state = PersistentUtils.readPreprocState(fs, input, unitIndex);
                }
                FilePreprocessorConditionState pcState = null;
                pcState = input.readBoolean() ? new FilePreprocessorConditionState(input) : FilePreprocessorConditionState.PARSING;
                return new PreprocessorStatePair(state, pcState);
            }
            return null;
        }

        private static void writeStatePair(RepositoryDataOutput output, PreprocessorStatePair pair, int unitIndex) throws IOException {
            output.writeBoolean(pair != null);
            if (pair != null) {
                output.writeBoolean(pair.state != null);
                if (pair.state != null) {
                    PersistentUtils.writePreprocState(pair.state, output, unitIndex);
                }
                output.writeBoolean(pair.pcState != FilePreprocessorConditionState.PARSING);
                if (pair.pcState != FilePreprocessorConditionState.PARSING) {
                    pair.pcState.write(output);
                }
            }
        }

        public final synchronized int getModCount() {
            return this.modCount;
        }

        public Object getLock() {
            return this;
        }

        public synchronized void debugClearState() {
            this.data = null;
        }

        public final synchronized void setState(APTPreprocHandler.State state, FilePreprocessorConditionState pcState) {
            if (TraceFlags.TRACE_182342_BUG) {
                new Exception("setState replacing:\n" + this.toString()).printStackTrace(System.err);
            }
            APTPreprocHandler.State oldState = null;
            if (state != null && !state.isCleaned()) {
                state = APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)state);
            }
            if (this.data instanceof Collection) {
                Collection states = (Collection)this.data;
                int oldGoodStatesCount = 0;
                for (PreprocessorStatePair pair : states) {
                    if (pair.state == null || !pair.state.isValid()) continue;
                    ++oldGoodStatesCount;
                    if (oldState != null && !state.isCompileContext()) continue;
                    oldState = state;
                }
                if (oldGoodStatesCount > 1 && CndUtils.isDebugMode()) {
                    StringBuilder sb = new StringBuilder("Attempt to set state while there are multiple states: " + this.canonical);
                    for (PreprocessorStatePair pair : states) {
                        sb.append(String.format("\nvalid: %b context: %b %s", pair.state.isValid(), pair.state.isCompileContext(), pair.pcState));
                    }
                    Utils.LOG.log(Level.SEVERE, sb.toString(), new Exception(sb.toString()));
                }
            } else if (this.data instanceof PreprocessorStatePair) {
                oldState = ((PreprocessorStatePair)this.data).state;
            }
            this.incrementModCount();
            if (oldState != null && oldState.isValid() && oldState.isCompileContext() && !state.isCompileContext()) {
                if (CndUtils.isDebugMode()) {
                    String message = "Replacing correct state to incorrect " + this.canonical;
                    Utils.LOG.log(Level.SEVERE, message, new Exception());
                }
                return;
            }
            if (TRACE_PP_STATE_OUT) {
                System.err.println("\nPut state for file" + this.canonical + "\n");
                System.err.println(state);
            }
            this.data = new PreprocessorStatePair(state, pcState);
            if (TraceFlags.TRACE_182342_BUG) {
                new Exception("setState at the end:\n" + this.toString()).printStackTrace(System.err);
            }
        }

        public synchronized void setStates(Collection<PreprocessorStatePair> pairs, PreprocessorStatePair yetOneMore) {
            if (TraceFlags.TRACE_182342_BUG) {
                new Exception("setStates replacing:\n" + this.toString()).printStackTrace(System.err);
            }
            this.incrementModCount();
            if (yetOneMore != null && yetOneMore.state != null && !yetOneMore.state.isCleaned()) {
                yetOneMore = new PreprocessorStatePair(APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)yetOneMore.state), yetOneMore.pcState);
            }
            if (yetOneMore == null && pairs.size() == 1) {
                yetOneMore = pairs.iterator().next();
                pairs = Collections.emptyList();
            }
            if (pairs.isEmpty()) {
                assert (yetOneMore != null);
                this.data = yetOneMore;
            } else {
                ArrayList<PreprocessorStatePair> newData = new ArrayList<PreprocessorStatePair>(pairs.size() + 1);
                newData.addAll(pairs);
                if (yetOneMore != null) {
                    newData.add(yetOneMore);
                }
                if (TraceFlags.DYNAMIC_TESTS_TRACE) {
                    for (int i = 0; i < newData.size(); ++i) {
                        PreprocessorStatePair first = (PreprocessorStatePair)newData.get(i);
                        for (int j = i + 1; j < newData.size(); ++j) {
                            PreprocessorStatePair second = (PreprocessorStatePair)newData.get(j);
                            if (first.pcState != FilePreprocessorConditionState.PARSING && second.pcState != FilePreprocessorConditionState.PARSING || !APTHandlersSupport.equalsIgnoreInvalid((APTPreprocHandler.State)first.state, (APTPreprocHandler.State)second.state)) continue;
                            new Exception("setStates :\n" + newData).printStackTrace(System.err);
                        }
                    }
                }
                this.data = newData;
            }
            if (CndUtils.isDebugMode()) {
                this.checkConsistency();
            }
            if (TraceFlags.TRACE_182342_BUG) {
                new Exception("setStates at the end:\n" + this.toString()).printStackTrace(System.err);
            }
        }

        private void checkConsistency() {
            Collection<PreprocessorStatePair> pairs = this.getStatePairs();
            if (!pairs.isEmpty()) {
                boolean alarm = false;
                APTPreprocHandler.State firstState = null;
                FilePreprocessorConditionState firstPCState = null;
                boolean first = true;
                for (PreprocessorStatePair pair : this.getStatePairs()) {
                    if (first) {
                        first = false;
                        firstState = pair.state;
                        firstPCState = pair.pcState;
                        continue;
                    }
                    if (firstState == null != (pair.state == null)) {
                        alarm = true;
                        break;
                    }
                    if (firstState == null) continue;
                    if (firstState.isCompileContext() != pair.state.isCompileContext()) {
                        alarm = true;
                        break;
                    }
                    if (firstState.isValid() == pair.state.isValid()) continue;
                    alarm = !firstState.isValid() && firstPCState != FilePreprocessorConditionState.PARSING;
                    if (!(alarm |= !pair.state.isValid() && pair.pcState != FilePreprocessorConditionState.PARSING)) continue;
                    break;
                }
                if (alarm) {
                    StringBuilder sb = new StringBuilder("Mixed preprocessor states: " + this.canonical);
                    for (PreprocessorStatePair pair : this.getStatePairs()) {
                        if (pair.state == null) {
                            sb.append(String.format(" (null, %s)", pair.pcState));
                            continue;
                        }
                        sb.append(String.format(" (valid: %b, context: %b, %s) ", pair.state.isValid(), pair.state.isCompileContext(), pair.pcState));
                    }
                    Utils.LOG.log(Level.INFO, sb.toString(), new Exception(sb.toString()));
                }
            }
        }

        private synchronized void incrementModCount() {
            this.modCount = this.modCount == Integer.MAX_VALUE ? 0 : this.modCount + 1;
        }

        public synchronized void invalidateStates() {
            this.incrementModCount();
            if (this.data != null) {
                if (this.data instanceof PreprocessorStatePair) {
                    this.data = FileEntry.createInvalidState((PreprocessorStatePair)this.data);
                } else {
                    ArrayList<PreprocessorStatePair> newData = new ArrayList<PreprocessorStatePair>();
                    for (PreprocessorStatePair pair : (Collection)this.data) {
                        newData.add(FileEntry.createInvalidState(pair));
                    }
                    this.data = newData;
                }
            }
            if (TraceFlags.TRACE_182342_BUG) {
                new Exception("invalidateStates:\n" + this.toString()).printStackTrace(System.err);
            }
        }

        public synchronized void markAsParsingPreprocStates() {
            this.incrementModCount();
            if (this.data != null) {
                if (this.data instanceof PreprocessorStatePair) {
                    this.data = FileEntry.createMarkedAsParsingState((PreprocessorStatePair)this.data);
                } else {
                    ArrayList<PreprocessorStatePair> newData = new ArrayList<PreprocessorStatePair>();
                    for (PreprocessorStatePair pair : (Collection)this.data) {
                        newData.add(FileEntry.createMarkedAsParsingState(pair));
                    }
                    this.data = newData;
                }
            }
            if (TraceFlags.TRACE_182342_BUG) {
                new Exception("invalidateStates:\n" + this.toString()).printStackTrace(System.err);
            }
        }

        private static PreprocessorStatePair createMarkedAsParsingState(PreprocessorStatePair pair) {
            if (pair == null) {
                return pair;
            }
            if (pair.state == null) {
                return pair;
            }
            return new PreprocessorStatePair(pair.state, FilePreprocessorConditionState.PARSING);
        }

        private static PreprocessorStatePair createInvalidState(PreprocessorStatePair pair) {
            if (pair == null) {
                return pair;
            }
            if (pair.state == null) {
                return pair;
            }
            return new PreprocessorStatePair(APTHandlersSupport.createInvalidPreprocState((APTPreprocHandler.State)pair.state), pair.pcState);
        }

        public synchronized Collection<PreprocessorStatePair> getStatePairs() {
            if (this.data == null) {
                return Collections.emptyList();
            }
            if (this.data instanceof PreprocessorStatePair) {
                return Collections.singleton((PreprocessorStatePair)this.data);
            }
            Collection array = (Collection)this.data;
            return new ArrayList<PreprocessorStatePair>(array);
        }

        public synchronized Collection<APTPreprocHandler.State> getPrerocStates() {
            if (this.data == null) {
                return Collections.emptyList();
            }
            if (this.data instanceof PreprocessorStatePair) {
                return Collections.singleton(((PreprocessorStatePair)this.data).state);
            }
            Collection pairs = (Collection)this.data;
            ArrayList<APTPreprocHandler.State> result = new ArrayList<APTPreprocHandler.State>(pairs.size());
            for (PreprocessorStatePair pair : pairs) {
                result.add(pair.state);
            }
            return result;
        }

        public CsmUID<CsmFile> getTestFileUID() {
            return this.fileNew;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.fileNew);
            sb.append("\nstates:\n");
            for (PreprocessorStatePair pair : this.getStatePairs()) {
                sb.append(pair);
                sb.append('\n');
            }
            return sb.toString();
        }
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

