/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.content.file;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponentReferences;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.ReferencesIndexKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public final class ReferencesIndex
implements SelfPersistent,
Persistent {
    static final Comparator<FileComponentReferences.ReferenceImpl> REF_COMPARATOR = new RefComparator();
    private static final boolean TRACE = Boolean.getBoolean("cnd.model.global.index") || Boolean.getBoolean("cnd.model.index.enabled");
    private final Map<CsmUID<?>, Collection<FileComponentReferences.ReferenceImpl>> obj2refs = new HashMap();
    private final Map<CsmUID<?>, Set<CsmUID<CsmFile>>> obj2files = new HashMap();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final boolean ENABLED = Boolean.getBoolean("cnd.model.global.index");

    private ReferencesIndex() {
    }

    public static SelfPersistent create(RepositoryDataInput stream) throws IOException {
        return new ReferencesIndex(stream);
    }

    public static void shutdown() {
        if (ENABLED) {
            RepositoryUtils.closeUnit(KeyHolder.INDEX_KEY, null, !TraceFlags.PERSISTENT_REPOSITORY);
        }
    }

    public static void startup() {
        if (ENABLED) {
            RepositoryUtils.openUnit(KeyHolder.INDEX_KEY);
        }
    }

    private static ReferencesIndex read() {
        if (TRACE) {
            System.err.printf("Opening INDEX by key %s\n", KeyHolder.INDEX_KEY);
        }
        RepositoryUtils.openUnit(KeyHolder.INDEX_KEY);
        ReferencesIndex instance = (ReferencesIndex)RepositoryUtils.get(KeyHolder.INDEX_KEY);
        if (instance == null) {
            if (TRACE) {
                System.err.printf("NO REFERENCES INDEX IN REPOSITORY\n", new Object[0]);
            }
            return new ReferencesIndex();
        }
        if (TRACE) {
            System.err.printf("ReferencesIndex from repository has %d ref-entries\n", instance.obj2refs.size());
            System.err.printf("ReferencesIndex from repository has %d file-entries\n", instance.obj2files.size());
        }
        return instance;
    }

    public static void dumpInfo(PrintWriter printOut) {
        Holder.INSTANCE.trace(printOut);
    }

    public static void clearIndex() {
        Holder.INSTANCE.clear();
    }

    static void put(CsmUID<?> refedObject, CsmUID<CsmFile> fileUID, FileComponentReferences.ReferenceImpl ref) {
        Holder.INSTANCE.addRef(refedObject, fileUID, ref);
    }

    public static Collection<CsmReference> getAllReferences(CsmUID<?> referedObject) {
        if (!ENABLED) {
            System.err.printf("INDEX IS DISABLED\n", new Object[0]);
        }
        Collection<CsmReference> refs = Holder.INSTANCE.getRefs(referedObject);
        if (TRACE) {
            System.err.printf("getAllReferences for %s has %d refs\n", referedObject, refs.size());
        }
        return refs;
    }

    public static Collection<CsmUID<CsmFile>> getRelevantFiles(CsmUID<?> referedObject) {
        Collection<CsmUID<CsmFile>> refs = Holder.INSTANCE.getFiles(referedObject);
        if (TRACE) {
            System.err.printf("getAllFiles for %s has %d files\n", referedObject, refs.size());
        }
        return refs;
    }

    private void trace(PrintWriter printOut) {
        if (!ENABLED) {
            printOut.printf("INDEX IS DISABLED\n", new Object[0]);
            return;
        }
        if (this.obj2refs.isEmpty()) {
            printOut.printf("INDEX IS EMPTY\n", new Object[0]);
            return;
        }
        printOut.printf("INDEX has %d referenced objects\n", this.obj2refs.size());
        ArrayList keys = new ArrayList(this.obj2refs.keySet());
        Collections.sort(keys, new ComparatorImpl());
        int lastProjectID = -1;
        int lastFileID = -1;
        int numKeys = 0;
        for (CsmUID csmUID : keys) {
            Collection<CsmReference> refs;
            Collection<FileComponentReferences.ReferenceImpl> obj;
            int curProjectID = UIDUtilities.getProjectID(csmUID);
            if (lastProjectID != curProjectID) {
                if (lastProjectID >= 0) {
                    printOut.printf("PROJECT %s has %d referenced objects\n\n", KeyUtilities.getUnitName(lastProjectID), numKeys);
                }
                numKeys = 0;
                lastProjectID = curProjectID;
                printOut.printf("Elements of project [%d] %s\n", curProjectID, KeyUtilities.getUnitName(curProjectID));
            }
            ++numKeys;
            int curFileID = UIDUtilities.getFileID(csmUID);
            if (lastFileID != curFileID) {
                lastFileID = curFileID;
                printOut.printf("Elements of project %s of file [%d] %s\n", KeyUtilities.getUnitName(curProjectID), curFileID, KeyUtilities.getFileNameById(curProjectID, curFileID));
            }
            if ((obj = this.obj2refs.get(csmUID)) == null) {
                printOut.printf("NO REFERENCES for %s\n", csmUID);
            }
            if ((refs = this.getRefs(csmUID)).isEmpty()) {
                printOut.printf("NO REFERENCES 2 for %s\n", csmUID);
                continue;
            }
            printOut.printf("%s is referenced from:\n", csmUID);
            CsmFile prevFile = null;
            for (CsmReference ref : refs) {
                FileComponentReferences.ReferenceImpl csmReference = (FileComponentReferences.ReferenceImpl)ref;
                CsmFile containingFile = csmReference.getContainingFile();
                if (containingFile != null) {
                    if (containingFile != prevFile) {
                        prevFile = containingFile;
                        printOut.printf("\tFILE %s\n", containingFile.getAbsolutePath());
                    }
                    printOut.printf("\t%s\n", this.toString(csmReference));
                    continue;
                }
                printOut.printf("NOT FROM FILE %s\n", this.toString(csmReference));
            }
        }
    }

    private String toString(FileComponentReferences.ReferenceImpl ref) {
        return ref.toString(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        this.lock.writeLock().lock();
        try {
            this.obj2refs.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (ENABLED) {
            RepositoryUtils.put(KeyHolder.INDEX_KEY, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRef(CsmUID<?> referedObject, CsmUID<CsmFile> fileUID, FileComponentReferences.ReferenceImpl ref) {
        if (!ENABLED) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            Set<CsmUID<CsmFile>> files;
            if (ENABLED) {
                Collection<FileComponentReferences.ReferenceImpl> value = this.obj2refs.get(referedObject);
                if (value == null) {
                    value = new TreeSet<FileComponentReferences.ReferenceImpl>(REF_COMPARATOR);
                    this.obj2refs.put(referedObject, value);
                }
                value.add(ref);
            }
            if ((files = this.obj2files.get(referedObject)) == null) {
                files = new HashSet<CsmUID<CsmFile>>();
                this.obj2files.put(referedObject, files);
            }
            files.add(fileUID);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        RepositoryUtils.put(KeyHolder.INDEX_KEY, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<CsmReference> getRefs(CsmUID<?> refedObject) {
        this.lock.readLock().lock();
        try {
            Collection<FileComponentReferences.ReferenceImpl> value = this.obj2refs.get(refedObject);
            if (value == null) {
                List<CsmReference> list = Collections.emptyList();
                return list;
            }
            ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>(value);
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<CsmUID<CsmFile>> getFiles(CsmUID<?> refedObject) {
        this.lock.readLock().lock();
        try {
            Set<CsmUID<CsmFile>> value = this.obj2files.get(refedObject);
            if (value == null) {
                List<CsmUID<CsmFile>> list = Collections.emptyList();
                return list;
            }
            ArrayList<CsmUID<CsmFile>> arrayList = new ArrayList<CsmUID<CsmFile>>(value);
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(RepositoryDataOutput out) throws IOException {
        UIDObjectFactory defaultFactory = UIDObjectFactory.getDefaultFactory();
        this.lock.readLock().lock();
        try {
            Set value;
            if (TRACE) {
                System.err.printf("writing REFERENCES INDEX [%s] with %d entries\n", KeyHolder.INDEX_KEY, this.obj2refs.size());
            }
            out.writeInt(this.obj2refs.size());
            for (Map.Entry<CsmUID<?>, Collection<FileComponentReferences.ReferenceImpl>> entry : this.obj2refs.entrySet()) {
                defaultFactory.writeUID(entry.getKey(), out);
                value = entry.getValue();
                out.writeInt(value.size());
                for (FileComponentReferences.ReferenceImpl referenceImpl : value) {
                    defaultFactory.writeUID(referenceImpl.getContainingFileUID(), out);
                    referenceImpl.write(defaultFactory, out);
                }
            }
            out.writeInt(this.obj2files.size());
            for (Map.Entry<CsmUID<?>, Collection<FileComponentReferences.ReferenceImpl>> entry : this.obj2files.entrySet()) {
                defaultFactory.writeUID(entry.getKey(), out);
                value = (Set)entry.getValue();
                out.writeInt(value.size());
                for (CsmUID csmUID : value) {
                    defaultFactory.writeUID(csmUID, out);
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    private ReferencesIndex(RepositoryDataInput aStream) throws IOException {
        CsmUID fileUID;
        int j;
        CsmUID key;
        int i;
        int size = aStream.readInt();
        UIDObjectFactory defaultFactory = UIDObjectFactory.getDefaultFactory();
        for (i = 0; i < size; ++i) {
            key = defaultFactory.readUID(aStream);
            TreeSet<FileComponentReferences.ReferenceImpl> value = new TreeSet<FileComponentReferences.ReferenceImpl>(REF_COMPARATOR);
            int refSize = aStream.readInt();
            for (j = 0; j < refSize; ++j) {
                fileUID = defaultFactory.readUID(aStream);
                FileComponentReferences.ReferenceImpl val = new FileComponentReferences.ReferenceImpl(fileUID, key, defaultFactory, aStream);
                value.add(val);
            }
            this.obj2refs.put(key, value);
        }
        size = aStream.readInt();
        for (i = 0; i < size; ++i) {
            key = defaultFactory.readUID(aStream);
            int filesSize = aStream.readInt();
            HashSet value = new HashSet(filesSize);
            for (j = 0; j < filesSize; ++j) {
                fileUID = defaultFactory.readUID(aStream);
                value.add(fileUID);
            }
            this.obj2files.put(key, value);
        }
    }

    static /* synthetic */ boolean access$000() {
        return ENABLED;
    }

    static /* synthetic */ ReferencesIndex access$100() {
        return ReferencesIndex.read();
    }

    private static final class KeyHolder {
        private static final Key INDEX_KEY = new ReferencesIndexKey();

        private KeyHolder() {
        }
    }

    private static final class Holder {
        private static final ReferencesIndex INSTANCE = ReferencesIndex.access$000() ? ReferencesIndex.access$100() : new ReferencesIndex();

        private Holder() {
        }
    }

    private static final class RefImpl
    implements CsmReference {
        private final CsmUID<CsmFile> containingFile;
        private final int start;
        private final int end;
        private final CsmReferenceKind kind;

        public RefImpl(CsmUID<CsmFile> fileUID, int start, int end, CsmReferenceKind kind) {
            this.containingFile = fileUID;
            this.start = start;
            this.end = end;
            this.kind = kind;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RefImpl other = (RefImpl)obj;
            if (!(this.containingFile == other.containingFile || this.containingFile != null && this.containingFile.equals(other.containingFile))) {
                return false;
            }
            if (this.start != other.start) {
                return false;
            }
            if (this.end != other.end) {
                return false;
            }
            return this.kind == other.kind;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + (this.containingFile != null ? this.containingFile.hashCode() : 0);
            hash = 37 * hash + this.start;
            hash = 37 * hash + this.end;
            hash = 37 * hash + (this.kind != null ? this.kind.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return "RefImpl{start=" + this.start + ", end=" + this.end + ", kind=" + this.kind + '}';
        }

        public CsmReferenceKind getKind() {
            return this.kind;
        }

        public CsmObject getReferencedObject() {
            return null;
        }

        public CsmObject getOwner() {
            return null;
        }

        public CsmObject getClosestTopLevelObject() {
            return null;
        }

        public CsmFile getContainingFile() {
            return UIDCsmConverter.UIDtoFile(this.containingFile);
        }

        public int getStartOffset() {
            return this.start;
        }

        public int getEndOffset() {
            return this.end;
        }

        public CsmOffsetable.Position getStartPosition() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CsmOffsetable.Position getEndPosition() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public CharSequence getText() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private static final class RefComparator
    implements Comparator<FileComponentReferences.ReferenceImpl> {
        @Override
        public int compare(FileComponentReferences.ReferenceImpl o1, FileComponentReferences.ReferenceImpl o2) {
            int res;
            CsmUID<CsmFile> containingFileUID2;
            CsmUID<CsmFile> containingFileUID1 = o1.getContainingFileUID();
            if (containingFileUID1 != (containingFileUID2 = o2.getContainingFileUID())) {
                int containingFileID2;
                int projectID2;
                int projectID1 = UIDUtilities.getProjectID(containingFileUID1);
                res = projectID1 - (projectID2 = UIDUtilities.getProjectID(containingFileUID2));
                if (res != 0) {
                    return res;
                }
                int containingFileID1 = UIDUtilities.getFileID(containingFileUID1);
                res = containingFileID1 - (containingFileID2 = UIDUtilities.getFileID(containingFileUID2));
                if (res != 0) {
                    return res;
                }
            }
            if ((res = o1.getStartOffset() - o2.getStartOffset()) != 0) {
                return res;
            }
            return o1.getEndOffset() - o2.getEndOffset();
        }
    }

    private static final class ComparatorImpl
    implements Comparator<CsmUID<?>> {
        @Override
        public int compare(CsmUID<?> o1, CsmUID<?> o2) {
            int fileID2;
            int projectID2;
            int projectID1 = UIDUtilities.getProjectID(o1);
            if (projectID1 != (projectID2 = UIDUtilities.getProjectID(o2))) {
                return projectID1 - projectID2;
            }
            int fileID1 = UIDUtilities.getFileID(o1);
            if (fileID1 != (fileID2 = UIDUtilities.getFileID(o2))) {
                try {
                    return fileID1 - fileID2;
                }
                catch (IndexOutOfBoundsException e) {
                    System.err.printf("exception %s, when compare\n%s\nvs.\n%s\n", e.getMessage(), o1.getObject(), o2.getObject());
                }
            }
            int startOffset1 = UIDUtilities.getStartOffset(o1);
            int startOffset2 = UIDUtilities.getStartOffset(o2);
            return startOffset1 - startOffset2;
        }
    }
}

