/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.content.file;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.trace.LineDiff;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.openide.util.CharSequences;

public final class FileContentSignature {
    private final List<KindAndSignature> signature;
    private final CsmUID<CsmFile> file;
    private final int hashCode;
    private static final Comparator<FileElement> PAIR_COMPARATOR = new Comparator<FileElement>(){

        @Override
        public int compare(FileElement o1, FileElement o2) {
            int res = o1.start - o2.start;
            if (res == 0) {
                res = CharSequences.comparator().compare(o1.signature.getSignature(), o2.signature.getSignature());
            }
            if (res == 0) {
                res = o1.signature.getKind() - o2.signature.getKind();
            }
            return res;
        }
    };

    private FileContentSignature(List<KindAndSignature> signature, CsmUID<CsmFile> file) {
        this.signature = signature;
        this.file = file;
        this.hashCode = FileContentSignature.hash(signature);
    }

    public static FileContentSignature create(CsmFile file) {
        List<KindAndSignature> signature = FileContentSignature.createFileSignature(file);
        return new FileContentSignature(signature, UIDCsmConverter.fileToUID(file));
    }

    private static List<KindAndSignature> createFileSignature(CsmFile csmFile) {
        FileElement fe;
        KindAndSignature cs;
        TreeSet<FileElement> fileElements = new TreeSet<FileElement>(PAIR_COMPARATOR);
        for (CsmInclude element : csmFile.getIncludes()) {
            cs = new CharAndCharSequence(element.getIncludeName(), Utils.getCsmIncludeKindKey());
            fe = new FileElement(element.getStartOffset(), cs);
            fileElements.add(fe);
        }
        for (CsmInclude element : csmFile.getMacros()) {
            cs = new MacroCharSequence(element.getName(), element.getBody(), Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.MACRO));
            fe = new FileElement(element.getStartOffset(), cs);
            fileElements.add(fe);
        }
        for (CsmInclude element : csmFile.getDeclarations()) {
            FileContentSignature.addDeclarationAndNested(fileElements, (CsmOffsetableDeclaration)element);
        }
        ArrayList<KindAndSignature> out = new ArrayList<KindAndSignature>(fileElements.size());
        for (FileElement fe2 : fileElements) {
            out.add(fe2.signature);
        }
        out.trimToSize();
        return out;
    }

    private static void addDeclarationAndNested(Collection<FileElement> toAdd, CsmOffsetableDeclaration outDecl) {
        CharAndCharSequence cs = new CharAndCharSequence(outDecl.getQualifiedName(), Utils.getCsmDeclarationKindkey(outDecl.getKind()));
        FileElement fe = new FileElement(outDecl.getStartOffset(), cs);
        toAdd.add(fe);
        Iterator it = null;
        if (CsmKindUtilities.isNamespaceDefinition((CsmObject)outDecl)) {
            it = ((CsmNamespaceDefinition)outDecl).getDeclarations().iterator();
        } else if (CsmKindUtilities.isClass((CsmObject)outDecl)) {
            CsmClass cl = (CsmClass)outDecl;
            it = cl.getMembers().iterator();
            for (CsmInheritance inh : cl.getBaseClasses()) {
                CharAndCharSequence csi = new CharAndCharSequence(inh.getAncestorType().getClassifierText(), Utils.getCsmInheritanceKindKey(inh));
                toAdd.add(new FileElement(inh.getStartOffset(), csi));
            }
        } else if (CsmKindUtilities.isEnum((CsmObject)outDecl)) {
            CsmEnum en = (CsmEnum)outDecl;
            it = en.getEnumerators().iterator();
        }
        if (it != null) {
            while (it.hasNext()) {
                CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)it.next();
                FileContentSignature.addDeclarationAndNested(toAdd, decl);
            }
        }
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FileContentSignature other = (FileContentSignature)obj;
        if (this.hashCode != other.hashCode) {
            return false;
        }
        if (!this.file.equals(other.file)) {
            return false;
        }
        return ((Object)this.signature).equals(other.signature);
    }

    public static ComparisonResult compare(FileContentSignature first, FileContentSignature second) {
        ListIterator<KindAndSignature> remaining;
        ListIterator<KindAndSignature> e1 = first.signature.listIterator();
        ListIterator<KindAndSignature> e2 = second.signature.listIterator();
        boolean changed = false;
        boolean changeCanAffectIncludes = false;
        char inclKind = Utils.getCsmIncludeKindKey().charAt(0);
        while (e1.hasNext() && e2.hasNext()) {
            KindAndSignature o2;
            KindAndSignature o1 = e1.next();
            if (!o1.equals(o2 = e2.next())) {
                changed = true;
            }
            if (o1.getKind() != inclKind && o2.getKind() != inclKind || !changed) continue;
            changeCanAffectIncludes = true;
        }
        ListIterator<KindAndSignature> listIterator = remaining = e1.hasNext() ? e1 : e2;
        while (remaining.hasNext()) {
            KindAndSignature next = remaining.next();
            changed = true;
            if (next.getKind() != inclKind) continue;
            changeCanAffectIncludes = true;
        }
        if (changed) {
            return changeCanAffectIncludes ? ComparisonResult.CHANGE_CAN_AFFECT_INCLUDES : ComparisonResult.FILE_LOCAL_CHANGE;
        }
        return ComparisonResult.SAME;
    }

    public static CharSequence testDifference(FileContentSignature first, FileContentSignature second) {
        StringBuilder out;
        block7: {
            List<KindAndSignature> sigToDump;
            block6: {
                out = new StringBuilder();
                if (!first.file.equals(second.file)) {
                    out.append("FILE - ").append(first.file).append('\n');
                    out.append("FILE + ").append(second.file).append('\n');
                    return out;
                }
                if (first.hashCode != second.hashCode) {
                    out.append("HASH - ").append(first.hashCode).append('\n');
                    out.append("HASH + ").append(second.hashCode).append('\n');
                }
                if (first.signature.isEmpty() || second.signature.isEmpty()) break block6;
                List<String> diff = LineDiff.diff(first.signature, second.signature);
                if (diff.isEmpty()) break block7;
                for (String line : diff) {
                    out.append(line).append('\n');
                }
                break block7;
            }
            if (first.signature.isEmpty()) {
                out.append("FIRST is empty, content of the second:\n");
                sigToDump = first.signature;
            } else {
                out.append("SECOND is empty, content of the first:\n");
                sigToDump = second.signature;
            }
            for (KindAndSignature sigElem : sigToDump) {
                out.append(sigElem).append('\n');
            }
        }
        return out;
    }

    private static int hash(List<KindAndSignature> signature) {
        int hash = 7;
        for (KindAndSignature charSequence : signature) {
            hash = 89 * hash + charSequence.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (KindAndSignature sig : this.signature) {
            out.append(sig).append('\n');
        }
        return out.toString();
    }

    private static final class MacroCharSequence
    implements KindAndSignature {
        private final CharSequence signature;
        private final CharSequence extra;

        public MacroCharSequence(CharSequence sig, CharSequence extra, String kind) {
            assert (sig != null);
            this.signature = sig;
            assert (extra != null);
            this.extra = extra;
            assert (kind.length() == 1) : kind;
            assert (kind.charAt(0) == 'M') : kind + " instead of M";
        }

        @Override
        public int length() {
            return 2 + this.signature.length() + 1 + this.extra.length();
        }

        @Override
        public char charAt(int index) {
            if (index == 0) {
                return 'M';
            }
            if (index == 1) {
                return '[';
            }
            int len1 = this.signature.length();
            if ((index -= 2) < len1) {
                return this.signature.charAt(index);
            }
            if (index == len1) {
                return ']';
            }
            return this.extra.charAt(index - 1 - len1);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toStringImpl().subSequence(start, end);
        }

        private String toStringImpl() {
            return "M[" + this.signature + "]" + this.extra;
        }

        @Override
        public String toString() {
            return this.toStringImpl();
        }

        public int hashCode() {
            int hash = 77;
            hash = 37 * hash + this.signature.hashCode();
            hash = 37 * hash + this.extra.hashCode();
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MacroCharSequence other = (MacroCharSequence)obj;
            if (!this.signature.equals(other.signature)) {
                return false;
            }
            return this.extra.equals(other.extra);
        }

        @Override
        public char getKind() {
            return 'M';
        }

        @Override
        public CharSequence getSignature() {
            return this.signature;
        }
    }

    private static class CharAndCharSequence
    implements KindAndSignature {
        private final CharSequence delegate;
        private final char kind;

        public CharAndCharSequence(CharSequence delegate, String kind) {
            assert (delegate != null);
            this.delegate = delegate;
            assert (kind.length() == 1) : kind;
            this.kind = kind.charAt(0);
        }

        @Override
        public int length() {
            return this.delegate.length() + 2;
        }

        @Override
        public char charAt(int index) {
            switch (index) {
                case 0: {
                    return this.kind;
                }
                case 1: {
                    return ':';
                }
            }
            return this.delegate.charAt(index - 2);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toStringImpl().subSequence(start, end);
        }

        private String toStringImpl() {
            return this.kind + ":" + this.delegate;
        }

        @Override
        public String toString() {
            return this.toStringImpl();
        }

        public int hashCode() {
            int hash = 3;
            hash = 37 * hash + this.delegate.hashCode();
            hash = 37 * hash + this.kind;
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CharAndCharSequence other = (CharAndCharSequence)obj;
            if (!this.delegate.equals(other.delegate)) {
                return false;
            }
            return this.kind == other.kind;
        }

        @Override
        public char getKind() {
            return this.kind;
        }

        @Override
        public CharSequence getSignature() {
            return this.delegate;
        }
    }

    private static interface KindAndSignature
    extends CharSequence {
        public char getKind();

        public CharSequence getSignature();
    }

    private static final class FileElement {
        private final int start;
        private final KindAndSignature signature;

        public FileElement(int start, KindAndSignature sig) {
            this.start = start;
            this.signature = sig;
        }
    }

    public static enum ComparisonResult {
        SAME,
        FILE_LOCAL_CHANGE,
        CHANGE_CAN_AFFECT_INCLUDES;

    }
}

