/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.content.file;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponent;
import org.netbeans.modules.cnd.modelimpl.content.file.ReferencesIndex;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.PositionManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.FileReferencesKey;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDProviderIml;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public class FileComponentReferences
extends FileComponent
implements Persistent,
SelfPersistent {
    private static final boolean TRACE = false;
    private final SortedMap<ReferenceImpl, CsmUID<CsmObject>> references;
    private final SortedMap<ReferenceImpl, CsmUID<CsmObject>> type2classifier;
    private final Map<CsmUID<?>, Collection<ReferenceImpl>> obj2refs = new HashMap();
    private final ReadWriteLock referencesLock = new ReentrantReadWriteLock();
    private final CsmUID<CsmFile> fileUID;
    private static final FileComponentReferences EMPTY = new FileComponentReferences(){

        @Override
        void put() {
        }
    };

    public static boolean isKindOf(CsmReference ref, Set<CsmReferenceKind> kinds) {
        return ref instanceof ReferenceImpl && kinds.contains(ref.getKind());
    }

    public static FileComponentReferences empty() {
        return EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileComponentReferences(FileComponentReferences other, boolean empty) {
        super(other);
        try {
            if (!empty) {
                other.referencesLock.readLock().lock();
            }
            this.references = new TreeMap<ReferenceImpl, CsmUID<CsmObject>>(empty ? Collections.emptyMap() : other.references);
            this.type2classifier = new TreeMap<ReferenceImpl, CsmUID<CsmObject>>(empty ? Collections.emptyMap() : other.type2classifier);
        }
        finally {
            if (!empty) {
                other.referencesLock.readLock().unlock();
            }
        }
        this.fileUID = other.fileUID;
    }

    public FileComponentReferences(FileImpl file) {
        super(new FileReferencesKey(file));
        this.references = new TreeMap<ReferenceImpl, CsmUID<CsmObject>>();
        this.type2classifier = new TreeMap<ReferenceImpl, CsmUID<CsmObject>>();
        this.fileUID = file.getUID();
    }

    public FileComponentReferences(RepositoryDataInput input) throws IOException {
        super(input);
        UIDObjectFactory defaultFactory = UIDObjectFactory.getDefaultFactory();
        this.fileUID = defaultFactory.readUID(input);
        this.references = defaultFactory.readReferencesSortedToUIDMap(input, this.fileUID);
        this.type2classifier = defaultFactory.readReferencesSortedToUIDMap(input, this.fileUID);
        int size = input.readInt();
        for (int i = 0; i < size; ++i) {
            CsmUID key = defaultFactory.readUID(input);
            int refSize = input.readInt();
            ArrayList<ReferenceImpl> value = new ArrayList<ReferenceImpl>(refSize);
            for (int j = 0; j < refSize; ++j) {
                ReferenceImpl val = new ReferenceImpl(this.fileUID, key, defaultFactory, input);
                value.add(val);
            }
            value.trimToSize();
            this.obj2refs.put(key, value);
        }
    }

    private FileComponentReferences() {
        super((Key)null);
        this.references = new TreeMap<ReferenceImpl, CsmUID<CsmObject>>();
        this.type2classifier = new TreeMap<ReferenceImpl, CsmUID<CsmObject>>();
        this.fileUID = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        this.referencesLock.writeLock().lock();
        try {
            this.references.clear();
            this.type2classifier.clear();
            this.obj2refs.clear();
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmReference> getReferences(Collection<CsmObject> objects) {
        HashSet<CsmUID> searchFor = new HashSet<CsmUID>(objects.size());
        for (CsmObject obj : objects) {
            CsmUID uid = UIDs.get((Object)obj);
            searchFor.add(uid);
        }
        ArrayList<CsmReference> res = new ArrayList<CsmReference>();
        this.referencesLock.readLock().lock();
        try {
            for (CsmUID csmUID : searchFor) {
                Collection<ReferenceImpl> val = this.obj2refs.get(csmUID);
                if (val == null) continue;
                res.addAll(val);
            }
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmReference> getReferences() {
        ArrayList<CsmReference> res = new ArrayList<CsmReference>();
        this.referencesLock.readLock().lock();
        try {
            for (Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry : this.references.entrySet()) {
                res.add(entry.getKey());
            }
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
        return res;
    }

    public CsmReference getReference(int offset) {
        return this.getReferenceImpl(offset, this.references);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmReference getResolvedReference(CsmReference ref) {
        this.referencesLock.readLock().lock();
        try {
            Iterator<Map.Entry<ReferenceImpl, CsmUID<CsmObject>>> i$ = this.type2classifier.tailMap(new ReferenceImpl(ref.getStartOffset(), ref.getEndOffset(), ref.getText())).entrySet().iterator();
            if (i$.hasNext()) {
                Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry = i$.next();
                if (entry.getKey().start == ref.getStartOffset() && entry.getKey().end == ref.getEndOffset() && entry.getKey().identifier.equals(ref.getText())) {
                    CsmReference csmReference = entry.getKey();
                    return csmReference;
                }
                CsmReference csmReference = null;
                return csmReference;
            }
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceImpl getReferenceImpl(int offset, SortedMap<ReferenceImpl, CsmUID<CsmObject>> storage) {
        this.referencesLock.readLock().lock();
        try {
            Iterator<Map.Entry<ReferenceImpl, CsmUID<CsmObject>>> i$ = storage.tailMap(new ReferenceImpl(offset)).entrySet().iterator();
            if (i$.hasNext()) {
                Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry = i$.next();
                if (entry.getKey().start <= offset && offset < entry.getKey().end) {
                    ReferenceImpl referenceImpl = entry.getKey();
                    return referenceImpl;
                }
                ReferenceImpl referenceImpl = null;
                return referenceImpl;
            }
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
        return null;
    }

    public boolean addResolvedReference(CsmReference ref, CsmObject cls) {
        return this.addReferenceImpl(ref, cls, this.type2classifier, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResolvedReference(CsmReference ref) {
        CsmUID remove;
        this.referencesLock.writeLock().lock();
        try {
            remove = (CsmUID)this.type2classifier.remove(new ReferenceImpl(ref.getStartOffset(), ref.getEndOffset(), ref.getText()));
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
        if (remove != null) {
            this.put();
        }
    }

    public boolean addReference(CsmReference ref, CsmObject referencedObject) {
        return this.addReferenceImpl(ref, referencedObject, this.references, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addReferenceImpl(CsmReference ref, CsmObject referencedObject, Map<ReferenceImpl, CsmUID<CsmObject>> storage, boolean index) {
        if (!UIDCsmConverter.isIdentifiable(referencedObject)) {
            return false;
        }
        CsmUID referencedUID = UIDs.get((Object)referencedObject);
        if (!UIDProviderIml.isPersistable(referencedUID)) {
            return false;
        }
        CsmObject owner = ref.getOwner();
        CsmUID<CsmObject> ownerUID = this.getUID(owner, "Ignore local owners ", false);
        CsmObject closestTopLevelObject = ref.getClosestTopLevelObject();
        CsmUID<CsmObject> closestTopLevelObjectUID = this.getUID(closestTopLevelObject, "Why local top level object? ", true);
        assert (closestTopLevelObjectUID == null || UIDProviderIml.isPersistable(closestTopLevelObjectUID)) : "not persistable top level object " + closestTopLevelObject;
        ReferenceImpl refImpl = new ReferenceImpl(this.fileUID, ref, referencedUID, ownerUID, closestTopLevelObjectUID);
        this.referencesLock.writeLock().lock();
        try {
            CsmUID<CsmObject> old = storage.put(refImpl, (CsmUID<CsmObject>)referencedUID);
            if (index) {
                Collection<ReferenceImpl> value;
                Collection<ReferenceImpl> refsToOld;
                if (!referencedUID.equals(old) && old != null && (refsToOld = this.obj2refs.get(old)) != null) {
                    refsToOld.remove(refImpl);
                    if (refsToOld.isEmpty()) {
                        this.obj2refs.remove(old);
                    }
                }
                if ((value = this.obj2refs.get(referencedUID)) == null) {
                    value = new HashSet<ReferenceImpl>(1);
                    this.obj2refs.put(referencedUID, value);
                }
                value.add(refImpl);
            }
        }
        finally {
            this.referencesLock.writeLock().unlock();
        }
        this.put();
        if (index) {
            ReferencesIndex.put(referencedUID, this.fileUID, refImpl);
        }
        return true;
    }

    private CsmUID<CsmObject> getUID(CsmObject csmObject, String warning, boolean trace) {
        CsmUID csmObjectUID = null;
        if (csmObject != null) {
            if (UIDCsmConverter.isIdentifiable(csmObject)) {
                CsmUID aClosestTopLevelObjectUID = UIDs.get((Object)csmObject);
                if (UIDProviderIml.isPersistable(aClosestTopLevelObjectUID)) {
                    csmObjectUID = aClosestTopLevelObjectUID;
                } else if (trace) {
                    Utils.LOG.log(Level.WARNING, "{0} {1}\n {2}", new Object[]{warning, csmObject, new Exception()});
                }
            } else if (trace) {
                Utils.LOG.log(Level.WARNING, "{0} {1}\n {2}", new Object[]{warning, csmObject, new Exception()});
            }
        }
        return csmObjectUID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(RepositoryDataOutput out) throws IOException {
        super.write(out);
        UIDObjectFactory defaultFactory = UIDObjectFactory.getDefaultFactory();
        defaultFactory.writeUID(this.fileUID, out);
        this.referencesLock.readLock().lock();
        try {
            out.writeInt(this.references.size());
            for (Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry : this.references.entrySet()) {
                defaultFactory.writeUID(entry.getValue(), out);
                entry.getKey().write(defaultFactory, out);
            }
            out.writeInt(this.type2classifier.size());
            for (Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry : this.type2classifier.entrySet()) {
                defaultFactory.writeUID(entry.getValue(), out);
                entry.getKey().write(defaultFactory, out);
            }
            out.writeInt(this.obj2refs.size());
            for (Map.Entry<ReferenceImpl, Object> entry : this.obj2refs.entrySet()) {
                defaultFactory.writeUID((CsmUID)entry.getKey(), out);
                Collection value = (Collection)entry.getValue();
                out.writeInt(value.size());
                for (ReferenceImpl referenceImpl : value) {
                    referenceImpl.write(defaultFactory, out);
                }
            }
        }
        finally {
            this.referencesLock.readLock().unlock();
        }
    }

    public void dump(PrintWriter printOut) {
        printOut.printf("Has %d references:\n", this.references.size());
        for (Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry : this.references.entrySet()) {
            printOut.printf("ref %s\n\t%s:\n", entry.getKey().toString(true), entry.getValue());
        }
        printOut.printf("Has %d type2classifier:\n", this.type2classifier.size());
        for (Map.Entry<ReferenceImpl, CsmUID<CsmObject>> entry : this.type2classifier.entrySet()) {
            printOut.printf("type ref %s\n\t%s:\n", entry.getKey().toString(true), entry.getValue());
        }
        printOut.printf("Has %d obj2refs:\n", this.obj2refs.size());
        int refNum = 0;
        for (Map.Entry<CsmUID<?>, Collection<ReferenceImpl>> entry : this.obj2refs.entrySet()) {
            printOut.printf("refs on %s:\n", entry.getKey());
            TreeSet<ReferenceImpl> value = new TreeSet<ReferenceImpl>(ReferencesIndex.REF_COMPARATOR);
            value.addAll(entry.getValue());
            refNum += value.size();
            int index = 1;
            for (ReferenceImpl referenceImpl : value) {
                printOut.printf("[%d] %s\n", index++, referenceImpl.toString(true));
            }
        }
        if (refNum != this.references.size()) {
            printOut.printf("DIFFERENT number of references refs=%d vs obj2refs=%d:\n", this.references.size(), refNum);
        }
    }

    public static final class ReferenceImpl
    implements CsmReference,
    Comparable<ReferenceImpl> {
        private final CsmUID<CsmFile> file;
        private final CsmReferenceKind refKind;
        private final CsmUID<CsmObject> refObj;
        private final int start;
        private final int end;
        private final CharSequence identifier;
        private final CsmUID<CsmObject> ownerUID;
        private final CsmUID<CsmObject> closestTopLevelObjectUID;

        private ReferenceImpl(int start) {
            this.start = start;
            this.end = start;
            this.file = null;
            this.refKind = null;
            this.refObj = null;
            this.identifier = null;
            this.ownerUID = null;
            this.closestTopLevelObjectUID = null;
        }

        private ReferenceImpl(int start, int end, CharSequence identifier) {
            this.start = start;
            this.end = end;
            this.file = null;
            this.refKind = null;
            this.refObj = null;
            this.identifier = identifier;
            this.ownerUID = null;
            this.closestTopLevelObjectUID = null;
        }

        private ReferenceImpl(CsmUID<CsmFile> fileUID, CsmReference delegate, CsmUID<CsmObject> refObj, CsmUID<CsmObject> ownerUID, CsmUID<CsmObject> closestTopLevelObjectUID) {
            this.file = fileUID;
            this.refKind = delegate.getKind();
            this.refObj = refObj;
            assert (refObj != null);
            this.start = PositionManager.createPositionID(fileUID, delegate.getStartOffset(), PositionManager.Position.Bias.FOWARD);
            this.end = PositionManager.createPositionID(fileUID, delegate.getEndOffset(), PositionManager.Position.Bias.BACKWARD);
            this.identifier = NameCache.getManager().getString(delegate.getText());
            this.ownerUID = ownerUID;
            this.closestTopLevelObjectUID = closestTopLevelObjectUID;
        }

        public ReferenceImpl(CsmUID<CsmFile> fileUID, CsmUID<CsmObject> refObj, UIDObjectFactory defaultFactory, RepositoryDataInput input) throws IOException {
            this.file = fileUID;
            this.refObj = refObj;
            assert (refObj != null);
            this.start = input.readInt();
            this.end = input.readInt();
            this.identifier = PersistentUtils.readUTF(input, NameCache.getManager());
            this.refKind = CsmReferenceKind.values()[input.readByte()];
            this.ownerUID = defaultFactory.readUID(input);
            this.closestTopLevelObjectUID = defaultFactory.readUID(input);
        }

        void write(UIDObjectFactory defaultFactory, RepositoryDataOutput out) throws IOException {
            out.writeInt(this.start);
            out.writeInt(this.end);
            PersistentUtils.writeUTF(this.identifier, out);
            out.writeByte(this.refKind.ordinal());
            defaultFactory.writeUID(this.ownerUID, out);
            defaultFactory.writeUID(this.closestTopLevelObjectUID, out);
        }

        public CsmReferenceKind getKind() {
            return this.refKind;
        }

        public CsmObject getReferencedObject() {
            CsmObject out = UIDCsmConverter.UIDtoCsmObject(this.refObj);
            if (out == null) {
                Logger.getLogger("xRef").log(Level.FINE, "how can we store nulls? {0}", this.refObj);
            }
            return out;
        }

        public CsmObject getOwner() {
            return UIDCsmConverter.UIDtoCsmObject(this.ownerUID);
        }

        public CsmObject getClosestTopLevelObject() {
            return UIDCsmConverter.UIDtoCsmObject(this.closestTopLevelObjectUID);
        }

        public CsmFile getContainingFile() {
            return (CsmFile)this.file.getObject();
        }

        public CsmUID<CsmFile> getContainingFileUID() {
            return this.file;
        }

        public int getStartOffset() {
            return PositionManager.getOffset(this.file, this.start);
        }

        public int getEndOffset() {
            return PositionManager.getOffset(this.file, this.end);
        }

        public CsmOffsetable.Position getStartPosition() {
            return PositionManager.getPosition(this.file, this.start);
        }

        public CsmOffsetable.Position getEndPosition() {
            return PositionManager.getPosition(this.file, this.end);
        }

        public CharSequence getText() {
            return this.identifier;
        }

        public int hashCode() {
            int hash = 5;
            hash = 17 * hash + this.start;
            hash = 17 * hash + this.end;
            hash = 17 * hash + (this.identifier != null ? this.identifier.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ReferenceImpl other = (ReferenceImpl)obj;
            if (this.start != other.start) {
                return false;
            }
            if (this.end != other.end) {
                return false;
            }
            return this.identifier == other.identifier || this.identifier != null && this.identifier.equals(other.identifier);
        }

        @Override
        public int compareTo(ReferenceImpl o) {
            int res = this.start - o.end;
            if (res > 0) {
                return res;
            }
            res = this.end - o.start;
            if (res < 0) {
                return res;
            }
            res = 0;
            if (this.identifier != null && o.identifier != null) {
                res = this.identifier.hashCode() - o.identifier.hashCode();
            }
            return res;
        }

        public String toString() {
            return this.toString(false);
        }

        String toString(boolean minimal) {
            if (minimal) {
                String stString = PositionManager.getPosition(this.file, this.start).toString();
                String endString = PositionManager.getPosition(this.file, this.end).toString();
                return this.identifier + "[" + stString + "-" + endString + "] refKind=" + this.refKind;
            }
            return this.identifier + "[" + this.start + "," + this.end + "] file=" + this.file + ";refKind=" + this.refKind + ";refObj=" + this.refObj + ";topUID=" + this.closestTopLevelObjectUID + ";ownerUID=" + this.ownerUID + '}';
        }
    }
}

