/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.content.file;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelimpl.content.file.FileComponent;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImpl;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.VariableImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.FileDeclarationsKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.openide.util.CharSequences;

public class FileComponentDeclarations
extends FileComponent
implements Persistent,
SelfPersistent {
    private final TreeMap<OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> declarations;
    private WeakReference<Map<CsmDeclaration.Kind, SortedMap<NameKey, CsmUID<CsmOffsetableDeclaration>>>> sortedDeclarations;
    private final ReadWriteLock declarationsLock = new ReentrantReadWriteLock();
    private final Collection<CsmUID<CsmFunction>> staticFunctionDeclarationUIDs;
    private final Collection<CsmUID<CsmVariable>> staticVariableUIDs;
    private final ReadWriteLock staticLock = new ReentrantReadWriteLock();
    private static final FileComponentDeclarations EMPTY = new FileComponentDeclarations(){

        @Override
        void put() {
        }
    };

    public static FileComponentDeclarations empty() {
        return EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileComponentDeclarations(FileComponentDeclarations other, boolean empty) {
        super(other);
        try {
            if (!empty) {
                other.declarationsLock.readLock().lock();
            }
            this.declarations = new TreeMap(empty ? Collections.emptyMap() : other.declarations);
        }
        finally {
            if (!empty) {
                other.declarationsLock.readLock().unlock();
            }
        }
        try {
            if (!empty) {
                other.staticLock.readLock().lock();
            }
            this.staticFunctionDeclarationUIDs = new ArrayList(empty ? Collections.emptyList() : other.staticFunctionDeclarationUIDs);
            this.staticVariableUIDs = new ArrayList(empty ? Collections.emptyList() : other.staticVariableUIDs);
        }
        finally {
            if (!empty) {
                other.staticLock.readLock().unlock();
            }
        }
    }

    public FileComponentDeclarations(FileImpl file) {
        super(new FileDeclarationsKey(file));
        this.declarations = new TreeMap();
        this.staticFunctionDeclarationUIDs = new ArrayList<CsmUID<CsmFunction>>(0);
        this.staticVariableUIDs = new ArrayList<CsmUID<CsmVariable>>(0);
    }

    public FileComponentDeclarations(RepositoryDataInput input) throws IOException {
        super(input);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        this.declarations = factory.readOffsetSortedToUIDMap(input, null);
        int collSize = input.readInt();
        this.staticFunctionDeclarationUIDs = collSize <= 0 ? new ArrayList<CsmUID<CsmFunction>>(0) : new ArrayList<CsmUID<CsmFunction>>(collSize);
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.staticFunctionDeclarationUIDs, input, collSize);
        collSize = input.readInt();
        this.staticVariableUIDs = collSize <= 0 ? new ArrayList<CsmUID<CsmVariable>>(0) : new ArrayList<CsmUID<CsmVariable>>(collSize);
        UIDObjectFactory.getDefaultFactory().readUIDCollection(this.staticVariableUIDs, input, collSize);
    }

    private FileComponentDeclarations() {
        super((Key)null);
        this.declarations = new TreeMap();
        this.staticFunctionDeclarationUIDs = new ArrayList<CsmUID<CsmFunction>>(0);
        this.staticVariableUIDs = new ArrayList<CsmUID<CsmVariable>>(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<CsmUID<CsmOffsetableDeclaration>> clean() {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> uids;
        try {
            this.declarationsLock.writeLock().lock();
            uids = new ArrayList<CsmUID<CsmOffsetableDeclaration>>(this.declarations.values());
            this.sortedDeclarations = null;
            this.declarations.clear();
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        try {
            this.staticLock.writeLock().lock();
            this.staticFunctionDeclarationUIDs.clear();
            this.staticVariableUIDs.clear();
        }
        finally {
            this.staticLock.writeLock().unlock();
        }
        this.put();
        return uids;
    }

    public boolean hasDeclarations() {
        return this.declarations.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmOffsetableDeclaration> getDeclarations() {
        Collection<CsmOffsetableDeclaration> decls;
        try {
            this.declarationsLock.readLock().lock();
            Collection uids = this.declarations.values();
            decls = UIDCsmConverter.UIDsToDeclarations(uids);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return decls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmOffsetableDeclaration> getDeclarations(CsmSelect.CsmFilter filter) {
        Iterator<CsmOffsetableDeclaration> out;
        try {
            this.declarationsLock.readLock().lock();
            out = UIDCsmConverter.UIDsToDeclarationsFiltered(this.declarations.values(), filter);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeclarationsSize() {
        try {
            this.declarationsLock.readLock().lock();
            int n = this.declarations.size();
            return n;
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> getDeclarations(CsmDeclaration.Kind[] kinds, CharSequence prefix) {
        ArrayList<CsmUID<CsmOffsetableDeclaration>> out = null;
        try {
            this.declarationsLock.readLock().lock();
            EnumMap<CsmDeclaration.Kind, TreeMap<NameKey, CsmUID<CsmOffsetableDeclaration>>> map = null;
            if (this.sortedDeclarations != null) {
                map = (EnumMap<CsmDeclaration.Kind, TreeMap<NameKey, CsmUID<CsmOffsetableDeclaration>>>)this.sortedDeclarations.get();
            }
            if (map == null) {
                map = new EnumMap<CsmDeclaration.Kind, TreeMap<NameKey, CsmUID<CsmOffsetableDeclaration>>>(CsmDeclaration.Kind.class);
                for (CsmUID<CsmOffsetableDeclaration> anUid : this.declarations.values()) {
                    CsmDeclaration.Kind kind = UIDUtilities.getKind(anUid);
                    TreeMap<NameKey, CsmUID<CsmOffsetableDeclaration>> val = (TreeMap<NameKey, CsmUID<CsmOffsetableDeclaration>>)map.get(kind);
                    if (val == null) {
                        val = new TreeMap<NameKey, CsmUID<CsmOffsetableDeclaration>>();
                        map.put(kind, val);
                    }
                    val.put(new NameKey(anUid), anUid);
                }
                this.sortedDeclarations = new WeakReference(map);
            }
            out = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
            for (CsmDeclaration.Kind kind : kinds) {
                SortedMap val = (SortedMap)map.get(kind);
                if (val == null) continue;
                if (prefix == null) {
                    out.addAll(val.values());
                    continue;
                }
                NameKey fromKey = new NameKey(prefix, 0);
                NameKey toKey = new NameKey(prefix, Integer.MAX_VALUE);
                out.addAll(val.subMap(fromKey, toKey).values());
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmOffsetableDeclaration findExistingDeclaration(int startOffset, int endOffset, CharSequence name) {
        OffsetSortedKey key = new OffsetSortedKey(startOffset, Math.abs(CharSequences.create((CharSequence)name).hashCode()));
        CsmUID<CsmOffsetableDeclaration> anUid = null;
        try {
            this.declarationsLock.readLock().lock();
            anUid = this.declarations.get(key);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        if (anUid != null && UIDUtilities.getEndOffset(anUid) != endOffset) {
            anUid = null;
        }
        return UIDCsmConverter.UIDtoDeclaration(anUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmOffsetableDeclaration findExistingDeclaration(int startOffset, CharSequence name, CsmDeclaration.Kind kind) {
        OffsetSortedKey key = new OffsetSortedKey(startOffset, Math.abs(CharSequences.create((CharSequence)name).hashCode()));
        CsmUID<CsmOffsetableDeclaration> anUid = null;
        try {
            this.declarationsLock.readLock().lock();
            anUid = this.declarations.get(key);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        if (anUid != null && UIDUtilities.getKind(anUid) != kind) {
            anUid = null;
        }
        return UIDCsmConverter.UIDtoDeclaration(anUid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmUID<CsmOffsetableDeclaration>> getDeclarations(int startOffset, int endOffset) {
        List<CsmUID<CsmOffsetableDeclaration>> res;
        try {
            this.declarationsLock.readLock().lock();
            res = this.getDeclarationsByOffset(startOffset - 1);
            OffsetSortedKey fromKey = new OffsetSortedKey(startOffset, 0);
            OffsetSortedKey toKey = new OffsetSortedKey(endOffset, 0);
            SortedMap<OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> map = this.declarations.subMap(fromKey, toKey);
            for (Map.Entry<OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> entry : map.entrySet()) {
                CsmUID<CsmOffsetableDeclaration> anUid = entry.getValue();
                int start = UIDUtilities.getStartOffset(anUid);
                int end = UIDUtilities.getEndOffset(anUid);
                if (start >= endOffset) {
                    break;
                }
                if (end < startOffset || start >= endOffset) continue;
                res.add(anUid);
            }
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmOffsetableDeclaration> getDeclarations(int offset) {
        List res;
        try {
            this.declarationsLock.readLock().lock();
            res = this.getDeclarationsByOffset(offset);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        return UIDCsmConverter.UIDsToDeclarations(res).iterator();
    }

    private List<CsmUID<CsmOffsetableDeclaration>> getDeclarationsByOffset(int offset) {
        SortedMap<OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> head;
        ArrayList<CsmUID<CsmOffsetableDeclaration>> res = new ArrayList<CsmUID<CsmOffsetableDeclaration>>();
        OffsetSortedKey key = new OffsetSortedKey(offset + 1, 0);
        block0: while (!(head = this.declarations.headMap(key)).isEmpty()) {
            OffsetSortedKey last = head.lastKey();
            while (last != null) {
                CsmUID higher;
                int higherTo;
                OffsetSortedKey higherKey;
                CsmUID<CsmOffsetableDeclaration> aUid = this.declarations.get(last);
                int from = UIDUtilities.getStartOffset(aUid);
                int to = UIDUtilities.getEndOffset(aUid);
                if (from <= offset && offset <= to) {
                    res.add(0, aUid);
                    key = last;
                    continue block0;
                }
                SortedMap<OffsetSortedKey, CsmUID<CsmOffsetableDeclaration>> headMap = head.headMap(last);
                if (headMap.isEmpty() || (higherKey = headMap.lastKey()) == null || (higherTo = UIDUtilities.getEndOffset(higher = (CsmUID)head.get(higherKey))) < to) break block0;
                last = higherKey;
            }
            break block0;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmFunction> getStaticFunctionDeclarations() {
        Collection<CsmFunction> out;
        try {
            this.staticLock.readLock().lock();
            out = UIDCsmConverter.UIDsToDeclarations(this.staticFunctionDeclarationUIDs);
        }
        finally {
            this.staticLock.readLock().unlock();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmFunction> getStaticFunctionDeclarations(CsmSelect.CsmFilter filter) {
        Iterator<CsmFunction> out;
        try {
            this.staticLock.readLock().lock();
            out = UIDCsmConverter.UIDsToDeclarationsFiltered(this.staticFunctionDeclarationUIDs, filter);
        }
        finally {
            this.staticLock.readLock().unlock();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CsmVariable> getStaticVariableDeclarations() {
        Collection<CsmVariable> out;
        try {
            this.staticLock.readLock().lock();
            out = UIDCsmConverter.UIDsToDeclarations(this.staticVariableUIDs);
        }
        finally {
            this.staticLock.readLock().unlock();
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<CsmVariable> getStaticVariableDeclarations(CsmSelect.CsmFilter filter) {
        Iterator<CsmVariable> out;
        try {
            this.staticLock.readLock().lock();
            out = UIDCsmConverter.UIDsToDeclarationsFiltered(this.staticVariableUIDs, filter);
        }
        finally {
            this.staticLock.readLock().unlock();
        }
        return out;
    }

    private OffsetSortedKey getOffsetSortKey(CsmOffsetableDeclaration declaration) {
        return new OffsetSortedKey(declaration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CsmUID<CsmOffsetableDeclaration> addDeclaration(CsmOffsetableDeclaration decl) {
        FunctionImpl fi;
        VariableImpl v;
        CsmUID<CsmOffsetableDeclaration> uidDecl = RepositoryUtils.put(decl);
        try {
            this.declarationsLock.writeLock().lock();
            this.declarations.put(this.getOffsetSortKey(decl), uidDecl);
            this.sortedDeclarations = null;
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        if (decl instanceof VariableImpl && !NamespaceImpl.isNamespaceScope(v = (VariableImpl)decl, true)) {
            v.setScope((CsmScope)decl.getContainingFile());
            this.addStaticVariableDeclaration(uidDecl);
        }
        if (CsmKindUtilities.isFunctionDeclaration((CsmObject)decl) && decl instanceof FunctionImpl && !NamespaceImpl.isNamespaceScope(fi = (FunctionImpl)decl)) {
            fi.setScope((CsmScope)decl.getContainingFile());
            this.addStaticFunctionDeclaration(uidDecl);
        }
        this.put();
        return uidDecl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStaticFunctionDeclaration(CsmUID<?> uidDecl) {
        try {
            this.staticLock.writeLock().lock();
            this.staticFunctionDeclarationUIDs.add(uidDecl);
        }
        finally {
            this.staticLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStaticVariableDeclaration(CsmUID<?> uidDecl) {
        try {
            this.staticLock.writeLock().lock();
            this.staticVariableUIDs.add(uidDecl);
        }
        finally {
            this.staticLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeclaration(CsmOffsetableDeclaration declaration) {
        CsmUID<CsmOffsetableDeclaration> uidDecl;
        try {
            this.declarationsLock.writeLock().lock();
            uidDecl = this.declarations.remove(this.getOffsetSortKey(declaration));
            this.sortedDeclarations = null;
        }
        finally {
            this.declarationsLock.writeLock().unlock();
        }
        RepositoryUtils.remove(uidDecl, (CsmObject)declaration);
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(RepositoryDataOutput output) throws IOException {
        super.write(output);
        UIDObjectFactory factory = UIDObjectFactory.getDefaultFactory();
        try {
            this.declarationsLock.readLock().lock();
            factory.writeOffsetSortedToUIDMap(this.declarations, output, false);
        }
        finally {
            this.declarationsLock.readLock().unlock();
        }
        try {
            this.staticLock.readLock().lock();
            UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.staticFunctionDeclarationUIDs, output, false);
            UIDObjectFactory.getDefaultFactory().writeUIDCollection(this.staticVariableUIDs, output, false);
        }
        finally {
            this.staticLock.readLock().unlock();
        }
    }

    public static final class NameKey
    implements Comparable<NameKey> {
        private int start = 0;
        private CharSequence name;

        public NameKey(CsmUID<CsmOffsetableDeclaration> anUid) {
            this.name = UIDUtilities.getName(anUid);
            this.start = UIDUtilities.getStartOffset(anUid);
        }

        public NameKey(CharSequence name, int offset) {
            this.name = name;
            this.start = offset;
        }

        @Override
        public int compareTo(NameKey o) {
            int res = CharSequences.comparator().compare(this.name, o.name);
            if (res == 0) {
                res = this.start - o.start;
            }
            return res;
        }
    }

    public static final class OffsetSortedKey
    implements Comparable<OffsetSortedKey>,
    Persistent,
    SelfPersistent {
        private final int start;
        private final int name;

        public OffsetSortedKey(CsmOffsetableDeclaration declaration) {
            this.start = declaration.getStartOffset();
            this.name = Math.abs(declaration.getName().hashCode());
        }

        public OffsetSortedKey(int offset, int name) {
            this.start = offset;
            this.name = name;
        }

        @Override
        public int compareTo(OffsetSortedKey o) {
            int res = this.start - o.start;
            if (res == 0) {
                res = this.name - o.name;
            }
            return res;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OffsetSortedKey) {
                OffsetSortedKey key = (OffsetSortedKey)obj;
                return this.compareTo(key) == 0;
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 37 * hash + this.start;
            hash = 37 * hash + this.name;
            return hash;
        }

        public String toString() {
            return "OffsetSortedKey: " + this.name + "[" + this.start;
        }

        public void write(RepositoryDataOutput output) throws IOException {
            output.writeInt(this.start);
            output.writeInt(this.name);
        }

        public OffsetSortedKey(RepositoryDataInput input) throws IOException {
            this.start = input.readInt();
            this.name = input.readInt();
        }
    }
}

