/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.cache.impl;

import java.lang.ref.WeakReference;
import org.netbeans.modules.cnd.api.model.CsmValidable;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.utils.CndUtils;

public final class WeakContainer<T> {
    private volatile WeakReference<T> weakContainer = TraceFlags.USE_WEAK_MEMORY_CACHE ? new WeakReference<Object>(null) : null;
    private int preventMultiplyDiagnosticExceptionsSorage = 0;
    private final CsmValidable stateOwner;
    private final Key storageKey;

    public WeakContainer(CsmValidable stateOwner, Key storageKey) {
        assert (storageKey != null);
        this.stateOwner = stateOwner;
        this.storageKey = storageKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        WeakContainer weakContainer = this;
        synchronized (weakContainer) {
            if (TraceFlags.USE_WEAK_MEMORY_CACHE) {
                this.weakContainer.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getContainer() {
        Object container = this.getFromRef();
        if (container != null) {
            return container;
        }
        WeakContainer weakContainer = this;
        synchronized (weakContainer) {
            container = this.getFromRef();
            if (container != null) {
                return container;
            }
            container = RepositoryUtils.get(this.storageKey);
            if (container == null && this.stateOwner.isValid() && this.preventMultiplyDiagnosticExceptionsSorage < 3) {
                Persistent container2 = RepositoryUtils.get(this.storageKey);
                String postfix = "";
                if (CndUtils.isDebugMode() || CndUtils.isUnitTestMode()) {
                    postfix = container2 == null ? " TWICE" : " second attempt OK";
                }
                DiagnosticExceptoins.registerIllegalRepositoryStateException("Failed to get container sorage by key " + postfix, this.storageKey);
                ++this.preventMultiplyDiagnosticExceptionsSorage;
            }
            if (TraceFlags.USE_WEAK_MEMORY_CACHE && container != null && this.weakContainer != null) {
                this.weakContainer = new WeakReference<T>(container);
            }
            return container;
        }
    }

    private T getFromRef() {
        WeakReference<T> weak;
        if (TraceFlags.USE_WEAK_MEMORY_CACHE && this.stateOwner.isValid() && (weak = this.weakContainer) != null) {
            return weak.get();
        }
        return null;
    }
}

