/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Image;
import java.awt.Toolkit;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.SimpleBeanInfo;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.form.palette.PaletteItem;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PaletteItemDataObject
extends MultiDataObject
implements CookieSet.Factory {
    static final String XML_ROOT = "palette_item";
    static final String ATTR_VERSION = "version";
    static final String TAG_COMPONENT = "component";
    static final String ATTR_CLASSNAME = "classname";
    static final String ATTR_TYPE = "type";
    static final String ATTR_INITIALIZER_ID = "initializer-id";
    static final String TAG_CLASSPATH = "classpath";
    static final String TAG_RESOURCE = "resource";
    static final String ATTR_NAME = "name";
    static final String TAG_DESCRIPTION = "description";
    static final String ATTR_BUNDLE = "localizing-bundle";
    static final String ATTR_DISPLAY_NAME_KEY = "display-name-key";
    static final String ATTR_TOOLTIP_KEY = "tooltip-key";
    static final String TAG_ICON16 = "icon16";
    static final String ATTR_URL = "urlvalue";
    static final String TAG_ICON32 = "icon32";
    private static final Node.PropertySet[] NO_PROPERTIES = new Node.PropertySet[0];
    private boolean fileLoaded;
    private PaletteItem paletteItem;
    private String displayName_key;
    private String tooltip_key;
    private String bundleName;
    private String icon16URL;
    private String icon32URL;
    String displayName;
    String tooltip;
    Image icon16;
    Image icon32;

    PaletteItemDataObject(FileObject fo, MultiFileLoader loader) throws DataObjectExistsException {
        super(fo, loader);
        this.getCookieSet().add(PaletteItem.class, (CookieSet.Factory)this);
    }

    boolean isFileRead() {
        return this.fileLoaded;
    }

    boolean isItemValid() {
        return this.paletteItem != null;
    }

    void reloadFile() {
        if (this.paletteItem != null) {
            this.paletteItem.reset();
            this.paletteItem.componentClassSource = null;
            this.paletteItem.componentType_explicit = null;
            this.paletteItem.setComponentInitializerId(null);
        }
        this.displayName = null;
        this.tooltip = null;
        this.icon16 = null;
        this.icon32 = null;
        this.displayName_key = null;
        this.tooltip_key = null;
        this.bundleName = null;
        this.icon16URL = null;
        this.icon32URL = null;
        this.loadFile();
    }

    public Node createNodeDelegate() {
        return new ItemNode();
    }

    public <T extends Node.Cookie> T createCookie(Class<T> cookieClass) {
        if (PaletteItem.class.equals(cookieClass)) {
            if (!this.fileLoaded) {
                this.loadFile();
            }
            return (T)((Node.Cookie)cookieClass.cast(this.paletteItem));
        }
        return null;
    }

    private void loadFile() {
        FileObject file;
        this.fileLoaded = true;
        PaletteItem item = this.paletteItem;
        if (item == null) {
            item = new PaletteItem(this);
        }
        if ((file = this.getPrimaryFile()).getSize() == 0L) {
            item.setComponentClassSource(new ClassSource(file.getName().replace('-', '.'), new ClassSource.Entry[0]));
            this.paletteItem = item;
            return;
        }
        try {
            XMLReader reader = XMLUtil.createXMLReader();
            PaletteItemHandler handler = new PaletteItemHandler();
            reader.setContentHandler(handler);
            InputSource input = new InputSource(this.getPrimaryFile().getURL().toExternalForm());
            reader.parse(input);
            item.setComponentExplicitType(handler.componentExplicitType);
            item.setComponentInitializerId(handler.componentInitializerId);
            if (handler.componentClassName != null || this.displayName_key != null) {
                item.setComponentClassSource(new ClassSource(handler.componentClassName, handler.entries));
                this.paletteItem = item;
            }
        }
        catch (SAXException saxex) {
            ErrorManager.getDefault().notify(1, (Throwable)saxex);
        }
        catch (IOException ioex) {
            ErrorManager.getDefault().notify(1, (Throwable)ioex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createFile(FileObject folder, ClassSource classSource) throws IOException {
        String classname = classSource.getClassName();
        int idx = classname.lastIndexOf(46);
        String fileName = FileUtil.findFreeFileName((FileObject)folder, (String)(idx >= 0 ? classname.substring(idx + 1) : classname), (String)XML_ROOT);
        FileObject itemFile = folder.createData(fileName, XML_ROOT);
        StringBuilder buff = new StringBuilder(512);
        buff.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n");
        buff.append("<palette_item version=\"1.0\">\n");
        buff.append("  <component classname=\"");
        buff.append(classname);
        buff.append("\" />\n");
        buff.append("  <classpath>\n");
        for (ClassSource.Entry entry : classSource.getEntries()) {
            buff.append("      <resource type=\"");
            buff.append(entry.getPicklingType());
            buff.append("\" name=\"");
            buff.append(entry.getPicklingName());
            buff.append("\" />\n");
            buff.append("  </classpath>\n");
            buff.append("</palette_item>\n");
        }
        FileLock lock = itemFile.lock();
        OutputStream outputStream = itemFile.getOutputStream(lock);
        try {
            outputStream.write(buff.toString().getBytes("UTF-8"));
        }
        finally {
            outputStream.close();
            lock.releaseLock();
        }
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    private class PaletteItemHandler
    extends DefaultHandler {
        List<ClassSource.Entry> entries;
        String componentClassName;
        String componentExplicitType;
        String componentInitializerId;

        private PaletteItemHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            this.entries = new ArrayList<ClassSource.Entry>();
            this.componentClassName = null;
            this.componentExplicitType = null;
            this.componentInitializerId = null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (PaletteItemDataObject.XML_ROOT.equals(qName)) {
                String version = attributes.getValue(PaletteItemDataObject.ATTR_VERSION);
                if (version == null) {
                    String message = NbBundle.getBundle(PaletteItemDataObject.class).getString("MSG_UnknownPaletteItemVersion");
                    throw new SAXException(message);
                }
                if (!version.startsWith("1.")) {
                    String message = NbBundle.getBundle(PaletteItemDataObject.class).getString("MSG_UnsupportedPaletteItemVersion");
                    throw new SAXException(message);
                }
            } else if (PaletteItemDataObject.TAG_COMPONENT.equals(qName)) {
                String className;
                this.componentClassName = className = attributes.getValue(PaletteItemDataObject.ATTR_CLASSNAME);
                this.componentExplicitType = attributes.getValue(PaletteItemDataObject.ATTR_TYPE);
                this.componentInitializerId = attributes.getValue(PaletteItemDataObject.ATTR_INITIALIZER_ID);
            } else if (!PaletteItemDataObject.TAG_CLASSPATH.equals(qName)) {
                String url;
                if (PaletteItemDataObject.TAG_RESOURCE.equals(qName)) {
                    ClassSource.Entry entry;
                    String type = attributes.getValue(PaletteItemDataObject.ATTR_TYPE);
                    String name = attributes.getValue(PaletteItemDataObject.ATTR_NAME);
                    if (type != null && name != null && (entry = ClassSource.unpickle(type, name)) != null) {
                        this.entries.add(entry);
                    }
                } else if (PaletteItemDataObject.TAG_DESCRIPTION.equals(qName)) {
                    String tooltipKey;
                    String displayNameKey;
                    String bundle = attributes.getValue(PaletteItemDataObject.ATTR_BUNDLE);
                    if (bundle != null) {
                        PaletteItemDataObject.this.bundleName = bundle;
                    }
                    if ((displayNameKey = attributes.getValue(PaletteItemDataObject.ATTR_DISPLAY_NAME_KEY)) != null) {
                        PaletteItemDataObject.this.displayName_key = displayNameKey;
                    }
                    if ((tooltipKey = attributes.getValue(PaletteItemDataObject.ATTR_TOOLTIP_KEY)) != null) {
                        PaletteItemDataObject.this.tooltip_key = tooltipKey;
                    }
                } else if (PaletteItemDataObject.TAG_ICON16.equals(qName)) {
                    String url2 = attributes.getValue(PaletteItemDataObject.ATTR_URL);
                    if (url2 != null) {
                        PaletteItemDataObject.this.icon16URL = url2;
                    }
                } else if (PaletteItemDataObject.TAG_ICON32.equals(qName) && (url = attributes.getValue(PaletteItemDataObject.ATTR_URL)) != null) {
                    PaletteItemDataObject.this.icon32URL = url;
                }
            }
        }
    }

    class ItemNode
    extends DataNode {
        ItemNode() {
            super((DataObject)PaletteItemDataObject.this, Children.LEAF);
        }

        public String getDisplayName() {
            if (!PaletteItemDataObject.this.fileLoaded) {
                PaletteItemDataObject.this.loadFile();
            }
            if (PaletteItemDataObject.this.displayName == null) {
                PaletteItemDataObject.this.displayName = this.getExplicitDisplayName();
                if (PaletteItemDataObject.this.displayName == null) {
                    if (PaletteItemDataObject.this.isItemValid()) {
                        String classname;
                        PaletteItemDataObject.this.displayName = PaletteItemDataObject.this.paletteItem.getDisplayName();
                        if (PaletteItemDataObject.this.displayName == null && (classname = PaletteItemDataObject.this.paletteItem.getComponentClassName()) != null) {
                            int i = classname.lastIndexOf(46);
                            String string = PaletteItemDataObject.this.displayName = i >= 0 ? classname.substring(i + 1) : classname;
                        }
                    }
                    if (PaletteItemDataObject.this.displayName == null) {
                        PaletteItemDataObject.this.displayName = super.getDisplayName();
                    }
                }
            }
            return PaletteItemDataObject.this.displayName;
        }

        public String getShortDescription() {
            if (!PaletteItemDataObject.this.fileLoaded) {
                PaletteItemDataObject.this.loadFile();
            }
            if (PaletteItemDataObject.this.tooltip == null) {
                PaletteItemDataObject.this.tooltip = this.getExplicitTooltip();
                if (PaletteItemDataObject.this.tooltip == null) {
                    if (PaletteItemDataObject.this.isItemValid()) {
                        PaletteItemDataObject.this.tooltip = PaletteItemDataObject.this.paletteItem.getTooltip();
                        if (PaletteItemDataObject.this.tooltip == null) {
                            PaletteItemDataObject.this.tooltip = PaletteItemDataObject.this.paletteItem.getComponentClassName();
                        }
                    }
                    if (PaletteItemDataObject.this.tooltip == null) {
                        PaletteItemDataObject.this.tooltip = this.getDisplayName();
                    }
                }
            }
            return PaletteItemDataObject.this.tooltip;
        }

        public boolean canRename() {
            return false;
        }

        public Image getIcon(int type) {
            if (!PaletteItemDataObject.this.fileLoaded) {
                PaletteItemDataObject.this.loadFile();
            }
            if (type == 2 || type == 4) {
                if (PaletteItemDataObject.this.icon32 == null) {
                    PaletteItemDataObject.this.icon32 = this.getExplicitIcon(type);
                    if (PaletteItemDataObject.this.icon32 == null && PaletteItemDataObject.this.isItemValid()) {
                        PaletteItemDataObject.this.icon32 = PaletteItemDataObject.this.paletteItem.getIcon(type);
                    }
                    if (PaletteItemDataObject.this.icon32 == null) {
                        PaletteItemDataObject.this.icon32 = ImageUtilities.loadImage((String)"org/netbeans/modules/form/resources/palette/unknown32.gif");
                    }
                }
                return PaletteItemDataObject.this.icon32;
            }
            if (PaletteItemDataObject.this.icon16 == null) {
                PaletteItemDataObject.this.icon16 = this.getExplicitIcon(type);
                if (PaletteItemDataObject.this.icon16 == null && PaletteItemDataObject.this.isItemValid()) {
                    PaletteItemDataObject.this.icon16 = PaletteItemDataObject.this.paletteItem.getIcon(type);
                }
                if (PaletteItemDataObject.this.icon16 == null) {
                    PaletteItemDataObject.this.icon16 = ImageUtilities.loadImage((String)"org/netbeans/modules/form/resources/palette/unknown.gif");
                }
            }
            return PaletteItemDataObject.this.icon16;
        }

        public Node.PropertySet[] getPropertySets() {
            return NO_PROPERTIES;
        }

        private String getExplicitDisplayName() {
            String displayName = null;
            if (PaletteItemDataObject.this.displayName_key != null) {
                if (PaletteItemDataObject.this.bundleName != null) {
                    try {
                        displayName = NbBundle.getBundle((String)PaletteItemDataObject.this.bundleName).getString(PaletteItemDataObject.this.displayName_key);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (displayName == null) {
                    displayName = PaletteItemDataObject.this.displayName_key;
                }
            }
            return displayName;
        }

        private String getExplicitTooltip() {
            String tooltip = null;
            if (PaletteItemDataObject.this.tooltip_key != null) {
                if (PaletteItemDataObject.this.bundleName != null) {
                    try {
                        tooltip = NbBundle.getBundle((String)PaletteItemDataObject.this.bundleName).getString(PaletteItemDataObject.this.tooltip_key);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (tooltip == null) {
                    tooltip = PaletteItemDataObject.this.tooltip_key;
                }
            }
            return tooltip;
        }

        private Image getExplicitIcon(int type) {
            if (type == 2 || type == 4) {
                if (PaletteItemDataObject.this.icon32URL != null) {
                    try {
                        return Toolkit.getDefaultToolkit().getImage(new URL(PaletteItemDataObject.this.icon32URL));
                    }
                    catch (MalformedURLException ex) {
                    }
                } else if (PaletteItemDataObject.this.getPrimaryFile().getAttribute("SystemFileSystem.icon32") != null) {
                    return super.getIcon(type);
                }
            } else if (PaletteItemDataObject.this.icon16URL != null) {
                try {
                    return Toolkit.getDefaultToolkit().getImage(new URL(PaletteItemDataObject.this.icon16URL));
                }
                catch (MalformedURLException malformedURLException) {
                }
            } else if (PaletteItemDataObject.this.getPrimaryFile().getAttribute("SystemFileSystem.icon") != null) {
                return super.getIcon(type);
            }
            return null;
        }
    }

    public static final class PaletteItemDataLoaderBeanInfo
    extends SimpleBeanInfo {
        private static String iconURL = "org/netbeans/modules/form/resources/palette_manager.png";

        @Override
        public BeanInfo[] getAdditionalBeanInfo() {
            try {
                return new BeanInfo[]{Introspector.getBeanInfo(UniFileLoader.class)};
            }
            catch (IntrospectionException ie) {
                ErrorManager.getDefault().notify((Throwable)ie);
                return null;
            }
        }

        @Override
        public Image getIcon(int type) {
            return ImageUtilities.loadImage((String)iconURL);
        }
    }

    public static final class PaletteItemDataLoader
    extends UniFileLoader {
        static final String ITEM_EXT = "palette_item";
        static final String ITEM_MIME = "text/x-palette-item";

        PaletteItemDataLoader() {
            super("org.netbeans.modules.form.palette.PaletteItemDataObject");
            ExtensionList ext = new ExtensionList();
            ext.addMimeType(ITEM_MIME);
            this.setExtensions(ext);
        }

        protected String defaultDisplayName() {
            return NbBundle.getBundle(PaletteItemDataObject.class).getString("PROP_PaletteItemLoader_Name");
        }

        protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
            return new PaletteItemDataObject(primaryFile, (MultiFileLoader)this);
        }
    }
}

