/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.Dialog;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.palette.PaletteItem;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class BoxFillerInitializer
implements PaletteItem.ComponentInitializer {
    private String initializerId;
    private int width;
    private int height;

    BoxFillerInitializer() {
    }

    @Override
    public boolean prepare(PaletteItem item, FileObject classPathRep) {
        this.initializerId = item.getComponentInitializerId();
        boolean dialogOKClosed = true;
        WidthHeightPanel panel = null;
        if ("Box.Filler.HorizontalStrut".equals(this.initializerId)) {
            panel = new WidthHeightPanel(true, false);
            dialogOKClosed = this.showDialog(panel, "BoxFillerInitializer.HorizontalStrut");
        } else if ("Box.Filler.VerticalStrut".equals(this.initializerId)) {
            panel = new WidthHeightPanel(false, true);
            dialogOKClosed = this.showDialog(panel, "BoxFillerInitializer.VerticalStrut");
        } else if ("Box.Filler.RigidArea".equals(this.initializerId)) {
            panel = new WidthHeightPanel(true, true);
            dialogOKClosed = this.showDialog(panel, "BoxFillerInitializer.RigidArea");
        }
        if (panel != null && dialogOKClosed) {
            this.width = panel.getFillerWidth();
            this.height = panel.getFillerHeight();
        }
        return dialogOKClosed;
    }

    @Override
    public void initializeComponent(RADComponent metaComp) {
        metaComp.setAuxValue("classDetails", this.initializerId);
        if ("Box.Filler.Glue".equals(this.initializerId)) {
            this.setProperty(metaComp, "maximumSize", new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        } else if ("Box.Filler.HorizontalGlue".equals(this.initializerId)) {
            this.setProperty(metaComp, "maximumSize", new Dimension(Short.MAX_VALUE, 0));
        } else if ("Box.Filler.VerticalGlue".equals(this.initializerId)) {
            this.setProperty(metaComp, "maximumSize", new Dimension(0, Short.MAX_VALUE));
        } else if ("Box.Filler.HorizontalStrut".equals(this.initializerId)) {
            this.setProperty(metaComp, "minimumSize", new Dimension(this.width, 0));
            this.setProperty(metaComp, "preferredSize", new Dimension(this.width, 0));
            this.setProperty(metaComp, "maximumSize", new Dimension(this.width, Short.MAX_VALUE));
        } else if ("Box.Filler.VerticalStrut".equals(this.initializerId)) {
            this.setProperty(metaComp, "minimumSize", new Dimension(0, this.height));
            this.setProperty(metaComp, "preferredSize", new Dimension(0, this.height));
            this.setProperty(metaComp, "maximumSize", new Dimension(Short.MAX_VALUE, this.height));
        } else if ("Box.Filler.RigidArea".equals(this.initializerId)) {
            this.setProperty(metaComp, "minimumSize", new Dimension(this.width, this.height));
            this.setProperty(metaComp, "preferredSize", new Dimension(this.width, this.height));
            this.setProperty(metaComp, "maximumSize", new Dimension(this.width, this.height));
        }
    }

    private boolean showDialog(WidthHeightPanel panel, String titleKey) {
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(BoxFillerInitializer.class, (String)titleKey), true, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        HelpCtx.setHelpIDString((JComponent)panel, (String)"f1_gui_filler_html");
        dialog.setVisible(true);
        return dd.getValue() == DialogDescriptor.OK_OPTION;
    }

    private void setProperty(RADComponent metacomp, String propName, Dimension value) {
        try {
            Node.Property prop = metacomp.getPropertyByName(propName);
            prop.setValue((Object)value);
        }
        catch (IllegalAccessException iaex) {
            Logger.getLogger(BoxFillerInitializer.class.getName()).log(Level.INFO, iaex.getMessage(), iaex);
        }
        catch (InvocationTargetException itex) {
            Logger.getLogger(BoxFillerInitializer.class.getName()).log(Level.INFO, itex.getMessage(), itex);
        }
    }

    private static class WidthHeightPanel
    extends JPanel {
        private JSpinner widthField;
        private JSpinner heightField;

        WidthHeightPanel(boolean showWidth, boolean showHeight) {
            ResourceBundle bundle = NbBundle.getBundle(BoxFillerInitializer.class);
            JLabel widthLabel = new JLabel(bundle.getString("BoxFillerInitializer.width"));
            JLabel heightLabel = new JLabel(bundle.getString("BoxFillerInitializer.height"));
            this.widthField = new JSpinner(new SpinnerNumberModel());
            this.heightField = new JSpinner(new SpinnerNumberModel());
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(widthLabel).addComponent(heightLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.widthField).addComponent(this.heightField)).addContainerGap()));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(widthLabel).addComponent(this.widthField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(heightLabel).addComponent(this.heightField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
            widthLabel.setVisible(showWidth);
            heightLabel.setVisible(showHeight);
            this.widthField.setVisible(showWidth);
            this.heightField.setVisible(showHeight);
        }

        int getFillerWidth() {
            return (Integer)this.widthField.getValue();
        }

        int getFillerHeight() {
            return (Integer)this.heightField.getValue();
        }
    }
}

