/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.griddesigner;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.ComponentPeer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.Timer;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridUtils;

public class AnimationLayer
implements ActionListener {
    private static final long ANIMATION_LENGTH_MILLIS = Math.max(1, Integer.getInteger("netbeans.modules.form.grid.animationlength", 300));
    private Map<Component, Rectangle> startBounds = new HashMap<Component, Rectangle>();
    private Map<Component, Rectangle> endBounds = new HashMap<Component, Rectangle>();
    private Set<Component> components = new HashSet<Component>();
    private List<Component> vipComponents = Collections.EMPTY_LIST;
    private float phase;
    private long startTime;
    private long endTime;
    private Timer timer = new Timer(0, this);
    private Container container;
    private JComponent glassPane;
    private Dimension maxContDim = new Dimension();
    private Image containerImage;

    public void setContainer(Container container) {
        this.container = container;
    }

    public void setGlassPane(JComponent glassPane) {
        this.glassPane = glassPane;
    }

    public void loadStart() {
        this.loadBounds(this.startBounds);
    }

    public void loadEnd() {
        this.loadBounds(this.endBounds);
    }

    private void loadBounds(Map<Component, Rectangle> map) {
        map.clear();
        for (Component comp : this.container.getComponents()) {
            if (GridUtils.isPaddingComponent(comp) || !comp.isVisible()) continue;
            map.put(comp, comp.getBounds());
        }
        Dimension contDim = this.container.getSize();
        this.maxContDim = new Dimension(Math.max(this.maxContDim.width, contDim.width), Math.max(this.maxContDim.height, contDim.height));
    }

    public void setVIPComponents(List<Component> vipComponents) {
        this.vipComponents = vipComponents;
    }

    public void animate() {
        this.phase = 0.0f;
        this.components.clear();
        this.components.addAll(this.startBounds.keySet());
        this.components.addAll(this.endBounds.keySet());
        this.components.remove(this.container);
        this.createContainerImage();
        this.components.removeAll(this.vipComponents);
        this.startTime = System.nanoTime();
        this.endTime = this.startTime + ANIMATION_LENGTH_MILLIS * 1000000L;
        this.timer.restart();
    }

    private void createContainerImage() {
        HashMap<Component, Boolean> map = new HashMap<Component, Boolean>();
        for (Component comp : this.components) {
            map.put(comp, comp.isVisible());
            comp.setVisible(false);
        }
        Dimension oldSize = this.container.getSize();
        this.container.setSize(this.maxContDim);
        this.containerImage = this.container.createImage(this.maxContDim.width, this.maxContDim.height);
        this.container.paint(this.containerImage.getGraphics());
        this.container.setSize(oldSize);
        for (Component comp : this.components) {
            comp.setVisible((Boolean)map.get(comp));
        }
    }

    private void updatePhase() {
        long currentTime = System.nanoTime();
        float linPhase = (float)(currentTime - this.startTime) / (float)(this.endTime - this.startTime);
        if ((linPhase = Math.min(linPhase, 1.0f)) <= 0.5f) {
            this.phase = 2.0f * linPhase * linPhase;
        } else {
            linPhase = 1.0f - linPhase;
            this.phase = 1.0f - 2.0f * linPhase * linPhase;
        }
        this.phase = Math.min(Math.max(0.0f, this.phase), 1.0f);
    }

    public float getPhase() {
        return this.phase;
    }

    private Rectangle currentBounds(Component comp) {
        Rectangle start = this.startBounds.get(comp);
        Rectangle end = this.endBounds.get(comp);
        Rectangle bounds = start == null ? end : (end == null ? start : new Rectangle(this.currentValue(start.x, end.x), this.currentValue(start.y, end.y), this.currentValue(start.width, end.width), this.currentValue(start.height, end.height)));
        return bounds;
    }

    private int currentValue(int start, int end) {
        return Math.round((float)start * (1.0f - this.phase) + (float)end * this.phase);
    }

    private float currentAlpha(Component comp) {
        boolean start = this.startBounds.containsKey(comp);
        boolean end = this.endBounds.containsKey(comp);
        float alpha = !start ? this.phase : (!end ? 1.0f - this.phase : 1.0f);
        return alpha;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updatePhase();
        RepaintManager manager = RepaintManager.currentManager(this.glassPane);
        manager.markCompletelyDirty(this.glassPane);
        manager.paintDirtyRegions();
    }

    public void paint(Graphics g) {
        if (this.timer.isRunning()) {
            Graphics gClip = g.create();
            gClip.setClip(0, 0, this.containerImage.getWidth(null), this.containerImage.getHeight(null));
            gClip.drawImage(this.containerImage, 0, 0, null);
            for (Component component : this.components) {
                this.paintComponent(gClip, component);
            }
            for (Component component : this.vipComponents) {
                this.paintComponent(gClip, component);
            }
            if (this.phase == 1.0f) {
                this.timer.stop();
                this.maxContDim = new Dimension();
                for (Map.Entry entry : this.endBounds.entrySet()) {
                    Component comp = (Component)entry.getKey();
                    comp.setBounds((Rectangle)entry.getValue());
                    comp.validate();
                }
            }
            gClip.dispose();
        }
    }

    private void paintComponent(Graphics g, Component comp) {
        Rectangle bounds = this.currentBounds(comp);
        float alpha = this.currentAlpha(comp);
        Graphics gg = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
        if (alpha != 1.0f) {
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, alpha);
            ((Graphics2D)gg).setComposite(alphaComposite);
        }
        comp.setBounds(bounds);
        comp.validate();
        if (comp instanceof JComponent) {
            comp.print(gg);
        } else {
            ComponentPeer peer = comp.getPeer();
            if (peer != null) {
                peer.paint(gg);
            }
        }
        gg.dispose();
    }
}

