/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutsupport.delegates;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormPropertyContext;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.codestructure.CodeExpression;
import org.netbeans.modules.form.codestructure.CodeGroup;
import org.netbeans.modules.form.codestructure.CodeStatement;
import org.netbeans.modules.form.codestructure.CodeStructure;
import org.netbeans.modules.form.codestructure.CodeVariable;
import org.netbeans.modules.form.codestructure.FormCodeSupport;
import org.netbeans.modules.form.editors.PrimitiveTypeArrayEditor;
import org.netbeans.modules.form.layoutsupport.AbstractLayoutSupport;
import org.netbeans.modules.form.layoutsupport.LayoutConstraints;
import org.netbeans.modules.form.layoutsupport.LayoutSupportContext;
import org.netbeans.modules.form.layoutsupport.LayoutSupportManager;
import org.netbeans.modules.form.layoutsupport.delegates.AbsoluteLayoutSupport;
import org.netbeans.modules.form.layoutsupport.delegates.GridBagCustomizer;
import org.netbeans.modules.form.layoutsupport.griddesigner.GridDesigner;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class GridBagLayoutSupport
extends AbstractLayoutSupport {
    private GridBagLayout initialLayout;
    private Rectangle customizerBounds;
    private static Reference<GridBagCustomizer.Window> customizerRef;
    private FormProperty[] layoutProperties;
    private CodeGroup layoutCode;
    private CodeExpression layoutExpression;
    private CodeStatement[] propertyStatements;

    @Override
    public Class getSupportedClass() {
        return GridBagLayout.class;
    }

    private boolean isGridDesignerEnabled() {
        return !Boolean.getBoolean("netbeans.modules.form.oldgriddesigner");
    }

    @Override
    public Class getCustomizerClass() {
        return this.isGridDesignerEnabled() ? GridDesigner.class : GridBagCustomizer.Window.class;
    }

    @Override
    public Component getSupportCustomizer() {
        if (this.isGridDesignerEnabled()) {
            GridDesigner designer = new GridDesigner();
            RADVisualContainer container = ((LayoutSupportManager)this.getLayoutContext()).getMetaContainer();
            designer.setDesignedContainer(container);
            DialogDescriptor dd = new DialogDescriptor((Object)designer, NbBundle.getMessage(GridDesigner.class, (String)"GridDesignerWindow.title"));
            dd.setOptions(new Object[]{DialogDescriptor.CLOSED_OPTION});
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    GridBagLayoutSupport.this.customizerBounds = e.getWindow().getBounds();
                }
            });
            if (this.customizerBounds != null) {
                dialog.setBounds(this.customizerBounds);
                dialog.setPreferredSize(new Dimension(this.customizerBounds.width, this.customizerBounds.height));
            }
            return dialog;
        }
        GridBagCustomizer.Window customizer = null;
        if (customizerRef != null) {
            customizer = customizerRef.get();
        }
        if (customizer == null) {
            customizer = new GridBagCustomizer.Window();
            customizerRef = new WeakReference<GridBagCustomizer.Window>(customizer);
        }
        customizer.setObject(this);
        return customizer;
    }

    @Override
    protected FormProperty[] getProperties() {
        if (this.layoutProperties == null) {
            FormPropertyContext.Component context = new FormPropertyContext.Component(this.metaLayout);
            ResourceBundle bundle = GridBagLayoutSupport.getBundle();
            this.layoutProperties = new FormProperty[]{new GBLProperty(context, "columnWidths", int[].class, bundle.getString("PROP_columnWidths"), bundle.getString("HINT_columnWidths")), new GBLProperty(context, "rowHeights", int[].class, bundle.getString("PROP_rowHeights"), bundle.getString("HINT_rowHeights")), new GBLProperty(context, "columnWeights", double[].class, bundle.getString("PROP_columnWeights"), bundle.getString("HINT_columnWeights")), new GBLProperty(context, "rowWeights", double[].class, bundle.getString("PROP_rowWeights"), bundle.getString("HINT_rowWeights"))};
        }
        return this.layoutProperties;
    }

    @Override
    protected Node.Property getProperty(String propName) {
        FormProperty result = null;
        for (FormProperty property : this.getProperties()) {
            if (!property.getName().equals(propName)) continue;
            result = property;
            break;
        }
        return result;
    }

    @Override
    protected LayoutManager cloneLayoutInstance(Container container, Container containerDelegate) throws Exception {
        GridBagLayout layout = new GridBagLayout();
        for (FormProperty property : this.getProperties()) {
            ((GBLProperty)property).update(layout);
        }
        return layout;
    }

    @Override
    protected void initializeInstance(LayoutManager initialInstance, boolean initializeProperties) throws Exception {
        super.initializeInstance(initialInstance, initializeProperties);
        if (initialInstance instanceof GridBagLayout) {
            this.initialLayout = (GridBagLayout)initialInstance;
            if (initializeProperties) {
                for (FormProperty prop : this.getProperties()) {
                    if (!(prop instanceof GBLProperty)) continue;
                    ((GBLProperty)prop).setFromInitial();
                }
            }
        }
    }

    @Override
    protected boolean isPropertyChangedFromInitial(FormProperty prop) {
        if (prop instanceof GBLProperty) {
            return ((GBLProperty)prop).isChangedFromInitial();
        }
        return prop.isChanged();
    }

    @Override
    protected CodeExpression createInitLayoutCode(CodeGroup layoutCode) {
        this.layoutCode = layoutCode;
        this.layoutExpression = this.getCodeStructure().createExpression(this.getLayoutConstructor(), CodeStructure.EMPTY_PARAMS);
        this.updateLayoutExpression();
        return this.layoutExpression;
    }

    @Override
    protected void readInitLayoutCode(CodeExpression layoutExp, CodeGroup layoutCode) {
        this.layoutCode = layoutCode;
        this.layoutExpression = layoutExp;
        Iterator iter = CodeStructure.getDefinedStatementsIterator(layoutExp);
        while (iter.hasNext()) {
            CodeStatement statement = (CodeStatement)iter.next();
            for (FormProperty property : this.getProperties()) {
                GBLProperty prop = (GBLProperty)property;
                Field propField = prop.getField();
                if (!propField.equals(statement.getMetaObject())) continue;
                CodeExpression propExp = statement.getStatementParameters()[0];
                FormCodeSupport.readPropertyExpression(propExp, prop, false);
            }
        }
        this.updateLayoutExpression();
    }

    void updateLayoutExpression() {
        boolean anyPropertyModified = false;
        this.layoutCode.removeAll();
        FormProperty[] properties = this.getProperties();
        for (int i = 0; i < properties.length; ++i) {
            if (!properties[i].isChanged()) continue;
            anyPropertyModified = true;
            this.layoutCode.addStatement(this.getPropertyStatement(i));
        }
        this.updateLayoutExpressionVariable(anyPropertyModified);
    }

    private void updateLayoutExpressionVariable(boolean variableNeeded) {
        if (variableNeeded) {
            CodeVariable var = this.layoutExpression.getVariable();
            if (var == null) {
                var = this.getCodeStructure().createVariableForExpression(this.layoutExpression, 4096, this.defaultLayoutVariableName());
            }
            this.layoutCode.addStatement(0, var.getAssignment(this.layoutExpression));
        } else {
            this.getCodeStructure().removeExpressionFromVariable(this.layoutExpression);
        }
    }

    private String defaultLayoutVariableName() {
        LayoutSupportManager manager = (LayoutSupportManager)this.getLayoutContext();
        RADVisualContainer metaCont = manager.getMetaContainer();
        String name = metaCont.getFormModel().getTopRADComponent() == metaCont ? "layout" : metaCont.getName() + "Layout";
        return name;
    }

    private Constructor getLayoutConstructor() {
        Constructor result = null;
        try {
            result = GridBagLayout.class.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (SecurityException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return result;
    }

    private CodeStatement getPropertyStatement(int index) {
        CodeStatement propStatement;
        FormProperty[] properties = this.getProperties();
        if (this.propertyStatements == null) {
            this.propertyStatements = new CodeStatement[properties.length];
        }
        if ((propStatement = this.propertyStatements[index]) == null) {
            CodeExpression propExp = this.getCodeStructure().createExpression(FormCodeSupport.createOrigin(properties[index]));
            Field field = ((GBLProperty)properties[index]).getField();
            this.propertyStatements[index] = propStatement = CodeStructure.createStatement(this.layoutExpression, field, propExp);
        }
        return propStatement;
    }

    @Override
    public void convertConstraints(LayoutConstraints[] previousConstraints, LayoutConstraints[] currentConstraints, Component[] components) {
        int i;
        Rectangle jbounds;
        int j;
        int i2;
        if (currentConstraints == null || components == null || components.length > currentConstraints.length || components.length == 0 || previousConstraints != null && !(previousConstraints[0] instanceof AbsoluteLayoutSupport.AbsoluteLayoutConstraints)) {
            return;
        }
        ArrayList<Integer> xlines = new ArrayList<Integer>();
        ArrayList<Integer> ylines = new ArrayList<Integer>();
        Container con = components[0].getParent();
        Rectangle parentbound = con == null ? components[0].getBounds() : con.getBounds();
        GridBagLayoutSupport.insertLines(0, xlines);
        GridBagLayoutSupport.insertLines(0, ylines);
        for (int i3 = 0; i3 < components.length; ++i3) {
            Rectangle ibounds = components[i3].getBounds();
            if (ibounds.width > 0) {
                GridBagLayoutSupport.insertLines(ibounds.x + ibounds.width, xlines);
            } else {
                GridBagLayoutSupport.insertLines(ibounds.x + 1, xlines);
            }
            if (ibounds.height > 0) {
                GridBagLayoutSupport.insertLines(ibounds.y + ibounds.height, ylines);
                continue;
            }
            GridBagLayoutSupport.insertLines(ibounds.y + 1, ylines);
        }
        LayoutInfo[] layouts = new LayoutInfo[components.length];
        for (i2 = 0; i2 < layouts.length; ++i2) {
            layouts[i2] = new LayoutInfo();
        }
        for (i2 = 0; i2 < xlines.size() - 1; ++i2) {
            int x1 = (Integer)xlines.get(i2);
            int x2 = (Integer)xlines.get(i2 + 1);
            for (j = 0; j < components.length; ++j) {
                jbounds = components[j].getBounds();
                if (jbounds.width <= 0) {
                    jbounds.width = 1;
                }
                if (!GridBagLayoutSupport.isOverlapped(x1, x2, jbounds.x, jbounds.x + jbounds.width - 1)) continue;
                layouts[j].incGridWidth(i2);
            }
        }
        for (i2 = 0; i2 < ylines.size() - 1; ++i2) {
            int y1 = (Integer)ylines.get(i2);
            int y2 = (Integer)ylines.get(i2 + 1);
            for (j = 0; j < components.length; ++j) {
                jbounds = components[j].getBounds();
                if (jbounds.height <= 0) {
                    jbounds.height = 1;
                }
                if (!GridBagLayoutSupport.isOverlapped(y1, y2, jbounds.y, jbounds.y + jbounds.height - 1)) continue;
                layouts[j].incGridHeight(i2);
            }
        }
        for (i2 = 0; i2 < components.length; ++i2) {
            int height;
            Rectangle curbounds = components[i2].getBounds();
            int lastleft = 0;
            int lasttop = 0;
            for (int j2 = 0; j2 < components.length; ++j2) {
                int height2;
                Rectangle jbounds2 = components[j2].getBounds();
                int width = jbounds2.width;
                if (width < 0) {
                    width = 0;
                }
                if (jbounds2.x + width - 1 < curbounds.x && jbounds2.x + width > lastleft) {
                    lastleft = jbounds2.x + width;
                }
                if ((height2 = jbounds2.height) < 0) {
                    height2 = 0;
                }
                if (jbounds2.y + height2 - 1 >= curbounds.y || jbounds2.y + height2 <= lasttop) continue;
                lasttop = jbounds2.y + height2;
            }
            layouts[i2].setLeft(curbounds.x - lastleft);
            layouts[i2].setTop(curbounds.y - lasttop);
            int width = curbounds.width < 0 ? 0 : curbounds.width;
            int n = height = curbounds.height < 0 ? 0 : curbounds.height;
            if (layouts[i2].getLastGridX() == xlines.size() - 2) {
                layouts[i2].setRight(parentbound.width - curbounds.x - width);
            }
            if (layouts[i2].getLastGridY() != ylines.size() - 2) continue;
            layouts[i2].setBottom(parentbound.height - curbounds.y - height);
        }
        LayoutInfoComparator comp = new LayoutInfoComparator(0);
        LayoutInfo[] layoutsX = (LayoutInfo[])layouts.clone();
        LayoutInfo[] layoutsY = (LayoutInfo[])layouts.clone();
        Arrays.sort(layoutsX, comp);
        comp.cord = 1;
        Arrays.sort(layoutsY, comp);
        for (i = 0; i < components.length; ++i) {
            int j3;
            int expand = 0;
            int lastgrid = layoutsX[i].getLastGridX();
            for (j3 = i + 1; j3 < components.length; ++j3) {
                if (!layoutsX[j3].containsGridX(lastgrid) || layoutsX[j3].getLastGridX() <= lastgrid || layoutsX[i].gridwidth < layoutsX[j3].gridwidth || expand >= layoutsX[i].gridwidth - layoutsX[j3].gridwidth + 1) continue;
                expand = layoutsX[i].gridwidth - layoutsX[j3].gridwidth + 1;
            }
            if (expand > 0) {
                for (j3 = i + 1; j3 < components.length; ++j3) {
                    if (layoutsX[j3].containsGridX(lastgrid) && layoutsX[j3].getLastGridX() > lastgrid) {
                        layoutsX[j3].expandGridWidth(expand);
                        continue;
                    }
                    if (layoutsX[j3].gridx <= lastgrid) continue;
                    layoutsX[j3].moveGridX(expand);
                }
            }
            expand = 0;
            lastgrid = layoutsY[i].getLastGridY();
            for (j3 = i + 1; j3 < components.length; ++j3) {
                if (!layoutsY[j3].containsGridY(lastgrid) || layoutsY[j3].getLastGridY() <= lastgrid || layoutsY[i].gridheight < layoutsY[j3].gridheight || expand >= layoutsY[i].gridheight - layoutsY[j3].gridheight + 1) continue;
                expand = layoutsY[i].gridheight - layoutsY[j3].gridheight + 1;
            }
            if (expand <= 0) continue;
            for (j3 = i + 1; j3 < components.length; ++j3) {
                if (layoutsY[j3].containsGridY(lastgrid) && layoutsY[j3].getLastGridY() > lastgrid) {
                    layoutsY[j3].expandGridHeight(expand);
                    continue;
                }
                if (layoutsY[j3].gridy <= lastgrid) continue;
                layoutsY[j3].moveGridY(expand);
            }
        }
        for (i = 0; i < components.length; ++i) {
            if (Math.max(layouts[i].gridx + layouts[i].gridwidth - 1, layouts[i].gridy + layouts[i].gridheight - 1) >= 512) {
                for (int j4 = 0; j4 < i; ++j4) {
                    currentConstraints[j4] = null;
                }
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(AbstractLayoutSupport.class, (String)"MSG_ERR_MoreThan512")));
                return;
            }
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = layouts[i].gridx;
            gbc.gridy = layouts[i].gridy;
            gbc.gridwidth = layouts[i].gridwidth;
            gbc.gridheight = layouts[i].gridheight;
            gbc.anchor = 18;
            gbc.insets = new Insets(layouts[i].top, layouts[i].left, layouts[i].bottom, layouts[i].right);
            if (components[i].getClass().getName().equals("javax.swing.JScrollPane")) {
                gbc.weightx = 1.0;
                gbc.weighty = 1.0;
                gbc.fill = 1;
            }
            Rectangle bounds = components[i].getBounds();
            Dimension minsize = components[i].getMinimumSize();
            Dimension prefsize = components[i].getPreferredSize();
            if (bounds.width > minsize.width) {
                gbc.ipadx = bounds.width - minsize.width;
            } else if (bounds.width < prefsize.width) {
                gbc.ipadx = bounds.width - prefsize.width;
            }
            if (bounds.height > minsize.height) {
                gbc.ipady = bounds.height - minsize.height;
            } else if (bounds.height < prefsize.height) {
                gbc.ipady = bounds.height - prefsize.height;
            }
            currentConstraints[i] = new GridBagLayoutConstraints(gbc);
        }
    }

    private static boolean isOverlapped(int border1, int border2, int compPos1, int compPos2) {
        return compPos2 >= border1 && compPos1 < border2;
    }

    private static void insertLines(int line, List<Integer> lines) {
        if (line < 0) {
            line = 0;
        }
        for (int i = 0; i < lines.size(); ++i) {
            int ival = lines.get(i);
            if (line < ival) {
                lines.add(i, new Integer(line));
                return;
            }
            if (line != ival) continue;
            return;
        }
        lines.add(new Integer(line));
    }

    @Override
    protected LayoutConstraints readConstraintsCode(CodeExpression constrExp, CodeGroup constrCode, CodeExpression compExp) {
        GridBagLayoutConstraints constr = new GridBagLayoutConstraints();
        constr.readCodeExpression(constrExp, constrCode);
        return constr;
    }

    @Override
    protected CodeExpression createConstraintsCode(CodeGroup constrCode, LayoutConstraints constr, CodeExpression compExp, int index) {
        if (!(constr instanceof GridBagLayoutConstraints)) {
            return null;
        }
        return ((GridBagLayoutConstraints)constr).createCodeExpression(this.getCodeStructure(), constrCode);
    }

    @Override
    protected LayoutConstraints createDefaultConstraints() {
        return new GridBagLayoutConstraints();
    }

    static ResourceBundle getBundleHack() {
        return GridBagLayoutSupport.getBundle();
    }

    LayoutSupportContext getLayoutSupportHack() {
        return super.getLayoutContext();
    }

    public static class DoubleArrayPropertyEditor
    extends PrimitiveTypeArrayEditor {
        public DoubleArrayPropertyEditor() {
            this.setValueType(double[].class);
        }
    }

    public static class IntArrayPropertyEditor
    extends PrimitiveTypeArrayEditor {
        public IntArrayPropertyEditor() {
            this.setValueType(int[].class);
        }
    }

    class GBLProperty
    extends FormProperty {
        private Object value;

        GBLProperty(FormPropertyContext context, String name, Class type, String displayName, String shortDescription) {
            super(context, name, type, displayName, shortDescription);
        }

        @Override
        public Object getTargetValue() {
            return this.value;
        }

        @Override
        public void setTargetValue(Object value) {
            this.value = value;
        }

        @Override
        public boolean supportsDefaultValue() {
            return true;
        }

        @Override
        public PropertyEditor getExpliciteEditor() {
            Class type = this.getValueType();
            PrimitiveTypeArrayEditor propEd = null;
            if (type.equals(int[].class)) {
                propEd = new IntArrayPropertyEditor();
            } else if (type.equals(double[].class)) {
                propEd = new DoubleArrayPropertyEditor();
            } else assert (false);
            return propEd;
        }

        @Override
        protected void propertyValueChanged(Object old, Object current) {
            super.propertyValueChanged(old, current);
            if (this.isChangeFiring()) {
                GridBagLayoutSupport.this.updateLayoutExpression();
            }
        }

        void update(GridBagLayout instance) {
            try {
                this.getField().set(instance, this.value);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IllegalAccessException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setFromInitial() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            Object initValue;
            if (GridBagLayoutSupport.this.initialLayout != null && (initValue = this.getField().get(GridBagLayoutSupport.this.initialLayout)) != null) {
                boolean firing = this.isChangeFiring();
                try {
                    this.setChangeFiring(false);
                    this.setValue(initValue);
                }
                finally {
                    this.setChangeFiring(firing);
                }
            }
        }

        boolean isChangedFromInitial() {
            if (GridBagLayoutSupport.this.initialLayout != null) {
                try {
                    Object initValue = this.getField().get(GridBagLayoutSupport.this.initialLayout);
                    return !Utilities.compareObjects((Object)this.value, (Object)initValue);
                }
                catch (IllegalArgumentException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            return this.isChanged();
        }

        Field getField() {
            Field field = null;
            try {
                field = GridBagLayout.class.getField(this.getName());
            }
            catch (NoSuchFieldException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return field;
        }
    }

    static final class AnchorEditor
    extends GridBagConstrEditor
    implements FormAwareEditor {
        AnchorEditor() {
        }

        @Override
        public void setContext(FormModel formModel, FormProperty property) {
            boolean isJDK6Compatible = true;
            if (formModel != null) {
                FileObject formFile = FormEditor.getFormDataObject(formModel).getPrimaryFile();
                isJDK6Compatible = ClassPathUtils.isJava6ProjectPlatform(formFile);
            }
            LinkedList<String> tagList = new LinkedList<String>();
            ResourceBundle bundle = GridBagLayoutSupport.getBundle();
            tagList.add(bundle.getString("VALUE_anchor_center"));
            tagList.add(bundle.getString("VALUE_anchor_north"));
            tagList.add(bundle.getString("VALUE_anchor_northeast"));
            tagList.add(bundle.getString("VALUE_anchor_east"));
            tagList.add(bundle.getString("VALUE_anchor_southeast"));
            tagList.add(bundle.getString("VALUE_anchor_south"));
            tagList.add(bundle.getString("VALUE_anchor_southwest"));
            tagList.add(bundle.getString("VALUE_anchor_west"));
            tagList.add(bundle.getString("VALUE_anchor_northwest"));
            tagList.add(bundle.getString("VALUE_anchor_pagestart"));
            tagList.add(bundle.getString("VALUE_anchor_pageend"));
            tagList.add(bundle.getString("VALUE_anchor_linestart"));
            tagList.add(bundle.getString("VALUE_anchor_lineend"));
            tagList.add(bundle.getString("VALUE_anchor_firstlinestart"));
            tagList.add(bundle.getString("VALUE_anchor_firstlineend"));
            tagList.add(bundle.getString("VALUE_anchor_lastlinestart"));
            tagList.add(bundle.getString("VALUE_anchor_lastlineend"));
            if (isJDK6Compatible) {
                tagList.add(bundle.getString("VALUE_anchor_above_baseline"));
                tagList.add(bundle.getString("VALUE_anchor_above_baseline_leading"));
                tagList.add(bundle.getString("VALUE_anchor_above_baseline_trailing"));
                tagList.add(bundle.getString("VALUE_anchor_baseline"));
                tagList.add(bundle.getString("VALUE_anchor_baseline_leading"));
                tagList.add(bundle.getString("VALUE_anchor_baseline_trailing"));
                tagList.add(bundle.getString("VALUE_anchor_below_baseline"));
                tagList.add(bundle.getString("VALUE_anchor_below_baseline_leading"));
                tagList.add(bundle.getString("VALUE_anchor_below_baseline_trailing"));
            }
            this.tags = tagList.toArray(new String[tagList.size()]);
            LinkedList<Integer> valueList = new LinkedList<Integer>();
            valueList.add(10);
            valueList.add(11);
            valueList.add(12);
            valueList.add(13);
            valueList.add(14);
            valueList.add(15);
            valueList.add(16);
            valueList.add(17);
            valueList.add(18);
            valueList.add(19);
            valueList.add(20);
            valueList.add(21);
            valueList.add(22);
            valueList.add(23);
            valueList.add(24);
            valueList.add(25);
            valueList.add(26);
            if (isJDK6Compatible) {
                valueList.add(1024);
                valueList.add(1280);
                valueList.add(1536);
                valueList.add(256);
                valueList.add(512);
                valueList.add(768);
                valueList.add(1792);
                valueList.add(2048);
                valueList.add(2304);
            }
            this.values = valueList.toArray(new Integer[valueList.size()]);
            LinkedList<String> initStringList = new LinkedList<String>();
            initStringList.add("java.awt.GridBagConstraints.CENTER");
            initStringList.add("java.awt.GridBagConstraints.NORTH");
            initStringList.add("java.awt.GridBagConstraints.NORTHEAST");
            initStringList.add("java.awt.GridBagConstraints.EAST");
            initStringList.add("java.awt.GridBagConstraints.SOUTHEAST");
            initStringList.add("java.awt.GridBagConstraints.SOUTH");
            initStringList.add("java.awt.GridBagConstraints.SOUTHWEST");
            initStringList.add("java.awt.GridBagConstraints.WEST");
            initStringList.add("java.awt.GridBagConstraints.NORTHWEST");
            initStringList.add("java.awt.GridBagConstraints.PAGE_START");
            initStringList.add("java.awt.GridBagConstraints.PAGE_END");
            initStringList.add("java.awt.GridBagConstraints.LINE_START");
            initStringList.add("java.awt.GridBagConstraints.LINE_END");
            initStringList.add("java.awt.GridBagConstraints.FIRST_LINE_START");
            initStringList.add("java.awt.GridBagConstraints.FIRST_LINE_END");
            initStringList.add("java.awt.GridBagConstraints.LAST_LINE_START");
            initStringList.add("java.awt.GridBagConstraints.LAST_LINE_END");
            if (isJDK6Compatible) {
                initStringList.add("java.awt.GridBagConstraints.ABOVE_BASELINE");
                initStringList.add("java.awt.GridBagConstraints.ABOVE_BASELINE_LEADING");
                initStringList.add("java.awt.GridBagConstraints.ABOVE_BASELINE_TRAILING");
                initStringList.add("java.awt.GridBagConstraints.BASELINE");
                initStringList.add("java.awt.GridBagConstraints.BASELINE_LEADING");
                initStringList.add("java.awt.GridBagConstraints.BASELINE_TRAILING");
                initStringList.add("java.awt.GridBagConstraints.BELOW_BASELINE");
                initStringList.add("java.awt.GridBagConstraints.BELOW_BASELINE_LEADING");
                initStringList.add("java.awt.GridBagConstraints.BELOW_BASELINE_TRAILING");
            }
            this.javaInitStrings = initStringList.toArray(new String[initStringList.size()]);
            this.otherValuesAllowed = false;
        }

        @Override
        public void updateFormVersionLevel() {
        }
    }

    static final class FillEditor
    extends GridBagConstrEditor {
        public FillEditor() {
            this.tags = new String[]{GridBagLayoutSupport.getBundle().getString("VALUE_fill_none"), GridBagLayoutSupport.getBundle().getString("VALUE_fill_horizontal"), GridBagLayoutSupport.getBundle().getString("VALUE_fill_vertical"), GridBagLayoutSupport.getBundle().getString("VALUE_fill_both")};
            this.values = new Integer[]{new Integer(0), new Integer(2), new Integer(3), new Integer(1)};
            this.javaInitStrings = new String[]{"java.awt.GridBagConstraints.NONE", "java.awt.GridBagConstraints.HORIZONTAL", "java.awt.GridBagConstraints.VERTICAL", "java.awt.GridBagConstraints.BOTH"};
            this.otherValuesAllowed = false;
        }
    }

    static final class GridSizeEditor
    extends GridBagConstrEditor {
        public GridSizeEditor() {
            this.tags = new String[]{GridBagLayoutSupport.getBundle().getString("VALUE_relative"), GridBagLayoutSupport.getBundle().getString("VALUE_remainder")};
            this.values = new Integer[]{new Integer(-1), new Integer(0)};
            this.javaInitStrings = new String[]{"java.awt.GridBagConstraints.RELATIVE", "java.awt.GridBagConstraints.REMAINDER"};
            this.otherValuesAllowed = true;
        }
    }

    static final class GridPosEditor
    extends GridBagConstrEditor {
        public GridPosEditor() {
            this.tags = new String[]{GridBagLayoutSupport.getBundle().getString("VALUE_relative")};
            this.values = new Integer[]{new Integer(-1)};
            this.javaInitStrings = new String[]{"java.awt.GridBagConstraints.RELATIVE"};
            this.otherValuesAllowed = true;
        }
    }

    private static abstract class GridBagConstrEditor
    extends PropertyEditorSupport {
        String[] tags;
        Integer[] values;
        String[] javaInitStrings;
        boolean otherValuesAllowed;

        private GridBagConstrEditor() {
        }

        @Override
        public String[] getTags() {
            return this.tags;
        }

        @Override
        public String getAsText() {
            Object value = this.getValue();
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(value)) continue;
                return this.tags[i];
            }
            return this.otherValuesAllowed && value != null ? value.toString() : null;
        }

        @Override
        public void setAsText(String str) {
            for (int i = 0; i < this.tags.length; ++i) {
                if (!this.tags[i].equals(str)) continue;
                this.setValue(this.values[i]);
                return;
            }
            if (this.otherValuesAllowed) {
                try {
                    this.setValue(new Integer(Integer.parseInt(str)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        @Override
        public String getJavaInitializationString() {
            Object value = this.getValue();
            for (int i = 0; i < this.values.length; ++i) {
                if (!this.values[i].equals(value)) continue;
                return this.javaInitStrings[i];
            }
            if (!this.otherValuesAllowed) {
                return this.javaInitStrings[0];
            }
            return value != null ? value.toString() : null;
        }
    }

    public static class GridBagLayoutConstraints
    implements LayoutConstraints {
        private GridBagConstraints constraints;
        private GridBagConstraints defaultConstraints = new GridBagConstraints();
        private Property[] properties;
        private CodeExpression constraintsExpression;
        private CodeGroup constraintsCode;
        private CodeStatement[] propertyStatements;
        private static Constructor constrConstructor;
        private static final int variableType = 20480;
        private static final int variableMask = 28672;
        private static final String defaultVariableName = "gridBagConstraints";

        public GridBagLayoutConstraints() {
            this.constraints = new GridBagConstraints();
        }

        public GridBagLayoutConstraints(GridBagConstraints constraints) {
            this.constraints = constraints;
        }

        @Override
        public Node.Property[] getProperties() {
            if (this.properties == null) {
                this.createProperties();
                this.reinstateProperties();
            }
            return this.properties;
        }

        @Override
        public Object getConstraintsObject() {
            return this.constraints;
        }

        @Override
        public LayoutConstraints cloneConstraints() {
            return new GridBagLayoutConstraints((GridBagConstraints)this.constraints.clone());
        }

        private CodeExpression createCodeExpression(CodeStructure codeStructure, CodeGroup constrCode) {
            this.constraintsCode = constrCode;
            this.propertyStatements = null;
            this.constraintsExpression = codeStructure.createExpression(GridBagLayoutConstraints.getConstraintsConstructor(), CodeStructure.EMPTY_PARAMS);
            this.updateCodeExpression();
            return this.constraintsExpression;
        }

        private void readCodeExpression(CodeExpression constrExp, CodeGroup constrCode) {
            this.constraintsExpression = constrExp;
            this.constraintsCode = constrCode;
            this.propertyStatements = null;
            this.getProperties();
            boolean isAnyChanged = false;
            Iterator it = CodeStructure.getDefinedStatementsIterator(constrExp);
            ArrayList<CodeStatement> redundantStatements = new ArrayList<CodeStatement>(15);
            block0: while (it.hasNext()) {
                CodeStatement statement = (CodeStatement)it.next();
                for (int j = 0; j < this.properties.length; ++j) {
                    Property prop = this.properties[j];
                    if (!prop.field.equals(statement.getMetaObject())) continue;
                    FormCodeSupport.readPropertyStatement(statement, prop, false);
                    this.setPropertyStatement(j, statement);
                    if (prop.isChanged()) {
                        constrCode.addStatement(statement);
                        isAnyChanged = true;
                        continue block0;
                    }
                    redundantStatements.add(statement);
                    continue block0;
                }
            }
            for (CodeStatement statement : redundantStatements) {
                CodeStructure.removeStatement(statement);
            }
            this.setupVariable(isAnyChanged);
        }

        private void updateCodeExpression() {
            if (this.constraintsCode == null || this.constraintsExpression == null) {
                return;
            }
            this.constraintsCode.removeAll();
            this.getProperties();
            boolean isAnyChanged = false;
            for (int i = 0; i < this.properties.length; ++i) {
                if (!this.properties[i].isChanged()) continue;
                this.constraintsCode.addStatement(this.getPropertyStatement(i));
                isAnyChanged = true;
            }
            this.setupVariable(isAnyChanged);
        }

        private CodeStatement getPropertyStatement(int index) {
            CodeStatement propStatement;
            if (this.propertyStatements == null) {
                this.propertyStatements = new CodeStatement[this.properties.length];
            }
            if ((propStatement = this.propertyStatements[index]) == null) {
                CodeExpression propExp = this.constraintsExpression.getCodeStructure().createExpression(FormCodeSupport.createOrigin(this.properties[index]));
                this.propertyStatements[index] = propStatement = CodeStructure.createStatement(this.constraintsExpression, this.properties[index].field, propExp);
            }
            return propStatement;
        }

        private void setPropertyStatement(int index, CodeStatement propStatement) {
            if (this.propertyStatements == null) {
                this.propertyStatements = new CodeStatement[this.properties.length];
            }
            this.propertyStatements[index] = propStatement;
        }

        private void setupVariable(boolean anyChangedProperty) {
            CodeStructure codeStructure = this.constraintsExpression.getCodeStructure();
            CodeVariable var = this.constraintsExpression.getVariable();
            if (anyChangedProperty) {
                if (var == null) {
                    var = this.findVariable();
                    if (var == null) {
                        var = codeStructure.createVariableForExpression(this.constraintsExpression, 20480, defaultVariableName);
                    } else {
                        codeStructure.attachExpressionToVariable(this.constraintsExpression, var);
                    }
                }
                this.constraintsCode.addStatement(0, var.getAssignment(this.constraintsExpression));
            } else {
                codeStructure.removeExpressionFromVariable(this.constraintsExpression);
            }
        }

        private CodeVariable findVariable() {
            CodeStructure codeStructure = this.constraintsExpression.getCodeStructure();
            CodeVariable var = codeStructure.getVariable(defaultVariableName);
            if (var != null && (var.getType() & 0x7000) == 20480 && GridBagConstraints.class.equals((Object)var.getDeclaredType())) {
                return var;
            }
            Iterator it = codeStructure.getVariablesIterator(20480, 28672, GridBagConstraints.class);
            while (it.hasNext()) {
                var = (CodeVariable)it.next();
                if (!var.getName().startsWith(defaultVariableName)) continue;
                return var;
            }
            return null;
        }

        private void createProperties() {
            this.properties = new Property[]{new Property("gridx", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_gridx"), GridBagLayoutSupport.getBundle().getString("HINT_gridx"), GridPosEditor.class), new Property("gridy", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_gridy"), GridBagLayoutSupport.getBundle().getString("HINT_gridy"), GridPosEditor.class), new Property("gridwidth", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_gridwidth"), GridBagLayoutSupport.getBundle().getString("HINT_gridwidth"), GridSizeEditor.class), new Property("gridheight", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_gridheight"), GridBagLayoutSupport.getBundle().getString("HINT_gridheight"), GridSizeEditor.class), new Property("fill", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_fill"), GridBagLayoutSupport.getBundle().getString("HINT_fill"), FillEditor.class), new Property("ipadx", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_ipadx"), GridBagLayoutSupport.getBundle().getString("HINT_ipadx"), null), new Property("ipady", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_ipady"), GridBagLayoutSupport.getBundle().getString("HINT_ipady"), null), new Property("anchor", Integer.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_anchor"), GridBagLayoutSupport.getBundle().getString("HINT_anchor"), AnchorEditor.class), new Property("weightx", Double.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_weightx"), GridBagLayoutSupport.getBundle().getString("HINT_weightx"), null), new Property("weighty", Double.TYPE, GridBagLayoutSupport.getBundle().getString("PROP_weighty"), GridBagLayoutSupport.getBundle().getString("HINT_weighty"), null), new Property("insets", (Class)Insets.class, GridBagLayoutSupport.getBundle().getString("PROP_insets"), GridBagLayoutSupport.getBundle().getString("HINT_insets"), null){

                @Override
                public void setTargetValue(Object value) {
                    if (value == null) {
                        String msg = GridBagLayoutSupport.getBundle().getString("MSG_null_insets");
                        IllegalArgumentException ex = new IllegalArgumentException(msg);
                        Exceptions.attachLocalizedMessage((Throwable)ex, (String)msg);
                        throw ex;
                    }
                    super.setTargetValue(value);
                }
            }};
            this.properties[0].setValue("canEditAsText", Boolean.TRUE);
            this.properties[1].setValue("canEditAsText", Boolean.TRUE);
            this.properties[2].setValue("canEditAsText", Boolean.TRUE);
            this.properties[3].setValue("canEditAsText", Boolean.TRUE);
        }

        private void reinstateProperties() {
            try {
                for (int i = 0; i < this.properties.length; ++i) {
                    Property prop = this.properties[i];
                    prop.reinstateProperty();
                }
            }
            catch (IllegalAccessException e1) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }

        private static Constructor getConstraintsConstructor() {
            if (constrConstructor == null) {
                try {
                    constrConstructor = GridBagConstraints.class.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException ex) {
                    ex.printStackTrace();
                }
            }
            return constrConstructor;
        }

        private class Property
        extends FormProperty {
            private Field field;
            private Class<? extends PropertyEditor> propertyEditorClass;

            Property(String name, Class type, String displayName, String shortDescription, Class<? extends PropertyEditor> propertyEditorClass) {
                super("GridBagLayoutConstraints " + name, type, displayName, shortDescription);
                this.propertyEditorClass = propertyEditorClass;
                try {
                    this.field = GridBagConstraints.class.getField(name);
                }
                catch (NoSuchFieldException ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public Object getTargetValue() {
                try {
                    return this.field.get(GridBagLayoutConstraints.this.constraints);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            @Override
            public void setTargetValue(Object value) {
                try {
                    this.field.set(GridBagLayoutConstraints.this.constraints, value);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }

            @Override
            public boolean supportsDefaultValue() {
                return true;
            }

            @Override
            public Object getDefaultValue() {
                try {
                    return this.field.get(GridBagLayoutConstraints.this.defaultConstraints);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            @Override
            public PropertyEditor getExpliciteEditor() {
                if (this.propertyEditorClass == null) {
                    return null;
                }
                try {
                    return this.propertyEditorClass.newInstance();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return null;
                }
            }

            @Override
            protected void propertyValueChanged(Object old, Object current) {
                String name;
                if (current instanceof Integer && (((name = this.getName()).endsWith("gridx") || name.endsWith("gridwidth")) && ((GridBagLayoutConstraints)GridBagLayoutConstraints.this).constraints.gridx + ((GridBagLayoutConstraints)GridBagLayoutConstraints.this).constraints.gridwidth > 512 || (name.endsWith("gridy") || name.endsWith("gridheight")) && ((GridBagLayoutConstraints)GridBagLayoutConstraints.this).constraints.gridy + ((GridBagLayoutConstraints)GridBagLayoutConstraints.this).constraints.gridheight > 512)) {
                    boolean fire = this.isChangeFiring();
                    this.setChangeFiring(false);
                    try {
                        this.setValue(old);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.setChangeFiring(fire);
                    return;
                }
                if (this.isChangeFiring()) {
                    GridBagLayoutConstraints.this.updateCodeExpression();
                }
                super.propertyValueChanged(old, current);
            }

            @Override
            public void setPropertyContext(FormPropertyContext ctx) {
                super.setPropertyContext(new GridBagPropertyContext(ctx));
            }
        }

        static class GridBagPropertyContext
        implements FormPropertyContext {
            private FormPropertyContext delegate;

            GridBagPropertyContext(FormPropertyContext delegate) {
                this.delegate = delegate;
            }

            @Override
            public boolean useMultipleEditors() {
                return false;
            }

            @Override
            public void initPropertyEditor(PropertyEditor prEd, FormProperty property) {
                this.delegate.initPropertyEditor(prEd, property);
            }

            @Override
            public FormModel getFormModel() {
                return this.delegate.getFormModel();
            }

            @Override
            public Object getOwner() {
                return this.delegate.getOwner();
            }
        }
    }

    private static class LayoutInfo {
        int gridx;
        int gridy;
        int gridwidth;
        int gridheight;
        int top = 0;
        int left = 0;
        int bottom = 0;
        int right = 0;

        private LayoutInfo() {
        }

        void setLeft(int left) {
            if (left < 0) {
                left = 0;
            }
            this.left = left;
        }

        void setTop(int top) {
            if (top < 0) {
                top = 0;
            }
            this.top = top;
        }

        void setBottom(int bottom) {
            if (bottom < 0) {
                bottom = 0;
            }
            this.bottom = bottom;
        }

        void setRight(int right) {
            if (right < 0) {
                right = 0;
            }
            this.right = right;
        }

        void moveGridX(int diff) {
            this.gridx += diff;
        }

        void moveGridY(int diff) {
            this.gridy += diff;
        }

        void expandGridWidth(int diff) {
            this.gridwidth += diff;
        }

        void expandGridHeight(int diff) {
            this.gridheight += diff;
        }

        void incGridWidth(int gridx) {
            if (this.gridwidth == 0) {
                this.gridx = gridx;
            }
            ++this.gridwidth;
        }

        void incGridHeight(int gridy) {
            if (this.gridheight == 0) {
                this.gridy = gridy;
            }
            ++this.gridheight;
        }

        boolean containsGridX(int grid) {
            return grid >= this.gridx && grid < this.gridx + this.gridwidth;
        }

        boolean containsGridY(int grid) {
            return grid >= this.gridy && grid < this.gridy + this.gridheight;
        }

        int getLastGridX() {
            return this.gridx + this.gridwidth - 1;
        }

        int getLastGridY() {
            return this.gridy + this.gridheight - 1;
        }
    }

    private static class LayoutInfoComparator
    implements Comparator<LayoutInfo> {
        static final int XAXIS = 0;
        static final int YAXIS = 1;
        int cord;

        public LayoutInfoComparator(int cord) {
            this.cord = cord;
        }

        @Override
        public int compare(LayoutInfo layoutleft, LayoutInfo layoutright) {
            if (layoutleft == null || layoutright == null) {
                return 0;
            }
            if (this.cord == 0) {
                return layoutleft.getLastGridX() - layoutright.getLastGridX();
            }
            return layoutleft.getLastGridY() - layoutright.getLastGridY();
        }
    }
}

