/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutDesigner;
import org.netbeans.modules.form.layoutdesign.LayoutEvent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;
import org.netbeans.modules.form.layoutdesign.VisualMapper;
import org.openide.util.NbBundle;

public class VisualState
implements LayoutConstants {
    private LayoutModel layoutModel;
    private VisualMapper visualMapper;
    private Map<LayoutComponent, List<GapInfo>> componentGaps = new HashMap<LayoutComponent, List<GapInfo>>();
    private Map<LayoutComponent, List<GapInfo>> compGapsToUpdate;
    private Map<LayoutComponent, List<GapInfo>> containerGaps = new HashMap<LayoutComponent, List<GapInfo>>();
    private Map<LayoutComponent, List<GapInfo>> contGapsToUpdate;
    private Map<LayoutComponent, Shape> clippingCache = new HashMap<LayoutComponent, Shape>();
    private static final int PROXIMITY = 32;
    private static String[] PADDING_DISPLAY_NAMES;

    VisualState(LayoutModel model, VisualMapper mapper) {
        this.layoutModel = model;
        this.visualMapper = mapper;
        this.layoutModel.addListener(new LayoutModel.Listener(){

            @Override
            public void layoutChanged(LayoutEvent ev) {
                int type = ev.getType();
                if (type != 7 && type != 13) {
                    VisualState.this.componentGaps.clear();
                    if (VisualState.this.compGapsToUpdate != null) {
                        VisualState.this.compGapsToUpdate.clear();
                    }
                    VisualState.this.containerGaps.clear();
                    if (VisualState.this.contGapsToUpdate != null) {
                        VisualState.this.contGapsToUpdate.clear();
                    }
                }
            }
        });
    }

    void updateCurrentSpaceOfComponents(LayoutComponent container, boolean top) {
        if (top) {
            Rectangle bounds = container.getParent() != null ? this.visualMapper.getComponentBounds(container.getId()) : null;
            container.setCurrentBounds(bounds, -1);
        }
        container.setCurrentInterior(this.visualMapper.getContainerInterior(container.getId()));
        for (LayoutComponent subComp : container.getSubcomponents()) {
            Rectangle bounds = this.visualMapper.getComponentBounds(subComp.getId());
            int baseline = this.visualMapper.getBaselinePosition(subComp.getId(), bounds.width, bounds.height);
            subComp.setCurrentBounds(bounds, baseline);
        }
        Dimension minimum = this.visualMapper.getComponentMinimumSize(container.getId());
        Rectangle bounds = this.visualMapper.getComponentBounds(container.getId());
        container.setDiffToMinimumSize(0, bounds.width - minimum.width);
        container.setDiffToMinimumSize(1, bounds.height - minimum.height);
        this.prepareGapsForUpdate();
        this.clippingCache.clear();
    }

    private void prepareGapsForUpdate() {
        LayoutComponent comp;
        if (this.componentGaps.isEmpty() && this.containerGaps.isEmpty()) {
            return;
        }
        for (Map.Entry<LayoutComponent, List<GapInfo>> e : this.componentGaps.entrySet()) {
            List<GapInfo> gaps;
            comp = e.getKey();
            if (comp.getParent() == null || !this.isComponentInDesignView(comp.getParent()) || (gaps = e.getValue()).isEmpty()) continue;
            if (this.compGapsToUpdate == null) {
                this.compGapsToUpdate = new HashMap<LayoutComponent, List<GapInfo>>();
            }
            this.compGapsToUpdate.put(comp, e.getValue());
        }
        this.componentGaps.clear();
        for (Map.Entry<LayoutComponent, List<GapInfo>> e : this.containerGaps.entrySet()) {
            comp = e.getKey();
            if (!this.isComponentInDesignView(comp)) continue;
            if (this.contGapsToUpdate == null) {
                this.contGapsToUpdate = new HashMap<LayoutComponent, List<GapInfo>>();
            }
            this.contGapsToUpdate.put(comp, e.getValue());
        }
        this.containerGaps.clear();
    }

    private boolean isComponentInDesignView(LayoutComponent component) {
        return this.visualMapper.getComponentBounds(component.getId()) != null;
    }

    void updateCurrentSpaceOfGroups(LayoutInterval group, int dimension, int[] parentEdgePositions) {
        if (group.getSubIntervalCount() == 0) {
            return;
        }
        LayoutRegion groupSpace = group.getCurrentSpace();
        if (group.getParent() != null) {
            assert (!groupSpace.isSet(dimension));
            LayoutRegion parentSpace = group.getParent().getCurrentSpace();
            for (int e = 0; e <= 1; ++e) {
                if (!parentSpace.isSet(dimension, e) || !LayoutInterval.isAlignedAtBorder(group, e)) continue;
                groupSpace.setPos(dimension, e, parentSpace.positions[dimension][e]);
            }
        }
        if (group.getGroupAlignment() == 3) {
            groupSpace.positions[dimension][3] = Integer.MIN_VALUE;
        }
        LayoutRegion space = new LayoutRegion();
        boolean[] def = new boolean[]{false, false};
        boolean[] undef = new boolean[]{false, false};
        int[] endGapSize = new int[]{-1, -1};
        int[] groupEdgePositions = VisualState.getGroupPositionLimits(group, dimension, parentEdgePositions);
        for (int i = 0; i < group.getSubIntervalCount(); ++i) {
            LayoutInterval sub = group.getSubInterval(i);
            if (sub.isEmptySpace()) {
                int align;
                if (!group.isSequential() || i != 0 && i != group.getSubIntervalCount() - 1) continue;
                int n = align = i == 0 ? 0 : 1;
                if (groupSpace.isSet(dimension, align)) continue;
                if (!LayoutInterval.canResize(sub)) {
                    endGapSize[align] = sub.getPreferredSize() != -1 ? sub.getPreferredSize() : LayoutUtils.getSizeOfDefaultGap(sub, this.visualMapper);
                }
                if (endGapSize[align] >= 0) {
                    def[align] = true;
                    continue;
                }
                undef[align] = true;
                continue;
            }
            LayoutRegion subSpace = sub.getCurrentSpace();
            if (sub.isGroup()) {
                subSpace.reset();
                this.updateCurrentSpaceOfGroups(sub, dimension, groupEdgePositions);
            } else if (sub.isComponent() && group.getGroupAlignment() == 3 && groupSpace.positions[dimension][3] == Integer.MIN_VALUE) {
                groupSpace.positions[dimension][3] = subSpace.positions[dimension][3];
            }
            space.expand(subSpace, dimension);
            groupSpace.expand(subSpace, dimension ^ 1);
            for (int e = 0; e <= 1; ++e) {
                if (groupSpace.isSet(dimension, e)) continue;
                if (subSpace.isSet(dimension, e)) {
                    if (def[e] || !LayoutInterval.isAlignedAtBorder(sub, e)) continue;
                    def[e] = true;
                    continue;
                }
                if (def[e] || undef[e] || !LayoutInterval.isAlignedAtBorder(sub, e)) continue;
                undef[e] = true;
            }
        }
        for (int e = 0; e <= 1; ++e) {
            int d;
            if (groupSpace.isSet(dimension, e)) continue;
            int n = d = e == 0 ? -1 : 1;
            if (space.isSet(dimension, e) && (def[e] || !undef[e])) {
                int limitPos;
                groupSpace.setPos(dimension, e, space.positions[dimension][e]);
                if (endGapSize[e] < 0) continue;
                int change = endGapSize[e] * d;
                int gapPos = groupSpace.positions[dimension][e] + change;
                int n2 = limitPos = parentEdgePositions != null ? parentEdgePositions[e] : Integer.MIN_VALUE;
                if (limitPos != Integer.MIN_VALUE && gapPos * d > limitPos * d) {
                    change = (limitPos - gapPos + change) * d;
                }
                if (change == 0) continue;
                groupSpace.reshape(dimension, e, change);
                continue;
            }
            if (!group.isParallel()) continue;
            int outPos = Integer.MIN_VALUE;
            for (LayoutInterval comp : LayoutUtils.getSideComponents(group, e, false, false)) {
                int pos = group.getSubInterval((int)LayoutInterval.getIndexInParent((LayoutInterval)comp, (LayoutInterval)group)).getCurrentSpace().positions[dimension][e];
                if (pos == Integer.MIN_VALUE) {
                    pos = comp.getCurrentSpace().positions[dimension][e];
                    LayoutInterval borderGap = LayoutInterval.getNeighbor(comp, e, false, true, false);
                    if (borderGap != null && borderGap.isEmptySpace() && group.isParentOf(borderGap)) {
                        int gapSize = borderGap.getPreferredSize();
                        if (gapSize == -1) {
                            gapSize = LayoutUtils.getSizeOfDefaultGap(borderGap, this.visualMapper);
                        }
                        if (gapSize >= 0) {
                            pos += gapSize * d;
                        } else {
                            outPos = Integer.MIN_VALUE;
                            break;
                        }
                    }
                }
                if (outPos != Integer.MIN_VALUE && pos * d <= outPos * d) continue;
                outPos = pos;
            }
            if (outPos == Integer.MIN_VALUE) continue;
            groupSpace.setPos(dimension, e, outPos);
        }
        VisualState.completeUknownGroupPositions(group, dimension);
    }

    private static int[] getGroupPositionLimits(LayoutInterval group, int dimension, int[] parentEdgePositions) {
        int[] pos = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE};
        for (int e = 0; e <= 1; ++e) {
            List<LayoutInterval> l;
            pos[e] = group.getParent() == null ? group.getCurrentSpace().positions[dimension][e] : (parentEdgePositions != null && parentEdgePositions[e] != Integer.MIN_VALUE && LayoutInterval.isAlignedAtBorder(group, e) ? parentEdgePositions[e] : (!(l = LayoutUtils.getSideComponents(group, e, true, true)).isEmpty() ? l.get((int)0).getCurrentSpace().positions[dimension][e] : parentEdgePositions[e]));
        }
        return pos;
    }

    private static void completeUknownGroupPositions(LayoutInterval group, int dimension) {
        LayoutRegion groupSpace = group.getCurrentSpace();
        for (int i = 0; i < group.getSubIntervalCount(); ++i) {
            LayoutInterval sub = group.getSubInterval(i);
            if (!sub.isGroup()) continue;
            LayoutRegion subSpace = sub.getCurrentSpace();
            boolean subSpaceCompleted = false;
            for (int e = 0; e <= 1; ++e) {
                if (subSpace.isSet(dimension, e)) continue;
                if (group.isSequential()) {
                    if (i == 0 && e == 0 || i == group.getSubIntervalCount() - 1 && e == 1) {
                        if (groupSpace.isSet(dimension, e)) {
                            subSpace.setPos(dimension, e, groupSpace.positions[dimension][e]);
                        }
                    } else {
                        LayoutInterval neighbor = group.getSubInterval(i + (e == 0 ? -1 : 1));
                        LayoutRegion nSpace = neighbor.getCurrentSpace();
                        assert (nSpace.isSet(dimension, e ^ 1));
                        subSpace.setPos(dimension, e, nSpace.positions[dimension][e ^ 1]);
                    }
                } else if (groupSpace.isSet(dimension, e)) {
                    assert (LayoutInterval.isAlignedAtBorder(sub, group, e) || group.getSubIntervalCount() == 1);
                    subSpace.setPos(dimension, e, groupSpace.positions[dimension][e]);
                }
                if (!subSpace.isSet(dimension, e)) continue;
                subSpaceCompleted = true;
            }
            if (!subSpaceCompleted) continue;
            VisualState.completeUknownGroupPositions(sub, dimension);
        }
    }

    int collectResizingDiffs(LayoutInterval group, int dimension) {
        int groupDiff = 0;
        int biggestDefSize = Integer.MIN_VALUE;
        for (int i = 0; i < group.getSubIntervalCount(); ++i) {
            LayoutInterval sub = group.getSubInterval(i);
            int diff = 0;
            if (sub.isGroup()) {
                diff = this.collectResizingDiffs(sub, dimension);
            } else if (LayoutInterval.wantResize(sub)) {
                int defaultSize;
                if (sub.isEmptySpace()) {
                    int min = sub.getMinimumSize();
                    defaultSize = min == -1 ? LayoutUtils.getSizeOfDefaultGap(sub, this.visualMapper) : min;
                } else {
                    Dimension prefSize = this.visualMapper.getComponentPreferredSize(sub.getComponent().getId());
                    defaultSize = dimension == 0 ? prefSize.width : prefSize.height;
                }
                int currentSize = LayoutInterval.getCurrentSize(sub, dimension);
                diff = currentSize - defaultSize;
                sub.setDiffToDefaultSize(diff);
                if (sub.getPreferredSize() == currentSize || sub.getPreferredSize() == -1 && diff == 0) {
                    sub.unsetAttribute(512);
                } else {
                    sub.setAttribute(512);
                }
                diff = diff < 0 ? currentSize : LayoutInterval.getDiffToDefaultSize(sub, true);
            } else {
                sub.setDiffToDefaultSize(0);
                sub.unsetAttribute(512);
            }
            if (group.isSequential()) {
                groupDiff += diff;
                continue;
            }
            int defSize = LayoutInterval.getCurrentSize(sub, dimension) - diff;
            if (defSize <= biggestDefSize) continue;
            biggestDefSize = defSize;
        }
        if (group.isParallel() && biggestDefSize != Integer.MIN_VALUE) {
            groupDiff = group.getCurrentSpace().size(dimension) - biggestDefSize;
        }
        group.setDiffToDefaultSize(groupDiff);
        return groupDiff;
    }

    boolean updateToActualSize(LayoutInterval group, int dimension, int sizeUpdate) {
        HashSet<LayoutInterval> defaultCandidates = new HashSet<LayoutInterval>();
        boolean r = this.updateToActualSize(group, dimension, sizeUpdate, defaultCandidates, false);
        for (LayoutInterval li : defaultCandidates) {
            int pref = LayoutInterval.getDefaultSizeDef(li);
            int min = li.isEmptySpace() ? pref : li.getMinimumSize();
            this.layoutModel.setIntervalSize(li, min, pref, li.getMaximumSize());
        }
        return r;
    }

    private boolean updateToActualSize(LayoutInterval group, int dimension, int sizeUpdate, Set<LayoutInterval> defaultCandidates, boolean parentFlexSizeDef) {
        boolean forceAtSecond;
        if (sizeUpdate == 2 && group.isParallel() && (group.getParent() == null || !LayoutInterval.canResize(group))) {
            forceAtSecond = true;
            sizeUpdate = 1;
        } else {
            forceAtSecond = false;
        }
        boolean updated = false;
        boolean updateMissing = false;
        do {
            LayoutInterval repInt = null;
            int minDiff = Integer.MAX_VALUE;
            if (sizeUpdate == 2 && group.isParallel()) {
                Iterator<LayoutInterval> it = group.getSubIntervals();
                while (it.hasNext()) {
                    LayoutInterval sub = it.next();
                    int diff = LayoutInterval.getDiffToDefaultSize(sub, true);
                    if (diff < 0) {
                        diff = 100 - diff;
                    }
                    if (diff <= 0 || !LayoutInterval.canResize(sub) || diff >= minDiff && (diff != minDiff || repInt != null && (sub.getPreferredSize() == -1 || repInt.getPreferredSize() != -1))) continue;
                    minDiff = diff;
                    repInt = sub;
                }
            }
            boolean sizeDefined = false;
            for (int i = 0; i < group.getSubIntervalCount(); ++i) {
                LayoutInterval sub = group.getSubInterval(i);
                boolean forceUpdate = sizeUpdate == 2 && (group.isSequential() || sub == repInt);
                boolean updatedSub = false;
                int diff = LayoutInterval.getDiffToDefaultSize(sub, true);
                if (diff < 0 && sub.isEmptySpace() && sub.getPreferredSize() == -1 && group.isSequential() && (i == 0 || i == group.getSubIntervalCount() - 1)) {
                    diff = 0;
                }
                if (diff == 0 && forceAtSecond && sizeUpdate == 1 && !sizeDefined && LayoutInterval.getCurrentSize(sub, dimension) == LayoutInterval.getCurrentSize(group, dimension)) {
                    sizeDefined = true;
                }
                if (sub.isGroup()) {
                    int subUpdate = diff == 0 ? 0 : (forceUpdate || !LayoutInterval.canResize(sub) ? 2 : (sizeUpdate == 0 ? 0 : 1));
                    updatedSub = this.updateToActualSize(sub, dimension, subUpdate, defaultCandidates, parentFlexSizeDef);
                } else {
                    boolean single;
                    if (sub.isComponent() && sub.getComponent().isLayoutContainer()) {
                        LayoutComponent subContainer = sub.getComponent();
                        LayoutInterval root = subContainer.getDefaultLayoutRoot(dimension);
                        int subUpdate = diff == 0 || subContainer.getDiffToMinimumSize(dimension) < 0 ? 0 : (forceUpdate || !LayoutInterval.canResize(sub) ? 2 : (sizeUpdate == 0 ? 0 : 1));
                        updatedSub = this.updateToActualSize(root, dimension, subUpdate, defaultCandidates, parentFlexSizeDef || sub.hasAttribute(1024));
                        boolean bl = single = subContainer.getDiffToMinimumSize(dimension) < 0;
                        if (!single && LayoutInterval.wantResize(sub)) {
                            if (updatedSub || diff == 0) {
                                sub.unsetAttribute(512);
                            } else {
                                sub.setAttribute(512);
                            }
                        }
                    } else {
                        single = true;
                    }
                    if (single && LayoutInterval.wantResize(sub)) {
                        boolean pretendDefault;
                        int min = sub.getMinimumSize();
                        int pref = sub.getPreferredSize();
                        int max = sub.getMaximumSize();
                        int defaultPref = LayoutInterval.getDefaultSizeDef(sub);
                        boolean bl = pretendDefault = pref != defaultPref && diff != 0 && pref <= 0 || parentFlexSizeDef || sub.hasAttribute(1024);
                        if (pretendDefault) {
                            pref = defaultPref;
                        }
                        int currentSize = LayoutInterval.getCurrentSize(sub, dimension);
                        int lastSize = sub.getLastActualSize();
                        if (lastSize < 0) {
                            sub.setLastActualSize(currentSize);
                        }
                        if (sizeUpdate == 0 || diff == 0) {
                            this.layoutModel.setIntervalSize(sub, min, defaultPref, max);
                            pretendDefault = false;
                        } else if (forceUpdate || pref != defaultPref && pref != currentSize && (lastSize >= Short.MAX_VALUE || lastSize >= 0 && lastSize != currentSize)) {
                            this.layoutModel.setIntervalSize(sub, min, currentSize, max);
                            pretendDefault = false;
                            sub.setLastActualSize(Integer.MAX_VALUE);
                        }
                        if (pretendDefault) {
                            defaultCandidates.add(sub);
                        } else {
                            defaultCandidates.remove(sub);
                            pref = sub.getPreferredSize();
                            if (sizeUpdate > 0 && pref == currentSize) {
                                updatedSub = true;
                            }
                        }
                        if (diff == 0 || pref == currentSize) {
                            sub.unsetAttribute(512);
                        } else {
                            sub.setAttribute(512);
                        }
                    }
                }
                if (!LayoutInterval.canResize(sub)) continue;
                if (updatedSub) {
                    updated = true;
                    continue;
                }
                if (!group.isSequential() || diff == 0) continue;
                updateMissing = true;
            }
            if (!forceAtSecond) continue;
            if (sizeUpdate == 1 && !updated && !sizeDefined) {
                sizeUpdate = 2;
                continue;
            }
            forceAtSecond = false;
        } while (forceAtSecond);
        return updated && !updateMissing;
    }

    void updateContainerSize(LayoutComponent container) {
        Dimension preferred = this.visualMapper.getComponentPreferredSize(container.getId());
        for (int i = 0; i < 2; ++i) {
            LayoutInterval outer = container.getLayoutInterval(i);
            int currentSize = outer.getCurrentSpace().size(i);
            int pref = i == 0 ? preferred.width : preferred.height;
            boolean externalSize = this.visualMapper.hasExplicitPreferredSize(container.getId()) && currentSize != pref || container.getDiffToMinimumSize(i) < 0 && currentSize != pref;
            this.resizeInterval(outer, externalSize ? currentSize : -1);
        }
    }

    void resizeInterval(LayoutInterval interval, int size) {
        assert (interval.isSingle() && (size >= 0 || size == -1));
        int min = interval.getMinimumSize();
        int max = interval.getMaximumSize();
        if (min == interval.getPreferredSize() && (max < Short.MAX_VALUE || min > 0)) {
            min = size;
        }
        if (max == interval.getPreferredSize()) {
            max = max > 0 ? size : -2;
        }
        this.layoutModel.setIntervalSize(interval, min, size, max);
    }

    void updateSpaceAfterRemove(LayoutInterval root, int dimension) {
        this.updateCurrentSpaceOfGroups(root, dimension, null);
        if (this.collectResizingDiffs(root, dimension) != 0) {
            this.updateToActualSize(root, dimension, 2);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Collection<GapInfo> getComponentGaps(LayoutComponent component) {
        void var2_7;
        List<GapInfo> list;
        void var2_8;
        List<GapInfo> list2 = this.componentGaps.get(component);
        if (list2 != null) return var2_8;
        if (this.compGapsToUpdate == null || (list = this.compGapsToUpdate.remove(component)) == null) {
            if (component.getParent() != null && this.isComponentInDesignView(component.getParent())) {
                List<GapInfo> list3 = this.computeComponentGapInfo(component);
            } else {
                if (!component.isLayoutContainer()) return null;
                List list4 = Collections.emptyList();
            }
        } else {
            this.updateComponentGapInfo(component, list);
        }
        this.componentGaps.put(component, (List<GapInfo>)var2_7);
        return var2_8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Collection<GapInfo> getContainerGaps(LayoutComponent container) {
        List<GapInfo> gaps = this.containerGaps.get(container);
        if (gaps != null) return gaps;
        if (this.contGapsToUpdate == null || (gaps = this.contGapsToUpdate.remove(container)) == null) {
            if (!this.isComponentInDesignView(container)) return null;
            gaps = this.computeContainerGapInfo(container);
        } else {
            this.updateContainerGapInfo(container, gaps);
        }
        this.containerGaps.put(container, gaps);
        return gaps;
    }

    private List<GapInfo> computeComponentGapInfo(LayoutComponent component) {
        ArrayList<GapInfo> gapList = new ArrayList<GapInfo>(4);
        for (int dim = 1; dim >= 0; --dim) {
            GapInfo gapInfo;
            LayoutInterval li = component.getLayoutInterval(dim);
            LayoutInterval gap = LayoutInterval.getNeighbor(li, 0, false, true, false);
            if (gap != null && gap.isEmptySpace() && (gapInfo = this.createOrUpdateGapInfo(null, gap, dim, component, component.getParent())) != null) {
                gapList.add(gapInfo);
            }
            if ((gap = LayoutInterval.getNeighbor(li, 1, false, true, false)) == null || !gap.isEmptySpace() || (gapInfo = this.createOrUpdateGapInfo(null, gap, dim, component, component.getParent())) == null) continue;
            gapList.add(gapInfo);
        }
        return gapList;
    }

    private List<GapInfo> computeContainerGapInfo(LayoutComponent container) {
        LinkedList<GapInfo> gapList = new LinkedList<GapInfo>();
        LinkedList<LayoutInterval> l = new LinkedList<LayoutInterval>();
        for (int dim = 1; dim >= 0; --dim) {
            l.add(container.getLayoutRoot(0, dim));
            while (!l.isEmpty()) {
                GapInfo gapInfo;
                LayoutInterval interval = (LayoutInterval)l.remove(0);
                if (interval.isGroup()) {
                    Iterator<LayoutInterval> it = interval.getSubIntervals();
                    while (it.hasNext()) {
                        l.add(it.next());
                    }
                    continue;
                }
                if (!interval.isEmptySpace() || (gapInfo = this.createOrUpdateGapInfo(null, interval, dim, null, container)) == null) continue;
                gapList.add(gapInfo);
            }
        }
        return gapList;
    }

    private void updateComponentGapInfo(LayoutComponent component, List<GapInfo> gapList) {
        for (GapInfo gapInfo : gapList) {
            this.createOrUpdateGapInfo(gapInfo, null, gapInfo.dimension, component, component.getParent());
        }
    }

    private void updateContainerGapInfo(LayoutComponent container, List<GapInfo> gapList) {
        if (container.isLayoutContainer()) {
            LayoutInterval[] roots = new LayoutInterval[]{container.getDefaultLayoutRoot(0), container.getDefaultLayoutRoot(1)};
            for (GapInfo gapInfo : gapList) {
                if (!roots[gapInfo.dimension].isParentOf(gapInfo.gap)) continue;
                this.createOrUpdateGapInfo(gapInfo, null, gapInfo.dimension, null, container);
            }
        }
    }

    private GapInfo createOrUpdateGapInfo(GapInfo gapInfo, LayoutInterval gap, int dimension, LayoutComponent component, LayoutComponent container) {
        LayoutInterval parent;
        if (gap == null) {
            gap = gapInfo.gap;
        }
        if ((parent = gap.getParent()).isParallel()) {
            return null;
        }
        boolean resizing = LayoutInterval.canResize(gap);
        LayoutInterval[] neighbors = new LayoutInterval[2];
        int[] gapPos = new int[2];
        int index = parent.indexOf(gap);
        if (index > 0) {
            neighbors[0] = parent.getSubInterval(index - 1);
            if (neighbors[0].isEmptySpace()) {
                return null;
            }
            gapPos[0] = neighbors[0].getCurrentSpace().positions[dimension][1];
        } else {
            gapPos[0] = (resizing ? parent.getParent() : parent).getCurrentSpace().positions[dimension][0];
        }
        if (index + 1 < parent.getSubIntervalCount()) {
            neighbors[1] = parent.getSubInterval(index + 1);
            if (neighbors[1].isEmptySpace()) {
                return null;
            }
            gapPos[1] = neighbors[1].getCurrentSpace().positions[dimension][0];
        } else {
            gapPos[1] = (resizing ? parent.getParent() : parent).getCurrentSpace().positions[dimension][1];
        }
        if (neighbors[0] == null && neighbors[1] == null) {
            return null;
        }
        if (gapInfo == null) {
            gapInfo = new GapInfo();
            gapInfo.gap = gap;
        }
        gapInfo.dimension = dimension;
        gapInfo.position = gapPos[0];
        int wholeSize = gapPos[1] - gapPos[0];
        int minSize = gap.getMinimumSize();
        int prefSize = gap.getPreferredSize();
        if (minSize == -2) {
            minSize = gap.getPreferredSize();
        }
        if (minSize == -1 || prefSize == -1) {
            int defaultSize;
            int n = defaultSize = resizing || neighbors[0] == null || neighbors[1] == null ? LayoutUtils.getSizeOfDefaultGap(gap, this.visualMapper) : wholeSize;
            if (minSize == -1) {
                minSize = defaultSize;
            }
            if (prefSize == -1) {
                prefSize = defaultSize;
            }
        }
        gapInfo.minSize = minSize;
        gapInfo.currentSize = resizing ? wholeSize : prefSize;
        gapInfo.resizeLeading = false;
        gapInfo.resizeTrailing = false;
        LayoutInterval parParent = parent.getParent();
        LayoutInterval li = gap;
        do {
            LayoutInterval inPar;
            int align;
            if ((align = LayoutInterval.getEffectiveAlignmentInParent(li, null, 0)) != 0 && li == gap && LayoutDesigner.shouldAbsorbExplicitSizeChange(gap)) {
                gapInfo.resizeLeading = true;
                if (align == 1) break;
                gapInfo.resizeTrailing = true;
                break;
            }
            LayoutInterval layoutInterval = inPar = li.getParent().isSequential() ? li.getParent() : li;
            if (align == 1) {
                if (LayoutInterval.isAlignedAtBorder(inPar, parParent, 0) || LayoutInterval.isPlacedAtBorder(inPar, parParent, dimension, 0)) continue;
                gapInfo.resizeLeading = true;
                break;
            }
            if (LayoutInterval.isAlignedAtBorder(inPar, parParent, 1) || LayoutInterval.isPlacedAtBorder(inPar, parParent, dimension, 1)) break;
        } while ((parParent = LayoutInterval.getFirstParent(li = parParent, 103)) != null);
        if (!gapInfo.resizeLeading) {
            gapInfo.resizeTrailing = true;
        }
        int[] ortPos = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        for (int e = 0; e <= 1; ++e) {
            if (neighbors[e] == null) continue;
            List<LayoutInterval> relatedComps = LayoutUtils.getSideComponents(neighbors[e], e ^ 1, true, false);
            if (relatedComps.isEmpty()) {
                relatedComps = LayoutUtils.getSideComponents(neighbors[e], e ^ 1, false, false);
            }
            for (LayoutInterval comp : relatedComps) {
                int[][] pos = comp.getCurrentSpace().positions;
                if (component != null && comp.getComponent() != component && Math.abs(pos[dimension][e ^ 1] - gapPos[e]) >= 32) continue;
                int p = pos[dimension ^ 1][0];
                if (p < ortPos[0]) {
                    ortPos[0] = p;
                }
                if ((p = pos[dimension ^ 1][1]) <= ortPos[1]) continue;
                ortPos[1] = p;
            }
        }
        gapInfo.ortPositions = ortPos;
        gapInfo.paintRect = null;
        gapInfo.overlappingComponents = container != null ? VisualState.computeOverlappingComponents(gapInfo, container) : null;
        StringBuilder fmtKey = new StringBuilder();
        fmtKey.append(dimension == 0 ? "FMT_GAP_DESCRIPTION_H" : "FMT_GAP_DESCRIPTION_V");
        fmtKey.append(resizing ? "R" : "F");
        ArrayList<String> sizeParam = new ArrayList<String>(2);
        prefSize = gap.getPreferredSize();
        if (prefSize == -1) {
            LayoutConstants.PaddingType pt = gap.getPaddingType();
            if (!(pt != null || neighbors[0] == null && LayoutInterval.getNeighbor(gap, 0, true, true, false) == null || neighbors[1] == null && LayoutInterval.getNeighbor(gap, 1, true, true, false) == null)) {
                pt = LayoutConstants.PaddingType.RELATED;
            }
            sizeParam.add(VisualState.getDefaultGapDisplayName(pt));
            if (resizing && gap.getDiffToDefaultSize() != 0) {
                fmtKey.append("2");
                sizeParam.add(Integer.toString(wholeSize));
            }
        } else {
            sizeParam.add(Integer.toString(prefSize));
            if (resizing && prefSize != wholeSize) {
                fmtKey.append("2");
                sizeParam.add(Integer.toString(wholeSize));
            }
        }
        gapInfo.description = NbBundle.getMessage(VisualState.class, (String)fmtKey.toString(), (Object[])sizeParam.toArray());
        return gapInfo;
    }

    private static List<String> computeOverlappingComponents(GapInfo gapInfo, LayoutComponent container) {
        LinkedList<String> overlapping = null;
        LayoutRegion gapFakeRegion = new LayoutRegion();
        gapFakeRegion.set(gapInfo.dimension, gapInfo.position, gapInfo.position + gapInfo.currentSize);
        gapFakeRegion.set(gapInfo.dimension ^ 1, gapInfo.ortPositions[0], gapInfo.ortPositions[1]);
        for (LayoutComponent comp : container.getSubcomponents()) {
            if (!LayoutRegion.overlap(comp.getCurrentSpace(), gapFakeRegion)) continue;
            if (overlapping == null) {
                overlapping = new LinkedList<String>();
            }
            overlapping.add(comp.getId());
        }
        return overlapping;
    }

    Shape getComponentVisibilityClip(LayoutComponent component) {
        Shape clip = this.clippingCache.get(component);
        if (!this.clippingCache.containsKey(component)) {
            clip = this.visualMapper.getComponentVisibilityClip(component.getId());
            this.clippingCache.put(component, clip);
        }
        return clip;
    }

    Shape getClipForGapPainting(Collection<GapInfo> gaps, Shape baseClipRect) {
        if (gaps == null || gaps.isEmpty()) {
            throw new IllegalArgumentException();
        }
        Area clip = null;
        for (GapInfo gap : gaps) {
            if (gap.overlappingComponents == null) continue;
            for (String componentId : gap.overlappingComponents) {
                if (clip == null) {
                    clip = new Area(baseClipRect);
                }
                Rectangle componentBounds = this.visualMapper.getComponentBounds(componentId);
                Area componentArea = new Area(componentBounds);
                clip.subtract(componentArea);
            }
        }
        if (clip != null) {
            return clip;
        }
        return baseClipRect;
    }

    static String getDefaultGapDisplayName(LayoutConstants.PaddingType pt) {
        if (PADDING_DISPLAY_NAMES == null) {
            ResourceBundle bundle = NbBundle.getBundle(VisualState.class);
            PADDING_DISPLAY_NAMES = new String[]{bundle.getString("DEFAULT_GAP_SMALL"), bundle.getString("DEFAULT_GAP_MEDIUM"), bundle.getString("INDENT_GAP"), bundle.getString("DEFAULT_GAP_LARGE"), bundle.getString("DEFAULT_GAP_UNSPECIFIED")};
        }
        return PADDING_DISPLAY_NAMES[pt != null ? pt.ordinal() : 4];
    }

    static List<LayoutComponent> getComponentsInRegion(LayoutComponent container, LayoutInterval[] roots, LayoutRegion space) {
        LinkedList<LayoutComponent> list = null;
        for (LayoutComponent comp : container.getSubcomponents()) {
            if (!LayoutRegion.overlap(space, comp.getCurrentSpace()) || roots != null && roots[0] != LayoutInterval.getRoot(comp.getLayoutInterval(0))) continue;
            if (list == null) {
                list = new LinkedList<LayoutComponent>();
            }
            list.add(comp);
        }
        return list != null ? list : Collections.EMPTY_LIST;
    }

    static class GapInfo {
        LayoutInterval gap;
        int dimension;
        boolean resizeLeading;
        boolean resizeTrailing;
        int position;
        int minSize;
        int currentSize;
        int[] ortPositions;
        Rectangle paintRect;
        List<String> overlappingComponents;
        int[] defaultGapSizes;
        String description;

        GapInfo() {
        }
    }
}

