/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutEvent;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutPersistenceManager;
import org.w3c.dom.NodeList;

public class LayoutModel
implements LayoutConstants {
    private Map<String, LayoutComponent> idToComponents = new HashMap<String, LayoutComponent>();
    private ArrayList<Listener> listeners;
    private RemoveHandler removeHandler;
    private ResizeHandler resizeHandler;
    private boolean recordingChanges = true;
    private boolean undoRedoInProgress;
    private int changeMark;
    private int oldestMark;
    private int changeCountHardLimit = 10000;
    private Map<Integer, LayoutEvent> undoMap = new HashMap<Integer, LayoutEvent>(500);
    private Map<Integer, LayoutEvent> redoMap = new HashMap<Integer, LayoutEvent>(100);
    private LayoutUndoableEdit lastUndoableEdit;
    private boolean corrected;
    private Map<Integer, List<String>> linkSizeGroupsH = new HashMap<Integer, List<String>>();
    private Map<Integer, List<String>> linkSizeGroupsV = new HashMap<Integer, List<String>>();
    private int maxLinkGroupId = 0;

    public LayoutComponent getLayoutComponent(String compId) {
        return this.idToComponents.get(compId);
    }

    public void addRootComponent(LayoutComponent comp) {
        this.addComponent(comp, null, -1);
    }

    public void removeComponent(String compId, boolean fromModel) {
        LayoutComponent comp = this.getLayoutComponent(compId);
        if (comp != null) {
            if (this.removeHandler != null) {
                this.removeHandler.removeComponents(new LayoutComponent[]{comp}, fromModel);
            } else {
                this.removeComponentAndIntervals(comp, true);
            }
        }
    }

    public boolean changeComponentToContainer(String componentId) {
        LayoutComponent component = this.getLayoutComponent(componentId);
        if (component != null) {
            this.setLayoutContainer(component, true);
            return true;
        }
        return false;
    }

    public boolean changeContainerToComponent(String componentId) {
        LayoutComponent component = this.getLayoutComponent(componentId);
        if (component == null) {
            return false;
        }
        for (int i = component.getSubComponentCount() - 1; i >= 0; --i) {
            LayoutComponent sub = component.getSubComponent(i);
            if (sub.isLayoutContainer()) {
                this.removeComponentAndIntervals(sub, false);
                continue;
            }
            this.removeComponent(sub, true);
        }
        this.setLayoutContainer(component, false);
        if (component.getParent() == null) {
            this.removeComponent(component, true);
        }
        return true;
    }

    void registerComponent(LayoutComponent comp, boolean recursive) {
        this.registerComponentImpl(comp);
        if (recursive && comp.isLayoutContainer()) {
            for (LayoutComponent subComp : comp.getSubcomponents()) {
                this.registerComponent(subComp, recursive);
            }
        }
    }

    void registerComponentImpl(LayoutComponent comp) {
        LayoutComponent lc = this.idToComponents.put(comp.getId(), comp);
        if (lc != comp) {
            LayoutEvent.Component ev = new LayoutEvent.Component(this, 11);
            ev.setComponent(comp);
            this.addChange(ev);
            this.fireEvent(ev);
        }
    }

    void unregisterComponent(LayoutComponent comp, boolean recursive) {
        if (recursive && comp.isLayoutContainer()) {
            for (LayoutComponent subComp : comp.getSubcomponents()) {
                this.unregisterComponent(subComp, recursive);
            }
        }
        this.removeComponentFromLinkSizedGroup(comp, 0);
        this.removeComponentFromLinkSizedGroup(comp, 1);
        this.unregisterComponentImpl(comp);
    }

    void unregisterComponentImpl(LayoutComponent comp) {
        LayoutComponent lc = this.idToComponents.remove(comp.getId());
        if (lc != null) {
            LayoutEvent.Component ev = new LayoutEvent.Component(this, 12);
            ev.setComponent(comp);
            this.addChange(ev);
            this.fireEvent(ev);
        }
    }

    void changeComponentId(LayoutComponent comp, String newId) {
        this.unregisterComponentImpl(comp);
        comp.setId(newId);
        this.registerComponentImpl(comp);
    }

    void replaceComponent(LayoutComponent comp, LayoutComponent substComp) {
        assert (substComp.getParent() == null);
        for (int i = 0; i < 2; ++i) {
            LayoutInterval interval = comp.getLayoutInterval(i);
            LayoutInterval substInt = substComp.getLayoutInterval(i);
            assert (substInt.getParent() == null);
            this.setIntervalAlignment(substInt, interval.getRawAlignment());
            this.setIntervalSize(substInt, interval.getMinimumSize(), interval.getPreferredSize(), interval.getMaximumSize());
            LayoutInterval parentInt = interval.getParent();
            if (parentInt == null) continue;
            int index = this.removeInterval(interval);
            this.addInterval(substInt, parentInt, index);
        }
        LayoutComponent parent = comp.getParent();
        if (parent != null) {
            int index = this.removeComponentImpl(comp);
            this.addComponentImpl(substComp, parent, index);
        }
        this.unregisterComponentImpl(comp);
        this.registerComponentImpl(substComp);
    }

    Iterator getAllComponents() {
        return this.idToComponents.values().iterator();
    }

    Collection<LayoutComponent> getTopContainers() {
        LinkedList<LayoutComponent> containers = new LinkedList<LayoutComponent>();
        for (LayoutComponent comp : this.idToComponents.values()) {
            if (!comp.isLayoutContainer() || comp.getParent() != null) continue;
            containers.add(comp);
        }
        return containers;
    }

    void addComponent(LayoutComponent component, LayoutComponent parent, int index) {
        this.addComponentImpl(component, parent, index);
        this.registerComponent(component, true);
    }

    void addComponentImpl(LayoutComponent component, LayoutComponent parent, int index) {
        assert (component.getParent() == null);
        if (parent != null) {
            assert (this.getLayoutComponent(parent.getId()) == parent);
            index = parent.addComponent(component, index);
        } else assert (component.isLayoutContainer());
        LayoutEvent.Component ev = new LayoutEvent.Component(this, 1);
        ev.setComponent(component, parent, index);
        this.addChange(ev);
        this.fireEvent(ev);
    }

    void removeComponent(LayoutComponent component, boolean fromModel) {
        this.removeComponentImpl(component);
        if (fromModel && this.getLayoutComponent(component.getId()) != null) {
            this.unregisterComponent(component, true);
        }
    }

    int removeComponentImpl(LayoutComponent component) {
        LayoutComponent parent = component.getParent();
        if (parent == null) {
            return -1;
        }
        int index = parent.removeComponent(component);
        LayoutEvent.Component ev = new LayoutEvent.Component(this, 2);
        ev.setComponent(component, parent, index);
        this.addChange(ev);
        this.fireEvent(ev);
        return index;
    }

    void removeComponentAndIntervals(LayoutComponent comp, boolean fromModel) {
        if (comp.getParent() != null) {
            for (int i = 0; i < 2; ++i) {
                LayoutInterval interval = comp.getLayoutInterval(i);
                if (interval.getParent() == null) continue;
                this.removeInterval(interval);
            }
        }
        this.removeComponent(comp, fromModel);
    }

    LayoutInterval[] addNewLayoutRoots(LayoutComponent container) {
        LayoutInterval[] newRoots = container.addNewLayoutRoots();
        LayoutEvent.Component ev = new LayoutEvent.Component(this, 14);
        ev.setLayoutRoots(container, newRoots, -1);
        this.addChange(ev);
        return newRoots;
    }

    LayoutInterval[] removeLayoutRoots(LayoutComponent container, LayoutInterval oneRoot) {
        LayoutInterval[] roots = container.getLayoutRoots(oneRoot);
        if (roots != null) {
            int index = container.removeLayoutRoots(roots);
            LayoutEvent.Component ev = new LayoutEvent.Component(this, 15);
            ev.setLayoutRoots(container, roots, index);
            this.addChange(ev);
        }
        return roots;
    }

    void addInterval(LayoutInterval interval, LayoutInterval parent, int index) {
        assert (interval.getParent() == null);
        index = parent.add(interval, index);
        LayoutEvent.Interval ev = new LayoutEvent.Interval(this, 3);
        ev.setInterval(interval, parent, index);
        this.addChange(ev);
        this.fireEvent(ev);
    }

    int removeInterval(LayoutInterval interval) {
        LayoutInterval parent = interval.getParent();
        int index = parent.remove(interval);
        LayoutEvent.Interval ev = new LayoutEvent.Interval(this, 4);
        ev.setInterval(interval, parent, index);
        this.addChange(ev);
        this.fireEvent(ev);
        return index;
    }

    LayoutInterval removeInterval(LayoutInterval parent, int index) {
        LayoutInterval interval = parent.remove(index);
        LayoutEvent.Interval ev = new LayoutEvent.Interval(this, 4);
        ev.setInterval(interval, parent, index);
        this.addChange(ev);
        this.fireEvent(ev);
        return interval;
    }

    void changeIntervalAttribute(LayoutInterval interval, int attribute, boolean set) {
        int oldAttributes = interval.getAttributes();
        if (set) {
            interval.setAttribute(attribute);
        } else {
            interval.unsetAttribute(attribute);
        }
        int newAttributes = interval.getAttributes();
        LayoutEvent.Interval ev = new LayoutEvent.Interval(this, 8);
        ev.setAttributes(interval, oldAttributes, newAttributes);
        this.addChange(ev);
    }

    void setIntervalAlignment(LayoutInterval interval, int alignment) {
        int oldAlignment = interval.getRawAlignment();
        interval.setAlignment(alignment);
        LayoutEvent.Interval ev = new LayoutEvent.Interval(this, 5);
        ev.setAlignment(interval, oldAlignment, alignment);
        this.addChange(ev);
    }

    void setGroupAlignment(LayoutInterval group, int alignment) {
        int oldAlignment = group.getGroupAlignment();
        if (alignment == oldAlignment) {
            return;
        }
        group.setGroupAlignment(alignment);
        LayoutEvent.Interval ev = new LayoutEvent.Interval(this, 6);
        ev.setAlignment(group, oldAlignment, alignment);
        this.addChange(ev);
    }

    void setLayoutContainer(LayoutComponent component, boolean container) {
        boolean oldContainer = component.isLayoutContainer();
        if (oldContainer != container) {
            List<LayoutInterval[]> roots = oldContainer ? component.getLayoutRoots() : null;
            component.setLayoutContainer(container, null);
            if (container) {
                roots = component.getLayoutRoots();
            }
            LayoutEvent.Component ev = new LayoutEvent.Component(this, 10);
            ev.setContainer(component, roots);
            this.addChange(ev);
        }
    }

    public void setUserIntervalSize(LayoutInterval interval, int dimension, int size) {
        int min = interval.getMinimumSize();
        int pref = interval.getPreferredSize();
        int max = interval.getMaximumSize();
        if (min == pref && max == -2 && pref != size) {
            min = -2;
        }
        if (this.resizeHandler != null) {
            this.resizeHandler.setIntervalSize(interval, dimension, min, size, max);
        } else {
            this.setIntervalSize(interval, min, size, max);
        }
        this.changeIntervalAttribute(interval, 1024, false);
    }

    public void setUserIntervalSize(LayoutInterval interval, int dimension, int size, boolean resizing) {
        int max;
        int min;
        boolean sizeChange;
        if (size == -1 && interval.isComponent()) {
            size = LayoutInterval.getDefaultSizeDef(interval);
        }
        boolean bl = sizeChange = size != interval.getPreferredSize();
        if (resizing) {
            min = !interval.isEmptySpace() ? -1 : (size == 0 || size != -1 && interval.getMinimumSize() == 0 ? 0 : -1);
            max = Short.MAX_VALUE;
        } else {
            min = size == 0 || size == -1 ? size : -2;
            max = -2;
        }
        if (this.resizeHandler != null) {
            this.resizeHandler.setIntervalSize(interval, dimension, min, size, max);
        } else {
            this.setIntervalSize(interval, min, size, max);
        }
        if (sizeChange) {
            this.changeIntervalAttribute(interval, 1024, false);
        }
    }

    public boolean setIntervalSize(LayoutInterval interval, int min, int pref, int max) {
        int oldMin = interval.getMinimumSize();
        int oldPref = interval.getPreferredSize();
        int oldMax = interval.getMaximumSize();
        if (min == oldMin && pref == oldPref && max == oldMax) {
            return false;
        }
        interval.setSizes(min, pref, max);
        if (interval.isComponent()) {
            boolean horizontal;
            LayoutComponent comp = interval.getComponent();
            boolean bl = horizontal = interval == comp.getLayoutInterval(0);
            if (oldMin != min) {
                comp.firePropertyChange(horizontal ? "horizontalMinSize" : "verticalMinSize", new Integer(oldMin), new Integer(min));
            }
            if (oldPref != pref) {
                comp.firePropertyChange(horizontal ? "horizontalPrefSize" : "verticalPrefSize", new Integer(oldPref), new Integer(pref));
            }
            if (oldMax != max) {
                comp.firePropertyChange(horizontal ? "horizontalMaxSize" : "verticalMaxSize", new Integer(oldMax), new Integer(max));
            }
        }
        LayoutEvent.Interval ev = new LayoutEvent.Interval(this, 7);
        ev.setSize(interval, oldMin, oldPref, oldMax, min, pref, max);
        this.addChange(ev);
        this.fireEvent(ev);
        return true;
    }

    public void setPaddingType(LayoutInterval interval, LayoutConstants.PaddingType paddingType) {
        LayoutConstants.PaddingType oldPadding = interval.getPaddingType();
        if (oldPadding != paddingType) {
            interval.setPaddingType(paddingType);
            LayoutEvent.Interval ev = new LayoutEvent.Interval(this, 13);
            ev.setPaddingType(interval, oldPadding, paddingType);
            this.addChange(ev);
        }
    }

    public void copyContainerLayout(LayoutModel sourceModel, String sourceContainerId, Map<String, String> sourceToTargetId, String targetContainerId) {
        LayoutComponent sourceContainer = sourceModel.getLayoutComponent(sourceContainerId);
        LayoutComponent targetContainer = this.getLayoutComponent(targetContainerId);
        if (targetContainer == null) {
            targetContainer = new LayoutComponent(targetContainerId, true);
            this.addRootComponent(targetContainer);
        } else if (!targetContainer.isLayoutContainer()) {
            this.changeComponentToContainer(targetContainerId);
        }
        this.copyContainerLayout(sourceContainer, sourceToTargetId, targetContainer);
    }

    void copyContainerLayout(LayoutComponent sourceContainer, Map<String, String> sourceToTargetId, LayoutComponent targetContainer) {
        for (LayoutComponent sourceComp : sourceContainer.getSubcomponents()) {
            String targetId = sourceToTargetId.get(sourceComp.getId());
            LayoutComponent targetComp = this.getLayoutComponent(targetId);
            if (targetComp == null) {
                targetComp = new LayoutComponent(targetId, sourceComp.isLayoutContainer());
            }
            if (targetComp.getParent() != null) continue;
            this.addComponent(targetComp, targetContainer, -1);
        }
        int i = 0;
        for (LayoutInterval[] sourceRoots : sourceContainer.getLayoutRoots()) {
            int dim;
            LayoutInterval[] targetRoots;
            if (i == targetContainer.getLayoutRootCount()) {
                targetRoots = this.addNewLayoutRoots(targetContainer);
            } else {
                targetRoots = targetContainer.getLayoutRoots().get(i);
                for (dim = 0; dim < 2; ++dim) {
                    for (int n = targetRoots[dim].getSubIntervalCount(); n > 0; --n) {
                        this.removeInterval(targetRoots[dim], n - 1);
                    }
                }
            }
            for (dim = 0; dim < 2; ++dim) {
                this.copySubIntervals(sourceRoots[dim], targetRoots[dim], sourceToTargetId);
            }
            ++i;
        }
    }

    private void copySubIntervals(LayoutInterval sourceInterval, LayoutInterval targetInterval, Map sourceToTargetIds) {
        Iterator<LayoutInterval> iter = sourceInterval.getSubIntervals();
        while (iter.hasNext()) {
            LayoutInterval sourceSub = iter.next();
            LayoutInterval clone = null;
            if (sourceSub.isComponent()) {
                String compId = (String)sourceToTargetIds.get(sourceSub.getComponent().getId());
                LayoutComponent comp = this.getLayoutComponent(compId);
                int dimension = sourceSub == sourceSub.getComponent().getLayoutInterval(0) ? 0 : 1;
                clone = comp.getLayoutInterval(dimension);
            }
            LayoutInterval targetSub = LayoutInterval.cloneInterval(sourceSub, clone);
            if (sourceSub.isGroup()) {
                this.copySubIntervals(sourceSub, targetSub, sourceToTargetIds);
            }
            this.addInterval(targetSub, targetInterval, -1);
        }
    }

    void moveContainerLayout(LayoutComponent sourceContainer, LayoutComponent targetContainer) {
        if (!sourceContainer.isLayoutContainer() || !targetContainer.isLayoutContainer() || targetContainer.getSubComponentCount() > 0) {
            throw new IllegalArgumentException();
        }
        while (sourceContainer.getSubComponentCount() > 0) {
            LayoutComponent sub = sourceContainer.getSubComponent(0);
            this.removeComponent(sub, false);
            this.addComponent(sub, targetContainer, -1);
        }
        List<LayoutInterval[]> transferRoots = sourceContainer.getLayoutRoots();
        List<LayoutInterval[]> originalTargetRoots = targetContainer.getLayoutRoots();
        sourceContainer.setLayoutRoots(null);
        LayoutEvent.Component ev = new LayoutEvent.Component(this, 16);
        ev.setLayoutRoots(sourceContainer, transferRoots, sourceContainer.getLayoutRoots());
        this.addChange(ev);
        targetContainer.setLayoutRoots(transferRoots);
        ev = new LayoutEvent.Component(this, 16);
        ev.setLayoutRoots(targetContainer, originalTargetRoots, transferRoots);
        this.addChange(ev);
    }

    LayoutInterval[] createIntervalsFromBounds(Map<LayoutComponent, Rectangle> compToBounds) {
        RegionInfo region = new RegionInfo(compToBounds);
        region.calculateIntervals();
        LayoutInterval[] result = new LayoutInterval[2];
        for (int dim = 0; dim < 2; ++dim) {
            result[dim] = region.getInterval(dim);
        }
        return result;
    }

    void setRemoveHandler(RemoveHandler h) {
        this.removeHandler = h;
    }

    RemoveHandler getRemoveHandler() {
        return this.removeHandler;
    }

    void setResizeHandler(ResizeHandler h) {
        this.resizeHandler = h;
    }

    ResizeHandler getResizeHandler() {
        return this.resizeHandler;
    }

    void addListener(Listener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        } else {
            this.listeners.remove(l);
        }
        this.listeners.add(l);
    }

    void removeListener(Listener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    private void fireEvent(LayoutEvent event) {
        if (this.listeners != null) {
            for (Listener l : this.listeners) {
                l.layoutChanged(event);
            }
        }
    }

    public boolean isChangeRecording() {
        return this.recordingChanges;
    }

    public void setChangeRecording(boolean record) {
        this.recordingChanges = record;
    }

    boolean isUndoRedoInProgress() {
        return this.undoRedoInProgress;
    }

    public Object getChangeMark() {
        return new Integer(this.changeMark);
    }

    public boolean endUndoableEdit() {
        boolean empty = true;
        if (this.lastUndoableEdit != null) {
            this.lastUndoableEdit.endMark = this.getChangeMark();
            if (!this.lastUndoableEdit.endMark.equals(this.lastUndoableEdit.startMark)) {
                empty = false;
            }
            this.lastUndoableEdit = null;
        }
        return !empty;
    }

    public boolean isUndoableEditInProgress() {
        return this.lastUndoableEdit != null;
    }

    public UndoableEdit getUndoableEdit() {
        if (this.recordingChanges && !this.undoRedoInProgress) {
            LayoutUndoableEdit undoEdit = new LayoutUndoableEdit();
            undoEdit.startMark = this.getChangeMark();
            this.endUndoableEdit();
            this.lastUndoableEdit = undoEdit;
            return undoEdit;
        }
        return null;
    }

    private void addChange(LayoutEvent change) {
        if (this.recordingChanges && !this.undoRedoInProgress) {
            this.redoMap.clear();
            if (this.undoMap.isEmpty()) {
                this.oldestMark = this.changeMark;
            }
            this.undoMap.put(new Integer(this.changeMark++), change);
            while (this.undoMap.size() > this.changeCountHardLimit) {
                this.undoMap.remove(new Integer(this.oldestMark++));
            }
        }
    }

    boolean undo(Object startMark, Object endMark) {
        assert (!this.undoRedoInProgress);
        boolean undone = false;
        int start = (Integer)startMark;
        int end = (Integer)endMark;
        this.undoRedoInProgress = true;
        while (end > start) {
            Integer key;
            LayoutEvent change;
            if ((change = this.undoMap.remove(key = new Integer(--end))) == null) continue;
            change.undo();
            this.redoMap.put(key, change);
            undone = true;
        }
        this.undoRedoInProgress = false;
        return undone;
    }

    boolean redo(Object startMark, Object endMark) {
        assert (!this.undoRedoInProgress);
        int start = (Integer)startMark;
        int end = (Integer)endMark;
        this.undoRedoInProgress = true;
        while (start < end) {
            Integer key;
            LayoutEvent change;
            if ((change = this.redoMap.remove(key = new Integer(start++))) == null) continue;
            change.redo();
            this.undoMap.put(key, change);
        }
        this.undoRedoInProgress = false;
        return true;
    }

    boolean revert(Object startMark, Object endMark) {
        assert (!this.undoRedoInProgress);
        boolean reverted = false;
        int start = (Integer)startMark;
        int end = (Integer)endMark;
        this.undoRedoInProgress = true;
        while (end > start) {
            Integer key;
            LayoutEvent change;
            if ((change = this.undoMap.remove(key = new Integer(--end))) == null) continue;
            change.undo();
            reverted = true;
        }
        this.undoRedoInProgress = false;
        if (this.lastUndoableEdit != null && startMark.equals(this.lastUndoableEdit.startMark)) {
            this.lastUndoableEdit.startMark = endMark;
        }
        return reverted;
    }

    void releaseChanges(Object fromMark, Object toMark) {
        int m2 = (Integer)toMark;
        for (int m1 = ((Integer)fromMark).intValue(); m1 < m2; ++m1) {
            Integer m = new Integer(m1);
            this.undoMap.remove(m);
            this.redoMap.remove(m);
        }
    }

    public String dump(Map<String, String> idToNameMap) {
        return this.dump(idToNameMap, null, true);
    }

    public String dump(final Map<String, String> idToNameMap, String contId, boolean subcontainers) {
        TreeSet<LayoutComponent> roots = new TreeSet<LayoutComponent>(new Comparator<LayoutComponent>(){

            @Override
            public int compare(LayoutComponent lc1, LayoutComponent lc2) {
                if (lc1 == lc2) {
                    return 0;
                }
                if (lc1.isParentOf(lc2)) {
                    return -1;
                }
                if (lc2.isParentOf(lc1)) {
                    return 1;
                }
                LayoutComponent parent = LayoutComponent.getCommonParent(lc1, lc2);
                while (lc1.getParent() != parent) {
                    lc1 = lc1.getParent();
                }
                while (lc2.getParent() != parent) {
                    lc2 = lc2.getParent();
                }
                if (parent != null) {
                    return parent.indexOf(lc1) < parent.indexOf(lc2) ? -1 : 1;
                }
                String id1 = lc1.getId();
                String id2 = lc2.getId();
                if (idToNameMap != null) {
                    id1 = (String)idToNameMap.get(id1);
                    id2 = (String)idToNameMap.get(id2);
                    if (id1 == null) {
                        return -1;
                    }
                    if (id2 == null) {
                        return 1;
                    }
                }
                return id1.compareTo(id2);
            }
        });
        LayoutComponent rootComp = contId != null ? this.getLayoutComponent(contId) : null;
        for (Map.Entry<String, LayoutComponent> entry : this.idToComponents.entrySet()) {
            LayoutComponent comp = entry.getValue();
            if (!comp.isLayoutContainer() || rootComp != null && comp != rootComp && (!subcontainers || !rootComp.isParentOf(comp))) continue;
            roots.add(comp);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<LayoutModel>\n");
        for (LayoutComponent root : roots) {
            String rootId = root.getId();
            if (idToNameMap != null) {
                rootId = idToNameMap.get(rootId);
            }
            if (rootId != null) {
                sb.append("  <Root id=\"").append(rootId).append("\">\n");
            } else {
                sb.append("  <Root>\n");
            }
            sb.append(this.saveContainerLayout(root, idToNameMap, 2, true));
            sb.append("  </Root>\n");
        }
        sb.append("</LayoutModel>\n");
        return sb.toString();
    }

    public String dump(LayoutInterval interval, int dimension) {
        return LayoutPersistenceManager.dumpInterval(this, interval, dimension, 2);
    }

    public String saveContainerLayout(LayoutComponent container, Map<String, String> idToNameMap, int indent, boolean humanReadable) {
        return LayoutPersistenceManager.saveContainer(this, container, idToNameMap, indent, humanReadable);
    }

    public void loadContainerLayout(String containerId, NodeList layoutNodeList, Map<String, String> nameToIdMap) throws IOException {
        LayoutPersistenceManager.loadContainer(this, containerId, layoutNodeList, nameToIdMap);
    }

    public boolean wasCorrected() {
        return this.corrected;
    }

    void setCorrected() {
        this.corrected = true;
    }

    void addComponentToLinkSizedGroup(int groupId, String compId, int dimension) {
        Integer groupIdInt;
        Map<Integer, List<String>> linkSizeGroups;
        List<String> l;
        if (-1 == groupId) {
            return;
        }
        if (this.maxLinkGroupId < groupId) {
            this.maxLinkGroupId = groupId;
        }
        if ((l = (linkSizeGroups = dimension == 0 ? this.linkSizeGroupsH : this.linkSizeGroupsV).get(groupIdInt = new Integer(groupId))) != null && (l.contains(compId) || !this.sameContainer(compId, l.get(0)))) {
            return;
        }
        this.addComponentToLinkSizedGroupImpl(groupId, compId, dimension);
    }

    void addComponentToLinkSizedGroupImpl(int groupId, String compId, int dimension) {
        Integer groupIdInt;
        LayoutComponent lc = this.getLayoutComponent(compId);
        Map<Integer, List<String>> linkSizeGroups = dimension == 0 ? this.linkSizeGroupsH : this.linkSizeGroupsV;
        List<String> l = linkSizeGroups.get(groupIdInt = new Integer(groupId));
        if (l != null) {
            l.add(lc.getId());
        } else {
            l = new ArrayList<String>();
            l.add(lc.getId());
            linkSizeGroups.put(groupIdInt, l);
        }
        int oldLinkSizeId = lc.getLinkSizeId(dimension);
        lc.setLinkSizeId(groupId, dimension);
        LayoutEvent.Component ev = new LayoutEvent.Component(this, 9);
        ev.setLinkSizeGroup(lc, oldLinkSizeId, groupId, dimension);
        this.addChange(ev);
        this.fireEvent(ev);
    }

    private boolean sameContainer(String compId1, String compId2) {
        LayoutComponent lc1 = this.getLayoutComponent(compId1);
        LayoutComponent lc2 = this.getLayoutComponent(compId2);
        return lc1.getParent().equals(lc2.getParent());
    }

    void removeComponentFromLinkSizedGroup(LayoutComponent comp, int dimension) {
        if (comp == null) {
            return;
        }
        int linkId = comp.getLinkSizeId(dimension);
        if (linkId != -1) {
            Map<Integer, List<String>> map = dimension == 0 ? this.linkSizeGroupsH : this.linkSizeGroupsV;
            Integer linkIdInt = new Integer(linkId);
            List<String> l = map.get(linkIdInt);
            l.remove(comp.getId());
            comp.setLinkSizeId(-1, dimension);
            if (l.size() == 1) {
                LayoutComponent lc = this.getLayoutComponent(l.get(0));
                int oldLinkSizeId = lc.getLinkSizeId(dimension);
                lc.setLinkSizeId(-1, dimension);
                map.remove(linkIdInt);
                LayoutEvent.Component ev = new LayoutEvent.Component(this, 9);
                ev.setLinkSizeGroup(lc, oldLinkSizeId, -1, dimension);
                this.addChange(ev);
                this.fireEvent(ev);
            }
            if (l.isEmpty()) {
                map.remove(linkIdInt);
            }
            LayoutEvent.Component ev = new LayoutEvent.Component(this, 9);
            ev.setLinkSizeGroup(comp, linkId, -1, dimension);
            this.addChange(ev);
            this.fireEvent(ev);
        }
    }

    public int areComponentsLinkSized(List<String> components, int dimension) {
        if (components.size() == 1) {
            String id = components.get(0);
            boolean retVal = this.getLayoutComponent(id).isLinkSized(dimension);
            return retVal ? 1 : 0;
        }
        Iterator<String> i = components.iterator();
        ArrayList<Integer> idsFound = new ArrayList<Integer>();
        while (i.hasNext()) {
            String cid = i.next();
            LayoutComponent lc = this.getLayoutComponent(cid);
            Integer linkSizeId = new Integer(lc.getLinkSizeId(dimension));
            if (!idsFound.contains(linkSizeId)) {
                idsFound.add(linkSizeId);
            }
            if (idsFound.size() <= 2) continue;
            return -1;
        }
        if (idsFound.size() == 1) {
            if (idsFound.contains(new Integer(-1))) {
                return 0;
            }
            return 1;
        }
        if (idsFound.contains(new Integer(-1))) {
            return 0;
        }
        return -1;
    }

    Map<Integer, List<String>> getLinkSizeGroups(int dimension) {
        if (0 == dimension) {
            return this.linkSizeGroupsH;
        }
        if (1 == dimension) {
            return this.linkSizeGroupsV;
        }
        return null;
    }

    public void unsetSameSize(List components, int dimension) {
        for (String cid : components) {
            LayoutComponent lc = this.getLayoutComponent(cid);
            this.removeComponentFromLinkSizedGroup(lc, dimension);
        }
    }

    public void setSameSize(List components, int dimension) {
        Iterator i = components.iterator();
        int groupId = this.findGroupId(components, dimension);
        while (i.hasNext()) {
            String cid = (String)i.next();
            LayoutComponent lc = this.getLayoutComponent(cid);
            this.addComponentToLinkSizedGroup(groupId, lc.getId(), dimension);
        }
    }

    private int findGroupId(List components, int dimension) {
        for (String cid : components) {
            LayoutComponent lc = this.getLayoutComponent(cid);
            if (!lc.isLinkSized(dimension)) continue;
            return lc.getLinkSizeId(dimension);
        }
        return ++this.maxLinkGroupId;
    }

    private class LayoutUndoableEdit
    extends AbstractUndoableEdit {
        private Object startMark;
        private Object endMark;

        private LayoutUndoableEdit() {
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.endMark == null) {
                assert (LayoutModel.this.lastUndoableEdit == this);
                this.endMark = LayoutModel.this.getChangeMark();
                LayoutModel.this.lastUndoableEdit = null;
            }
            LayoutModel.this.undo(this.startMark, this.endMark);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            LayoutModel.this.redo(this.startMark, this.endMark);
        }

        @Override
        public String getUndoPresentationName() {
            return "";
        }

        @Override
        public String getRedoPresentationName() {
            return "";
        }

        @Override
        public void die() {
            LayoutModel.this.releaseChanges(this.startMark, this.endMark != null ? this.endMark : LayoutModel.this.getChangeMark());
        }
    }

    static interface Listener {
        public void layoutChanged(LayoutEvent var1);
    }

    static interface ResizeHandler {
        public void setIntervalSize(LayoutInterval var1, int var2, int var3, int var4, int var5);
    }

    static interface RemoveHandler {
        public void removeComponents(LayoutComponent[] var1, boolean var2);
    }

    private class RegionInfo {
        private LayoutInterval horizontal = null;
        private LayoutInterval vertical = null;
        private Map<LayoutComponent, Rectangle> compToBounds;
        private int minx;
        private int maxx;
        private int miny;
        private int maxy;
        private int dimension;

        public RegionInfo(Map<LayoutComponent, Rectangle> compToBounds) {
            this.compToBounds = compToBounds;
            this.dimension = -1;
            this.miny = 0;
            this.minx = 0;
            this.updateRegionBounds();
        }

        private RegionInfo(Map<LayoutComponent, Rectangle> compToBounds, int dimension) {
            this.compToBounds = compToBounds;
            this.dimension = dimension;
            this.miny = Short.MAX_VALUE;
            this.minx = Short.MAX_VALUE;
            this.updateRegionBounds();
        }

        private void updateRegionBounds() {
            this.maxx = Short.MIN_VALUE;
            this.maxy = Short.MIN_VALUE;
            for (Rectangle bounds : this.compToBounds.values()) {
                this.minx = Math.min(this.minx, bounds.x);
                this.miny = Math.min(this.miny, bounds.y);
                this.maxx = Math.max(this.maxx, bounds.x + bounds.width);
                this.maxy = Math.max(this.maxy, bounds.y + bounds.height);
            }
        }

        public void calculateIntervals() {
            if (this.compToBounds.size() == 1) {
                Map.Entry<LayoutComponent, Rectangle> e = this.compToBounds.entrySet().iterator().next();
                LayoutComponent comp = e.getKey();
                Rectangle bounds = e.getValue();
                this.horizontal = comp.getLayoutInterval(0);
                this.horizontal = this.prefixByGap(this.horizontal, bounds.x - this.minx);
                this.vertical = comp.getLayoutInterval(1);
                this.vertical = this.prefixByGap(this.vertical, bounds.y - this.miny);
                return;
            }
            int effDim = -1;
            List<Map<LayoutComponent, Rectangle>> parts = null;
            HashMap<LayoutComponent, Rectangle> removedCompToBounds = null;
            do {
                boolean remove;
                boolean bl = remove = this.dimension == -1 && effDim == 0 || this.dimension != -1 && effDim != -1;
                if (remove) {
                    effDim = -1;
                }
                if (this.dimension == -1) {
                    switch (effDim) {
                        case -1: {
                            effDim = 1;
                            break;
                        }
                        case 1: {
                            effDim = 0;
                            break;
                        }
                        case 0: {
                            remove = true;
                        }
                    }
                } else {
                    effDim = this.dimension;
                }
                if (remove) {
                    Map.Entry<LayoutComponent, Rectangle> e = this.compToBounds.entrySet().iterator().next();
                    LayoutComponent comp = e.getKey();
                    Rectangle bounds = e.getValue();
                    if (removedCompToBounds == null) {
                        removedCompToBounds = new HashMap<LayoutComponent, Rectangle>();
                    }
                    removedCompToBounds.put(comp, bounds);
                    this.compToBounds.remove(comp);
                }
                SortedSet<Integer> cutSet = this.createPossibleCuts(effDim);
                parts = this.cutIntoParts(cutSet, effDim);
            } while (!this.compToBounds.isEmpty() && parts.isEmpty());
            this.dimension = effDim;
            LinkedList<RegionInfo> regions = new LinkedList<RegionInfo>();
            for (Map<LayoutComponent, Rectangle> part : parts) {
                RegionInfo region = new RegionInfo(part, this.dimension == 0 ? 1 : 0);
                region.calculateIntervals();
                regions.add(region);
            }
            this.mergeSubRegions(regions, this.dimension);
            if (removedCompToBounds != null) {
                for (int dim = 0; dim <= 1; ++dim) {
                    LayoutInterval parent;
                    LayoutInterval layoutInterval = parent = dim == 0 ? this.horizontal : this.vertical;
                    if (!parent.isParallel()) {
                        LayoutInterval parGroup = new LayoutInterval(103);
                        this.add(parent, parGroup);
                        if (dim == 0) {
                            this.horizontal = parGroup;
                        } else {
                            this.vertical = parGroup;
                        }
                        parent = parGroup;
                    }
                    for (Map.Entry entry : removedCompToBounds.entrySet()) {
                        LayoutComponent comp = (LayoutComponent)entry.getKey();
                        Rectangle bounds = (Rectangle)entry.getValue();
                        LayoutInterval interval = comp.getLayoutInterval(dim);
                        int gap = dim == 0 ? bounds.x - this.minx : bounds.y - this.miny;
                        interval = this.prefixByGap(interval, gap);
                        this.add(interval, parent);
                    }
                }
            }
        }

        private SortedSet<Integer> createPossibleCuts(int dimension) {
            TreeSet<Integer> cutSet = new TreeSet<Integer>();
            for (Rectangle bounds : this.compToBounds.values()) {
                int leading = dimension == 0 ? bounds.x : bounds.y;
                cutSet.add(new Integer(leading));
            }
            cutSet.add(new Integer(dimension == 0 ? this.maxx : this.maxy));
            return cutSet;
        }

        private List<Map<LayoutComponent, Rectangle>> cutIntoParts(Set<Integer> cutSet, int dimension) {
            LinkedList<Map<LayoutComponent, Rectangle>> parts = new LinkedList<Map<LayoutComponent, Rectangle>>();
            for (Integer cutInt : cutSet) {
                int cut = cutInt;
                boolean isCut = true;
                HashMap<LayoutComponent, Rectangle> preCompToBounds = new HashMap<LayoutComponent, Rectangle>();
                HashMap<LayoutComponent, Rectangle> postCompToBounds = new HashMap<LayoutComponent, Rectangle>();
                Iterator<Map.Entry<LayoutComponent, Rectangle>> it = this.compToBounds.entrySet().iterator();
                while (isCut && it.hasNext()) {
                    Map.Entry<LayoutComponent, Rectangle> entry = it.next();
                    LayoutComponent comp = entry.getKey();
                    Rectangle bounds = entry.getValue();
                    int leading = dimension == 0 ? bounds.x : bounds.y;
                    int trailing = leading + (dimension == 0 ? bounds.width : bounds.height);
                    if (leading >= cut) {
                        postCompToBounds.put(comp, bounds);
                        continue;
                    }
                    if (trailing <= cut) {
                        preCompToBounds.put(comp, bounds);
                        continue;
                    }
                    isCut = false;
                }
                if (!isCut || preCompToBounds.isEmpty() || parts.isEmpty() && preCompToBounds.size() == this.compToBounds.size()) continue;
                this.compToBounds.keySet().removeAll(preCompToBounds.keySet());
                parts.add(preCompToBounds);
            }
            return parts;
        }

        private void mergeSubRegions(List regions, int dimension) {
            if (regions.isEmpty()) {
                this.horizontal = new LayoutInterval(103);
                this.vertical = new LayoutInterval(103);
                return;
            }
            LayoutInterval seqGroup = new LayoutInterval(102);
            LayoutInterval parGroup = new LayoutInterval(103);
            int lastSeqTrailing = dimension == 0 ? this.minx : this.miny;
            for (RegionInfo region : regions) {
                int seqGap;
                int parGap;
                LayoutInterval parInterval;
                LayoutInterval seqInterval;
                if (dimension == 0) {
                    seqInterval = region.horizontal;
                    parInterval = region.vertical;
                    parGap = region.miny - this.miny;
                    seqGap = region.minx - lastSeqTrailing;
                    lastSeqTrailing = region.maxx;
                } else {
                    seqInterval = region.vertical;
                    parInterval = region.horizontal;
                    parGap = region.minx - this.minx;
                    seqGap = region.miny - lastSeqTrailing;
                    lastSeqTrailing = region.maxy;
                }
                if (seqGap > 0) {
                    LayoutInterval gap = new LayoutInterval(101);
                    gap.setSize(seqGap);
                    seqGroup.add(gap, -1);
                }
                this.add(seqInterval, seqGroup);
                parInterval = this.prefixByGap(parInterval, parGap);
                this.add(parInterval, parGroup);
            }
            if (dimension == 0) {
                this.horizontal = seqGroup;
                this.vertical = parGroup;
            } else {
                this.horizontal = parGroup;
                this.vertical = seqGroup;
            }
        }

        private LayoutInterval prefixByGap(LayoutInterval interval, int size) {
            if (size > 0) {
                LayoutInterval gap = new LayoutInterval(101);
                gap.setSize(size);
                if (interval.isSequential()) {
                    interval.add(gap, 0);
                } else {
                    LayoutInterval group = new LayoutInterval(102);
                    group.add(gap, -1);
                    this.add(interval, group);
                    interval = group;
                }
            }
            return interval;
        }

        private void add(LayoutInterval interval, LayoutInterval parent) {
            if (interval.isComponent()) {
                LayoutModel.this.addInterval(interval, parent, -1);
            } else {
                parent.add(interval, -1);
            }
        }

        public LayoutInterval getInterval(int dimension) {
            return dimension == 0 ? this.horizontal : this.vertical;
        }
    }
}

