/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;

public final class LayoutInterval
implements LayoutConstants {
    static final int ATTR_DESIGN_CONTAINER_GAP = 4;
    static final int ATTR_CLOSED_GROUP = 32;
    static final int ATTR_ALIGN_PRE = 64;
    static final int ATTR_ALIGN_POST = 128;
    static final int ATTR_SIZE_DIFF = 512;
    static final int ATTR_FLEX_SIZEDEF = 1024;
    static final int ATTR_OPTIMIZED = 2048;
    static final int REFRESHING_ATTRS = 708;
    static final int ATTR_PERSISTENT_MASK = 35;
    private int type;
    private int attributes;
    private int alignment = -1;
    private LayoutInterval parentInterval;
    private int groupAlignment = 0;
    private List<LayoutInterval> subIntervals;
    private LayoutComponent layoutComponent;
    private LayoutConstants.PaddingType paddingType;
    private String[] paddingDefComps;
    private int minSize;
    private int prefSize;
    private int maxSize;
    private LayoutRegion currentSpace;
    private int lastActualSize = Integer.MAX_VALUE;
    private int diffToDefaultSize;

    LayoutInterval(int type) {
        this.type = type;
        this.minSize = -1;
        this.prefSize = -1;
        if (type == 102 || type == 103) {
            this.subIntervals = new ArrayList<LayoutInterval>();
            this.maxSize = -1;
        } else {
            assert (type == 101);
            this.maxSize = -2;
        }
    }

    void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    void setGroupAlignment(int alignment) {
        assert (alignment != -1 && this.type == 103);
        this.groupAlignment = alignment;
    }

    void setComponent(LayoutComponent comp) {
        this.layoutComponent = comp;
    }

    void setMinimumSize(int size) {
        assert (this.isSingle() || size == -2 || size == -1);
        this.minSize = size;
    }

    void setPreferredSize(int size) {
        assert (size != -2 && this.isSingle() || size == -1);
        this.prefSize = size;
    }

    void setMaximumSize(int size) {
        assert (this.isSingle() && size != -1 || this.isGroup() && (size == -2 || size == -1));
        if (size != this.maxSize && size == Short.MAX_VALUE) {
            this.lastActualSize = Integer.MAX_VALUE;
        }
        this.maxSize = size;
    }

    void setSize(int size) {
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(-2);
    }

    void setSizes(int min, int pref, int max) {
        this.setMinimumSize(min);
        this.setPreferredSize(pref);
        this.setMaximumSize(max);
    }

    public int getMinimumSize() {
        return this.minSize;
    }

    public int getPreferredSize() {
        return this.prefSize;
    }

    public int getMaximumSize() {
        return this.maxSize;
    }

    void setPaddingType(LayoutConstants.PaddingType type) {
        this.paddingType = type;
    }

    String[] getPaddingDefComponents() {
        return this.paddingDefComps;
    }

    void setPaddingDefComponents(String compId1, String compId2) {
        this.paddingDefComps = compId1 == null ? null : new String[]{compId1, compId2};
    }

    public int getType() {
        return this.type;
    }

    public int getAlignment() {
        return this.alignment == -1 && this.parentInterval != null && this.parentInterval.isParallel() ? this.parentInterval.getGroupAlignment() : this.alignment;
    }

    public int getGroupAlignment() {
        return this.groupAlignment;
    }

    public int getSubIntervalCount() {
        return this.subIntervals != null ? this.subIntervals.size() : 0;
    }

    public Iterator<LayoutInterval> getSubIntervals() {
        return this.subIntervals != null ? this.subIntervals.iterator() : Collections.EMPTY_LIST.iterator();
    }

    public LayoutComponent getComponent() {
        return this.layoutComponent;
    }

    public boolean isParallel() {
        return this.type == 103;
    }

    public boolean isSequential() {
        return this.type == 102;
    }

    public boolean isComponent() {
        return this.layoutComponent != null;
    }

    public boolean isEmptySpace() {
        return this.type == 101 && this.layoutComponent == null;
    }

    public boolean isDefaultPadding() {
        return this.isEmptySpace() && (this.getMinimumSize() == -1 || this.getPreferredSize() == -1);
    }

    public LayoutConstants.PaddingType getPaddingType() {
        return this.paddingType;
    }

    public boolean isSingle() {
        return this.type == 101;
    }

    public boolean isGroup() {
        return this.type == 102 || this.type == 103;
    }

    boolean hasAttribute(int attr) {
        return (this.attributes & attr) == attr;
    }

    void setAttribute(int attr) {
        this.attributes |= attr;
    }

    void unsetAttribute(int attr) {
        this.attributes &= ~attr;
    }

    void setAttributes(int attrs) {
        this.attributes = attrs;
    }

    int getAttributes() {
        return this.attributes;
    }

    int getRawAlignment() {
        return this.alignment;
    }

    public LayoutInterval getParent() {
        return this.parentInterval;
    }

    int add(LayoutInterval interval, int index) {
        if (interval == null) {
            throw new NullPointerException();
        }
        if (this.getParent() == interval) {
            throw new IllegalArgumentException("Cannot add parent as a sub-interval!");
        }
        if (index < 0) {
            index = this.subIntervals.size();
        }
        this.subIntervals.add(index, interval);
        interval.parentInterval = this;
        return index;
    }

    int remove(LayoutInterval interval) {
        int index = this.subIntervals.indexOf(interval);
        if (index >= 0) {
            this.subIntervals.remove(index);
            interval.parentInterval = null;
        }
        return index;
    }

    LayoutInterval remove(int index) {
        LayoutInterval interval = this.subIntervals.get(index);
        this.subIntervals.remove(index);
        interval.parentInterval = null;
        return interval;
    }

    public LayoutInterval getSubInterval(int index) {
        return this.subIntervals != null ? this.subIntervals.get(index) : null;
    }

    int indexOf(LayoutInterval interval) {
        return this.subIntervals != null ? this.subIntervals.indexOf(interval) : -1;
    }

    public boolean isParentOf(LayoutInterval interval) {
        if (this.isGroup()) {
            do {
                if ((interval = interval.getParent()) != this) continue;
                return true;
            } while (interval != null);
        }
        return false;
    }

    public LayoutInterval getRoot() {
        return LayoutInterval.getRoot(this);
    }

    LayoutRegion getCurrentSpace() {
        assert (!this.isEmptySpace());
        if (this.currentSpace == null) {
            this.currentSpace = new LayoutRegion();
        }
        return this.currentSpace;
    }

    void setCurrentSpace(LayoutRegion space) {
        this.currentSpace = space;
    }

    int getDiffToDefaultSize() {
        return this.diffToDefaultSize;
    }

    void setDiffToDefaultSize(int diff) {
        this.diffToDefaultSize = diff;
    }

    int getLastActualSize() {
        return this.lastActualSize;
    }

    void setLastActualSize(int size) {
        this.lastActualSize = size;
    }

    static LayoutInterval getFirstParent(LayoutInterval interval, int type) {
        LayoutInterval parent;
        for (parent = interval.getParent(); parent != null && parent.getType() != type; parent = parent.getParent()) {
        }
        return parent;
    }

    static LayoutInterval getRoot(LayoutInterval interval) {
        while (interval.getParent() != null) {
            interval = interval.getParent();
        }
        return interval;
    }

    static LayoutInterval getRoot(LayoutInterval interval, int type) {
        LayoutInterval root = null;
        do {
            if (interval.getType() != type) continue;
            root = interval;
        } while ((interval = interval.getParent()) != null);
        return root;
    }

    static LayoutInterval getCommonParent(LayoutInterval[] intervals) {
        LayoutInterval parent = intervals[0].getParent();
        if (parent != null) {
            for (int i = 1; i < intervals.length; ++i) {
                parent = LayoutInterval.getCommonParent(parent, intervals[i]);
            }
        }
        return parent;
    }

    static LayoutInterval getCommonParent(LayoutInterval interval1, LayoutInterval interval2) {
        Iterator<LayoutInterval> parents1 = LayoutInterval.parentsOfInterval(interval1).iterator();
        Iterator<LayoutInterval> parents2 = LayoutInterval.parentsOfInterval(interval2).iterator();
        LayoutInterval parent1 = parents1.next();
        LayoutInterval parent2 = parents2.next();
        assert (parent1 == parent2);
        LayoutInterval parent = null;
        while (parent1 == parent2) {
            parent = parent1;
            if (!parents1.hasNext()) break;
            parent1 = parents1.next();
            if (!parents2.hasNext()) break;
            parent2 = parents2.next();
        }
        return parent;
    }

    private static List<LayoutInterval> parentsOfInterval(LayoutInterval interval) {
        LinkedList<LayoutInterval> parents = new LinkedList<LayoutInterval>();
        while (interval != null) {
            parents.add(0, interval);
            interval = interval.getParent();
        }
        return parents;
    }

    static int getCount(LayoutInterval group, int alignment, boolean nonEmpty) {
        int n = 0;
        Iterator<LayoutInterval> it = group.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval li = it.next();
            if (!group.isSequential() && alignment != Integer.MAX_VALUE && li.getAlignment() != alignment && !LayoutInterval.wantResize(li) || nonEmpty && li.isEmptySpace()) continue;
            ++n;
        }
        return n;
    }

    static LayoutInterval getDirectNeighbor(LayoutInterval interval, int alignment, boolean nonEmpty) {
        LayoutInterval parent = interval.getParent();
        if (parent == null || parent.isParallel()) {
            return null;
        }
        LayoutInterval neighbor = null;
        int d = alignment == 0 ? -1 : 1;
        int n = parent.getSubIntervalCount();
        for (int index = parent.indexOf(interval) + d; index >= 0 && index < n && neighbor == null; index += d) {
            LayoutInterval li = parent.getSubInterval(index);
            if (nonEmpty && li.isEmptySpace()) continue;
            neighbor = li;
        }
        return neighbor;
    }

    public static LayoutInterval getNeighbor(LayoutInterval interval, int alignment, boolean nonEmpty, boolean outOfParent, boolean aligned) {
        assert (alignment == 0 || alignment == 1);
        LayoutInterval neighbor = null;
        LayoutInterval parent = interval;
        int d = alignment == 0 ? -1 : 1;
        while (true) {
            interval = parent;
            parent = interval.getParent();
            if (aligned && parent != null && parent.isParallel() && !LayoutInterval.isAlignedAtBorder(interval, alignment)) {
                parent = null;
            }
            if (parent != null && parent.isParallel()) continue;
            if (parent != null) {
                neighbor = LayoutInterval.getDirectNeighbor(interval, alignment, nonEmpty);
            }
            if (neighbor != null || parent == null || !outOfParent) break;
        }
        return neighbor;
    }

    static boolean startsWithEmptySpace(LayoutInterval interval, int alignment) {
        assert (alignment == 0 || alignment == 1);
        if (interval.isSingle()) {
            return interval.isEmptySpace();
        }
        if (interval.isSequential()) {
            int index = alignment == 0 ? 0 : interval.getSubIntervalCount() - 1;
            return LayoutInterval.startsWithEmptySpace(interval.getSubInterval(index), alignment);
        }
        Iterator<LayoutInterval> it = interval.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval li = it.next();
            if (!LayoutInterval.startsWithEmptySpace(li, alignment)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAlignedAtBorder(LayoutInterval interval, int alignment) {
        if (alignment != 0 && alignment != 1) {
            return false;
        }
        LayoutInterval parent = interval.getParent();
        if (parent == null) {
            return false;
        }
        if (parent.isSequential()) {
            int index = alignment == 0 ? 0 : parent.getSubIntervalCount() - 1;
            return interval == parent.getSubInterval(index);
        }
        return interval.getAlignment() == alignment || LayoutInterval.wantResize(interval);
    }

    static boolean isAlignedAtBorder(LayoutInterval interval, LayoutInterval parent, int alignment) {
        do {
            if (LayoutInterval.isAlignedAtBorder(interval, alignment)) continue;
            return false;
        } while ((interval = interval.getParent()) != parent);
        return true;
    }

    static boolean isPlacedAtBorder(LayoutInterval interval, int dimension, int alignment) {
        if (alignment != 0 && alignment != 1) {
            return false;
        }
        LayoutInterval parent = interval.getParent();
        if (parent == null) {
            return false;
        }
        if (interval.isEmptySpace()) {
            if (parent.isSequential()) {
                int index = alignment == 0 ? 0 : parent.getSubIntervalCount() - 1;
                return interval == parent.getSubInterval(index);
            }
            return true;
        }
        return LayoutRegion.distance(interval.getCurrentSpace(), parent.getCurrentSpace(), dimension, alignment, alignment) == 0;
    }

    static boolean isPlacedAtBorder(LayoutInterval interval, LayoutInterval parent, int dimension, int alignment) {
        if (alignment != 0 && alignment != 1) {
            return false;
        }
        if (interval.isEmptySpace()) {
            LayoutInterval p = interval.getParent();
            if (p.isSequential()) {
                int index;
                int n = index = alignment == 0 ? 0 : p.getSubIntervalCount() - 1;
                if (interval != p.getSubInterval(index)) {
                    return false;
                }
            }
            if (p == parent) {
                return true;
            }
            interval = p;
        }
        return LayoutRegion.distance(interval.getCurrentSpace(), parent.getCurrentSpace(), dimension, alignment, alignment) == 0 && parent.isParentOf(interval);
    }

    static boolean isBorderInterval(LayoutInterval interval, int alignment, boolean attached) {
        LayoutInterval parent = interval.getParent();
        if (parent != null && (alignment == 0 || alignment == 1)) {
            if (parent.isSequential()) {
                int index;
                int n = index = alignment == 0 ? 0 : parent.getSubIntervalCount() - 1;
                while (index >= 0 && index < parent.getSubIntervalCount()) {
                    LayoutInterval li = parent.getSubInterval(index);
                    if (li == interval) {
                        return true;
                    }
                    if (attached || !li.isEmptySpace()) {
                        return false;
                    }
                    index += alignment == 0 ? 1 : -1;
                }
            } else {
                return !attached || interval.getAlignment() == alignment || LayoutInterval.wantResize(interval);
            }
        }
        return false;
    }

    static boolean isClosedGroup(LayoutInterval group, int alignment) {
        assert (group.isParallel());
        if (group.hasAttribute(32) || group.getGroupAlignment() == 2 || group.getGroupAlignment() == 3) {
            return true;
        }
        if (!LayoutInterval.canResize(group)) {
            return true;
        }
        Iterator<LayoutInterval> it = group.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval li = it.next();
            if (li.getAlignment() != alignment && !LayoutInterval.wantResize(li)) continue;
            return true;
        }
        return false;
    }

    static boolean isExplicitlyClosedGroup(LayoutInterval group) {
        return group.hasAttribute(32);
    }

    static boolean isDefaultPadding(LayoutInterval interval) {
        return interval.isEmptySpace() && (interval.getMinimumSize() == -1 || interval.getPreferredSize() == -1);
    }

    static boolean isFixedDefaultPadding(LayoutInterval interval) {
        return !(!interval.isEmptySpace() || interval.getMinimumSize() != -1 && interval.getMinimumSize() != -2 || interval.getPreferredSize() != -1 || interval.getMaximumSize() != -1 && interval.getMaximumSize() != -2);
    }

    public static boolean canResize(LayoutInterval interval) {
        int max = interval.getMaximumSize();
        int pref = interval.getPreferredSize();
        assert (interval.isGroup() || max != -1);
        if (max != pref && max != -2 || max == -1) {
            if (interval.isComponent()) {
                int dimension;
                LayoutComponent comp = interval.getComponent();
                int n = dimension = comp.getLayoutInterval(0) == interval ? 0 : 1;
                if (comp.isLinkSized(dimension)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean wantResize(LayoutInterval interval) {
        return LayoutInterval.canResize(interval) && (!interval.isGroup() || LayoutInterval.contentWantResize(interval));
    }

    static boolean wantResizeInLayout(LayoutInterval interval) {
        return LayoutInterval.wantResizeInParent(interval, null);
    }

    static boolean wantResizeInParent(LayoutInterval interval, LayoutInterval parent) {
        return LayoutInterval.canResizeInParent(interval, parent) && LayoutInterval.wantResize(interval);
    }

    static boolean canResizeInLayout(LayoutInterval interval) {
        return LayoutInterval.canResizeInParent(interval, null);
    }

    static boolean canResizeInParent(LayoutInterval interval, LayoutInterval parent) {
        if (!LayoutInterval.canResize(interval)) {
            return false;
        }
        while (interval.getParent() != parent) {
            if (LayoutInterval.canResize(interval = interval.getParent())) continue;
            return false;
        }
        return true;
    }

    static boolean contentWantResize(LayoutInterval group) {
        boolean subres = false;
        Iterator<LayoutInterval> it = group.getSubIntervals();
        while (it.hasNext()) {
            if (!LayoutInterval.wantResize(it.next())) continue;
            subres = true;
            break;
        }
        return subres;
    }

    static boolean subordinateSize(LayoutInterval interval) {
        return interval.isSingle() && LayoutInterval.canResize(interval) && interval.getPreferredSize() == 0 && interval.hasAttribute(512);
    }

    static int getCurrentSize(LayoutInterval interval, int dimension) {
        if (dimension < 0) {
            assert (interval.isComponent());
            int n = dimension = interval.getComponent().getLayoutInterval(0) == interval ? 0 : 1;
        }
        if (!interval.isEmptySpace()) {
            return interval.getCurrentSpace().size(dimension);
        }
        if (!LayoutInterval.canResize(interval) && interval.getPreferredSize() != -1) {
            return interval.getPreferredSize();
        }
        int[] pos = LayoutInterval.getCurrentPositions(interval, dimension);
        return pos[1] - pos[0];
    }

    static int[] getCurrentPositions(LayoutInterval interval, int dimension) {
        int posT;
        int posL;
        if (dimension < 0) {
            assert (interval.isComponent());
            int n = dimension = interval.getComponent().getLayoutInterval(0) == interval ? 0 : 1;
        }
        if (!interval.isEmptySpace()) {
            posL = interval.getCurrentSpace().positions[dimension][0];
            posT = interval.getCurrentSpace().positions[dimension][1];
        } else {
            LayoutInterval parent = interval.getParent();
            if (parent.isSequential()) {
                int index = parent.indexOf(interval);
                int n = index > 0 ? parent.getSubInterval((int)(index - 1)).getCurrentSpace().positions[dimension][1] : (posL = (LayoutInterval.canResize((LayoutInterval)interval) ? parent.getParent() : parent).getCurrentSpace().positions[dimension][0]);
                posT = index + 1 < parent.getSubIntervalCount() ? parent.getSubInterval((int)(index + 1)).getCurrentSpace().positions[dimension][0] : (LayoutInterval.canResize((LayoutInterval)interval) ? parent.getParent() : parent).getCurrentSpace().positions[dimension][1];
            } else {
                posL = parent.getCurrentSpace().positions[dimension][0];
                posT = parent.getCurrentSpace().positions[dimension][1];
            }
        }
        return new int[]{posL, posT};
    }

    static int getDefaultSizeDef(LayoutInterval interval) {
        if (interval.isComponent() && LayoutInterval.canResize(interval)) {
            int dim;
            LayoutComponent comp = interval.getComponent();
            int n = dim = comp.getLayoutInterval(0) == interval ? 0 : 1;
            if (LayoutInterval.subordinateSize(interval) && !interval.hasAttribute(1024) && (interval.diffToDefaultSize != 0 || LayoutInterval.getCurrentSize(interval, dim) > 0)) {
                return 0;
            }
            if (comp.isLayoutContainer() ? comp.getDiffToMinimumSize(dim) < 0 : interval.diffToDefaultSize < 0) {
                return 0;
            }
        } else if (interval.isEmptySpace() && interval.getMinimumSize() == 0) {
            return 0;
        }
        return -1;
    }

    static int getDiffToDefaultSize(LayoutInterval interval, boolean inside) {
        LayoutComponent comp;
        if (inside && interval.isComponent() && (comp = interval.getComponent()).isLayoutContainer()) {
            int dim = comp.getLayoutInterval(0) == interval ? 0 : 1;
            int outDiff = comp.getDiffToMinimumSize(dim);
            int inDiff = comp.getDefaultLayoutRoot((int)dim).diffToDefaultSize;
            if (outDiff < 0) {
                if (inDiff < 0) {
                    outDiff += inDiff;
                }
                return outDiff;
            }
            return inDiff;
        }
        return interval.diffToDefaultSize;
    }

    static int getEffectiveAlignment(LayoutInterval interval) {
        LayoutInterval parent = interval.getParent();
        if (parent.isParallel()) {
            return interval.getAlignment();
        }
        if (LayoutInterval.wantResize(interval)) {
            return -1;
        }
        boolean before = true;
        boolean leadingFixed = true;
        boolean trailingFixed = true;
        Iterator<LayoutInterval> it = parent.getSubIntervals();
        do {
            LayoutInterval li;
            if ((li = it.next()) == interval) {
                before = false;
                continue;
            }
            if (!LayoutInterval.wantResize(li)) continue;
            if (before) {
                leadingFixed = false;
                continue;
            }
            trailingFixed = false;
        } while (it.hasNext());
        if (leadingFixed && !trailingFixed) {
            return 0;
        }
        if (!leadingFixed && trailingFixed) {
            return 1;
        }
        if (leadingFixed && trailingFixed) {
            return parent.getAlignment();
        }
        return -1;
    }

    static int getEffectiveAlignment(LayoutInterval interval, int edge, boolean considerParentSequenceAlignment) {
        assert (edge == 0 || edge == 1);
        boolean wantResize = LayoutInterval.wantResize(interval);
        LayoutInterval parent = interval.getParent();
        if (parent.isParallel()) {
            return wantResize ? edge : interval.getAlignment();
        }
        int n = parent.getSubIntervalCount();
        int d = edge == 0 ? 1 : -1;
        boolean before = true;
        boolean beforeFixed = true;
        boolean afterFixed = true;
        for (int i = edge == 0 ? 0 : n - 1; i >= 0 && i < n; i += d) {
            LayoutInterval li = parent.getSubInterval(i);
            if (li == interval) {
                before = false;
                if (!wantResize) continue;
                afterFixed = false;
                continue;
            }
            if (!LayoutInterval.wantResize(li)) continue;
            if (before) {
                beforeFixed = false;
                continue;
            }
            afterFixed = false;
        }
        if (beforeFixed && !afterFixed) {
            return edge;
        }
        if (!beforeFixed && afterFixed) {
            return edge ^ 1;
        }
        if (beforeFixed && afterFixed) {
            if (considerParentSequenceAlignment) {
                int parentAlignment = parent.getAlignment();
                if (parentAlignment == 0 || parentAlignment == 1) {
                    return parentAlignment;
                }
            } else {
                return edge;
            }
        }
        return -1;
    }

    static int getEffectiveAlignmentInParent(LayoutInterval interval, LayoutInterval parent, int edge) {
        assert (parent == null || parent.isParentOf(interval));
        int alignment = edge;
        do {
            alignment = LayoutInterval.getEffectiveAlignment(interval, alignment, true);
            if (alignment == 0 || alignment == 1) continue;
            for (interval = interval.getParent(); interval != parent && interval.getParent() != null; interval = interval.getParent()) {
                if (LayoutInterval.getEffectiveAlignment(interval) == alignment) continue;
                return -1;
            }
        } while (interval != parent && interval.getParent() != null);
        return alignment;
    }

    static boolean hasAnyResizingNeighbor(LayoutInterval interval, int alignment) {
        assert (alignment == 0 || alignment == 1);
        LayoutInterval parent = interval.getParent();
        if (parent.isSequential()) {
            int d = alignment == 0 ? -1 : 1;
            for (int index = parent.indexOf(interval) + d; index >= 0 && index < parent.getSubIntervalCount(); index += d) {
                if (!LayoutInterval.wantResize(parent.getSubInterval(index))) continue;
                return true;
            }
        }
        return false;
    }

    static int getIndexInParent(LayoutInterval interval, LayoutInterval parent) {
        while (interval != null) {
            if (interval.getParent() == parent) {
                return parent.indexOf(interval);
            }
            interval = interval.getParent();
        }
        return -1;
    }

    static int getDepthInParent(LayoutInterval interval, LayoutInterval parent) {
        int depth = 0;
        while (interval != null && interval != parent) {
            ++depth;
            interval = interval.getParent();
        }
        return interval != null ? depth : -1;
    }

    static LayoutInterval cloneInterval(LayoutInterval interval, LayoutInterval clone) {
        clone = clone == null ? new LayoutInterval(interval.getType()) : clone;
        clone.setAlignment(interval.getAlignment());
        clone.setAttributes(interval.getAttributes() & 0x23);
        if (interval.getType() == 103) {
            clone.setGroupAlignment(interval.getGroupAlignment());
        }
        clone.setSizes(interval.getMinimumSize(), interval.getPreferredSize(), interval.getMaximumSize());
        if (LayoutInterval.isDefaultPadding(interval)) {
            clone.setPaddingType(interval.getPaddingType());
        }
        return clone;
    }
}

